/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import smile.clustering.CLARANS;
import smile.clustering.DBSCAN;
import smile.clustering.DENCLUE;
import smile.clustering.DeterministicAnnealing;
import smile.clustering.GMeans;
import smile.clustering.HierarchicalClustering;
import smile.clustering.KMeans;
import smile.clustering.KModes;
import smile.clustering.MEC;
import smile.clustering.PartitionClustering;
import smile.clustering.SIB;
import smile.clustering.SpectralClustering;
import smile.clustering.XMeans;
import smile.clustering.linkage.CompleteLinkage;
import smile.clustering.linkage.Linkage;
import smile.clustering.linkage.SingleLinkage;
import smile.clustering.linkage.UPGMALinkage;
import smile.clustering.linkage.UPGMCLinkage;
import smile.clustering.linkage.WPGMALinkage;
import smile.clustering.linkage.WPGMCLinkage;
import smile.clustering.linkage.WardLinkage;
import smile.math.distance.Distance;
import smile.math.distance.EuclideanDistance;
import smile.math.distance.Metric;
import smile.math.matrix.Matrix;
import smile.neighbor.RNNSearch;
import smile.util.SparseArray;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00a2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aM\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000b\u001aI\u0010\f\u001a\u00020\r2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0014\u001aC\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0016\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0019\u001aI\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0016\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u001c\u001a/\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u001d\u001a)\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\b\u00a2\u0006\u0002\u0010\"\u001a#\u0010#\u001a\u00020$2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010%\u001a5\u0010&\u001a\u00020'\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010(\u001a\u00020)\u00a2\u0006\u0002\u0010*\u001a!\u0010&\u001a\u00020'2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010(\u001a\u00020)\u00a2\u0006\u0002\u0010+\u001a?\u0010,\u001a\u00020-2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u00102\b\b\u0002\u0010.\u001a\u00020\b\u00a2\u0006\u0002\u0010/\u001a5\u00100\u001a\u0002012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010.\u001a\u00020\b\u00a2\u0006\u0002\u00103\u001aC\u00104\u001a\b\u0012\u0004\u0012\u0002H\u000205\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\u0002\u00106\u001aC\u00104\u001a\b\u0012\u0004\u0012\u0002H\u000205\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u0002072\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\u0002\u00108\u001a[\u00104\u001a\b\u0012\u0004\u0012\u0002H\u000205\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u00109\u001a\u0002022\b\b\u0002\u0010\u0012\u001a\u00020\u0010\u00a2\u0006\u0002\u0010:\u001a/\u00104\u001a\b\u0012\u0004\u0012\u00020\u000e052\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\u0002\u0010;\u001a5\u0010<\u001a\u00020=2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020>0\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010.\u001a\u00020\b\u00a2\u0006\u0002\u0010?\u001a)\u0010@\u001a\u00020A2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0010\u00a2\u0006\u0002\u0010B\u001a1\u0010@\u001a\u00020A2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010C\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0010\u00a2\u0006\u0002\u0010D\u001a\u0016\u0010@\u001a\u00020A2\u0006\u0010E\u001a\u00020F2\u0006\u0010\u0007\u001a\u00020\b\u001a#\u0010G\u001a\u00020H2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010I\u00a8\u0006J"}, d2={"clarans", "Lsmile/clustering/CLARANS;", "T", "data", "", "distance", "Lsmile/math/distance/Distance;", "k", "", "maxNeighbor", "numLocal", "([Ljava/lang/Object;Lsmile/math/distance/Distance;III)Lsmile/clustering/CLARANS;", "dac", "Lsmile/clustering/DeterministicAnnealing;", "", "alpha", "", "maxIter", "tol", "splitTol", "([[DIDIDD)Lsmile/clustering/DeterministicAnnealing;", "dbscan", "Lsmile/clustering/DBSCAN;", "minPts", "radius", "([Ljava/lang/Object;Lsmile/math/distance/Distance;ID)Lsmile/clustering/DBSCAN;", "nns", "Lsmile/neighbor/RNNSearch;", "([Ljava/lang/Object;Lsmile/neighbor/RNNSearch;ID)Lsmile/clustering/DBSCAN;", "([[DID)Lsmile/clustering/DBSCAN;", "denclue", "Lsmile/clustering/DENCLUE;", "sigma", "m", "([[DDI)Lsmile/clustering/DENCLUE;", "gmeans", "Lsmile/clustering/GMeans;", "([[DI)Lsmile/clustering/GMeans;", "hclust", "Lsmile/clustering/HierarchicalClustering;", "method", "", "([Ljava/lang/Object;Lsmile/math/distance/Distance;Ljava/lang/String;)Lsmile/clustering/HierarchicalClustering;", "([[DLjava/lang/String;)Lsmile/clustering/HierarchicalClustering;", "kmeans", "Lsmile/clustering/KMeans;", "runs", "([[DIIDI)Lsmile/clustering/KMeans;", "kmodes", "Lsmile/clustering/KModes;", "", "([[IIII)Lsmile/clustering/KModes;", "mec", "Lsmile/clustering/MEC;", "([Ljava/lang/Object;Lsmile/math/distance/Distance;ID)Lsmile/clustering/MEC;", "Lsmile/math/distance/Metric;", "([Ljava/lang/Object;Lsmile/math/distance/Metric;ID)Lsmile/clustering/MEC;", "y", "([Ljava/lang/Object;Lsmile/neighbor/RNNSearch;ID[ID)Lsmile/clustering/MEC;", "([[DID)Lsmile/clustering/MEC;", "sib", "Lsmile/clustering/SIB;", "Lsmile/util/SparseArray;", "([Lsmile/util/SparseArray;III)Lsmile/clustering/SIB;", "specc", "Lsmile/clustering/SpectralClustering;", "([[DID)Lsmile/clustering/SpectralClustering;", "l", "([[DIID)Lsmile/clustering/SpectralClustering;", "W", "Lsmile/math/matrix/Matrix;", "xmeans", "Lsmile/clustering/XMeans;", "([[DI)Lsmile/clustering/XMeans;", "smile-kotlin"})
public final class ClusteringKt {
    @NotNull
    public static final HierarchicalClustering hclust(@NotNull double[][] data, @NotNull String method) {
        Linkage linkage;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        switch (method) {
            case "single": {
                linkage = (Linkage)SingleLinkage.of((double[][])data);
                break;
            }
            case "complete": {
                linkage = (Linkage)CompleteLinkage.of((double[][])data);
                break;
            }
            case "average": 
            case "upgma": {
                linkage = (Linkage)UPGMALinkage.of((double[][])data);
                break;
            }
            case "centroid": 
            case "upgmc": {
                linkage = (Linkage)UPGMCLinkage.of((double[][])data);
                break;
            }
            case "wpgma": {
                linkage = (Linkage)WPGMALinkage.of((double[][])data);
                break;
            }
            case "median": 
            case "wpgmc": {
                linkage = (Linkage)WPGMCLinkage.of((double[][])data);
                break;
            }
            case "ward": {
                linkage = (Linkage)WardLinkage.of((double[][])data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown agglomeration method: " + method);
            }
        }
        Linkage linkage2 = linkage;
        HierarchicalClustering hierarchicalClustering = HierarchicalClustering.fit((Linkage)linkage2);
        Intrinsics.checkNotNullExpressionValue((Object)hierarchicalClustering, (String)"fit(linkage)");
        return hierarchicalClustering;
    }

    @NotNull
    public static final <T> HierarchicalClustering hclust(@NotNull T[] data, @NotNull Distance<T> distance, @NotNull String method) {
        Linkage linkage;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        switch (method) {
            case "single": {
                linkage = (Linkage)SingleLinkage.of((Object[])data, distance);
                break;
            }
            case "complete": {
                linkage = (Linkage)CompleteLinkage.of((Object[])data, distance);
                break;
            }
            case "average": 
            case "upgma": {
                linkage = (Linkage)UPGMALinkage.of((Object[])data, distance);
                break;
            }
            case "centroid": 
            case "upgmc": {
                linkage = (Linkage)UPGMCLinkage.of((Object[])data, distance);
                break;
            }
            case "wpgma": {
                linkage = (Linkage)WPGMALinkage.of((Object[])data, distance);
                break;
            }
            case "median": 
            case "wpgmc": {
                linkage = (Linkage)WPGMCLinkage.of((Object[])data, distance);
                break;
            }
            case "ward": {
                linkage = (Linkage)WardLinkage.of((Object[])data, distance);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown agglomeration method: " + method);
            }
        }
        Linkage linkage2 = linkage;
        HierarchicalClustering hierarchicalClustering = HierarchicalClustering.fit((Linkage)linkage2);
        Intrinsics.checkNotNullExpressionValue((Object)hierarchicalClustering, (String)"fit(linkage)");
        return hierarchicalClustering;
    }

    @NotNull
    public static final KModes kmodes(@NotNull int[][] data, int k, int maxIter, int runs) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        PartitionClustering partitionClustering = PartitionClustering.run((int)runs, () -> ClusteringKt.kmodes$lambda$0(data, k, maxIter));
        Intrinsics.checkNotNullExpressionValue((Object)partitionClustering, (String)"run(runs, { KModes.fit(data, k, maxIter) })");
        return (KModes)partitionClustering;
    }

    public static /* synthetic */ KModes kmodes$default(int[][] nArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 100;
        }
        if ((n4 & 8) != 0) {
            n3 = 10;
        }
        return ClusteringKt.kmodes(nArray, n, n2, n3);
    }

    @NotNull
    public static final KMeans kmeans(@NotNull double[][] data, int k, int maxIter, double tol, int runs) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        PartitionClustering partitionClustering = PartitionClustering.run((int)runs, () -> ClusteringKt.kmeans$lambda$1(data, k, maxIter, tol));
        Intrinsics.checkNotNullExpressionValue((Object)partitionClustering, (String)"run(runs, { KMeans.fit(data, k, maxIter, tol) })");
        return (KMeans)partitionClustering;
    }

    public static /* synthetic */ KMeans kmeans$default(double[][] dArray, int n, int n2, double d, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 100;
        }
        if ((n4 & 8) != 0) {
            d = 1.0E-4;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 16;
        }
        return ClusteringKt.kmeans(dArray, n, n2, d, n3);
    }

    @NotNull
    public static final XMeans xmeans(@NotNull double[][] data, int k) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        XMeans xMeans = XMeans.fit((double[][])data, (int)k);
        Intrinsics.checkNotNullExpressionValue((Object)xMeans, (String)"fit(data, k)");
        return xMeans;
    }

    public static /* synthetic */ XMeans xmeans$default(double[][] dArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 100;
        }
        return ClusteringKt.xmeans(dArray, n);
    }

    @NotNull
    public static final GMeans gmeans(@NotNull double[][] data, int k) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        GMeans gMeans = GMeans.fit((double[][])data, (int)k);
        Intrinsics.checkNotNullExpressionValue((Object)gMeans, (String)"fit(data, k)");
        return gMeans;
    }

    public static /* synthetic */ GMeans gmeans$default(double[][] dArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 100;
        }
        return ClusteringKt.gmeans(dArray, n);
    }

    @NotNull
    public static final SIB sib(@NotNull SparseArray[] data, int k, int maxIter, int runs) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        PartitionClustering partitionClustering = PartitionClustering.run((int)runs, () -> ClusteringKt.sib$lambda$2(data, k, maxIter));
        Intrinsics.checkNotNullExpressionValue((Object)partitionClustering, (String)"run(runs, { SIB.fit(data, k, maxIter) })");
        return (SIB)partitionClustering;
    }

    public static /* synthetic */ SIB sib$default(SparseArray[] sparseArrayArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 100;
        }
        if ((n4 & 8) != 0) {
            n3 = 8;
        }
        return ClusteringKt.sib(sparseArrayArray, n, n2, n3);
    }

    @NotNull
    public static final DeterministicAnnealing dac(@NotNull double[][] data, int k, double alpha, int maxIter, double tol, double splitTol) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DeterministicAnnealing deterministicAnnealing = DeterministicAnnealing.fit((double[][])data, (int)k, (double)alpha, (int)maxIter, (double)tol, (double)splitTol);
        Intrinsics.checkNotNullExpressionValue((Object)deterministicAnnealing, (String)"fit(data, k, alpha, maxIter, tol, splitTol)");
        return deterministicAnnealing;
    }

    public static /* synthetic */ DeterministicAnnealing dac$default(double[][] dArray, int n, double d, int n2, double d2, double d3, int n3, Object object) {
        if ((n3 & 4) != 0) {
            d = 0.9;
        }
        if ((n3 & 8) != 0) {
            n2 = 100;
        }
        if ((n3 & 0x10) != 0) {
            d2 = 1.0E-4;
        }
        if ((n3 & 0x20) != 0) {
            d3 = 0.01;
        }
        return ClusteringKt.dac(dArray, n, d, n2, d2, d3);
    }

    @NotNull
    public static final <T> CLARANS<T> clarans(@NotNull T[] data, @NotNull Distance<T> distance, int k, int maxNeighbor, int numLocal) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        PartitionClustering partitionClustering = PartitionClustering.run((int)numLocal, () -> ClusteringKt.clarans$lambda$3(data, distance, k, maxNeighbor));
        Intrinsics.checkNotNullExpressionValue((Object)partitionClustering, (String)"run(numLocal, { CLARANS.\u2026tance, k, maxNeighbor) })");
        return (CLARANS)partitionClustering;
    }

    public static /* synthetic */ CLARANS clarans$default(Object[] objectArray, Distance distance, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n3 = 16;
        }
        return ClusteringKt.clarans(objectArray, distance, n, n2, n3);
    }

    @NotNull
    public static final <T> DBSCAN<T> dbscan(@NotNull T[] data, @NotNull RNNSearch<T, T> nns, int minPts, double radius) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(nns, (String)"nns");
        DBSCAN dBSCAN = DBSCAN.fit((Object[])data, nns, (int)minPts, (double)radius);
        Intrinsics.checkNotNullExpressionValue((Object)dBSCAN, (String)"fit(data, nns, minPts, radius)");
        return dBSCAN;
    }

    @NotNull
    public static final <T> DBSCAN<T> dbscan(@NotNull T[] data, @NotNull Distance<T> distance, int minPts, double radius) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        DBSCAN dBSCAN = DBSCAN.fit((Object[])data, distance, (int)minPts, (double)radius);
        Intrinsics.checkNotNullExpressionValue((Object)dBSCAN, (String)"fit(data, distance, minPts, radius)");
        return dBSCAN;
    }

    @NotNull
    public static final DBSCAN<double[]> dbscan(@NotNull double[][] data, int minPts, double radius) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return ClusteringKt.dbscan((Object[])data, (Distance)new EuclideanDistance(), minPts, radius);
    }

    @NotNull
    public static final DENCLUE denclue(@NotNull double[][] data, double sigma, int m) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DENCLUE dENCLUE = DENCLUE.fit((double[][])data, (double)sigma, (int)m);
        Intrinsics.checkNotNullExpressionValue((Object)dENCLUE, (String)"fit(data, sigma, m)");
        return dENCLUE;
    }

    @NotNull
    public static final <T> MEC<T> mec(@NotNull T[] data, @NotNull Distance<T> distance, int k, double radius) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        MEC mEC = MEC.fit((Object[])data, distance, (int)k, (double)radius);
        Intrinsics.checkNotNullExpressionValue((Object)mEC, (String)"fit(data, distance, k, radius)");
        return mEC;
    }

    @NotNull
    public static final <T> MEC<T> mec(@NotNull T[] data, @NotNull Metric<T> distance, int k, double radius) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        MEC mEC = MEC.fit((Object[])data, (Distance)((Distance)distance), (int)k, (double)radius);
        Intrinsics.checkNotNullExpressionValue((Object)mEC, (String)"fit(data, distance, k, radius)");
        return mEC;
    }

    @NotNull
    public static final MEC<double[]> mec(@NotNull double[][] data, int k, double radius) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        MEC mEC = MEC.fit((Object[])((Object[])data), (Distance)((Distance)new EuclideanDistance()), (int)k, (double)radius);
        Intrinsics.checkNotNullExpressionValue((Object)mEC, (String)"fit(data, EuclideanDistance(), k, radius)");
        return mEC;
    }

    @NotNull
    public static final <T> MEC<T> mec(@NotNull T[] data, @NotNull RNNSearch<T, T> nns, int k, double radius, @NotNull int[] y, double tol) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(nns, (String)"nns");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        MEC mEC = MEC.fit((Object[])data, nns, (int)k, (double)radius, (int[])y, (double)tol);
        Intrinsics.checkNotNullExpressionValue((Object)mEC, (String)"fit(data, nns, k, radius, y, tol)");
        return mEC;
    }

    public static /* synthetic */ MEC mec$default(Object[] objectArray, RNNSearch rNNSearch, int n, double d, int[] nArray, double d2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            d2 = 1.0E-4;
        }
        return ClusteringKt.mec(objectArray, rNNSearch, n, d, nArray, d2);
    }

    @NotNull
    public static final SpectralClustering specc(@NotNull Matrix W, int k) {
        Intrinsics.checkNotNullParameter((Object)W, (String)"W");
        SpectralClustering spectralClustering = SpectralClustering.fit((Matrix)W, (int)k);
        Intrinsics.checkNotNullExpressionValue((Object)spectralClustering, (String)"fit(W, k)");
        return spectralClustering;
    }

    @NotNull
    public static final SpectralClustering specc(@NotNull double[][] data, int k, double sigma) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SpectralClustering spectralClustering = SpectralClustering.fit((double[][])data, (int)k, (double)sigma);
        Intrinsics.checkNotNullExpressionValue((Object)spectralClustering, (String)"fit(data, k, sigma)");
        return spectralClustering;
    }

    @NotNull
    public static final SpectralClustering specc(@NotNull double[][] data, int k, int l, double sigma) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SpectralClustering spectralClustering = SpectralClustering.fit((double[][])data, (int)k, (int)l, (double)sigma);
        Intrinsics.checkNotNullExpressionValue((Object)spectralClustering, (String)"fit(data, k, l, sigma)");
        return spectralClustering;
    }

    private static final KModes kmodes$lambda$0(int[][] $data, int $k, int $maxIter) {
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        return KModes.fit((int[][])$data, (int)$k, (int)$maxIter);
    }

    private static final KMeans kmeans$lambda$1(double[][] $data, int $k, int $maxIter, double $tol) {
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        return KMeans.fit((double[][])$data, (int)$k, (int)$maxIter, (double)$tol);
    }

    private static final SIB sib$lambda$2(SparseArray[] $data, int $k, int $maxIter) {
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        return SIB.fit((SparseArray[])$data, (int)$k, (int)$maxIter);
    }

    private static final CLARANS clarans$lambda$3(Object[] $data, Distance $distance, int $k, int $maxNeighbor) {
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$distance, (String)"$distance");
        return CLARANS.fit((Object[])$data, (Distance)$distance, (int)$k, (int)$maxNeighbor);
    }
}

