/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.SubnetContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetQuery;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubnetRowSet<R>
implements RowSet<R>,
Extensibles.AsRowSet<R>,
Experimentals.AsRowSet<R> {
    private final SubnetContainer<?, ?> container;
    private final Class<R> rowType;
    private final RowMapper mapper;
    private RowMapper.Cursor resultCursor;
    private Object lastKey;
    private final long totalRowCount;
    private long remainingRowCount;
    private Map<Integer, byte[]> extResultMap;
    private final SubnetContainer.QueryFormatter queryFormatter;
    private SubnetQuery.QueryParameters queryParameters;
    private final SubnetContainer.PartialFetchStatus fetchStatus;
    private Object targetConnection;
    private Throwable lastProblem;
    private boolean previousFound;
    private boolean followingLost;
    private boolean closed;
    private final PartialRowSetReference remoteRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubnetRowSet(SubnetContainer<?, ?> container, Class<R> rowType, RowMapper mapper, RowMapper.Cursor resultCursor, Map<Integer, byte[]> extResultMap, SubnetContainer.QueryFormatter queryFormatter, SubnetQuery.QueryParameters queryParameters, SubnetContainer.PartialFetchStatus fetchStatus, Object targetConnection) throws GSException {
        this.container = container;
        this.rowType = rowType;
        this.mapper = mapper;
        this.resultCursor = resultCursor;
        PartialRowSetReference remoteRef = null;
        if (fetchStatus == null) {
            this.totalRowCount = SubnetQuery.QueryParameters.get(queryParameters).isPartialExecutionConfigured() ? -1L : (long)resultCursor.getRowCount();
            this.remainingRowCount = 0L;
        } else {
            this.totalRowCount = fetchStatus.totalRowCount;
            this.remainingRowCount = this.totalRowCount - (long)resultCursor.getRowCount();
        }
        this.extResultMap = extResultMap;
        this.queryFormatter = queryFormatter;
        this.queryParameters = queryParameters;
        this.fetchStatus = fetchStatus;
        if (fetchStatus != null) {
            this.targetConnection = targetConnection;
            GridStoreChannel.Context context = container.context;
            synchronized (context) {
                container.channel.cleanRemoteResources(container.context, new HashSet<Class>(Arrays.asList(NormalTarget.class, TransactionalTarget.class)));
                remoteRef = new PartialRowSetReference(this, fetchStatus, targetConnection);
                container.context.addRemoteReference(remoteRef);
            }
        }
        this.remoteRef = remoteRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpened() throws GSException {
        if (GridStoreChannel.v10ResourceCompatible) {
            return;
        }
        if (this.closed || this.container.isClosed() || this.remoteRef != null && this.remoteRef.closed) {
            Throwable lastProblem;
            GridStoreChannel.Context context = this.container.context;
            synchronized (context) {
                lastProblem = this.lastProblem;
            }
            if (lastProblem != null) {
                throw new GSException("Row set already closed by other problem (reason=" + lastProblem.getMessage() + ")", lastProblem);
            }
            throw new GSException(145040, "This row set or related container has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GSException closeByProblem(Throwable cause) {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            GridStoreChannel.Context context = this.container.context;
            synchronized (context) {
                this.lastProblem = cause;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws GSException {
        this.closed = true;
        if (this.targetConnection != null) {
            GridStoreChannel.Context context = this.container.context;
            synchronized (context) {
                if (this.targetConnection != null) {
                    try {
                        this.container.channel.closeRemoteResource(this.container.context, this.remoteRef, false);
                        Object var3_2 = null;
                        this.targetConnection = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        this.targetConnection = null;
                        throw throwable;
                    }
                }
            }
        }
        this.resultCursor.resetBuffer();
    }

    @Override
    public boolean hasNext() throws GSException {
        return this.resultCursor.hasNext();
    }

    void prepareFollowing() throws GSException {
        this.checkOpened();
        try {
            this.prepareFollowingDirect();
        }
        catch (Throwable t) {
            throw this.closeByProblem(t);
        }
    }

    private void prepareFollowingDirect() throws GSException {
        if (!this.resultCursor.hasNext()) {
            if (this.fetchStatus != null) {
                if (this.remainingRowCount > 0L) {
                    this.fetchFollowing();
                }
            } else if (SubnetQuery.QueryParameters.get((SubnetQuery.QueryParameters)this.queryParameters).executionStatus.isEnabled()) {
                this.executeFollowing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFollowing() throws GSException {
        GridStoreChannel.Context context = this.container.context;
        synchronized (context) {
            block19: {
                Object v1;
                if (this.followingLost) break block19;
                if (this.targetConnection == null) {
                    throw new GSException(145040, "Row set lost by transactional problem");
                }
                Object[] targetConnectionResult = new Object[]{this.targetConnection};
                boolean succeeded = false;
                try {
                    this.resultCursor = this.container.fetchRowSet(this.remainingRowCount, this.fetchStatus, this.queryParameters, targetConnectionResult, this.mapper);
                    succeeded = true;
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object v0;
                    Object var5_5 = null;
                    this.targetConnection = targetConnectionResult[0];
                    try {
                        if (this.targetConnection == null) {
                            this.container.context.removeRemoteReference(this.remoteRef);
                        }
                        v0 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var7_9;
                        v0 = var7_9 = null;
                    }
                    if (!succeeded) {
                        try {
                            this.close();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                this.targetConnection = targetConnectionResult[0];
                try {
                    if (this.targetConnection == null) {
                        this.container.context.removeRemoteReference(this.remoteRef);
                    }
                    v1 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8;
                    v1 = var7_8 = null;
                }
                if (!succeeded) {
                    try {
                        this.close();
                    }
                    catch (Throwable throwable) {}
                }
                this.remainingRowCount -= (long)this.resultCursor.getRowCount();
                if (this.remainingRowCount > 0L && this.targetConnection == null) {
                    this.followingLost = true;
                }
                if (this.resultCursor.hasNext()) {
                    return;
                }
            }
            throw GSErrorCode.newGSRecoverableException(145043, "Row set lost by modifications (remainingRowCount=" + this.remainingRowCount + ")", null);
        }
    }

    private void executeFollowing() throws GSException {
        do {
            SubnetRowSet<R> rowSet;
            if ((rowSet = this.container.queryAndFetch(this.rowType, this.mapper, this.queryFormatter, this.queryParameters, false)) == null) {
                this.queryParameters.executionStatus = SubnetContainer.PartialExecutionStatus.DISABLED;
                continue;
            }
            this.resultCursor = rowSet.resultCursor;
            this.extResultMap = rowSet.extResultMap;
            this.queryParameters = rowSet.queryParameters;
        } while (!this.resultCursor.hasNext() && this.queryParameters.executionStatus.isEnabled());
    }

    @Override
    public R next() throws GSException {
        Object rowObj;
        this.checkOpened();
        if (!this.resultCursor.hasNext()) {
            throw new GSException(145037, "No more rows were found");
        }
        try {
            Object uncheckedRowObj;
            rowObj = this.rowType == null ? (uncheckedRowObj = this.mapper.decode(this.resultCursor)) : this.rowType.cast(this.mapper.decode(this.resultCursor));
            this.lastKey = this.mapper.hasKey() ? this.mapper.resolveKey(null, rowObj) : null;
            if (!this.resultCursor.hasNext()) {
                this.prepareFollowingDirect();
                this.previousFound = true;
            }
        }
        catch (Throwable t) {
            throw this.closeByProblem(t);
        }
        return (R)rowObj;
    }

    @Override
    public void remove() throws GSException {
        this.checkOpened();
        this.checkInRange();
        this.container.remove(this.mapper, this.getTransactionId(), this.isUpdatable(), this.resultCursor.getLastRowId(), this.lastKey);
    }

    @Override
    public void update(R rowObj) throws GSException {
        this.checkOpened();
        this.checkInRange();
        this.container.update(this.mapper, this.getTransactionId(), this.isUpdatable(), this.resultCursor.getLastRowId(), this.lastKey, rowObj);
    }

    private void checkInRange() throws GSException {
        if (!this.resultCursor.isInRange() && !this.previousFound) {
            throw new GSException(145037, "Cursor out of range");
        }
    }

    private long getTransactionId() {
        return SubnetQuery.QueryParameters.resolveInitialTransactionId(this.queryParameters);
    }

    private boolean isUpdatable() {
        return SubnetQuery.QueryParameters.isForUpdate(this.queryParameters, false);
    }

    @Override
    public int size() {
        if (this.totalRowCount < 0L) {
            SubnetRowSet.raiseSizeError();
        }
        return (int)this.totalRowCount;
    }

    private static void raiseSizeError() {
        try {
            throw new GSException(145003, "Size of row set with partial execution is not supported");
        }
        catch (GSException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Class<R> getRowType() throws GSException {
        return this.rowType;
    }

    @Override
    public Set<Integer> getExtOptionKeys() throws GSException {
        if (this.extResultMap == null) {
            return Collections.emptySet();
        }
        return this.extResultMap.keySet();
    }

    @Override
    public byte[] getExtOption(int key) throws GSException {
        if (this.extResultMap == null) {
            return null;
        }
        return this.extResultMap.get(key);
    }

    Row nextGeneralRow() throws GSException {
        this.checkOpened();
        if (!this.hasNext()) {
            throw new GSException(145037, "Cursor out of range");
        }
        Row rowObj = (Row)this.mapper.decode(this.resultCursor, true);
        this.lastKey = this.mapper.hasKey() ? this.mapper.resolveKey(null, rowObj, true) : null;
        return rowObj;
    }

    @Override
    public Experimentals.RowId getRowIdForUpdate() throws GSException {
        long baseId;
        Container<?, ?> container = Tool.getContainer(this);
        long transactionId = Tool.getTransactionId(this);
        if (transactionId == 0L) {
            throw new GSException("Not locked");
        }
        if (container instanceof Collection) {
            baseId = Tool.getRowId(this);
        } else if (container instanceof TimeSeries) {
            baseId = ((Date)Tool.getRowKey(this)).getTime();
        } else {
            throw new Error("Unsupported container type");
        }
        return new Experimentals.RowId(container, transactionId, baseId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Tool {
        private Tool() {
        }

        public static Container<?, ?> getContainer(SubnetRowSet<?> rowSet) {
            return ((SubnetRowSet)rowSet).container;
        }

        public static long getTransactionId(SubnetRowSet<?> rowSet) {
            return ((SubnetRowSet)rowSet).getTransactionId();
        }

        public static long getRowId(SubnetRowSet<?> rowSet) throws GSException {
            ((SubnetRowSet)rowSet).checkOpened();
            if (!((SubnetRowSet)rowSet).resultCursor.isInRange()) {
                throw new GSException(145037, "Cursor out of range");
            }
            if (!((SubnetRowSet)rowSet).resultCursor.isRowIdIncluded()) {
                throw new GSException(145003, "Elements of this RowSet are not collection row");
            }
            return ((SubnetRowSet)rowSet).resultCursor.getLastRowId();
        }

        public static Object getRowKey(SubnetRowSet<?> rowSet) throws GSException {
            ((SubnetRowSet)rowSet).checkOpened();
            if (!((SubnetRowSet)rowSet).resultCursor.isInRange()) {
                throw new GSException(145037, "Cursor out of range");
            }
            if (!((SubnetRowSet)rowSet).container.getRowMapper().hasKey()) {
                return null;
            }
            return ((SubnetRowSet)rowSet).lastKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartialRowSetReference
    extends GridStoreChannel.RemoteReference<RowSet<?>> {
        private final SubnetContainer.PartialFetchStatus fetchStatus;
        private final Object targetConnection;
        private boolean closed;

        PartialRowSetReference(SubnetRowSet<?> rowSet, SubnetContainer.PartialFetchStatus fetchStatus, Object targetConnection) {
            super(rowSet, PartialRowSetReference.selectTargetClass(rowSet), ((SubnetRowSet)rowSet).container.context, ((SubnetRowSet)rowSet).container.getPartitionId(), ((SubnetRowSet)rowSet).container.getContainerId());
            this.fetchStatus = fetchStatus;
            this.targetConnection = targetConnection;
        }

        private static Class<?> selectTargetClass(SubnetRowSet<?> rowSet) {
            if (((SubnetRowSet)rowSet).getTransactionId() == 0L) {
                return NormalTarget.class;
            }
            return TransactionalTarget.class;
        }

        @Override
        public void close(GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            SubnetContainer.closeRowSet(channel, context, this.partitionId, this.containerId, this.fetchStatus, this.targetConnection);
        }
    }

    private static interface TransactionalTarget
    extends SubnetContainer.TransactionalResource {
    }

    private static interface NormalTarget
    extends SubnetContainer.ContainerSubResource {
    }
}

