/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.FetchOption;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.SubnetContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import com.toshiba.mwcloud.gs.subnet.SubnetRowSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubnetQuery<R>
implements Query<R>,
Extensibles.AsQuery<R>,
Experimentals.AsQuery<R> {
    private final SubnetContainer<?, ?> container;
    private final Class<R> resultType;
    private final RowMapper mapper;
    private final SubnetContainer.QueryFormatter formatter;
    private QueryParameters parameters;
    private SubnetRowSet<R> lastRowSet;
    private boolean lastRowSetVisible;
    private boolean closed;

    public SubnetQuery(SubnetContainer<?, ?> container, Class<R> resultType, RowMapper mapper, SubnetContainer.QueryFormatter formatter) {
        this.container = container;
        this.resultType = resultType;
        this.mapper = mapper;
        this.formatter = formatter;
    }

    SubnetContainer<?, ?> getContainer() {
        return this.container;
    }

    Statement getStatement() {
        return this.formatter.getStatement();
    }

    private void checkOpened() throws GSException {
        if (GridStoreChannel.v10ResourceCompatible) {
            return;
        }
        if (this.closed || this.container.isClosed()) {
            throw new GSException(145040, "");
        }
    }

    @Override
    public void setFetchOption(FetchOption option, Object value) throws GSException {
        this.checkOpened();
        if (option == null) {
            throw GSErrorCode.checkNullParameter(value, "option", null);
        }
        if (value == null) {
            throw GSErrorCode.checkNullParameter(value, "value", null);
        }
        this.parameters = QueryParameters.resolve(this.parameters);
        switch (option) {
            case LIMIT: {
                this.parameters.setFetchLimit(SubnetQuery.filterSizedFetchOption(option, value));
                break;
            }
            case SIZE: {
                this.parameters.setFetchSize(SubnetQuery.filterSizedFetchOption(option, value));
                break;
            }
            case PARTIAL_EXECUTION: {
                this.parameters.setPartialExecutionEnabled(SubnetQuery.filterFetchOption(option, value, Boolean.class, true));
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private static long filterSizedFetchOption(FetchOption option, Object value) throws GSException {
        Integer intValue = SubnetQuery.filterFetchOption(option, value, Integer.class, false);
        long longValue = intValue == null ? SubnetQuery.filterFetchOption(option, value, Long.class, true) : (long)intValue.intValue();
        if (longValue < 0L) {
            throw new GSException(145002, "Negative fetch option value specified (option=" + (Object)((Object)option) + ", value=" + longValue + ")");
        }
        return longValue;
    }

    private static <T> T filterFetchOption(FetchOption option, Object value, Class<T> type, boolean force) throws GSException {
        if (!type.isInstance(value)) {
            if (!force) {
                return null;
            }
            throw new GSException(145010, "Unsupported fetch option value type (option=" + (Object)((Object)option) + ", value=" + value + ", valueClass=" + value.getClass() + ")");
        }
        return type.cast(value);
    }

    @Override
    public void close() throws GSException {
        this.closed = true;
        this.clearLastRowSet();
    }

    @Override
    public RowSet<R> fetch() throws GSException {
        return this.fetch(false);
    }

    @Override
    public RowSet<R> fetch(boolean forUpdate) throws GSException {
        this.checkOpened();
        this.clearLastRowSet();
        SubnetRowSet<R> rowSet = this.container.queryAndFetch(this.resultType, this.mapper, this.formatter, this.parameters, QueryParameters.isForUpdate(this.parameters, forUpdate));
        if (rowSet != null) {
            rowSet.prepareFollowing();
            this.lastRowSet = rowSet;
            this.lastRowSetVisible = true;
        }
        return this.lastRowSet;
    }

    @Override
    public SubnetRowSet<R> getRowSet() throws GSException {
        this.checkOpened();
        if (!this.lastRowSetVisible) {
            return null;
        }
        this.lastRowSet.prepareFollowing();
        this.lastRowSetVisible = false;
        return this.lastRowSet;
    }

    private void clearLastRowSet() throws GSException {
        SubnetRowSet<R> rowSet = this.lastRowSet;
        this.lastRowSet = null;
        this.lastRowSetVisible = false;
        if (rowSet == null) {
            return;
        }
        if (!GridStoreChannel.v10ResourceCompatible) {
            rowSet.close();
        }
    }

    public static boolean isFetchSizeEnabled(int protocolVersion) {
        return protocolVersion >= 2 && (GridStoreChannel.v1ProtocolCompatible == null || GridStoreChannel.v1ProtocolCompatible == false);
    }

    @Override
    public long getFetchLimit() throws GSException {
        this.checkOpened();
        return QueryParameters.get((QueryParameters)this.parameters).fetchLimit;
    }

    void setForUpdate(boolean forUpdate) {
        if (forUpdate != QueryParameters.get((QueryParameters)this.parameters).forUpdate) {
            this.parameters = QueryParameters.resolve(this.parameters);
            this.parameters.forUpdate = forUpdate;
        }
    }

    boolean isForUpdate() {
        return QueryParameters.isForUpdate(this.parameters, false);
    }

    void makeRequest(BasicBuffer req, boolean noUUID) throws GSException {
        this.checkOpened();
        this.clearLastRowSet();
        boolean forUpdate = QueryParameters.isForUpdate(this.parameters, false);
        this.container.makeQueryRequest(this.formatter, this.parameters, forUpdate, req, noUUID);
    }

    void acceptResponse(BasicBuffer resp, Object targetConnection, boolean bufSwapAllowed) throws GSException {
        this.clearLastRowSet();
        boolean forUpdate = QueryParameters.isForUpdate(this.parameters, false);
        SubnetRowSet<R> rowSet = this.container.acceptQueryResponse(this.resultType, this.mapper, this.formatter, this.parameters, forUpdate, resp, targetConnection, bufSwapAllowed);
        if (rowSet != null) {
            this.lastRowSet = rowSet;
            this.lastRowSetVisible = true;
        }
    }

    @Override
    public void applyOptionsTo(Extensibles.AsQuery<?> dest) throws GSException {
        this.checkOpened();
        if (this.parameters == null) {
            return;
        }
        this.parameters.applyOptionsTo(dest);
    }

    @Override
    public void setExtOption(int key, byte[] value, boolean followingInheritable) throws GSException {
        this.checkOpened();
        this.parameters = QueryParameters.resolve(this.parameters);
        this.parameters.setExtOption(key, value, followingInheritable);
    }

    @Override
    public void setAcceptableResultKeys(Set<Integer> keys) throws GSException {
        this.checkOpened();
        this.parameters = QueryParameters.resolve(this.parameters);
        this.parameters.acceptableResultKeys = keys;
    }

    @Override
    public void setContainerLostAcceptable(boolean acceptable) throws GSException {
        this.checkOpened();
        this.parameters = QueryParameters.resolve(this.parameters);
        this.parameters.containerLostAcceptable = acceptable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueryParameters
    implements NodeConnection.OptionalRequestSource {
        private static final QueryParameters DEFAULT_INSTANCE = new QueryParameters();
        private static final long DEFAULT_SIZE_OPTION_VALUE = Long.MAX_VALUE;
        long fetchLimit = Long.MAX_VALUE;
        long fetchSize = Long.MAX_VALUE;
        SubnetContainer.PartialExecutionStatus executionStatus = SubnetContainer.PartialExecutionStatus.DISABLED;
        boolean executionPartial;
        boolean containerLostAcceptable;
        boolean forUpdate;
        Long initialTransactionId;
        Map<Integer, byte[]> extOptions;
        Set<Integer> inheritableOptionKeys;
        Set<Integer> acceptableResultKeys = Collections.emptySet();

        QueryParameters() {
        }

        QueryParameters(QueryParameters src) {
            this.fetchLimit = src.fetchLimit;
            this.fetchSize = src.fetchSize;
            this.executionStatus = src.executionStatus;
            this.executionPartial = src.executionPartial;
            this.containerLostAcceptable = src.containerLostAcceptable;
            this.forUpdate = src.forUpdate;
            this.initialTransactionId = src.initialTransactionId;
            if (src.extOptions != null) {
                this.extOptions = new HashMap<Integer, byte[]>(src.extOptions);
            }
            if (src.inheritableOptionKeys != null) {
                this.inheritableOptionKeys = new HashSet<Integer>(src.inheritableOptionKeys);
            }
            this.acceptableResultKeys = src.acceptableResultKeys;
        }

        @Override
        public boolean hasOptions() {
            return this.extOptions != null;
        }

        @Override
        public void putOptions(NodeConnection.OptionalRequest optionalRequest) {
            if (this.extOptions == null) {
                return;
            }
            for (Map.Entry<Integer, byte[]> entry : this.extOptions.entrySet()) {
                optionalRequest.putExt(entry.getKey(), entry.getValue());
            }
        }

        public void applyOptionsTo(Extensibles.AsQuery<?> dest) throws GSException {
            if (this.fetchLimit != Long.MAX_VALUE) {
                dest.setFetchOption(FetchOption.LIMIT, this.fetchLimit);
            }
            if (this.fetchSize != Long.MAX_VALUE) {
                FetchOption option = FetchOption.SIZE;
                dest.setFetchOption(option, this.fetchSize);
            }
            if (this.isPartialExecutionConfigured()) {
                dest.setFetchOption(FetchOption.PARTIAL_EXECUTION, true);
            }
            if (this.containerLostAcceptable) {
                dest.setContainerLostAcceptable(true);
            }
            if (this.extOptions != null) {
                for (Map.Entry<Integer, byte[]> entry : this.extOptions.entrySet()) {
                    Integer key = entry.getKey();
                    boolean inheritable = this.inheritableOptionKeys != null && this.inheritableOptionKeys.contains(key);
                    dest.setExtOption(key, entry.getValue(), inheritable);
                }
            }
            if (this.acceptableResultKeys != null) {
                dest.setAcceptableResultKeys(this.acceptableResultKeys);
            }
        }

        void putFixed(BasicBuffer out) {
            out.putLong(this.fetchLimit);
            if (SubnetQuery.isFetchSizeEnabled(NodeConnection.getProtocolVersion())) {
                out.putLong(this.fetchSize);
            }
            if (SubnetGridStore.isQueryOptionsExtensible()) {
                this.executionStatus.put(out);
            }
        }

        void setFetchLimit(long fetchLimit) throws GSException {
            this.fetchLimit = fetchLimit;
        }

        void setFetchSize(long fetchSize) throws GSException {
            QueryParameters.checkPartialOptions(fetchSize, this.executionStatus);
            this.fetchSize = fetchSize;
        }

        void setPartialExecutionEnabled(boolean enabled) throws GSException {
            SubnetContainer.PartialExecutionStatus executionStatus = enabled ? SubnetContainer.PartialExecutionStatus.ENABLED_INITIAL : SubnetContainer.PartialExecutionStatus.DISABLED;
            QueryParameters.checkPartialOptions(this.fetchSize, executionStatus);
            this.executionStatus = executionStatus;
            this.executionPartial = enabled;
        }

        boolean isPartialExecutionConfigured() {
            return this.executionPartial;
        }

        void setExtOption(int key, byte[] value, boolean followingInheritable) throws GSException {
            if (this.extOptions == null) {
                this.extOptions = new HashMap<Integer, byte[]>();
            }
            this.extOptions.put(key, value);
            if (followingInheritable) {
                if (this.inheritableOptionKeys == null) {
                    this.inheritableOptionKeys = new HashSet<Integer>();
                }
                this.inheritableOptionKeys.add(key);
            }
        }

        void checkResultType(int type) throws GSException {
            if (!this.acceptableResultKeys.contains(type)) {
                throw new GSException(145031, "Protocol error by unexpected query result type (type=" + type + ")");
            }
        }

        static void checkPartialOptions(long fetchSize, SubnetContainer.PartialExecutionStatus executionStatus) throws GSException {
            if (QueryParameters.isPartialFetch(fetchSize) && executionStatus.isEnabled()) {
                throw new GSException(145002, "Partial fetch and partial execution cannot be enabled at the same time");
            }
        }

        static boolean isPartialFetch(long fetchSize) {
            return fetchSize != Long.MAX_VALUE;
        }

        static boolean isForUpdate(QueryParameters src, boolean forUpdate) {
            return QueryParameters.get((QueryParameters)src).forUpdate || forUpdate;
        }

        static long resolveInitialTransactionId(QueryParameters src) {
            Long transactionId = QueryParameters.findInitialTransactionId(src);
            return transactionId == null ? 0L : transactionId;
        }

        static Long findInitialTransactionId(QueryParameters src) {
            return QueryParameters.get((QueryParameters)src).initialTransactionId;
        }

        static QueryParameters get(QueryParameters src) {
            return src == null ? DEFAULT_INSTANCE : src;
        }

        static QueryParameters resolve(QueryParameters src) {
            return src == null ? new QueryParameters() : src;
        }

        static QueryParameters inherit(QueryParameters src, boolean forUpdate, long transactionId, SubnetContainer.PartialExecutionStatus executionStatus) throws GSException {
            if (src == null && !forUpdate && transactionId == 0L && !SubnetContainer.PartialExecutionStatus.isEnabled(executionStatus)) {
                return null;
            }
            QueryParameters dest = src == null ? new QueryParameters() : new QueryParameters(src);
            dest.forUpdate = QueryParameters.isForUpdate(src, forUpdate);
            if (dest.initialTransactionId != null && dest.initialTransactionId != transactionId) {
                throw new Error();
            }
            dest.initialTransactionId = transactionId;
            dest.executionStatus = SubnetContainer.PartialExecutionStatus.inherit(dest.executionStatus, executionStatus);
            if (src != null && src.extOptions != null && dest.inheritableOptionKeys != null) {
                dest.extOptions.keySet().retainAll(dest.inheritableOptionKeys);
            }
            return dest;
        }
    }
}

