/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.PartitionController;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.ContainerKeyPredicate;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubnetPartitionController
implements PartitionController,
Extensibles.AsPartitionController {
    static final boolean WORKAROUND_WRONG_API_TEST = true;
    private static final ContainerKeyPredicate DEFAULT_PREDICATE = ContainerKeyPredicate.ofDefaultAttributes(true);
    private static final ContainerKeyPredicate COMPATIBLE_PREDICATE = ContainerKeyPredicate.ofDefaultAttributes(false);
    private final GridStoreChannel channel;
    private final GridStoreChannel.Context context;
    private boolean closed;

    public SubnetPartitionController(GridStoreChannel channel, GridStoreChannel.Context context) {
        this.channel = channel;
        this.context = context;
    }

    private void checkOpened() throws GSException {
        if (this.closed) {
            throw new GSException(145040, "This controller already closed");
        }
        this.channel.checkContextAvailable(this.context);
    }

    private void checkPartitionIndex(int partitionIndex) throws GSException {
        int partitionCount = this.channel.getPartitionCount(this.context);
        if (partitionIndex < 0 || partitionIndex >= partitionCount) {
            throw new GSException(145002, "Partition index out of range (partitionIndex=" + partitionIndex + ", partitionCount=" + partitionCount + ")");
        }
    }

    private static ContainerKeyPredicate getContainerKeyPredicate() {
        if (SubnetGridStore.isContainerAttributeUnified()) {
            return DEFAULT_PREDICATE;
        }
        return COMPATIBLE_PREDICATE;
    }

    private static void putContainerKeyPredicate(BasicBuffer req, ContainerKeyPredicate pred) throws GSException {
        int[] attributes = pred.getAttributes();
        if (attributes.length > 0) {
            req.putInt(attributes.length);
            for (int attribute : attributes) {
                req.putInt(attribute);
            }
        } else {
            throw new GSException(145001, "No container attribute specified");
        }
    }

    @Override
    public int getPartitionCount() throws GSException {
        this.checkOpened();
        return this.channel.getPartitionCount(this.context);
    }

    @Override
    public long getContainerCount(int partitionIndex) throws GSException {
        ContainerKeyPredicate pred = SubnetPartitionController.getContainerKeyPredicate();
        return this.getContainerCount(partitionIndex, pred, false);
    }

    @Override
    public long getContainerCount(int partitionIndex, ContainerKeyPredicate pred, boolean systemMode) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode, false, null);
        long start = 0L;
        long limit = 0L;
        req.putLong(0L);
        req.putLong(0L);
        SubnetPartitionController.putContainerKeyPredicate(req, pred);
        this.channel.executeStatement(this.context, Statement.GET_PARTITION_CONTAINER_NAMES.generalize(), partitionIndex, 0L, req, resp, null);
        long totalCount = resp.base().getLong();
        if (totalCount < 0L) {
            throw new GSException(145031, "Negative result by protocol error");
        }
        return totalCount;
    }

    @Override
    public List<String> getContainerNames(int partitionIndex, long start, Long limit) throws GSException {
        ContainerKeyPredicate pred = SubnetPartitionController.getContainerKeyPredicate();
        return this.getContainerNames(partitionIndex, start, limit, pred, false);
    }

    @Override
    public List<String> getContainerNames(int partitionIndex, long start, Long limit, ContainerKeyPredicate pred, boolean systemMode) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode, false, null);
        req.putLong(start);
        req.putLong(limit == null ? Long.MAX_VALUE : limit);
        SubnetPartitionController.putContainerKeyPredicate(req, pred);
        this.channel.executeStatement(this.context, Statement.GET_PARTITION_CONTAINER_NAMES.generalize(), partitionIndex, 0L, req, resp, null);
        ContainerKeyConverter keyConverter = this.context.getKeyConverter(systemMode);
        resp.base().getLong();
        int entryCount = resp.base().getInt();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < entryCount; ++i) {
            list.add(keyConverter.get(resp, false, true).toString());
        }
        return list;
    }

    private List<InetAddress> toAddressList(InetSocketAddress[] sockAddrList) {
        ArrayList<InetAddress> addrList = new ArrayList<InetAddress>();
        for (InetSocketAddress sockAddr : sockAddrList) {
            if (sockAddr == null || addrList.contains(sockAddr.getAddress())) continue;
            addrList.add(sockAddr.getAddress());
        }
        return addrList;
    }

    @Override
    public List<InetAddress> getHosts(int partitionIndex) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        InetSocketAddress[] baseList = this.channel.getNodeAddressList(this.context, partitionIndex);
        return this.toAddressList(baseList);
    }

    @Override
    public InetAddress getOwnerHost(int partitionIndex) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        InetSocketAddress[] baseList = this.channel.getNodeAddressList(this.context, partitionIndex);
        if (baseList.length == 0 || baseList[0] == null) {
            return null;
        }
        return baseList[0].getAddress();
    }

    @Override
    public List<InetAddress> getBackupHosts(int partitionIndex) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        InetSocketAddress[] baseList = this.channel.getNodeAddressList(this.context, partitionIndex);
        if (baseList.length > 0) {
            baseList[0] = null;
        }
        return this.toAddressList(baseList);
    }

    @Override
    public void assignPreferableHost(int partitionIndex, InetAddress host) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        this.context.setPreferableHost(partitionIndex, host);
    }

    @Override
    public int getPartitionIndexOfContainer(String containerName) throws GSException {
        boolean systemMode = true;
        return this.getPartitionIndexOfContainer(containerName, true);
    }

    @Override
    public int getPartitionIndexOfContainer(String containerName, boolean systemMode) throws GSException {
        ContainerKeyConverter.ContainerKey containerKey;
        this.checkOpened();
        ContainerKeyConverter keyConverter = this.context.getKeyConverter(systemMode);
        try {
            containerKey = keyConverter.parse(containerName, systemMode);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(containerName, "containerName", e);
        }
        return this.getPartitionIndexOfContainer(containerKey, systemMode);
    }

    @Override
    public int getPartitionIndexOfContainer(ContainerKeyConverter.ContainerKey containerKey, boolean systemMode) throws GSException {
        this.checkOpened();
        try {
            return this.channel.resolvePartitionId(this.context, containerKey, systemMode);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(containerKey, "containerKey", e);
        }
    }

    @Override
    public void close() throws GSException {
        this.closed = true;
    }
}

