/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.ColumnInfo;
import com.toshiba.mwcloud.gs.CompressionMethod;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSType;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.IndexInfo;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowKeyPredicate;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.TimeSeriesProperties;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TriggerInfo;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.ContainerKeyPredicate;
import com.toshiba.mwcloud.gs.common.ContainerProperties;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.experimental.ContainerAttribute;
import com.toshiba.mwcloud.gs.experimental.DatabaseInfo;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import com.toshiba.mwcloud.gs.experimental.PrivilegeInfo;
import com.toshiba.mwcloud.gs.experimental.UserInfo;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.SubnetCollection;
import com.toshiba.mwcloud.gs.subnet.SubnetContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetPartitionController;
import com.toshiba.mwcloud.gs.subnet.SubnetQuery;
import com.toshiba.mwcloud.gs.subnet.SubnetTimeSeries;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubnetGridStore
implements GridStore,
Extensibles.AsStore,
Experimentals.AsStore,
Experimentals.StoreProvider {
    private static final boolean ENABLE_COMPRESSION_WINDOW_SIZE = true;
    private static boolean OLD_TIME_SERIES_PROPERTIES = false;
    static final boolean WORKAROUND_WRONG_API_TEST = true;
    private static final LoggingUtils.BaseGridStoreLogger LOGGER = LoggingUtils.getLogger("Transaction");
    private static final String ERROR_PARAM_CONTAINER = "container";
    private static boolean pathKeyOperationEnabled = false;
    private static final int SYSTEM_USER_PARTITION_ID = 0;
    private static final String DEFAULT_PRIVILEGE = "ALL";
    private static final int MAX_PASSWORD_BYTES_LENGTH = 64;
    private static final IndexType[] INDEX_TYPE_CONSTANTS = IndexType.values();
    private static final byte INDEX_TYPE_DEFAULT_VALUE = -1;
    private static final RowMapper.Config DEFAULT_MAPPER_CONFIG = new RowMapper.Config(false, true, true);
    private static final RowMapper.Config COMPATIBLE_MAPPER_CONFIG_14 = new RowMapper.Config(false, true, false);
    private static final RowMapper.Config COMPATIBLE_MAPPER_CONFIG_13 = new RowMapper.Config(false, false, false);
    private final GridStoreChannel channel;
    private final GridStoreChannel.Context context;
    private final GridStoreChannel.ContextReference contextRef;
    private final NamedContainerMap<SubnetContainer<?, ?>> containerMap;
    private final GridStoreChannel.ContextMonitor contextMonitor = GridStoreChannel.createContextMonitorIfAvailable();
    private static final ContainerKeyConverter.ContainerKey CONTEXT_CONTROLLER_KEY = SubnetGridStore.createSystemContainerKey("#_internal_context_controller");

    public SubnetGridStore(GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
        this.channel = channel;
        this.context = context;
        this.contextRef = channel.registerContext(context, this);
        if (context.getContainerCache() != null) {
            context.addRemoteReference(new CacheReference(this, context));
        }
        this.containerMap = pathKeyOperationEnabled ? SubnetGridStore.makeContainerMap() : null;
    }

    private static NamedContainerMap<SubnetContainer<?, ?>> makeContainerMap() {
        return new NamedContainerMap<SubnetContainer<?, ?>>(){

            @Override
            protected Class<?> getRowType(SubnetContainer<?, ?> container) {
                return container.getRowMapper().getRowType();
            }
        };
    }

    static void setPathKeyOperationEnabled(boolean pathKeyOperationEnabled) {
        SubnetGridStore.pathKeyOperationEnabled = pathKeyOperationEnabled;
    }

    public GridStoreChannel getChannel() {
        return this.channel;
    }

    public GridStoreChannel.Context getContext() {
        return this.context;
    }

    @Override
    public void executeStatement(Statement.GeneralStatement statement, int partitionIndex, Extensibles.StatementHandler handler) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        handler.makeRequest(req);
        this.channel.executeStatement(this.context, statement, partitionIndex, 0L, req, resp, this.contextMonitor);
        handler.acceptResponse(resp);
    }

    private void executeStatement(Statement statement, int partitionId, BasicBuffer req, BasicBuffer resp, ContainerKeyConverter.ContainerKey key) throws GSException {
        this.beginComplexedStatement(statement, partitionId, key);
        this.channel.executeStatement(this.context, statement.generalize(), partitionId, 0L, req, resp, this.contextMonitor);
        this.endComplexedStatement();
    }

    private void beginComplexedStatement(Statement statement, int partitionId, ContainerKeyConverter.ContainerKey key) {
        if (this.contextMonitor != null) {
            this.contextMonitor.setContainerKey(key);
            this.contextMonitor.startStatement(statement.generalize(), 0L, partitionId, null);
        }
    }

    private void endComplexedStatement() {
        if (this.contextMonitor != null) {
            this.contextMonitor.endStatement();
        }
    }

    private SubnetContainer<?, ?> resolveContainer(ContainerKeyConverter.ContainerKey containerKey, Class<?> rowType) throws GSException {
        if (this.containerMap == null) {
            throw new GSException(145003, "Path key operation is restricted");
        }
        SubnetContainer<?, ?> container = this.containerMap.get(containerKey, rowType);
        if (container == null) {
            throw new GSException(145034, "Related container not opened (name=" + containerKey + ", rowType=" + (rowType == null ? "" : rowType.getName()) + ")");
        }
        return this.duplicateContainer(container);
    }

    private <R> SubnetContainer<?, R> duplicateContainer(SubnetContainer<?, R> base) throws GSException {
        RowMapper mapper = base.getRowMapper();
        if (mapper.isForTimeSeries()) {
            return new SubnetTimeSeries<R>(this, this.channel, this.context, base.getRowType(), mapper, base.getSchemaVersionId(), base.getPartitionId(), base.getContainerId(), null, null);
        }
        return new SubnetCollection(this, this.channel, this.context, base.getRowType(), mapper, base.getSchemaVersionId(), base.getPartitionId(), base.getContainerId(), null, null);
    }

    void createReference(SubnetContainer<?, ?> container) throws GSException {
        if (this.containerMap == null) {
            return;
        }
        this.containerMap.add(container.getNormalizedContainerKey(), container);
    }

    void removeReference(SubnetContainer<?, ?> container) {
        if (this.containerMap == null) {
            return;
        }
        this.containerMap.remove(container.getNormalizedContainerKey(), container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean put(String pathKey, Object rowObject) throws GSException {
        boolean bl;
        String[] keyElements = SubnetGridStore.splitPathKey(pathKey);
        SubnetContainer<?, ?> container = this.resolveContainer(this.parseContainerKey(keyElements[0]), rowObject.getClass());
        try {
            RowMapper mapper = container.getRowMapper();
            Object key = mapper.resolveKey(keyElements[1]);
            bl = SubnetGridStore.putChecked(container, key, rowObject);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            container.close();
            throw throwable;
        }
        container.close();
        return bl;
    }

    private static <R> boolean putChecked(SubnetContainer<?, R> container, Object key, Object row) throws GSException {
        SubnetContainer<Object, R> typedContainer = SubnetGridStore.disguiseTypedContainer(container);
        Class<R> rowType = typedContainer.getRowType();
        return typedContainer.put(key, rowType.cast(row));
    }

    @Override
    @Deprecated
    public Object get(String pathKey) throws GSException {
        return this.getByPathKey(pathKey, null);
    }

    @Override
    @Deprecated
    public <R> R get(String pathKey, Class<R> rowType) throws GSException {
        return rowType.cast(this.getByPathKey(pathKey, rowType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getByPathKey(String pathKey, Class<?> rowType) throws GSException {
        Object obj;
        String[] keyElements = SubnetGridStore.splitPathKey(pathKey);
        SubnetContainer<Object, ?> container = SubnetGridStore.disguiseTypedContainer(this.resolveContainer(this.parseContainerKey(keyElements[0]), rowType));
        try {
            RowMapper mapper = container.getRowMapper();
            Object key = mapper.resolveKey(keyElements[1]);
            obj = container.get(key);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            container.close();
            throw throwable;
        }
        container.close();
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean remove(String pathKey) throws GSException {
        boolean bl;
        String[] keyElements = SubnetGridStore.splitPathKey(pathKey);
        SubnetContainer<Object, ?> container = SubnetGridStore.disguiseTypedContainer(this.resolveContainer(this.parseContainerKey(keyElements[0]), null));
        try {
            RowMapper mapper = container.getRowMapper();
            Object key = mapper.resolveKey(keyElements[1]);
            bl = container.remove(key);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            container.close();
            throw throwable;
        }
        container.close();
        return bl;
    }

    private static String[] splitPathKey(String pathKey) throws GSException {
        String[] components = pathKey.split("/", 2);
        if (components.length != 2) {
            throw new GSException(145002, "Invalid path key (value=" + pathKey + ")");
        }
        return components;
    }

    @Override
    public long getDatabaseId() throws GSException {
        return this.channel.getDatabaseId(this.context);
    }

    @Override
    public ContainerKeyConverter getContainerKeyConverter(boolean systemMode) throws GSException {
        return this.context.getKeyConverter(systemMode);
    }

    private ContainerKeyConverter.ContainerKey parseContainerKey(String name) throws GSException {
        return this.parseContainerKey(name, false);
    }

    private ContainerKeyConverter.ContainerKey parseContainerKey(String name, boolean systemMode) throws GSException {
        return this.getContainerKeyConverter(systemMode).parse(name, systemMode);
    }

    private void putContainerKey(BasicBuffer req, ContainerKeyConverter.ContainerKey key, ContainerKeyConverter keyConverter) throws GSException {
        long databaseId = this.channel.getDatabaseId(this.context);
        keyConverter.put(key, databaseId, req);
    }

    static void tryPutSystemOptionalRequest(BasicBuffer req, GridStoreChannel.Context context, boolean systemMode, boolean forCreationDDL, Integer containerAttribute) {
        SubnetGridStore.tryPutSystemOptionalRequest(req, context, systemMode, forCreationDDL, containerAttribute, null);
    }

    static void tryPutSystemOptionalRequest(BasicBuffer req, GridStoreChannel.Context context, boolean systemMode, boolean forCreationDDL, Integer containerAttribute, NodeConnection.OptionalRequestSource source) {
        boolean clientIdRequired;
        boolean bl = clientIdRequired = forCreationDDL && SubnetGridStore.isClientIdEnabled();
        if (!(systemMode || clientIdRequired || containerAttribute != null || source != null && source.hasOptions())) {
            NodeConnection.tryPutEmptyOptionalRequest(req);
            return;
        }
        NodeConnection.OptionalRequest optionalRequest = context.getOptionalRequest();
        if (systemMode) {
            optionalRequest.put(NodeConnection.OptionalRequestType.SYSTEM_MODE, systemMode);
        }
        if (containerAttribute != null) {
            optionalRequest.put(NodeConnection.OptionalRequestType.CONTAINER_ATTRIBUTE, containerAttribute);
        }
        if (clientIdRequired) {
            optionalRequest.put(NodeConnection.OptionalRequestType.CLIENT_ID, context.generateClientId());
        }
        if (source != null) {
            source.putOptions(optionalRequest);
        }
        optionalRequest.format(req);
    }

    private static void tryPutDatabaseOptionalRequest(BasicBuffer req, GridStoreChannel.Context context, NodeConnection.OptionalRequestSource source) {
        if (source == null || !source.hasOptions()) {
            NodeConnection.tryPutEmptyOptionalRequest(req);
            return;
        }
        NodeConnection.OptionalRequest optionalRequest = context.getOptionalRequest();
        source.putOptions(optionalRequest);
        optionalRequest.format(req);
    }

    @Override
    public ContainerInfo getContainerInfo(String name) throws GSException {
        return ContainerProperties.findInfo(this.getContainerProperties(this.parseContainerKey(name, false), null, null, false));
    }

    @Override
    public ContainerProperties getContainerProperties(ContainerKeyConverter.ContainerKey key, ContainerProperties.KeySet propKeySet, Integer attribute, boolean systemMode) throws GSException {
        if (propKeySet == null) {
            propKeySet = ContainerPropertyKeysConstants.resolveDefault();
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode, false, attribute);
        ContainerKeyConverter keyConverter = this.context.getKeyConverter(systemMode);
        int partitionId = this.channel.resolvePartitionId(this.context, key, true);
        this.putContainerKey(req, key, keyConverter);
        Integer[] rawPropKeys = propKeySet.getRawKeys();
        req.putInt(rawPropKeys.length);
        Integer[] integerArray = rawPropKeys;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int propKey = integerArray[i];
            req.put((byte)propKey);
        }
        this.executeStatement(Statement.GET_CONTAINER_PROPERTIES, partitionId, req, resp, key);
        boolean found = resp.getBoolean();
        if (!found) {
            return null;
        }
        int propertyCount = resp.base().getInt();
        if (propertyCount != rawPropKeys.length) {
            throw new GSConnectionException(145031, "Protocol error by illegal property count (expected=" + rawPropKeys.length + ", actual=" + propertyCount + ")");
        }
        ContainerInfo containerInfo = new ContainerInfo();
        ContainerProperties.ContainerIdInfo containerIdInfo = null;
        ArrayList<ColumnInfo> columnInfoList = null;
        ArrayList<IndexInfo> indexInfoList = null;
        Integer respAttribute = null;
        HashMap<Integer, byte[]> rawEntries = null;
        for (int i = 0; i < propertyCount; ++i) {
            byte rawPropertyKey = resp.base().get();
            int propertySize = BasicBuffer.BufferUtils.getIntSize(resp.base());
            ContainerProperties.Key propertyKey = ContainerProperties.tryResolveKey(rawPropertyKey);
            if (propertyKey == null) {
                byte[] rawProperty = new byte[propertySize];
                resp.base().get(rawProperty);
                if (rawEntries == null) {
                    rawEntries = new HashMap<Integer, byte[]>();
                }
                rawEntries.put(Integer.valueOf(rawPropertyKey), rawProperty);
                continue;
            }
            int curEnd = resp.base().position() + propertySize;
            switch (propertyKey) {
                case ID: {
                    containerIdInfo = SubnetGridStore.importIdProperty(resp, keyConverter);
                    break;
                }
                case SCHEMA: {
                    columnInfoList = new ArrayList<ColumnInfo>();
                    SubnetGridStore.importSchemaProperty(resp, containerInfo, columnInfoList);
                    SubnetGridStore.importContainerProperties(resp, containerInfo, columnInfoList);
                    break;
                }
                case INDEX: {
                    SubnetGridStore.importIndexProperty(resp, columnInfoList);
                    break;
                }
                case EVENT_NOTIFICATION: {
                    SubnetGridStore.importEventNotificationProperty(resp, new ArrayList<URL>());
                    break;
                }
                case TRIGGER: {
                    SubnetGridStore.importTriggerProperty(resp, containerInfo, columnInfoList);
                    break;
                }
                case ATTRIBUTE: {
                    respAttribute = SubnetGridStore.importAttributeProperty(resp, attribute);
                    break;
                }
                case INDEX_DETAIL: {
                    indexInfoList = new ArrayList<IndexInfo>();
                    SubnetGridStore.importIndexDetailProperty(resp, indexInfoList);
                    break;
                }
                default: {
                    throw new GSConnectionException(145031, "Protocol error by illegal property type");
                }
            }
            if (resp.base().position() == curEnd) continue;
            throw new GSConnectionException(145031, "Protocol error by illegal property format");
        }
        if (containerIdInfo != null) {
            containerInfo.setName(containerIdInfo.remoteKey.toString());
        }
        if (columnInfoList != null) {
            containerInfo.setColumnInfoList(columnInfoList);
        }
        if (indexInfoList != null) {
            SubnetGridStore.assignIndexColumnNames(containerInfo, indexInfoList, respAttribute, systemMode);
            containerInfo.setIndexInfoList(indexInfoList);
        }
        ContainerProperties containerProps = new ContainerProperties();
        containerProps.setInfo(containerInfo);
        containerProps.setIdInfo(containerIdInfo);
        containerProps.setAttribute(respAttribute);
        containerProps.setRawEntries(rawEntries);
        return containerProps;
    }

    public <K, R> SubnetCollection<K, R> putCollection(String name, Class<R> rowType) throws GSException {
        return this.putCollection(name, (Class)rowType, false);
    }

    private static ContainerKeyConverter.ContainerKey normalizeFullContainerKey(ContainerKeyConverter.ContainerKey key, boolean systemMode) throws GSException {
        return key.toCaseSensitive(false);
    }

    private <K, R> SubnetContainer<K, R> findContainerByCache(GridStoreChannel.ContainerCache cache, ContainerKeyConverter.ContainerKey key, Class<R> rowType, ContainerType containerType, boolean systemMode) throws GSException {
        ContainerKeyConverter.ContainerKey normalizedKey = SubnetGridStore.normalizeFullContainerKey(key, systemMode);
        GridStoreChannel.LocatedSchema schema = cache.findSchema(normalizedKey, rowType, containerType);
        if (schema == null) {
            return null;
        }
        int partitionId = this.channel.resolvePartitionId(this.context, normalizedKey, systemMode);
        if (containerType == ContainerType.COLLECTION) {
            return new SubnetCollection(this, this.channel, this.context, rowType, schema.getMapper(), schema.getVersionId(), partitionId, schema.getContainerId(), normalizedKey, schema.getContainerKey());
        }
        return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<R>(this, this.channel, this.context, rowType, schema.getMapper(), schema.getVersionId(), partitionId, schema.getContainerId(), normalizedKey, schema.getContainerKey()));
    }

    @Override
    public void removeContainerCache(ContainerKeyConverter.ContainerKey key, boolean systemMode) throws GSException {
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null) {
            cache.removeSchema(key.toCaseSensitive(false));
        }
    }

    public static boolean isContainerStatementUnified() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    public static boolean isSessionUUIDSummarized() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    public static boolean isTSDivisionAndAffinityEnabled() {
        return NodeConnection.getProtocolVersion() >= 3 && !GridStoreChannel.v15TSPropsCompatible;
    }

    public static boolean isClientIdEnabled() {
        return NodeConnection.getProtocolVersion() >= 13;
    }

    public static boolean isIndexDetailEnabled() {
        return NodeConnection.getProtocolVersion() >= 13;
    }

    public static boolean isContainerAttributeUnified() {
        return NodeConnection.getProtocolVersion() >= 13;
    }

    public static boolean isAttributeVerifiable() {
        return NodeConnection.getProtocolVersion() >= 13;
    }

    public static boolean isNullableColumnAllowed(int protocolVersion) {
        return protocolVersion >= 13;
    }

    public static boolean isQueryOptionsExtensible() {
        return NodeConnection.getProtocolVersion() >= 14 && !GridStoreChannel.v40QueryCompatible;
    }

    public static RowMapper.Config getRowMapperConfig() {
        return SubnetGridStore.getRowMapperConfig(NodeConnection.getProtocolVersion());
    }

    public static RowMapper.Config getRowMapperConfig(int protocolVersion) {
        if (protocolVersion >= 14 && !GridStoreChannel.v40SchemaCompatible) {
            return DEFAULT_MAPPER_CONFIG;
        }
        if (SubnetGridStore.isNullableColumnAllowed(protocolVersion)) {
            return COMPATIBLE_MAPPER_CONFIG_14;
        }
        return COMPATIBLE_MAPPER_CONFIG_13;
    }

    private static Statement getContainerStatement(Statement statement, ContainerType containerType) {
        if (SubnetGridStore.isContainerStatementUnified()) {
            return statement;
        }
        if (containerType == ContainerType.TIME_SERIES) {
            switch (statement) {
                case PUT_CONTAINER: {
                    return Statement.PUT_TIME_SERIES;
                }
                case GET_CONTAINER: {
                    return Statement.GET_TIME_SERIES;
                }
                case DROP_CONTAINER: {
                    return Statement.DROP_TIME_SERIES;
                }
            }
            throw new Error("Internal error by invalid container statement (statement=" + (Object)((Object)statement) + ")");
        }
        if (containerType == ContainerType.COLLECTION) {
            if (statement == Statement.DROP_CONTAINER) {
                return Statement.DROP_COLLECTION;
            }
            return statement;
        }
        return statement;
    }

    private static void tryPutContainerType(BasicBuffer req, ContainerType containerType) {
        if (!SubnetGridStore.isContainerStatementUnified()) {
            return;
        }
        if (containerType == null) {
            req.put((byte)-1);
        } else {
            req.putByteEnum(containerType);
        }
    }

    private <K, R> SubnetContainer<K, R> putContainer(ContainerKeyConverter.ContainerKey key, ContainerType containerType, Class<R> rowType, ContainerInfo info, boolean modifiable, boolean systemMode) throws GSException {
        SubnetContainer<K, R> cachedContainer;
        ContainerKeyConverter keyConverter = this.context.getKeyConverter(systemMode);
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !modifiable && info == null && (cachedContainer = this.findContainerByCache(cache, key, rowType, containerType, systemMode)) != null) {
            return cachedContainer;
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode, true, null);
        RowMapper orgMapper = RowMapper.getInstance(rowType, containerType, SubnetGridStore.getRowMapperConfig());
        int partitionId = this.channel.resolvePartitionId(this.context, key, systemMode);
        this.putContainerKey(req, key, keyConverter);
        SubnetGridStore.tryPutContainerType(req, containerType);
        req.putBoolean(modifiable);
        orgMapper.exportSchema(req, SubnetGridStore.getRowMapperConfig());
        if (info != null && (info.getColumnCount() > 0 || info.isRowKeyAssigned() || info.isColumnOrderIgnorable())) {
            throw new GSException(145023, "Schema can not be specified on ContainerInfo (columnCount=" + info.getColumnCount() + ", rowKeyAssigned=" + info.isRowKeyAssigned() + ", columnOrderIgnorable=" + info.isColumnOrderIgnorable() + ")");
        }
        this.exportContainerProperties(req, containerType, info, orgMapper, key);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.PUT_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, key);
        int schemaVerId = resp.base().getInt();
        long containerId = resp.base().getLong();
        ContainerKeyConverter.ContainerKey[] acceptedKeys = this.acceptRemoteContainerKey(resp, keyConverter, key);
        ContainerKeyConverter.ContainerKey normalizedKey = acceptedKeys[0];
        ContainerKeyConverter.ContainerKey remoteKey = acceptedKeys[1];
        RowMapper mapper = orgMapper.reorderBySchema(resp, SubnetGridStore.getRowMapperConfig(), true);
        if (cache != null) {
            cache.cacheSchema(normalizedKey, new GridStoreChannel.LocatedSchema(mapper, containerId, schemaVerId, remoteKey));
        }
        if (mapper.isForTimeSeries()) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<R>(this, this.channel, this.context, rowType, mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey));
        }
        return new SubnetCollection(this, this.channel, this.context, rowType, mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey);
    }

    public <K, R> SubnetCollection<K, R> putCollection(String name, Class<R> rowType, boolean modifiable) throws GSException {
        SubnetContainer<K, R> container = this.putContainer(this.parseContainerKey(name), ContainerType.COLLECTION, rowType, null, modifiable, false);
        return (SubnetCollection)container;
    }

    public <R> SubnetTimeSeries<R> putTimeSeries(String name, Class<R> rowType) throws GSException {
        SubnetContainer container = this.putContainer(this.parseContainerKey(name), ContainerType.TIME_SERIES, rowType, null, false, false);
        return (SubnetTimeSeries)container;
    }

    public <R> SubnetTimeSeries<R> putTimeSeries(String name, Class<R> rowType, TimeSeriesProperties props, boolean modifiable) throws GSException {
        ContainerInfo info = new ContainerInfo();
        info.setTimeSeriesProperties(props);
        SubnetContainer container = this.putContainer(this.parseContainerKey(name), ContainerType.TIME_SERIES, rowType, info, modifiable, false);
        return (SubnetTimeSeries)container;
    }

    private ContainerKeyConverter.ContainerKey[] acceptRemoteContainerKey(BasicBuffer in, ContainerKeyConverter keyConverter, ContainerKeyConverter.ContainerKey localKey) throws GSException {
        ContainerKeyConverter.ContainerKey remoteKey = keyConverter.get(in, false, true);
        return this.filterRemoteContainerKey(remoteKey, localKey);
    }

    private ContainerKeyConverter.ContainerKey[] filterRemoteContainerKey(ContainerKeyConverter.ContainerKey remoteKey, ContainerKeyConverter.ContainerKey localKey) throws GSException {
        ContainerKeyConverter.ContainerKey normalizedLocalKey = localKey.toCaseSensitive(false);
        if (!remoteKey.equals(localKey) && !remoteKey.toCaseSensitive(false).equals(normalizedLocalKey)) {
            throw new GSConnectionException(145031, "Protocol error by inconsistent container name (localName=" + localKey + ", remoteName=" + remoteKey + ")");
        }
        return new ContainerKeyConverter.ContainerKey[]{!pathKeyOperationEnabled && this.context.getContainerCache() == null ? null : normalizedLocalKey, this.contextMonitor == null ? null : remoteKey};
    }

    private void exportContainerProperties(BasicBuffer out, ContainerType type, ContainerInfo info, RowMapper mapper, ContainerKeyConverter.ContainerKey containerKey) throws GSException {
        TimeSeriesProperties tsProps;
        if (SubnetGridStore.isTSDivisionAndAffinityEnabled() && !GridStoreChannel.v20AffinityCompatible) {
            String dataAffinity = info == null ? null : info.getDataAffinity();
            out.putString(dataAffinity == null ? this.context.getDataAffinityPattern().match(containerKey, "", this.context.getKeyConverter(true)) : dataAffinity);
        }
        TimeSeriesProperties timeSeriesProperties = tsProps = info == null ? null : info.getTimeSeriesProperties();
        if (type != ContainerType.TIME_SERIES) {
            if (tsProps != null) {
                throw new GSException(145023, "TimeSeriesProperties used except for TimeSeries (containerType=" + (Object)((Object)type) + ")");
            }
            return;
        }
        if (OLD_TIME_SERIES_PROPERTIES) {
            out.putInt(-1);
            out.putByteEnum(TimeUnit.DAY);
            out.putInt(-1);
            out.putByteEnum(TimeUnit.DAY);
            out.putInt(0);
            return;
        }
        if (tsProps == null) {
            out.putBoolean(false);
        } else {
            out.putBoolean(true);
            out.putInt(tsProps.getRowExpirationTime());
            TimeUnit timeUnit = tsProps.getRowExpirationTimeUnit();
            if (timeUnit == null) {
                out.putByteEnum(TimeUnit.DAY);
            } else {
                out.putByteEnum(timeUnit);
            }
            if (SubnetGridStore.isTSDivisionAndAffinityEnabled()) {
                out.putInt(tsProps.getExpirationDivisionCount());
                if (GridStoreChannel.v20AffinityCompatible) {
                    out.putString("");
                }
            }
            out.putInt(tsProps.getCompressionWindowSize());
            timeUnit = tsProps.getCompressionWindowSizeUnit();
            if (timeUnit == null) {
                out.putByteEnum(TimeUnit.DAY);
            } else {
                out.putByteEnum(timeUnit);
            }
            out.putByteEnum(tsProps.getCompressionMethod());
            Set<String> columnNameSet = tsProps.getSpecifiedColumns();
            out.putInt(columnNameSet.size());
            for (String columnName : columnNameSet) {
                out.putInt(mapper.resolveColumnId(columnName));
                boolean relative = tsProps.isCompressionRelative(columnName);
                out.putBoolean(relative);
                if (relative) {
                    out.putDouble(tsProps.getCompressionRate(columnName));
                    out.putDouble(tsProps.getCompressionSpan(columnName));
                    continue;
                }
                out.putDouble(tsProps.getCompressionWidth(columnName));
            }
        }
    }

    private static void importContainerProperties(BasicBuffer in, ContainerInfo containerInfo, List<ColumnInfo> columnInfoList) throws GSException {
        if (SubnetGridStore.isTSDivisionAndAffinityEnabled() && !GridStoreChannel.v20AffinityCompatible) {
            String dataAffinity = in.getString();
            containerInfo.setDataAffinity(dataAffinity.isEmpty() ? null : dataAffinity);
        }
        if (containerInfo.getType() != ContainerType.TIME_SERIES) {
            return;
        }
        boolean exists = in.getBoolean();
        if (!exists) {
            return;
        }
        TimeSeriesProperties props = new TimeSeriesProperties();
        int rowExpirationTime = in.base().getInt();
        TimeUnit timeUnit = in.getByteEnum(TimeUnit.class);
        if (rowExpirationTime > 0) {
            props.setRowExpiration(rowExpirationTime, timeUnit);
        }
        if (SubnetGridStore.isTSDivisionAndAffinityEnabled()) {
            int count = in.base().getInt();
            if (count > 0) {
                props.setExpirationDivisionCount(count);
            }
            if (GridStoreChannel.v20AffinityCompatible) {
                in.getString();
            }
        }
        int compressionWindowSize = in.base().getInt();
        timeUnit = in.getByteEnum(TimeUnit.class);
        if (compressionWindowSize > 0) {
            props.setCompressionWindowSize(compressionWindowSize, timeUnit);
        }
        CompressionMethod compressionMethod = in.getByteEnum(CompressionMethod.class);
        props.setCompressionMethod(compressionMethod);
        int entryCount = BasicBuffer.BufferUtils.getNonNegativeInt(in.base());
        if (entryCount > 0 && compressionMethod != CompressionMethod.HI) {
            throw new GSException(145031, "Protocol error by unexpected compression entry (entryCount=" + entryCount + ", compressionMethod=" + (Object)((Object)compressionMethod) + ")");
        }
        if (entryCount < 0) {
            throw new GSException(145031, "Protocol error by negative entry count (entryCount=" + entryCount + ")");
        }
        for (int i = 0; i < entryCount; ++i) {
            int columnId = in.base().getInt();
            if (columnId < 0 || columnId >= columnInfoList.size()) {
                throw new GSException(145031, "Protocol error by illegal column ID (columnId=" + columnId + ", columnCount=" + columnInfoList.size() + ")");
            }
            String columnName = columnInfoList.get(columnId).getName();
            boolean relative = in.getBoolean();
            if (relative) {
                double rate = in.base().getDouble();
                double span = in.base().getDouble();
                props.setRelativeHiCompression(columnName, rate, span);
                continue;
            }
            double width = in.base().getDouble();
            props.setAbsoluteHiCompression(columnName, width);
        }
        containerInfo.setTimeSeriesProperties(props);
    }

    public <K, R> SubnetContainer<K, R> getContainer(ContainerKeyConverter.ContainerKey key, ContainerType containerType, Class<R> rowType, Integer attribute, boolean systemMode) throws GSException {
        SubnetContainer<K, R> cachedContainer;
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !systemMode && (cachedContainer = this.findContainerByCache(cache, key, rowType, containerType, systemMode)) != null) {
            return cachedContainer;
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode, false, attribute);
        RowMapper orgMapper = RowMapper.getInstance(rowType, containerType, SubnetGridStore.getRowMapperConfig());
        int partitionId = this.channel.resolvePartitionId(this.context, key, systemMode);
        ContainerKeyConverter keyConverter = this.context.getKeyConverter(systemMode);
        this.putContainerKey(req, key, keyConverter);
        SubnetGridStore.tryPutContainerType(req, containerType);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.GET_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, key);
        boolean found = resp.getBoolean();
        if (!found) {
            return null;
        }
        int schemaVerId = resp.base().getInt();
        long containerId = resp.base().getLong();
        ContainerKeyConverter.ContainerKey[] acceptedKeys = this.acceptRemoteContainerKey(resp, keyConverter, key);
        ContainerKeyConverter.ContainerKey normalizedKey = acceptedKeys[0];
        ContainerKeyConverter.ContainerKey remoteKey = acceptedKeys[1];
        RowMapper mapper = orgMapper.reorderBySchema(resp, SubnetGridStore.getRowMapperConfig(), true);
        if (cache != null && !systemMode) {
            cache.cacheSchema(normalizedKey, new GridStoreChannel.LocatedSchema(mapper, containerId, schemaVerId, remoteKey));
        }
        if (mapper.isForTimeSeries()) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<R>(this, this.channel, this.context, rowType, mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey));
        }
        return new SubnetCollection(this, this.channel, this.context, rowType, mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey);
    }

    public <K, R> SubnetCollection<K, R> getCollection(String name, Class<R> rowType) throws GSException {
        Extensibles.AsContainer container = this.getContainer(this.parseContainerKey(name), ContainerType.COLLECTION, (Class)rowType, (Integer)null, false);
        return (SubnetCollection)container;
    }

    public <R> SubnetTimeSeries<R> getTimeSeries(String name, Class<R> rowType) throws GSException {
        Extensibles.AsContainer container = this.getContainer(this.parseContainerKey(name), ContainerType.TIME_SERIES, (Class)rowType, (Integer)null, false);
        return (SubnetTimeSeries)container;
    }

    @Override
    public void dropCollection(String name) throws GSException {
        this.dropContainer(this.parseContainerKey(name), ContainerType.COLLECTION, false);
    }

    @Override
    public void dropTimeSeries(String name) throws GSException {
        this.dropContainer(this.parseContainerKey(name), ContainerType.TIME_SERIES, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws GSException {
        try {
            this.channel.closeContext(this.context);
            Object var2_1 = null;
            this.channel.unregisterContext(this.contextRef);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.channel.unregisterContext(this.contextRef);
            throw throwable;
        }
    }

    private static ContainerProperties.ContainerIdInfo importIdProperty(BasicBuffer in, ContainerKeyConverter keyConverter) throws GSException {
        int versionId = in.base().getInt();
        long containerId = in.base().getLong();
        ContainerKeyConverter.ContainerKey remoteKey = keyConverter.get(in, false, true);
        return new ContainerProperties.ContainerIdInfo(versionId, containerId, remoteKey);
    }

    private static void importSchemaProperty(BasicBuffer in, ContainerInfo containerInfo, List<ColumnInfo> columnInfoList) throws GSException {
        columnInfoList.clear();
        RowMapper.Config config = SubnetGridStore.getRowMapperConfig();
        containerInfo.setType(in.getByteEnum(ContainerType.class));
        int columnCount = RowMapper.importColumnCount(in);
        List<Integer> keyList = RowMapper.importKeyListBegin(in, config, columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columnInfoList.add(RowMapper.importColumnSchema(in, config));
        }
        containerInfo.setRowKeyAssigned(!(keyList = RowMapper.importKeyListEnd(in, config, columnCount, keyList)).isEmpty());
    }

    private static void importIndexProperty(BasicBuffer in, List<ColumnInfo> columnInfoList) throws GSException {
        int i;
        ArrayList<Set<Object>> indexTypesList = new ArrayList<Set<Object>>();
        int columnCount = columnInfoList == null ? -1 : columnInfoList.size();
        for (int i2 = 0; i2 < columnCount; ++i2) {
            indexTypesList.add(Collections.emptySet());
        }
        int entryCount = BasicBuffer.BufferUtils.getNonNegativeInt(in.base());
        for (i = 0; i < entryCount; ++i) {
            IndexType indexType;
            int columnId = in.base().getInt();
            if (columnId < 0 || columnId >= columnCount && columnCount >= 0) {
                throw new GSException(145031, "Protocol error by illegal column ID (entryCount=" + columnId + ", columnCount=" + columnCount + ")");
            }
            EnumSet<IndexType> indexTypeSet = (EnumSet<IndexType>)indexTypesList.get(columnId);
            if (indexTypeSet.isEmpty()) {
                indexTypeSet = EnumSet.noneOf(IndexType.class);
                indexTypesList.set(columnId, indexTypeSet);
            }
            if ((indexType = in.getByteEnum(IndexType.class)) == IndexType.DEFAULT) {
                throw new GSException(145031, "Protocol error by illegal index type");
            }
            indexTypeSet.add(indexType);
        }
        for (i = 0; i < columnCount; ++i) {
            ColumnInfo srcInfo = columnInfoList.get(i);
            columnInfoList.set(i, new ColumnInfo(srcInfo.getName(), srcInfo.getType(), srcInfo.getNullable(), (Set)indexTypesList.get(i)));
        }
    }

    private static void importEventNotificationProperty(BasicBuffer in, List<URL> eventNotificationInfoList) throws GSException {
        eventNotificationInfoList.clear();
        int entryCount = in.base().getInt();
        if (entryCount < 0) {
            return;
        }
        for (int i = 0; i < entryCount; ++i) {
            String urlString = in.getString();
            try {
                eventNotificationInfoList.add(new URL(urlString));
                continue;
            }
            catch (MalformedURLException e) {
                throw new GSConnectionException(145031, "Protocol error by malformed URL (urlString=\"" + urlString + "\", reason=" + e.getMessage() + ")", e);
            }
        }
    }

    private static void importTriggerProperty(BasicBuffer in, ContainerInfo containerInfo, List<ColumnInfo> columnInfoList) throws GSException {
        ArrayList<TriggerInfo> triggerInfoList = new ArrayList<TriggerInfo>();
        int entryCount = in.base().getInt();
        if (entryCount < 0) {
            containerInfo.setTriggerInfoList(triggerInfoList);
            return;
        }
        int schemaColumnCount = columnInfoList == null ? -1 : columnInfoList.size();
        for (int i = 0; i < entryCount; ++i) {
            String name = in.getString();
            TriggerInfo.Type type = in.getByteEnum(TriggerInfo.Type.class);
            String uriString = in.getString();
            int eventTypeFlag = in.base().getInt();
            EnumSet<TriggerInfo.EventType> eventSet = EnumSet.noneOf(TriggerInfo.EventType.class);
            EnumSet<TriggerInfo.EventType> allEventSet = EnumSet.allOf(TriggerInfo.EventType.class);
            for (TriggerInfo.EventType e : allEventSet) {
                if ((eventTypeFlag & 1 << e.ordinal()) == 0) continue;
                eventSet.add(e);
            }
            HashSet<String> columnSet = new HashSet<String>();
            int columnCount = in.base().getInt();
            for (int j = 0; j < columnCount; ++j) {
                int columnId = in.base().getInt();
                if (schemaColumnCount < 0) continue;
                if (columnId < 0 || columnId >= schemaColumnCount && schemaColumnCount >= 0) {
                    throw new GSException(145031, "Protocol error by illegal column ID (entryCount=" + columnId + ", columnCount=" + schemaColumnCount + ")");
                }
                String columnName = columnInfoList.get(columnId).getName();
                columnSet.add(columnName);
            }
            in.getString();
            String jmsDestinationType = in.getString();
            String jmsDestinationName = in.getString();
            String jmsUser = in.getString();
            String jmsPassword = in.getString();
            TriggerInfo info = new TriggerInfo();
            info.setName(name);
            info.setType(type);
            try {
                info.setURI(new URI(uriString));
            }
            catch (URISyntaxException e) {
                throw new GSConnectionException(145031, "Protocol error by malformed URI (uriString=\"" + uriString + "\", reason=" + e.getMessage() + ")", e);
            }
            info.setTargetEvents(eventSet);
            info.setTargetColumns(columnSet);
            info.setJMSDestinationType(jmsDestinationType);
            info.setJMSDestinationName(jmsDestinationName);
            info.setUser(jmsUser);
            info.setPassword(jmsPassword);
            triggerInfoList.add(info);
        }
        containerInfo.setTriggerInfoList(triggerInfoList);
    }

    private static int importAttributeProperty(BasicBuffer in, Integer expectedAttribute) throws GSException {
        int attribute = in.base().getInt();
        if (expectedAttribute != null && attribute != expectedAttribute) {
            if (!SubnetGridStore.isAttributeVerifiable()) {
                throw new Error();
            }
            throw new GSConnectionException(145031, "Protocol error by unexpected container attribute (expected=" + expectedAttribute + ", actual=" + attribute + ")");
        }
        return attribute;
    }

    private static void importIndexDetailProperty(BasicBuffer in, List<IndexInfo> indexInfoList) throws GSException {
        indexInfoList.clear();
        int entryCount = BasicBuffer.BufferUtils.getIntSize(in.base());
        for (int i = 0; i < entryCount; ++i) {
            IndexInfo indexInfo = new IndexInfo();
            SubnetGridStore.importIndexInfo(in, indexInfo, false, false);
            indexInfoList.add(indexInfo);
        }
    }

    private static void assignIndexColumnNames(ContainerInfo containerInfo, List<IndexInfo> indexInfoList, Integer attribute, boolean systemMode) throws GSException {
        if (systemMode && (attribute == null || attribute != ContainerKeyPredicate.ATTRIBUTE_BASE && attribute != ContainerKeyPredicate.ATTRIBUTE_SINGLE)) {
            return;
        }
        for (IndexInfo indexInfo : indexInfoList) {
            ColumnInfo columnInfo;
            Integer column = indexInfo.getColumn();
            if (column == null) continue;
            try {
                columnInfo = containerInfo.getColumnInfo(column);
            }
            catch (IllegalArgumentException e) {
                throw new GSConnectionException(145031, "Protocol error by illegal index column", e);
            }
            indexInfo.setColumnName(columnInfo.getName());
            IndexType type = indexInfo.getType();
            Set<IndexType> typeSet = columnInfo.getIndexTypes();
            if (typeSet == null || typeSet.contains((Object)type)) continue;
            throw new GSConnectionException(145031, "Protocol error by inconsistent index type (type=" + (Object)((Object)type) + ")");
        }
    }

    public static void importIndexInfo(BasicBuffer in, IndexInfo indexInfo, boolean withMatchOptions, boolean defaultTypeAllowed) throws GSException {
        IndexType type;
        int infoSize = in.base().getInt();
        int orgLimit = BasicBuffer.BufferUtils.limitForward(in.base(), infoSize);
        String name = in.getString();
        if (!name.isEmpty()) {
            indexInfo.setName(name);
        }
        int columnCount = BasicBuffer.BufferUtils.getNonNegativeInt(in.base());
        for (int i = 0; i < columnCount; ++i) {
            int column = in.base().getInt();
            if (i != 0) continue;
            indexInfo.setColumn(column);
        }
        byte rawType = in.base().get();
        if (rawType == -1) {
            type = IndexType.DEFAULT;
        } else {
            try {
                type = INDEX_TYPE_CONSTANTS[rawType & 0xFF];
            }
            catch (IndexOutOfBoundsException e) {
                throw new GSException(145031, "Protocol error by illegal index type (reason=" + e.getMessage() + ")", e);
            }
        }
        if (type == IndexType.DEFAULT && !defaultTypeAllowed) {
            throw new GSException(145031, "Protocol error by illegal index type");
        }
        indexInfo.setType(type);
        BasicBuffer.BufferUtils.skipToLimit(in.base(), orgLimit);
        if (withMatchOptions) {
            boolean anyNameMatches = in.getBoolean();
            boolean anyTypeMatches = in.getBoolean();
            if (anyNameMatches) {
                indexInfo.setName(null);
            }
            if (anyTypeMatches) {
                indexInfo.setType(null);
            }
        }
    }

    public static void exportIndexInfo(BasicBuffer out, IndexInfo indexInfo, boolean withMatchOptions) {
        IndexType type;
        int headPos = out.base().position();
        out.putInt(0);
        int startPos = out.base().position();
        String name = indexInfo.getName();
        out.putString(name == null ? "" : name);
        Integer column = indexInfo.getColumn();
        int columnCount = column == null ? 0 : 1;
        out.putInt(columnCount);
        if (columnCount > 0) {
            out.putInt(column);
        }
        if ((type = indexInfo.getType()) == null || type == IndexType.DEFAULT) {
            out.put((byte)-1);
        } else {
            out.putByteEnum(type);
        }
        int endPos = out.base().position();
        out.base().position(headPos);
        out.putInt(endPos - startPos);
        out.base().position(endPos);
        if (withMatchOptions) {
            boolean anyNameMatches = indexInfo.getName() == null;
            boolean anyTypeMatches = indexInfo.getType() == null;
            out.putBoolean(anyNameMatches);
            out.putBoolean(anyTypeMatches);
        }
    }

    private static <K, R> SubnetContainer<K, R> disguiseTypedContainer(SubnetContainer<?, R> container) {
        return container;
    }

    private ContainerKeyConverter.ContainerKey resolveContainerKey(ContainerKeyConverter.ContainerKey key, ContainerInfo info, ContainerKeyConverter keyConverter) throws GSException {
        boolean caseSensitive = true;
        String anotherName = info.getName();
        ContainerKeyConverter.ContainerKey specifiedKey = key == null ? null : key.toCaseSensitive(true);
        ContainerKeyConverter.ContainerKey anotherKey = anotherName == null ? null : keyConverter.parse(anotherName, true);
        return SubnetGridStore.resolveName(specifiedKey, anotherKey, "container name");
    }

    private static <T> T resolveName(T name, T anotherName, String objectName) throws GSException {
        T another;
        T t = another = anotherName == null ? null : (T)anotherName;
        if (name == null) {
            if (another == null) {
                throw new GSException(145001, "Non-specified" + objectName);
            }
            return another;
        }
        if (another != null && !name.equals(another)) {
            throw new GSException(145002, "Inconsistent " + objectName + " (specifiedName=" + name + ", nameOnInfo=" + another + ")");
        }
        return (T)name;
    }

    private static ContainerType resolveContainerType(ContainerType type, ContainerInfo info) throws GSException {
        ContainerType another;
        ContainerType containerType = another = info == null ? null : info.getType();
        if (type == null) {
            if (another == null) {
                throw new GSException(145001, "Container type not specified");
            }
            return another;
        }
        if (another != null && another != type) {
            throw new GSException(145023, "Inconsistent container type (specifiedType=" + (Object)((Object)type) + ", typeOnInfo=" + (Object)((Object)another) + ")");
        }
        return type;
    }

    public <K> SubnetContainer<K, Row> getContainer(ContainerKeyConverter.ContainerKey key, ContainerType expectedType, Integer attribute, boolean systemMode) throws GSException {
        SubnetContainer<K, Row> cachedContainer;
        SubnetCollection<K, Row> container;
        if (CONTEXT_CONTROLLER_KEY.equals(key) && (container = this.getContextControllerCollection(expectedType)) != null) {
            return container;
        }
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && (cachedContainer = this.findContainerByCache(cache, key, Row.class, expectedType, systemMode)) != null) {
            return cachedContainer;
        }
        ContainerProperties containerProps = this.getContainerProperties(key, ContainerPropertyKeysConstants.FOR_OBJECT, attribute, systemMode);
        if (containerProps == null) {
            return null;
        }
        ContainerInfo containerInfo = containerProps.getInfo();
        ContainerProperties.ContainerIdInfo idInfo = containerProps.getIdInfo();
        ContainerType resolvedType = SubnetGridStore.resolveContainerType(expectedType, containerInfo);
        int partitionId = this.channel.resolvePartitionId(this.context, key, systemMode);
        RowMapper mapper = RowMapper.getInstance(resolvedType, containerInfo, SubnetGridStore.getRowMapperConfig());
        ContainerKeyConverter.ContainerKey[] acceptedKeys = this.filterRemoteContainerKey(idInfo.remoteKey, key);
        ContainerKeyConverter.ContainerKey normalizedKey = acceptedKeys[0];
        ContainerKeyConverter.ContainerKey remoteKey = acceptedKeys[1];
        if (cache != null) {
            cache.cacheSchema(normalizedKey, new GridStoreChannel.LocatedSchema(mapper, idInfo.containerId, idInfo.versionId, remoteKey));
        }
        if (mapper.isForTimeSeries()) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<Row>(this, this.channel, this.context, Row.class, mapper, idInfo.versionId, partitionId, idInfo.containerId, normalizedKey, remoteKey));
        }
        return SubnetGridStore.disguiseTypedContainer(new SubnetCollection(this, this.channel, this.context, Row.class, mapper, idInfo.versionId, partitionId, idInfo.containerId, normalizedKey, remoteKey));
    }

    @Override
    public <K> Container<K, Row> getContainer(String name) throws GSException {
        return this.getContainer(this.parseContainerKey(name), null, null, false);
    }

    @Override
    public <K> Collection<K, Row> getCollection(String name) throws GSException {
        Extensibles.AsContainer container = this.getContainer(this.parseContainerKey(name), ContainerType.COLLECTION, null, false);
        return (Collection)((Object)container);
    }

    @Override
    public TimeSeries<Row> getTimeSeries(String name) throws GSException {
        Extensibles.AsContainer container = this.getContainer(this.parseContainerKey(name), ContainerType.TIME_SERIES, null, false);
        return (TimeSeries)((Object)container);
    }

    private <K> Container<K, Row> putContainer(ContainerKeyConverter.ContainerKey key, ContainerType containerType, ContainerInfo containerInfo, Integer containerAttribute, boolean modifiable, boolean systemMode) throws GSException {
        SubnetContainer<K, Row> container;
        ContainerKeyConverter keyConverter = this.context.getKeyConverter(systemMode);
        key = this.resolveContainerKey(key, containerInfo, keyConverter);
        containerType = SubnetGridStore.resolveContainerType(containerType, containerInfo);
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !modifiable && !systemMode && containerInfo.getTimeSeriesProperties() != null && (container = this.findContainerByCache(cache, key, Row.class, containerType, systemMode)) != null) {
            return container;
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode, true, containerAttribute);
        RowMapper orgMapper = RowMapper.getInstance(containerType, containerInfo, SubnetGridStore.getRowMapperConfig());
        int partitionId = this.channel.resolvePartitionId(this.context, key, systemMode);
        this.putContainerKey(req, key, keyConverter);
        SubnetGridStore.tryPutContainerType(req, containerType);
        req.putBoolean(modifiable);
        orgMapper.exportSchema(req, SubnetGridStore.getRowMapperConfig());
        this.exportContainerProperties(req, containerType, containerInfo, orgMapper, key);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.PUT_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, key);
        int schemaVerId = resp.base().getInt();
        long containerId = resp.base().getLong();
        ContainerKeyConverter.ContainerKey[] acceptedKeys = this.acceptRemoteContainerKey(resp, keyConverter, key);
        ContainerKeyConverter.ContainerKey normalizedKey = acceptedKeys[0];
        ContainerKeyConverter.ContainerKey remoteKey = acceptedKeys[1];
        RowMapper.Config config = SubnetGridStore.getRowMapperConfig();
        RowMapper mapper = orgMapper.reorderBySchema(resp, config, containerInfo.isColumnOrderIgnorable());
        if (cache != null && !systemMode) {
            cache.cacheSchema(normalizedKey, new GridStoreChannel.LocatedSchema(mapper, containerId, schemaVerId, remoteKey));
        }
        if (mapper.isForTimeSeries()) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<Row>(this, this.channel, this.context, Row.class, mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey));
        }
        return SubnetGridStore.disguiseTypedContainer(new SubnetCollection(this, this.channel, this.context, Row.class, mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey));
    }

    @Override
    public <K> Container<K, Row> putContainer(ContainerKeyConverter.ContainerKey key, ContainerProperties props, boolean modifiable, boolean systemMode) throws GSException {
        return this.putContainer(key, (ContainerType)null, props.getInfo(), props.getAttribute(), modifiable, systemMode);
    }

    @Override
    public <K> Container<K, Row> putContainer(String name, ContainerInfo info, boolean modifiable) throws GSException {
        ContainerKeyConverter.ContainerKey key = name == null ? null : this.parseContainerKey(name, false);
        return this.putContainer(key, (ContainerType)null, info, null, modifiable, false);
    }

    @Override
    public <K> Collection<K, Row> putCollection(String name, ContainerInfo info, boolean modifiable) throws GSException {
        ContainerKeyConverter.ContainerKey key = name == null ? null : this.parseContainerKey(name, false);
        Container<K, Row> container = this.putContainer(key, ContainerType.COLLECTION, info, null, modifiable, false);
        return (Collection)container;
    }

    @Override
    public TimeSeries<Row> putTimeSeries(String name, ContainerInfo info, boolean modifiable) throws GSException {
        ContainerKeyConverter.ContainerKey key = name == null ? null : this.parseContainerKey(name, false);
        Container container = this.putContainer(key, ContainerType.TIME_SERIES, info, null, modifiable, false);
        return (TimeSeries)container;
    }

    @Override
    public void dropContainer(ContainerKeyConverter.ContainerKey key, ContainerType containerType, boolean systemMode) throws GSException {
        ContainerKeyConverter keyConverter = this.context.getKeyConverter(systemMode);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode, false, null);
        this.putContainerKey(req, key, keyConverter);
        SubnetGridStore.tryPutContainerType(req, containerType);
        int partitionId = this.channel.resolvePartitionId(this.context, key, systemMode);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.DROP_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, key);
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null) {
            cache.removeSchema(key.toCaseSensitive(false));
        }
    }

    @Override
    public void dropContainer(String name) throws GSException {
        this.dropContainer(this.parseContainerKey(name), null, false);
    }

    @Override
    public Row createRow(ContainerInfo info) throws GSException {
        this.channel.checkContextAvailable(this.context);
        RowMapper mapper = RowMapper.getInstance(info.getType(), info, SubnetGridStore.getRowMapperConfig());
        return mapper.createGeneralRow();
    }

    @Override
    public void fetchAll(List<? extends Query<?>> queryList) throws GSException {
        this.fetchAll(new UnnamedMultiOperationContext(queryList));
    }

    @Override
    public void fetchAll(Extensibles.MultiOperationContext<Integer, Query<?>, Query<?>> multiContext) throws GSException {
        boolean systemMode = false;
        this.executeAllMulti(Statement.EXECUTE_MULTIPLE_QUERIES, MultiQueryStatement.newFactory(multiContext, this), false);
    }

    @Override
    public void multiPut(Map<String, List<Row>> containerRowsMap) throws GSException {
        this.multiPut(new NamedMultiOperationContext<List<Row>, Void>(containerRowsMap, this.context.getKeyConverter(false)), false);
    }

    @Override
    public void multiPut(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, List<Row>, Void> multiContext, boolean systemMode) throws GSException {
        this.executeAllMulti(Statement.PUT_MULTIPLE_CONTAINER_ROWS, MultiPutStatement.newFactory(multiContext), systemMode);
    }

    private <K, T, V, R> void executeAllMulti(Statement statement, MultiOperationStatement.Factory<K, T, V, R> factory, boolean systemMode) throws GSException {
        Extensibles.MultiOperationContext<K, V, R> multiContext = factory.getMultiContext();
        HashMap requestMap = new HashMap();
        Extensibles.MultiTargetConsumer<K, V> consumer = factory.createConsumer(requestMap, this.channel, this.context, systemMode);
        this.beginComplexedStatement(statement, 0, null);
        int lastIncompleteCount = -1;
        int trialCount = 0;
        while (true) {
            multiContext.listTarget(consumer);
            HashSet<Integer> incompleteSet = null;
            Iterator it = requestMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int partitionId = (Integer)entry.getKey();
                MultiOperationStatement multiStatement = (MultiOperationStatement)entry.getValue();
                try {
                    this.executeMulti(partitionId, statement, multiStatement, systemMode);
                }
                catch (GSStatementException e) {
                    if (multiContext.acceptException(e)) {
                        incompleteSet = new HashSet<Integer>();
                        incompleteSet.add(partitionId);
                        while (it.hasNext()) {
                            incompleteSet.add((Integer)it.next().getKey());
                        }
                        if (lastIncompleteCount != incompleteSet.size()) {
                            lastIncompleteCount = incompleteSet.size();
                            LOGGER.info("transaction.repairingMultiOperation", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, lastIncompleteCount, e});
                            break;
                        }
                    }
                    Map<String, String> parameters = this.filterMultiOperationParamters(e.getParameters());
                    String description = GSErrorCode.getDescription(e);
                    String containerName = parameters.get(ERROR_PARAM_CONTAINER);
                    throw new GSStatementException(0, null, (description == null ? "" : description + " ") + "(containerName=" + containerName + ")", parameters, e);
                }
            }
            if (incompleteSet == null) {
                if (!multiContext.isRemaining()) break;
                requestMap.clear();
                lastIncompleteCount = -1;
            } else {
                for (Map.Entry entry : requestMap.entrySet()) {
                    if (incompleteSet.contains(entry.getKey())) continue;
                    ((MultiOperationStatement)entry.getValue()).repairOperation(multiContext);
                }
                requestMap.clear();
            }
            ++trialCount;
        }
        this.endComplexedStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeMulti(int partitionId, Statement statement, MultiOperationStatement<?, ?> multiStatement, boolean systemMode) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        boolean succeeded = false;
        try {
            int trialCount = 0;
            while (true) {
                int sessionTrial = 0;
                while (true) {
                    block19: {
                        this.channel.setupRequestBuffer(req);
                        if (!multiStatement.makeCreateSessionRequest(req, this.channel, this.context, systemMode)) break;
                        try {
                            this.channel.executeStatement(this.context, Statement.CREATE_MULTIPLE_SESSIONS.generalize(), partitionId, 0L, req, resp, this.contextMonitor);
                        }
                        catch (GSStatementException e) {
                            if (!SubnetContainer.isNewSessionConflicted(e)) {
                                throw e;
                            }
                            if (sessionTrial >= 2) {
                                throw new GSStatementException(e.getErrorCode(), "Failed to create session (totalTrialCount=" + trialCount + ", sessionTrialCount=" + sessionTrial + ", reason=" + e.getMessage() + ")", e);
                            }
                            if (!LOGGER.isInfoEnabled()) break block19;
                            LOGGER.info("transaction.regeneratingMultiSession", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, sessionTrial, e});
                            break block19;
                        }
                        multiStatement.acceptCreateSessionResponse(resp);
                        if (trialCount <= 0 && sessionTrial <= 0 || !LOGGER.isInfoEnabled()) break;
                        LOGGER.info("transaction.sessionRepaired", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, sessionTrial});
                        break;
                    }
                    ++sessionTrial;
                }
                try {
                    Object targetConnection;
                    this.channel.setupRequestBuffer(req);
                    if (!multiStatement.makeMainRequest(req, this.channel, this.context, systemMode)) break;
                    GridStoreChannel.Context context = this.context;
                    synchronized (context) {
                        this.channel.executeStatement(this.context, statement.generalize(), partitionId, 0L, req, resp, this.contextMonitor);
                        targetConnection = this.channel.getLastConnection(this.context);
                    }
                    multiStatement.acceptMainResponse(resp, targetConnection);
                    succeeded = true;
                }
                catch (GSStatementException e) {
                    if (!multiStatement.acceptStatementErrorForSession(e)) {
                        throw e;
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("transaction.repairingMultiSession", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, e});
                    }
                    if (trialCount >= 2) {
                        throw new GSStatementException(e.getErrorCode(), "Failed to repair session (trialCount=" + trialCount + ", reason=" + e.getMessage() + ")");
                    }
                    ++trialCount;
                    continue;
                }
                break;
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {
                this.channel.setupRequestBuffer(req);
                if (!multiStatement.makeCloseSessionRequest(req, this.context)) throw throwable;
                this.channel.executeStatement(this.context, Statement.CLOSE_MULTIPLE_SESSIONS.generalize(), partitionId, 0L, req, resp, this.contextMonitor);
                multiStatement.acceptSessionClosed();
                throw throwable;
            }
            catch (GSException e) {
                if (!succeeded) throw throwable;
                throw e;
            }
        }
        try {
            this.channel.setupRequestBuffer(req);
            if (!multiStatement.makeCloseSessionRequest(req, this.context)) return;
            this.channel.executeStatement(this.context, Statement.CLOSE_MULTIPLE_SESSIONS.generalize(), partitionId, 0L, req, resp, this.contextMonitor);
            multiStatement.acceptSessionClosed();
            return;
        }
        catch (GSException e) {
            if (!succeeded) return;
            throw e;
        }
    }

    private Map<String, String> filterMultiOperationParamters(Map<String, String> src) {
        String orgContainerName = src.get(ERROR_PARAM_CONTAINER);
        if (orgContainerName == null) {
            return src;
        }
        try {
            ContainerKeyConverter keyConverter = this.getContainerKeyConverter(true);
            ContainerKeyConverter.Components components = new ContainerKeyConverter.Components();
            keyConverter.decompose(keyConverter.parse(orgContainerName, true), components);
            if (components.largeId == -1L && components.subCount == -1) {
                return src;
            }
            components.largeId = -1L;
            components.subCount = -1;
            components.affinityNum = -1L;
            components.affinityStr = null;
            String filteredContainerName = keyConverter.compose(components, true).toString();
            Map<String, String> dest = GSErrorCode.newParameters(src);
            dest.put(ERROR_PARAM_CONTAINER, filteredContainerName);
            return dest;
        }
        catch (GSException gSException) {
            return src;
        }
    }

    @Override
    public Map<String, List<Row>> multiGet(Map<String, ? extends RowKeyPredicate<?>> containerPredicateMap) throws GSException {
        ContainerKeyConverter keyConverter = this.context.getKeyConverter(false);
        ListingMultiOperationContext<RowKeyPredicate<?>, Row> multiContext = ListingMultiOperationContext.create(containerPredicateMap, keyConverter);
        this.multiGet(multiContext, false);
        return multiContext.getAllResult();
    }

    @Override
    public void multiGet(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, ? extends RowKeyPredicate<?>, List<Row>> multiContext, boolean systemMode) throws GSException {
        ContainerKeyConverter keyConverter = this.context.getKeyConverter(systemMode);
        this.executeAllMulti(Statement.GET_MULTIPLE_CONTAINER_ROWS, MultiGetRequest.newFactory(multiContext, keyConverter), systemMode);
    }

    @Override
    public SubnetPartitionController getPartitionController() throws GSException {
        this.channel.checkContextAvailable(this.context);
        return new SubnetPartitionController(this.channel, this.context);
    }

    private static ContainerKeyConverter.ContainerKey createSystemContainerKey(String name) {
        ContainerKeyConverter keyConverter = ContainerKeyConverter.getInstance(0, true);
        try {
            return keyConverter.parse(name, false);
        }
        catch (GSException e) {
            throw new Error(e);
        }
    }

    private <K> SubnetCollection<K, Row> getContextControllerCollection(ContainerType expectedType) throws GSException {
        if (expectedType != null && expectedType != ContainerType.COLLECTION) {
            return null;
        }
        RowMapper mapper = RowMapper.getInstance(null, new ContainerInfo(null, null, Arrays.asList(new ColumnInfo("name", GSType.STRING), new ColumnInfo("value", GSType.STRING)), true), SubnetGridStore.getRowMapperConfig());
        return new SubnetCollection<K, Row>(this, this.channel, this.context, Row.class, mapper, -1, -1, -1L, CONTEXT_CONTROLLER_KEY, null){

            @Override
            public Row get(K key, boolean forUpdate) throws GSException {
                if (!(key instanceof String)) {
                    throw new GSException(145002, "Type of key for context controller must be string");
                }
                Row row = this.mapper.createGeneralRow();
                if ("failoverCount".equals(key)) {
                    row.setString(1, Integer.toString(this.context.getFailoverCount()));
                    row.setValue(0, key);
                    return row;
                }
                throw new GSException(145002, "Unknown key");
            }

            @Override
            public boolean put(K key, Row value) throws GSException {
                if ("invalidateMaster".equals(key) && value.getString(1).equals(Boolean.TRUE.toString())) {
                    this.channel.invalidateMaster(this.context);
                    return true;
                }
                throw new GSException(145002, "Unknown key");
            }
        };
    }

    @Override
    public <K, R> Container<K, R> putContainer(String name, Class<R> rowType, ContainerInfo info, boolean modifiable) throws GSException {
        ContainerKeyConverter keyConverter = this.context.getKeyConverter(false);
        return this.putContainer(this.resolveContainerKey(keyConverter.parse(name, false), info, keyConverter), SubnetGridStore.resolveContainerType(null, info), rowType, info, modifiable, false);
    }

    private void setUserInfoRequest(BasicBuffer req, String userName) throws GSException {
        RowMapper.checkSymbol(userName, "user name");
        req.putString(userName);
    }

    private void setUserInfoRequest(BasicBuffer req, String userName, byte prop, String hashPassword) throws GSException {
        this.setUserInfoRequest(req, userName);
        req.put(prop);
        if (hashPassword != null) {
            if (hashPassword.isEmpty()) {
                throw new GSException(145001, "Empty hash password");
            }
            req.putBoolean(true);
            req.putString(hashPassword);
        } else {
            req.putBoolean(false);
        }
    }

    private Map<String, UserInfo> getUserInfoMap(BasicBuffer resp) throws GSException {
        HashMap<String, UserInfo> map = new HashMap<String, UserInfo>();
        int userInfoCount = resp.base().getInt();
        if (userInfoCount == 0) {
            return map;
        }
        for (int i = 0; i < userInfoCount; ++i) {
            String userName = resp.getString();
            Byte property = resp.base().get();
            Boolean passwordExist = resp.getBoolean();
            String hashPassword = "";
            if (passwordExist.booleanValue()) {
                hashPassword = resp.getString();
            }
            map.put(userName, new UserInfo(userName, hashPassword, property != 0));
        }
        return map;
    }

    @Override
    public void putUser(String name, UserInfo userInfo, boolean modifiable) throws GSException {
        GSErrorCode.checkNullParameter(userInfo, "userInfo", null);
        name = SubnetGridStore.resolveName(name, userInfo.getName(), "user name");
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        String password = userInfo.getPassword();
        String hashPassword = userInfo.getHashPassword();
        if (password != null && hashPassword == null) {
            RowMapper.checkString(password, "password");
            int bytesLength = password.getBytes(BasicBuffer.DEFAULT_CHARSET).length;
            if (bytesLength > 64) {
                throw new GSException(145002, "The length of password string bytes exceeded (max=64)");
            }
            this.setUserInfoRequest(req, name, (byte)0, NodeConnection.getDigest(password));
        } else if (password == null && hashPassword != null) {
            this.setUserInfoRequest(req, name, (byte)0, hashPassword);
        } else {
            if (password == null) {
                throw new GSException(145001, "Password and hash password not specified");
            }
            throw new GSException(145002, "Both password and hash password specified");
        }
        req.putBoolean(modifiable);
        this.executeStatement(Statement.PUT_USER, 0, req, resp, null);
    }

    @Override
    public void dropUser(String name) throws GSException {
        GSErrorCode.checkNullParameter(name, "name", null);
        name = SubnetGridStore.resolveName(name, null, "user name");
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        this.setUserInfoRequest(req, name);
        this.executeStatement(Statement.DROP_USER, 0, req, resp, null);
    }

    @Override
    public Map<String, UserInfo> getUsers() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        req.putBoolean(false);
        req.put((byte)0);
        this.executeStatement(Statement.GET_USERS, 0, req, resp, null);
        Map<String, UserInfo> map = this.getUserInfoMap(resp);
        return map;
    }

    @Override
    public UserInfo getCurrentUser() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        req.putBoolean(true);
        req.putString(this.context.getUser());
        req.put((byte)0);
        this.executeStatement(Statement.GET_USERS, 0, req, resp, null);
        Map<String, UserInfo> map = this.getUserInfoMap(resp);
        if (map.size() != 1) {
            throw new GSConnectionException(145031, "Protocol error by illegal user info count (expected=1, actual=" + map.size() + ")");
        }
        UserInfo userInfo = map.get(this.context.getUser());
        if (userInfo == null) {
            throw new GSConnectionException(145031, "Protocol error by illegal user name (expected=" + this.context.getUser() + ")");
        }
        return userInfo;
    }

    private void setDatabaseInfoRequest(BasicBuffer req, String dbName) throws GSException {
        RowMapper.checkSymbol(dbName, "database name");
        req.putString(dbName);
    }

    private void setDatabaseInfoRequest(BasicBuffer req, String dbName, byte prop, Map<String, PrivilegeInfo> privileges) throws GSException {
        this.setDatabaseInfoRequest(req, dbName);
        req.put(prop);
        if (privileges != null) {
            req.base().putInt(privileges.size());
            for (Map.Entry<String, PrivilegeInfo> privilegeEntry : privileges.entrySet()) {
                RowMapper.checkSymbol(privilegeEntry.getKey(), "privilege name");
                req.putString(privilegeEntry.getKey());
                PrivilegeInfo privilegeInfo = privilegeEntry.getValue();
                if (privilegeInfo == null) {
                    throw new GSException(145001, "Privilege info not specified");
                }
                req.putString(DEFAULT_PRIVILEGE);
            }
        } else {
            req.base().putInt(0);
        }
    }

    private void setDatabaseInfoRequest(BasicBuffer req, String dbName, byte prop, String userName, PrivilegeInfo info) throws GSException {
        RowMapper.checkSymbol(userName, "user name");
        HashMap<String, PrivilegeInfo> map = new HashMap<String, PrivilegeInfo>();
        map.put(userName, info);
        this.setDatabaseInfoRequest(req, dbName, (byte)0, map);
    }

    private Map<String, DatabaseInfo> getDatabaseInfoMap(BasicBuffer resp) throws GSException {
        HashMap<String, DatabaseInfo> map = new HashMap<String, DatabaseInfo>();
        int databaseInfoCount = resp.base().getInt();
        if (databaseInfoCount == 0) {
            return map;
        }
        for (int i = 0; i < databaseInfoCount; ++i) {
            String databaseName = resp.getString();
            resp.base().get();
            int privilegeInfoCount = resp.base().getInt();
            HashMap<String, PrivilegeInfo> privilegeInfoMap = new HashMap<String, PrivilegeInfo>();
            for (int j = 0; j < privilegeInfoCount; ++j) {
                String userName = resp.getString();
                String privilegeData = resp.getString();
                if (!privilegeData.equals(DEFAULT_PRIVILEGE)) {
                    throw new GSConnectionException(145031, "Protocol error by illegal privilege (expected=ALL, actual=" + privilegeData + ")");
                }
                privilegeInfoMap.put(userName, new PrivilegeInfo());
            }
            map.put(databaseName, new DatabaseInfo(databaseName, privilegeInfoMap));
        }
        return map;
    }

    @Override
    public void putDatabase(String name, DatabaseInfo info, boolean modifiable) throws GSException {
        GSErrorCode.checkNullParameter(info, "info", null);
        name = SubnetGridStore.resolveName(name, info.getName(), "database name");
        modifiable = false;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        this.setDatabaseInfoRequest(req, name, (byte)0, null);
        req.putBoolean(modifiable);
        this.executeStatement(Statement.PUT_DATABASE, 0, req, resp, null);
    }

    @Override
    public void dropDatabase(String name) throws GSException {
        GSErrorCode.checkNullParameter(name, "name", null);
        DatabaseInfo info = this.getCurrentDatabase();
        if (!RowMapper.normalizeSymbolUnchecked(info.getName()).equals(RowMapper.normalizeSymbolUnchecked(name))) {
            throw new GSException(145002, "Only connected database can be dropped (connected=" + info.getName() + ", specified=" + name + ")");
        }
        SubnetPartitionController partitionController = this.getPartitionController();
        int partitionCount = partitionController.getPartitionCount();
        EnumSet<ContainerAttribute> attributeSet = EnumSet.of(ContainerAttribute.BASE, ContainerAttribute.SINGLE_SYSTEM, ContainerAttribute.SINGLE, ContainerAttribute.LARGE, ContainerAttribute.SUB);
        if (SubnetGridStore.isContainerAttributeUnified()) {
            attributeSet.remove((Object)ContainerAttribute.BASE);
        }
        ContainerKeyPredicate pred = new ContainerKeyPredicate(attributeSet);
        for (int partitionIndex = 0; partitionIndex < partitionCount; ++partitionIndex) {
            long containerCount = partitionController.getContainerCount(partitionIndex, pred, true);
            if (0L >= containerCount) continue;
            throw new GSException(145045, "Non-empty database cannot be dropped");
        }
        name = SubnetGridStore.resolveName(name, null, "database name");
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        this.setDatabaseInfoRequest(req, name);
        this.executeStatement(Statement.DROP_DATABASE, 0, req, resp, null);
    }

    @Override
    public Map<String, DatabaseInfo> getDatabases() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        req.putBoolean(false);
        req.put((byte)0);
        this.executeStatement(Statement.GET_DATABASES, 0, req, resp, null);
        Map<String, DatabaseInfo> map = this.getDatabaseInfoMap(resp);
        return map;
    }

    @Override
    public DatabaseInfo getCurrentDatabase() throws GSException {
        DatabaseInfo info;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        String dbName = this.context.getDatabaseName();
        req.putBoolean(true);
        req.putString(dbName == null ? "" : dbName);
        req.put((byte)0);
        this.executeStatement(Statement.GET_DATABASES, 0, req, resp, null);
        Map<String, DatabaseInfo> map = this.getDatabaseInfoMap(resp);
        if (map.size() == 1) {
            info = dbName == null ? map.values().iterator().next() : map.get(dbName);
            if (info == null) {
                throw new GSConnectionException(145031, "Protocol error by illegal database name (expected=" + dbName + ")");
            }
        } else {
            throw new GSConnectionException(145031, "Protocol error by illegal database info count (expected=1, actual=" + map.size() + ")");
        }
        return info;
    }

    @Override
    public void putPrivilege(String dbName, String userName, PrivilegeInfo info) throws GSException {
        GSErrorCode.checkNullParameter(dbName, "dbName", null);
        GSErrorCode.checkNullParameter(userName, "userName", null);
        GSErrorCode.checkNullParameter(info, "info", null);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        this.setDatabaseInfoRequest(req, dbName, (byte)0, userName, info);
        this.executeStatement(Statement.PUT_PRIVILEGE, 0, req, resp, null);
    }

    @Override
    public void dropPrivilege(String dbName, String userName, PrivilegeInfo info) throws GSException {
        GSErrorCode.checkNullParameter(dbName, "dbName", null);
        GSErrorCode.checkNullParameter(userName, "userName", null);
        GSErrorCode.checkNullParameter(info, "info", null);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        this.setDatabaseInfoRequest(req, dbName, (byte)0, userName, info);
        this.executeStatement(Statement.DROP_PRIVILEGE, 0, req, resp, null);
    }

    @Override
    public Experimentals.AsStore getExperimentalStore() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiGetRequest<V extends RowKeyPredicate<?>>
    extends MultiOperationStatement<ContainerKeyConverter.ContainerKey, V> {
        final Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, List<Row>> multiContext;
        final List<RowKeyPredicate<?>> predicateList = new ArrayList();
        final List<SubEntry> entryList = new ArrayList<SubEntry>();
        final ContainerKeyConverter keyConverter;

        MultiGetRequest(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, List<Row>> multiContext, ContainerKeyConverter keyConverter) {
            this.multiContext = multiContext;
            this.keyConverter = keyConverter;
        }

        static <V extends RowKeyPredicate<?>> MultiOperationStatement.BasicFactory<V, List<Row>> newFactory(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, List<Row>> multiContext, ContainerKeyConverter keyConverter) {
            return new MultiOperationStatement.BasicFactory<V, List<Row>>((Extensibles.MultiOperationContext)multiContext, keyConverter){

                public MultiGetRequest<V> create() {
                    return new MultiGetRequest(this.getMultiContext(), this.getKeyConverter());
                }
            };
        }

        @Override
        void addRequestValue(ContainerKeyConverter.ContainerKey key, V value, Integer attribute, NodeConnection.OptionalRequestSource source) throws GSException {
            SubEntry entry = new SubEntry();
            entry.containerKey = key;
            entry.predicateIndex = this.predicateList.indexOf(value);
            if (entry.predicateIndex < 0) {
                entry.predicateIndex = this.predicateList.size();
                this.predicateList.add((RowKeyPredicate<?>)value);
            }
            entry.attribute = attribute;
            entry.source = source;
            this.entryList.add(entry);
        }

        @Override
        boolean makeMainRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean systemMode) throws GSException {
            if (this.entryList.isEmpty()) {
                return false;
            }
            if (SubnetGridStore.isSessionUUIDSummarized()) {
                req.putUUID(context.getSessionUUID());
            }
            SubnetGridStore.tryPutSystemOptionalRequest(req, context, systemMode, false, null);
            RowMapper.MappingMode mappingMode = SubnetContainer.getRowMappingMode();
            req.putInt(this.predicateList.size());
            for (RowKeyPredicate<?> predicate : this.predicateList) {
                GSType keyType = predicate.getKeyType();
                req.putByteEnum(keyType);
                java.util.Collection<?> distinctKeys = predicate.getDistinctKeys();
                Object startKey = predicate.getStart();
                Object finishKey = predicate.getFinish();
                if (distinctKeys == null) {
                    req.putByteEnum(PredicateType.RANGE);
                    req.putBoolean(startKey != null);
                    if (startKey != null) {
                        RowMapper.encodeKey(req, startKey, keyType, mappingMode);
                    }
                    req.putBoolean(finishKey != null);
                    if (finishKey == null) continue;
                    RowMapper.encodeKey(req, finishKey, keyType, mappingMode);
                    continue;
                }
                req.putByteEnum(PredicateType.DISTINCT);
                req.putInt(distinctKeys.size());
                for (Object key : distinctKeys) {
                    RowMapper.encodeKey(req, key, keyType, mappingMode);
                }
            }
            long databaseId = channel.getDatabaseId(context);
            req.putInt(this.entryList.size());
            for (SubEntry entry : this.entryList) {
                if (SubnetGridStore.isAttributeVerifiable()) {
                    SubnetGridStore.tryPutSystemOptionalRequest(req, context, false, false, entry.attribute, entry.source);
                }
                this.keyConverter.put(entry.containerKey, databaseId, req);
                req.putInt(entry.predicateIndex);
            }
            return true;
        }

        @Override
        void acceptMainResponse(BasicBuffer resp, Object targetConnection) throws GSException {
            int headCount = resp.base().getInt();
            ArrayList<RowMapper> mapperList = new ArrayList<RowMapper>();
            for (int i = 0; i < headCount; ++i) {
                ContainerType containerType = resp.getByteEnum(ContainerType.class);
                mapperList.add(RowMapper.getInstance(resp, containerType, SubnetGridStore.getRowMapperConfig()));
            }
            int bodyCount = resp.base().getInt();
            for (int i = 0; i < bodyCount; ++i) {
                ContainerKeyConverter.ContainerKey containerKey = this.keyConverter.get(resp, false, true);
                int mapperIndex = resp.base().getInt();
                RowMapper mapper = (RowMapper)mapperList.get(mapperIndex);
                boolean rowIdIncluded = !mapper.isForTimeSeries();
                int rowCount = (int)resp.base().getLong();
                RowMapper.Cursor cursor = mapper.createCursor(resp, SubnetContainer.getRowMappingMode(), rowCount, rowIdIncluded, RowMapper.getDirectBlobFactory());
                ArrayList<Row> rowList = new ArrayList<Row>();
                for (int j = 0; j < rowCount; ++j) {
                    rowList.add((Row)mapper.decode(cursor));
                }
                this.multiContext.acceptCompletion(containerKey, rowList);
            }
        }

        private static class SubEntry {
            ContainerKeyConverter.ContainerKey containerKey;
            Integer attribute;
            NodeConnection.OptionalRequestSource source;
            int predicateIndex;

            private SubEntry() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PredicateType {
        RANGE,
        DISTINCT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiPutStatement
    extends MultiOperationStatement<ContainerKeyConverter.ContainerKey, List<Row>> {
        final List<RowMapper> mapperList = new ArrayList<RowMapper>();
        final List<ContainerKeyConverter.ContainerKey> containerKeyList = new ArrayList<ContainerKeyConverter.ContainerKey>();
        final Map<ContainerKeyConverter.ContainerKey, SubEntry> subEntryMap = new HashMap<ContainerKeyConverter.ContainerKey, SubEntry>();
        UUID sessionUUID;

        private MultiPutStatement() {
        }

        static MultiOperationStatement.BasicFactory<List<Row>, Void> newFactory(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, List<Row>, Void> multiContext) {
            return new MultiOperationStatement.BasicFactory<List<Row>, Void>(multiContext, null){

                public MultiPutStatement create() {
                    return new MultiPutStatement();
                }
            };
        }

        @Override
        void addRequestValue(ContainerKeyConverter.ContainerKey key, List<Row> value, Integer attribute, NodeConnection.OptionalRequestSource source) throws GSException {
            if (value.isEmpty()) {
                return;
            }
            ContainerKeyConverter.ContainerKey normalizedKey = key.toCaseSensitive(false);
            SubEntry entry = this.subEntryMap.get(normalizedKey);
            RowMapper mapper = null;
            for (Row row : value) {
                if (mapper == null) {
                    Row lastRow = entry == null ? row : entry.rowList.get(0);
                    mapper = RowMapper.getInstance(lastRow, SubnetGridStore.getRowMapperConfig());
                    continue;
                }
                mapper.checkSchemaMatched(RowMapper.getInstance(row, SubnetGridStore.getRowMapperConfig()));
            }
            if (entry == null) {
                entry = new SubEntry();
                entry.rowList = value;
                entry.attribute = attribute;
                this.subEntryMap.put(normalizedKey, entry);
                this.containerKeyList.add(normalizedKey);
                entry.mapperIndex = this.indexOf(mapper);
                if (entry.mapperIndex < 0) {
                    entry.mapperIndex = this.mapperList.size();
                    this.mapperList.add(mapper);
                }
            } else {
                if (!entry.listMerged) {
                    entry.rowList = new ArrayList<Row>(entry.rowList);
                    entry.listMerged = true;
                }
                entry.rowList.addAll(value);
            }
        }

        @Override
        boolean makeCreateSessionRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean systemMode) throws GSException {
            this.sessionUUID = context.getSessionUUID();
            if (this.containerKeyList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutSystemOptionalRequest(req, context, systemMode, false, null);
            ContainerKeyConverter keyConverter = context.getKeyConverter(systemMode);
            long databaseId = channel.getDatabaseId(context);
            boolean withId = false;
            req.putBoolean(withId);
            req.putInt(this.containerKeyList.size());
            for (ContainerKeyConverter.ContainerKey containerKey : this.containerKeyList) {
                SubEntry entry;
                if (SubnetGridStore.isAttributeVerifiable()) {
                    entry = this.subEntryMap.get(containerKey);
                    SubnetGridStore.tryPutSystemOptionalRequest(req, context, false, false, entry.attribute);
                }
                keyConverter.put(containerKey, databaseId, req);
                if (!summarized) {
                    req.putUUID(this.sessionUUID);
                }
                if (SubnetContainer.isSessionIdGeneratorEnabled()) {
                    entry = this.subEntryMap.get(containerKey);
                    entry.sessionId = context.generateSessionId();
                    req.putLong(entry.sessionId);
                    continue;
                }
                SubnetContainer.putNewSessionProperties(req, channel, context);
            }
            return true;
        }

        @Override
        void acceptCreateSessionResponse(BasicBuffer resp) throws GSException {
            int sessionCount = resp.base().getInt();
            if (this.subEntryMap.size() != sessionCount) {
                throw new GSConnectionException(145031, "Protocol error by inconsistent session count");
            }
            for (ContainerKeyConverter.ContainerKey containerKey : this.containerKeyList) {
                SubEntry entry = this.subEntryMap.get(containerKey);
                entry.containerId = resp.base().getLong();
                if (SubnetContainer.isSessionIdGeneratorEnabled()) continue;
                entry.sessionId = resp.base().getLong();
                if (entry.sessionId != 0L) continue;
                throw new GSConnectionException(145031, "Protocol error by empty session ID");
            }
        }

        @Override
        boolean makeMainRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean systemMode) throws GSException {
            if (this.containerKeyList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context, null);
            req.putInt(this.mapperList.size());
            for (RowMapper mapper : this.mapperList) {
                req.putByteEnum(mapper.isForTimeSeries() ? ContainerType.TIME_SERIES : ContainerType.COLLECTION);
                mapper.exportSchema(req, SubnetGridStore.getRowMapperConfig());
            }
            req.putInt(this.containerKeyList.size());
            for (ContainerKeyConverter.ContainerKey containerKey : this.containerKeyList) {
                SubEntry entry = this.subEntryMap.get(containerKey);
                NodeConnection.putStatementId(req, 1L);
                req.putLong(entry.containerId);
                req.putLong(entry.sessionId);
                if (!summarized) {
                    req.putUUID(this.sessionUUID);
                }
                if (SubnetContainer.isSessionIdGeneratorEnabled()) {
                    req.putByteEnum(SubnetContainer.SessionMode.GET);
                    req.putByteEnum(SubnetContainer.TransactionMode.AUTO);
                }
                SubnetGridStore.tryPutSystemOptionalRequest(req, context, false, false, entry.attribute);
                req.putInt(entry.mapperIndex);
                int listBytesSize = 0;
                req.putInt(listBytesSize);
                int listStartPos = req.base().position();
                req.putLong(entry.rowList.size());
                RowMapper mapper = this.mapperList.get(entry.mapperIndex);
                RowMapper.Cursor cursor = mapper.createCursor(req, SubnetContainer.getRowMappingMode(), entry.rowList.size(), false, null);
                for (Row row : entry.rowList) {
                    mapper.encode(cursor, null, row);
                }
                int listEndPos = req.base().position();
                req.base().position(listStartPos - 4);
                req.putInt(listEndPos - listStartPos);
                req.base().position(listEndPos);
            }
            return true;
        }

        @Override
        void acceptMainResponse(BasicBuffer resp, Object targetConnection) {
        }

        @Override
        boolean makeCloseSessionRequest(BasicBuffer req, GridStoreChannel.Context context) {
            if (this.containerKeyList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context, null);
            req.putInt(this.containerKeyList.size());
            for (ContainerKeyConverter.ContainerKey containerKey : this.containerKeyList) {
                SubEntry entry = this.subEntryMap.get(containerKey);
                NodeConnection.putStatementId(req, 2L);
                req.putLong(entry.containerId);
                req.putLong(entry.sessionId);
                if (summarized) continue;
                req.putUUID(this.sessionUUID);
            }
            return true;
        }

        @Override
        void acceptSessionClosed() {
        }

        @Override
        boolean acceptStatementErrorForSession(GSStatementException cause) throws GSException {
            return SubnetContainer.isInitialSessionLost(Statement.CREATE_MULTIPLE_SESSIONS, 1L, false, cause);
        }

        @Override
        <R> void repairOperation(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, ?, R> multiContext) throws GSException {
            for (ContainerKeyConverter.ContainerKey key : this.subEntryMap.keySet()) {
                multiContext.acceptCompletion(key, null);
            }
        }

        int indexOf(RowMapper mapper) {
            for (int i = 0; i < this.mapperList.size(); ++i) {
                if (this.mapperList.get(i) != mapper) continue;
                return i;
            }
            return -1;
        }

        private static class SubEntry {
            List<Row> rowList;
            int mapperIndex;
            long containerId;
            long sessionId;
            boolean listMerged;
            Integer attribute;

            private SubEntry() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiQueryStatement
    extends MultiOperationStatement<Integer, SubnetQuery<?>> {
        private final Extensibles.MultiOperationContext<Integer, ?, Query<?>> multiContext;
        private final List<Integer> keyList = new ArrayList<Integer>();
        private final List<SubnetQuery<?>> queryList = new ArrayList();
        private List<SubnetQuery<?>> optionalQueryList;
        boolean updateQueryFound;
        UUID sessionUUID;

        private MultiQueryStatement(Extensibles.MultiOperationContext<Integer, ?, Query<?>> multiContext) {
            this.multiContext = multiContext;
        }

        static <V extends Query<?>> MultiQueryFactory<V> newFactory(Extensibles.MultiOperationContext<Integer, V, Query<?>> multiContext, SubnetGridStore store) {
            return new MultiQueryFactory<V>(multiContext, store);
        }

        static SubnetQuery<?> check(Query<?> query, SubnetGridStore store) throws GSException {
            if (!(query instanceof SubnetQuery)) {
                if (query == null) {
                    throw new GSException(145001, "Empty query object");
                }
                throw new GSException(145002, "Query type not matched (class=" + query.getClass() + ")");
            }
            SubnetQuery subnetQuery = (SubnetQuery)query;
            if (subnetQuery.getContainer().getStore() != store) {
                throw new GSException(145002, "Derived GridStore instance not matched");
            }
            return subnetQuery;
        }

        @Override
        void addRequestValue(Integer key, SubnetQuery<?> value, Integer attribute, NodeConnection.OptionalRequestSource source) throws GSException {
            value.getContainer().clearBlob(false);
            this.updateQueryFound |= value.isForUpdate();
            this.keyList.add(key);
            this.queryList.add(value);
        }

        @Override
        boolean makeCreateSessionRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean systemMode) throws GSException {
            this.sessionUUID = context.getSessionUUID();
            if (!this.updateQueryFound || this.queryList.isEmpty()) {
                return false;
            }
            if (this.optionalQueryList == null) {
                this.optionalQueryList = new ArrayList();
            }
            this.optionalQueryList.clear();
            for (SubnetQuery<?> query : this.queryList) {
                if (!query.isForUpdate() || query.getContainer().getSessionIdDirect() != 0L) continue;
                this.optionalQueryList.add(query);
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context, null);
            boolean withId = true;
            req.putBoolean(withId);
            req.putInt(this.optionalQueryList.size());
            for (SubnetQuery<?> query : this.optionalQueryList) {
                SubnetContainer<?, ?> container = query.getContainer();
                req.putLong(container.getContainerId());
                if (!summarized) {
                    req.putUUID(this.sessionUUID);
                }
                if (SubnetContainer.isSessionIdGeneratorEnabled()) {
                    long sessionId = context.generateSessionId();
                    container.setSessionIdDirect(sessionId, false);
                    req.putLong(sessionId);
                    continue;
                }
                SubnetContainer.putNewSessionProperties(req, channel, context);
            }
            return true;
        }

        @Override
        void acceptCreateSessionResponse(BasicBuffer resp) throws GSException {
            int sessionCount = resp.base().getInt();
            if (this.optionalQueryList.size() != sessionCount) {
                throw new GSConnectionException(145031, "Protocol error by inconsistent session count");
            }
            if (!SubnetContainer.isSessionIdGeneratorEnabled()) {
                for (int i = 0; i < sessionCount; ++i) {
                    SubnetContainer<?, ?> container = this.optionalQueryList.get(i).getContainer();
                    long containerId = resp.base().getLong();
                    if (containerId != container.getContainerId()) {
                        throw new GSConnectionException(145031, "Protocol error by inconsistent session ID");
                    }
                    long sessionId = resp.base().getLong();
                    if (sessionId == 0L) {
                        throw new GSConnectionException(145031, "Protocol error by empty session ID");
                    }
                    container.setSessionIdDirect(sessionId, true);
                }
            }
            this.optionalQueryList.clear();
        }

        @Override
        boolean makeMainRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean systemMode) throws GSException {
            if (this.queryList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context, context.bindQueryOptions(null));
            req.putInt(this.queryList.size());
            for (SubnetQuery<?> query : this.queryList) {
                SubnetContainer<?, ?> container = query.getContainer();
                long statementId = container.isAutoCommit() || container.getSessionIdDirect() == 0L ? 0L : container.updateStatementIdDirect();
                req.putInt(GridStoreChannel.statementToNumber(query.getStatement()));
                NodeConnection.putStatementId(req, statementId);
                query.makeRequest(req, summarized);
            }
            return true;
        }

        @Override
        void acceptMainResponse(BasicBuffer resp, Object targetConnection) throws GSException {
            int count = resp.base().getInt();
            if (this.queryList.size() != count) {
                throw new GSConnectionException(145031, "Protocol error by inconsistent query count");
            }
            int totalEndPos = resp.base().limit();
            for (int i = 0; i < count; ++i) {
                int size = (int)BasicBuffer.BufferUtils.getLongSize(resp.base());
                BasicBuffer.BufferUtils.limitForward(resp.base(), size);
                SubnetQuery<?> query = this.queryList.get(i);
                query.acceptResponse(resp, targetConnection, false);
                this.multiContext.acceptCompletion(this.keyList.get(i), query);
                BasicBuffer.BufferUtils.skipToLimit(resp.base(), totalEndPos);
            }
        }

        @Override
        boolean makeCloseSessionRequest(BasicBuffer req, GridStoreChannel.Context context) throws GSException {
            return false;
        }

        @Override
        void acceptSessionClosed() throws GSException {
        }

        @Override
        boolean acceptStatementErrorForSession(GSStatementException cause) throws GSException {
            if (!this.updateQueryFound) {
                return false;
            }
            boolean initialSessionLost = false;
            for (SubnetQuery<?> query : this.queryList) {
                SubnetContainer<?, ?> container = query.getContainer();
                if (SubnetCollection.isInitialSessionLost(Statement.EXECUTE_MULTIPLE_QUERIES, container.getStatementIdDirect(), container.isTransactionStarted(), cause)) {
                    initialSessionLost = true;
                    container.setSessionIdDirect(0L, true);
                    continue;
                }
                container.disableCache();
            }
            return initialSessionLost;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class MultiQueryFactory<V extends Query<?>>
        extends MultiOperationStatement.Factory<Integer, SubnetQuery<?>, V, Query<?>> {
            private final SubnetGridStore store;

            MultiQueryFactory(Extensibles.MultiOperationContext<Integer, V, Query<?>> multiContext, SubnetGridStore store) {
                super(multiContext, null);
                this.store = store;
            }

            MultiQueryStatement create() {
                return new MultiQueryStatement(this.getMultiContext());
            }

            @Override
            Extensibles.MultiTargetConsumer<Integer, V> createConsumer(final Map<Integer, MultiOperationStatement<Integer, SubnetQuery<?>>> requestMap, GridStoreChannel channel, GridStoreChannel.Context context, boolean systemMode) {
                return new Extensibles.MultiTargetConsumer<Integer, V>(){

                    @Override
                    public void consume(Integer key, V value, Integer attribute, NodeConnection.OptionalRequestSource source) throws GSException {
                        SubnetQuery<?> query = MultiQueryStatement.check(value, MultiQueryFactory.this.store);
                        int partitionId = query.getContainer().getPartitionId();
                        MultiQueryFactory.this.resolveMultiStatement(requestMap, partitionId).addRequestValue(key, query, attribute, source);
                    }
                };
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MultiOperationStatement<K, T> {
        private MultiOperationStatement() {
        }

        abstract void addRequestValue(K var1, T var2, Integer var3, NodeConnection.OptionalRequestSource var4) throws GSException;

        boolean makeCreateSessionRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean systemMode) throws GSException {
            return false;
        }

        void acceptCreateSessionResponse(BasicBuffer resp) throws GSException {
        }

        abstract boolean makeMainRequest(BasicBuffer var1, GridStoreChannel var2, GridStoreChannel.Context var3, boolean var4) throws GSException;

        abstract void acceptMainResponse(BasicBuffer var1, Object var2) throws GSException;

        boolean makeCloseSessionRequest(BasicBuffer req, GridStoreChannel.Context context) throws GSException {
            return false;
        }

        void acceptSessionClosed() throws GSException {
        }

        boolean acceptStatementErrorForSession(GSStatementException cause) throws GSException {
            return false;
        }

        <R> void repairOperation(Extensibles.MultiOperationContext<K, ?, R> multiContext) throws GSException {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BasicConsumer<V, R>
        implements Extensibles.MultiTargetConsumer<ContainerKeyConverter.ContainerKey, V> {
            private final BasicFactory<V, R> factory;
            private final Map<Integer, MultiOperationStatement<ContainerKeyConverter.ContainerKey, V>> requestMap;
            private final GridStoreChannel channel;
            private final GridStoreChannel.Context context;
            private final boolean systemMode;

            private BasicConsumer(BasicFactory<V, R> factory, Map<Integer, MultiOperationStatement<ContainerKeyConverter.ContainerKey, V>> requestMap, GridStoreChannel channel, GridStoreChannel.Context context, boolean systemMode) {
                this.factory = factory;
                this.requestMap = requestMap;
                this.channel = channel;
                this.context = context;
                this.systemMode = systemMode;
            }

            @Override
            public void consume(ContainerKeyConverter.ContainerKey key, V value, Integer attribute, NodeConnection.OptionalRequestSource source) throws GSException {
                int partitionId = this.channel.resolvePartitionId(this.context, key, this.systemMode);
                MultiOperationStatement<ContainerKeyConverter.ContainerKey, V> multiStatement = this.factory.resolveMultiStatement(this.requestMap, partitionId);
                multiStatement.addRequestValue(key, value, attribute, source);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static abstract class BasicFactory<V, R>
        extends Factory<ContainerKeyConverter.ContainerKey, V, V, R> {
            private BasicFactory(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, R> multiContext, ContainerKeyConverter keyConverter) {
                super(multiContext, keyConverter);
            }

            @Override
            Extensibles.MultiTargetConsumer<ContainerKeyConverter.ContainerKey, V> createConsumer(Map<Integer, MultiOperationStatement<ContainerKeyConverter.ContainerKey, V>> requestMap, GridStoreChannel channel, GridStoreChannel.Context context, boolean systemMode) {
                return new BasicConsumer(this, requestMap, channel, context, systemMode);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static abstract class Factory<K, T, V, R> {
            private final Extensibles.MultiOperationContext<K, V, R> multiContext;
            private final ContainerKeyConverter keyConverter;

            Factory(Extensibles.MultiOperationContext<K, V, R> multiContext, ContainerKeyConverter keyConverter) {
                this.multiContext = multiContext;
                this.keyConverter = keyConverter;
            }

            abstract MultiOperationStatement<K, T> create();

            MultiOperationStatement<K, T> resolveMultiStatement(Map<Integer, MultiOperationStatement<K, T>> requestMap, int partitionId) {
                MultiOperationStatement<K, T> multiStatement = requestMap.get(partitionId);
                if (multiStatement == null) {
                    multiStatement = this.create();
                    requestMap.put(partitionId, multiStatement);
                }
                return multiStatement;
            }

            Extensibles.MultiOperationContext<K, V, R> getMultiContext() {
                return this.multiContext;
            }

            ContainerKeyConverter getKeyConverter() {
                return this.keyConverter;
            }

            abstract Extensibles.MultiTargetConsumer<K, V> createConsumer(Map<Integer, MultiOperationStatement<K, T>> var1, GridStoreChannel var2, GridStoreChannel.Context var3, boolean var4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListingMultiOperationContext<V, E>
    extends NamedMultiOperationContext<V, List<E>> {
        private final Map<String, List<E>> resultMap = new HashMap<String, List<E>>();

        public ListingMultiOperationContext(Map<String, V> targetMap, ContainerKeyConverter keyConverter) {
            super(targetMap, keyConverter);
        }

        @Override
        public void acceptCompletion(ContainerKeyConverter.ContainerKey containerKey, List<E> result) {
            List<E> orgList = this.resultMap.put(containerKey.toString(), result);
            if (orgList != null) {
                result.addAll(orgList);
            }
        }

        public Map<String, List<E>> getAllResult() {
            return this.resultMap;
        }

        public static <V, E> ListingMultiOperationContext<V, E> create(Map<String, V> targetMap, ContainerKeyConverter keyConverter) {
            return new ListingMultiOperationContext<V, E>(targetMap, keyConverter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamedMultiOperationContext<V, R>
    implements Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, R> {
        private final Map<String, V> targetMap;
        private final ContainerKeyConverter keyConverter;

        public NamedMultiOperationContext(Map<String, V> targetMap, ContainerKeyConverter keyConverter) {
            this.targetMap = targetMap;
            this.keyConverter = keyConverter;
        }

        @Override
        public void listTarget(Extensibles.MultiTargetConsumer<ContainerKeyConverter.ContainerKey, V> consumer) throws GSException {
            for (Map.Entry<String, V> entry : this.targetMap.entrySet()) {
                consumer.consume(this.keyConverter.parse(entry.getKey(), false), entry.getValue(), null, null);
            }
        }

        @Override
        public boolean acceptException(GSException exception) {
            return false;
        }

        @Override
        public void acceptCompletion(ContainerKeyConverter.ContainerKey key, R result) {
        }

        @Override
        public boolean isRemaining() throws GSException {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnnamedMultiOperationContext<K, V, R>
    implements Extensibles.MultiOperationContext<K, V, R> {
        private final Iterable<? extends V> iterable;

        private UnnamedMultiOperationContext(Iterable<? extends V> iterable) {
            this.iterable = iterable;
        }

        @Override
        public void listTarget(Extensibles.MultiTargetConsumer<K, V> consumer) throws GSException {
            for (V value : this.iterable) {
                consumer.consume(null, value, null, null);
            }
        }

        @Override
        public boolean acceptException(GSException exception) throws GSException {
            return false;
        }

        @Override
        public void acceptCompletion(K key, R result) throws GSException {
        }

        @Override
        public boolean isRemaining() throws GSException {
            return false;
        }
    }

    private static class ContainerPropertyKeysConstants {
        static final ContainerProperties.KeySet DEFAULT = ContainerPropertyKeysConstants.create(new ContainerProperties.Key[0]);
        static final ContainerProperties.KeySet COMPATIBLE_TRIGGER = ContainerPropertyKeysConstants.create(ContainerProperties.Key.TRIGGER, ContainerProperties.Key.INDEX_DETAIL);
        static final ContainerProperties.KeySet COMPATIBLE_INDEX = ContainerPropertyKeysConstants.create(ContainerProperties.Key.INDEX_DETAIL);
        static final ContainerProperties.KeySet FOR_OBJECT = new ContainerProperties.KeySet(EnumSet.of(ContainerProperties.Key.ID, ContainerProperties.Key.SCHEMA, ContainerProperties.Key.ATTRIBUTE), new Integer[0]);

        private ContainerPropertyKeysConstants() {
        }

        private static ContainerProperties.KeySet create(ContainerProperties.Key ... exclusiveKeys) {
            EnumSet<ContainerProperties.Key> keySet = EnumSet.allOf(ContainerProperties.Key.class);
            for (ContainerProperties.Key key : exclusiveKeys) {
                keySet.remove((Object)key);
            }
            return new ContainerProperties.KeySet(keySet, new Integer[0]);
        }

        private static ContainerProperties.KeySet resolveDefault() {
            if (SubnetGridStore.isIndexDetailEnabled()) {
                return DEFAULT;
            }
            if (NodeConnection.getProtocolVersion() < 2 || GridStoreChannel.v1ProtocolCompatible_1_1_103x) {
                return COMPATIBLE_TRIGGER;
            }
            return COMPATIBLE_INDEX;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheReference
    extends GridStoreChannel.RemoteReference<SubnetGridStore> {
        public CacheReference(SubnetGridStore target, GridStoreChannel.Context context) {
            super(target, SubnetGridStore.class, context, 0, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
            GridStoreChannel.Context context2 = context;
            synchronized (context2) {
                GridStoreChannel.ContainerCache cache = context.getContainerCache();
                if (cache != null) {
                    BasicBuffer req = context.getSynchronizedRequestBuffer();
                    BasicBuffer resp = context.getSynchronizedResponseBuffer();
                    SubnetContainer.closeAllSessions(channel, context, req, resp, cache.takeAllSessions(context));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NamedContainerMap<C extends Container<?, ?>> {
        private final Map<ContainerKeyConverter.ContainerKey, List<WeakReference<C>>> base = new HashMap<ContainerKeyConverter.ContainerKey, List<WeakReference<C>>>();

        public synchronized C get(ContainerKeyConverter.ContainerKey key, Class<?> rowType) throws GSException {
            List<WeakReference<C>> list = this.base.get(key.toCaseSensitive(false));
            if (list != null) {
                do {
                    for (WeakReference<C> containerRef : list) {
                        Container container = (Container)containerRef.get();
                        if (container == null || rowType != null && rowType != this.getRowType(container)) continue;
                        return (C)container;
                    }
                } while ((rowType = rowType.getSuperclass()) != null);
            }
            return null;
        }

        public synchronized void add(ContainerKeyConverter.ContainerKey normalizedKey, C container) {
            List<WeakReference<C>> list = this.base.get(normalizedKey);
            if (list == null) {
                list = new LinkedList<WeakReference<C>>();
                this.base.put(normalizedKey, list);
            }
            list.add(new WeakReference<C>(container));
        }

        public synchronized void remove(ContainerKeyConverter.ContainerKey normalizedKey, C container) {
            List<WeakReference<C>> list = this.base.get(normalizedKey);
            if (list == null) {
                return;
            }
            Iterator<WeakReference<C>> it = list.iterator();
            while (it.hasNext()) {
                Container candidate = (Container)it.next().get();
                if (candidate != null && candidate != container) continue;
                it.remove();
            }
            if (list.isEmpty()) {
                this.base.remove(normalizedKey);
            }
        }

        protected abstract Class<?> getRowType(C var1);
    }
}

