/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.AggregationResult;
import com.toshiba.mwcloud.gs.ColumnInfo;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSRecoverableException;
import com.toshiba.mwcloud.gs.IndexInfo;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.QueryAnalysisEntry;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.TriggerInfo;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.BlobImpl;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import com.toshiba.mwcloud.gs.subnet.SubnetQuery;
import com.toshiba.mwcloud.gs.subnet.SubnetRowSet;
import java.net.URL;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubnetContainer<K, R>
implements Container<K, R>,
RowMapper.BlobFactory,
Extensibles.AsContainer<K, R>,
Experimentals.AsContainer<K, R> {
    private static final boolean BLOB_CLEAR_ON_OPERATION_ENABLED = false;
    static final int MAX_SESSION_REPAIR_COUNT = 2;
    public static final int SESSION_NOT_FOUND_ERROR_CODE = 110003;
    public static final int UUID_UNMATCHED_ERROR_CODE = 110016;
    public static final int ROW_SET_NOT_FOUND_ERROR_CODE = 60132;
    private static boolean timeSeriesUpdateEnabled = true;
    private static boolean queryStatementIdPreserved = true;
    private static final Map<Statement, Statement> TIME_SERIES_STATEMENT_MAP;
    private static final Set<Statement> FIXED_SESSION_MODE_STATEMENTS;
    private static final QueryResultType[] QUERY_RESULT_TYPES;
    private final GridStoreChannel.ContextMonitor contextMonitor = GridStoreChannel.createContextMonitorIfAvailable();
    private static final LoggingUtils.BaseGridStoreLogger LOGGER;
    private SubnetGridStore store;
    protected final GridStoreChannel channel;
    protected final GridStoreChannel.Context context;
    protected final Class<R> rowType;
    protected final RowMapper mapper;
    private final int schemaVerId;
    private final int partitionId;
    private final long containerId;
    private final ContainerKeyConverter.ContainerKey normalizedContainerKey;
    protected long sessionId = 0L;
    private long transactionId = 1L;
    private long statementId;
    private boolean sessionPrepared;
    private boolean containerLocked;
    private boolean transactionStarted;
    private boolean autoCommit = true;
    private boolean cacheDisabled;
    private BlobImpl lastBlob;
    private SessionReference sessionRef;

    protected SubnetContainer(SubnetGridStore store, GridStoreChannel channel, GridStoreChannel.Context context, Class<R> rowType, RowMapper mapper, int schemaVerId, int partitionId, long containerId, ContainerKeyConverter.ContainerKey normalizedContainerKey, ContainerKeyConverter.ContainerKey remoteContainerKey) throws GSException {
        this.store = store;
        this.channel = channel;
        this.context = context;
        this.rowType = rowType;
        this.mapper = mapper;
        this.schemaVerId = schemaVerId;
        this.partitionId = partitionId;
        this.containerId = containerId;
        this.normalizedContainerKey = normalizedContainerKey;
        if (this.contextMonitor != null) {
            this.contextMonitor.setContainerKey(remoteContainerKey);
        }
        store.createReference(this);
    }

    SubnetGridStore getStore() {
        return this.store;
    }

    @Override
    public Class<R> getRowType() {
        return this.rowType;
    }

    public int getSchemaVersionId() {
        return this.schemaVerId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getContainerId() {
        return this.containerId;
    }

    public ContainerKeyConverter.ContainerKey getNormalizedContainerKey() {
        return this.normalizedContainerKey;
    }

    protected void clearBlob(boolean force) {
        if ((force || this.autoCommit) && this.lastBlob != null) {
            this.lastBlob.close();
            this.lastBlob = null;
        }
    }

    void disableCache() {
        GridStoreChannel.ContainerCache cache;
        if (this.cacheDisabled) {
            return;
        }
        this.cacheDisabled = true;
        if (this.normalizedContainerKey != null && (cache = this.context.getContainerCache()) != null) {
            cache.removeSchema(this.normalizedContainerKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeStatement(Statement statement, BasicBuffer req, BasicBuffer resp, StatementFamily familyForSession) throws GSException {
        if (this.store == null || this.context.isClosedAsync()) {
            throw new GSException(145038, "Already closed");
        }
        boolean sessionRequired = familyForSession != null;
        int trialCount = 0;
        while (true) {
            long statementId;
            long curSessionId = this.sessionId;
            if (sessionRequired) {
                if (!queryStatementIdPreserved || familyForSession != StatementFamily.QUERY) {
                    while (++this.statementId == 0L) {
                    }
                }
                statementId = this.statementId;
                if (curSessionId == 0L || statementId == 0L) {
                    throw new Error("Internal error by empty session or statement ID");
                }
                SessionReference sessionRef = this.sessionRef;
                if (sessionRef != null) {
                    sessionRef.lastStatementId = statementId;
                }
            } else {
                statementId = 0L;
            }
            int requestSize = req.base().position();
            try {
                if (this.contextMonitor != null) {
                    this.contextMonitor.startStatement(statement.generalize(), statementId, this.getPartitionId(), this.getContainerId());
                }
                Statement actualStatement = !SubnetGridStore.isContainerStatementUnified() && this.mapper.isForTimeSeries() && TIME_SERIES_STATEMENT_MAP.containsKey((Object)statement) ? TIME_SERIES_STATEMENT_MAP.get((Object)statement) : statement;
                this.channel.executeStatement(this.context, actualStatement.generalize(), this.getPartitionId(), statementId, req, resp, this.contextMonitor);
                if (sessionRequired) {
                    if (!this.sessionPrepared) {
                        this.setSessionIdDirect(curSessionId, true);
                    }
                    if (!this.autoCommit) {
                        this.setTransactionStarted(true);
                    }
                }
                if (trialCount > 0 && LOGGER.isInfoEnabled()) {
                    LOGGER.info("transaction.sessionRepaired", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, this.partitionId, statementId, this.containerId, curSessionId, trialCount});
                }
                if (this.contextMonitor == null) break;
                this.contextMonitor.endStatement();
            }
            catch (GSStatementException e) {
                boolean started;
                boolean bl = started = this.transactionStarted || this.containerLocked;
                if (statement != Statement.CLOSE_SESSION) {
                    try {
                        GridStoreChannel.Context context = this.context;
                        synchronized (context) {
                            this.closeSession(true);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!sessionRequired || !SubnetContainer.isInitialSessionLost(statement, statementId, started, e)) {
                    try {
                        this.disableCache();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.contextMonitor == null) {
                        throw e;
                    }
                    throw this.contextMonitor.analyzeStatementException(e, this.context, this);
                }
                if (trialCount >= 2) {
                    throw new GSStatementException(e.getErrorCode(), "Failed to repair session (trialCount=" + trialCount + ", reason=" + e.getMessage() + ")", e);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("transaction.repairingSession", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, this.partitionId, statementId, this.containerId, curSessionId, trialCount, started, e});
                }
                byte[] requestData = new byte[requestSize];
                req.base().position(0);
                req.base().get(requestData);
                this.channel.setupRequestBuffer(req);
                int containerIdSize = 8;
                int sessionIdPos = req.base().position() + 8;
                this.createSession();
                req.base().position(0);
                req.base().put(requestData);
                req.base().position(sessionIdPos);
                req.putLong(this.sessionId);
                if (SubnetContainer.isSessionIdGeneratorEnabled() && !FIXED_SESSION_MODE_STATEMENTS.contains((Object)statement)) {
                    int uuidSize = 16;
                    int schemaVerIdSize = 4;
                    req.base().position(req.base().position() + 16 + 4);
                    req.putByteEnum(SessionMode.GET);
                }
                req.base().position(requestSize);
                ++trialCount;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMultiStepStatement(Statement statement, BasicBuffer req, BasicBuffer resp, StatementFamily familyForSession, int statementStep) throws GSException {
        if (statementStep <= 0) {
            throw new Error("Internal error by illegal step");
        }
        try {
            this.executeStatement(statement, req, resp, familyForSession);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.sessionPrepared && SubnetContainer.isMultiStepStatementIdEnabled()) {
                this.statementId += (long)(statementStep - 1);
            }
            throw throwable;
        }
        if (this.sessionPrepared && SubnetContainer.isMultiStepStatementIdEnabled()) {
            this.statementId += (long)(statementStep - 1);
        }
    }

    protected StatementFamily prepareSession(StatementFamily family) throws GSException {
        boolean sessionRequired;
        if (SubnetContainer.isSessionIdGeneratorEnabled()) {
            boolean requiredImmediately;
            switch (family) {
                case QUERY: {
                    sessionRequired = !this.autoCommit && this.transactionStarted;
                    requiredImmediately = false;
                    break;
                }
                case LOCK: {
                    if (this.autoCommit) {
                        throw new GSException(145035, "Auto commit mode must be turned off for a lock operation");
                    }
                    sessionRequired = true;
                    requiredImmediately = false;
                    break;
                }
                case UPDATE: {
                    sessionRequired = this.containerLocked || !this.autoCommit || !this.mapper.hasKey();
                    requiredImmediately = sessionRequired && !this.mapper.hasKey();
                    break;
                }
                case POST: {
                    sessionRequired = true;
                    requiredImmediately = true;
                    break;
                }
                default: {
                    throw new Error("Internal error by unknown statement family");
                }
            }
            if (!this.sessionPrepared) {
                if (requiredImmediately) {
                    this.createSession();
                } else if (sessionRequired) {
                    this.setSessionIdDirect(this.context.generateSessionId(), false);
                }
            }
        } else {
            boolean bl = sessionRequired = family != StatementFamily.QUERY || !this.autoCommit && this.sessionId != 0L;
            if (sessionRequired && this.sessionId == 0L) {
                this.createSession();
            }
        }
        return sessionRequired ? family : null;
    }

    private void createSession() throws GSException {
        long newSessionId;
        GridStoreChannel.SessionInfo sessionInfo;
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && (sessionInfo = cache.takeSession(this.context, this.partitionId, this.containerId)) != null) {
            this.setSessionIdDirect(sessionInfo.getSessionId(), true);
            this.statementId = sessionInfo.getLastStatementId();
            return;
        }
        this.channel.cleanRemoteResources(this.context, Collections.singleton(SubnetContainer.class));
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        int trialCount = 0;
        while (true) {
            block10: {
                long generatedSessionId;
                this.channel.setupRequestBuffer(req);
                req.putLong(this.getContainerId());
                long l = generatedSessionId = SubnetContainer.isSessionIdGeneratorEnabled() ? this.context.generateSessionId() : 0L;
                if (generatedSessionId != 0L) {
                    req.putLong(generatedSessionId);
                }
                if (SubnetContainer.isInitialSessionRetrialEnabled()) {
                    req.putUUID(this.context.getSessionUUID());
                }
                NodeConnection.tryPutEmptyOptionalRequest(req);
                if (generatedSessionId == 0L) {
                    SubnetContainer.putNewSessionProperties(req, this.channel, this.context);
                }
                try {
                    this.executeStatement(Statement.CREATE_SESSION, req, resp, null);
                }
                catch (GSStatementException e) {
                    if (!SubnetContainer.isNewSessionConflicted(e)) {
                        throw e;
                    }
                    if (trialCount >= 2) {
                        throw new GSStatementException(e.getErrorCode(), "Failed to create session (trialCount=" + trialCount + ", reason=" + e.getMessage() + ")", e);
                    }
                    break block10;
                }
                long l2 = newSessionId = generatedSessionId == 0L ? resp.base().getLong() : generatedSessionId;
                if (newSessionId == 0L) {
                    throw new GSException(145031, "Protocol error by empty session ID");
                }
                break;
            }
            ++trialCount;
        }
        this.setSessionIdDirect(newSessionId, true);
    }

    static void putNewSessionProperties(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
        req.putInt(PropertyUtils.timeoutPropertyToIntSeconds(channel.getFailoverTimeoutMillis(context)));
        req.putInt(PropertyUtils.timeoutPropertyToIntSeconds(context.getTransactionTimeoutMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession(boolean invalidating) throws GSException {
        if (this.sessionId == 0L) {
            return;
        }
        try {
            BasicBuffer req = this.context.getSynchronizedRequestBuffer();
            BasicBuffer resp = this.context.getSynchronizedResponseBuffer();
            GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
            if (cache == null || this.transactionStarted || invalidating) {
                this.channel.setupRequestBuffer(req);
                req.putLong(this.getContainerId());
                this.putSessionInfo(req, this.sessionId);
                NodeConnection.tryPutEmptyOptionalRequest(req);
                this.executeStatement(Statement.CLOSE_SESSION, req, resp, StatementFamily.POST);
            } else {
                GridStoreChannel.SessionInfo oldSessionInfo = cache.cacheSession(this.context, new GridStoreChannel.SessionInfo(this.partitionId, this.containerId, this.sessionId, this.statementId));
                if (oldSessionInfo != null) {
                    SubnetContainer.closeSession(this.channel, this.context, req, resp, oldSessionInfo);
                }
            }
            Object var7_6 = null;
            this.setSessionIdDirect(0L, true);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setSessionIdDirect(0L, true);
            throw throwable;
        }
    }

    static void closeSession(GridStoreChannel channel, GridStoreChannel.Context context, BasicBuffer req, BasicBuffer resp, GridStoreChannel.SessionInfo sessionInfo) throws GSException {
        channel.setupRequestBuffer(req);
        req.putLong(sessionInfo.getContainerId());
        req.putLong(sessionInfo.getSessionId());
        if (SubnetContainer.isInitialSessionRetrialEnabled()) {
            req.putUUID(context.getSessionUUID());
        }
        NodeConnection.tryPutEmptyOptionalRequest(req);
        channel.executeStatement(context, Statement.CLOSE_SESSION.generalize(), sessionInfo.getPartitionId(), sessionInfo.getLastStatementId() + 1L, req, resp, null);
    }

    static void closeAllSessions(GridStoreChannel channel, GridStoreChannel.Context context, BasicBuffer req, BasicBuffer resp, List<GridStoreChannel.SessionInfo> allSessionInfos) throws GSException {
        ArrayList<GridStoreChannel.SessionInfo> sortedSessionInfos = new ArrayList<GridStoreChannel.SessionInfo>(allSessionInfos);
        Collections.sort(sortedSessionInfos, new Comparator<GridStoreChannel.SessionInfo>(){

            @Override
            public int compare(GridStoreChannel.SessionInfo o1, GridStoreChannel.SessionInfo o2) {
                return o1.getPartitionId() - o2.getPartitionId();
            }
        });
        boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
        int start = 0;
        while (start < sortedSessionInfos.size()) {
            GridStoreChannel.SessionInfo info;
            int partitionId = ((GridStoreChannel.SessionInfo)sortedSessionInfos.get(start)).getPartitionId();
            int end = start;
            while (++end < sortedSessionInfos.size() && (info = (GridStoreChannel.SessionInfo)sortedSessionInfos.get(end)).getPartitionId() == partitionId) {
            }
            try {
                channel.setupRequestBuffer(req);
                if (summarized) {
                    req.putUUID(context.getSessionUUID());
                }
                NodeConnection.tryPutEmptyOptionalRequest(req);
                req.putInt(end - start);
                for (int i = start; i < end; ++i) {
                    GridStoreChannel.SessionInfo info2 = (GridStoreChannel.SessionInfo)sortedSessionInfos.get(i);
                    NodeConnection.putStatementId(req, info2.getLastStatementId() + 1L);
                    req.putLong(info2.getContainerId());
                    req.putLong(info2.getSessionId());
                    if (summarized) continue;
                    req.putUUID(context.getSessionUUID());
                }
                channel.executeStatement(context, Statement.CLOSE_MULTIPLE_SESSIONS.generalize(), partitionId, 0L, req, resp, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            start = end;
        }
    }

    protected void putTransactionInfo(BasicBuffer req, StatementFamily familyForSession, TransactionInfoType type, Boolean forUpdate) {
        this.putTransactionInfo(req, familyForSession, type, forUpdate, null);
    }

    protected void putTransactionInfo(BasicBuffer req, StatementFamily familyForSession, TransactionInfoType type, Boolean forUpdate, NodeConnection.OptionalRequestSource source) {
        boolean generatorEnabled;
        boolean sessionRequired;
        boolean bl = sessionRequired = familyForSession != null;
        if (sessionRequired && this.sessionId == 0L) {
            throw new Error("Internal error by invalid session parameters");
        }
        req.putLong(sessionRequired ? this.sessionId : 0L);
        if (type != TransactionInfoType.NO_UUID && SubnetContainer.isInitialSessionRetrialEnabled()) {
            req.putUUID(this.context.getSessionUUID());
        }
        if (!(generatorEnabled = SubnetContainer.isSessionIdGeneratorEnabled())) {
            if (forUpdate != null) {
                req.putBoolean(forUpdate);
            }
            if (type != TransactionInfoType.SKIP_COMMIT_MODE) {
                req.putBoolean(this.autoCommit);
            }
        }
        req.putInt(this.getSchemaVersionId());
        if (generatorEnabled) {
            if (sessionRequired) {
                req.putByteEnum(this.sessionPrepared ? SessionMode.GET : SessionMode.CREATE);
            } else {
                req.putByteEnum(SessionMode.AUTO);
            }
            if (this.autoCommit || !sessionRequired) {
                req.putByteEnum(TransactionMode.AUTO);
            } else {
                req.putByteEnum(this.transactionStarted ? TransactionMode.CONTINUE : TransactionMode.BEGIN);
            }
        }
        this.tryPutOptionalRequest(req, forUpdate != null && forUpdate != false, true, false, source);
    }

    protected void tryPutOptionalRequest(BasicBuffer req, boolean forUpdate, boolean containerLockAware, boolean forCreationDDL, NodeConnection.OptionalRequestSource source) {
        boolean clientIdRequired;
        if (!NodeConnection.isOptionalRequestEnabled()) {
            return;
        }
        boolean containerLockRequired = containerLockAware && this.containerLocked;
        boolean bl = clientIdRequired = forCreationDDL && SubnetGridStore.isClientIdEnabled();
        if (forUpdate || containerLockRequired || clientIdRequired || source != null && source.hasOptions()) {
            NodeConnection.OptionalRequest optionalRequest = this.context.getOptionalRequest();
            if (forUpdate) {
                optionalRequest.put(NodeConnection.OptionalRequestType.FOR_UPDATE, true);
            }
            if (containerLockRequired) {
                optionalRequest.put(NodeConnection.OptionalRequestType.CONTAINER_LOCK_REQUIRED, true);
            }
            if (clientIdRequired) {
                optionalRequest.put(NodeConnection.OptionalRequestType.CLIENT_ID, this.context.generateClientId());
            }
            if (source != null) {
                source.putOptions(optionalRequest);
            }
            optionalRequest.format(req);
        } else {
            NodeConnection.tryPutEmptyOptionalRequest(req);
        }
    }

    long getSessionIdDirect() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setSessionIdDirect(long sessionId, boolean statusUpdatable) {
        boolean orgSessionPrepared;
        boolean orgTransactionStarted;
        block28: {
            block30: {
                long orgSessionId;
                block29: {
                    orgTransactionStarted = this.transactionStarted;
                    orgSessionPrepared = this.sessionPrepared;
                    orgSessionId = this.sessionId;
                    if (statusUpdatable) {
                        if (sessionId == 0L) {
                            this.statementId = 0L;
                            if (++this.transactionId == 0L) {
                                this.transactionId = 1L;
                            }
                            this.sessionPrepared = false;
                            this.containerLocked = false;
                            this.transactionStarted = false;
                        } else {
                            this.sessionPrepared = true;
                        }
                    }
                    try {
                        GridStoreChannel.Context context = this.context;
                        synchronized (context) {
                            if (this.sessionId != sessionId) {
                                if (this.sessionRef != null) {
                                    this.context.removeRemoteReference(this.sessionRef);
                                    this.sessionRef = null;
                                }
                                if (sessionId != 0L) {
                                    this.sessionRef = new SessionReference(this, sessionId);
                                    this.context.addRemoteReference(this.sessionRef);
                                }
                            }
                        }
                        Object var11_8 = null;
                        this.sessionId = sessionId;
                        if (!LOGGER.isDebugEnabled()) break block28;
                        if (!(orgSessionPrepared ^ this.sessionPrepared)) break block29;
                        LOGGER.debug(this.sessionPrepared ? "transaction.sessionStarted" : "transaction.sessionClosed", "transaction.sessionStarted", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, this.sessionPrepared ? sessionId : orgSessionId);
                    }
                    catch (Throwable throwable) {
                        Object var11_9 = null;
                        this.sessionId = sessionId;
                        if (LOGGER.isDebugEnabled()) {
                            if (orgSessionPrepared ^ this.sessionPrepared) {
                                LOGGER.debug(this.sessionPrepared ? "transaction.sessionStarted" : "transaction.sessionClosed", "transaction.sessionStarted", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, this.sessionPrepared ? sessionId : orgSessionId);
                            } else if (sessionId != 0L && orgSessionId != sessionId) {
                                LOGGER.debug("transaction.sessionIdGenerated", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, sessionId);
                            }
                            if (orgTransactionStarted ^ this.transactionStarted) {
                                LOGGER.debug(this.transactionStarted ? "transaction.transactionStarted" : "transaction.transactionEnded", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, sessionId);
                            }
                        }
                        if (this.contextMonitor == null) throw throwable;
                        if (orgSessionPrepared ^ this.sessionPrepared) {
                            if (this.sessionPrepared) {
                                this.contextMonitor.startSession(sessionId);
                            } else {
                                this.contextMonitor.endSession();
                            }
                        }
                        if (!(orgTransactionStarted ^ this.transactionStarted)) throw throwable;
                        if (this.transactionStarted) {
                            this.contextMonitor.startTransaction();
                            throw throwable;
                        } else {
                            this.contextMonitor.endTransaction();
                        }
                        throw throwable;
                    }
                    break block30;
                }
                if (sessionId != 0L && orgSessionId != sessionId) {
                    LOGGER.debug("transaction.sessionIdGenerated", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, sessionId);
                }
            }
            if (orgTransactionStarted ^ this.transactionStarted) {
                LOGGER.debug(this.transactionStarted ? "transaction.transactionStarted" : "transaction.transactionEnded", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, sessionId);
            }
        }
        if (this.contextMonitor == null) return;
        if (orgSessionPrepared ^ this.sessionPrepared) {
            if (this.sessionPrepared) {
                this.contextMonitor.startSession(sessionId);
            } else {
                this.contextMonitor.endSession();
            }
        }
        if (!(orgTransactionStarted ^ this.transactionStarted)) return;
        if (this.transactionStarted) {
            this.contextMonitor.startTransaction();
            return;
        }
        this.contextMonitor.endTransaction();
    }

    long getStatementIdDirect() {
        return this.statementId;
    }

    boolean isTransactionStarted() {
        return this.transactionStarted;
    }

    private void setTransactionStarted(boolean started) {
        boolean orgStarted = this.transactionStarted;
        this.transactionStarted = started;
        if (orgStarted ^ started) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(started ? "transaction.transactionStarted" : "transaction.transactionEnded", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, this.sessionId);
            }
            if (this.contextMonitor != null) {
                if (started) {
                    this.contextMonitor.startTransaction();
                } else {
                    this.contextMonitor.endTransaction();
                }
            }
        }
    }

    long updateStatementIdDirect() {
        if (this.sessionId == 0L) {
            throw new Error("Internal error by empty session");
        }
        while (++this.statementId == 0L) {
        }
        return this.statementId;
    }

    public static boolean isInitialSessionRetrialEnabled(int protocolVersion) {
        return protocolVersion >= 2;
    }

    private static boolean isInitialSessionRetrialEnabled() {
        return SubnetContainer.isInitialSessionRetrialEnabled(NodeConnection.getProtocolVersion());
    }

    static boolean isSessionIdGeneratorEnabled() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    static boolean isDDLSessionEnabled() {
        return NodeConnection.getProtocolVersion() >= 3 && !GridStoreChannel.v15DDLCompatible;
    }

    static boolean isRowSetIdHintDisabled() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    static boolean isPartialRowSetLostAcceptable() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    protected static RowMapper.MappingMode getRowMappingMode() {
        if (NodeConnection.getProtocolVersion() >= 3) {
            return RowMapper.MappingMode.ROWWISE_SEPARATED_V2;
        }
        return RowMapper.MappingMode.ROWWISE_SEPARATED;
    }

    static boolean isMultiStepStatementIdEnabled() {
        return NodeConnection.getProtocolVersion() >= 5 && !GridStoreChannel.v21StatementIdCompatible;
    }

    static boolean isNewSessionConflicted(GSStatementException cause) {
        if (!SubnetContainer.isSessionIdGeneratorEnabled()) {
            return false;
        }
        return cause.getErrorCode() == 110016;
    }

    static boolean isInitialSessionLost(Statement statement, long statementId, boolean transactionStarted, GSStatementException cause) {
        if (statement == Statement.CREATE_SESSION || statement == Statement.CLOSE_SESSION) {
            return false;
        }
        int errorCode = cause.getErrorCode();
        if (errorCode != 110003 && errorCode != 110016) {
            return false;
        }
        if (!SubnetContainer.isInitialSessionRetrialEnabled()) {
            return false;
        }
        return !(SubnetContainer.isSessionIdGeneratorEnabled() ? transactionStarted : statementId != 1L);
    }

    protected void putSessionInfo(BasicBuffer req, long sessionId) {
        req.putLong(sessionId);
        if (SubnetContainer.isInitialSessionRetrialEnabled()) {
            req.putUUID(this.context.getSessionUUID());
        }
    }

    protected boolean isAutoCommit() {
        return this.autoCommit;
    }

    private void commitForDDL() throws GSException {
        if (!this.autoCommit && this.transactionStarted) {
            this.commit();
        }
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public RowMapper getRowMapper() {
        return this.mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws GSException {
        if (this.autoCommit) {
            throw new GSException(145035, "Auto commit mode must be turned off for a transactional operation");
        }
        if (!this.transactionStarted) {
            return;
        }
        if (++this.transactionId == 0L) {
            this.transactionId = 1L;
        }
        this.clearBlob(true);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putSessionInfo(req, this.sessionId);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        try {
            this.executeStatement(Statement.COMMIT_TRANSACTION, req, resp, StatementFamily.POST);
            Object var4_3 = null;
            this.setTransactionStarted(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setTransactionStarted(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws GSException {
        if (this.autoCommit) {
            throw new GSException(145035, "Auto commit mode must be turned off for a transactional operation");
        }
        if (!this.transactionStarted) {
            return;
        }
        if (++this.transactionId == 0L) {
            this.transactionId = 1L;
        }
        this.clearBlob(true);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        boolean succeeded = false;
        try {
            this.channel.setupRequestBuffer(req);
            req.putLong(this.getContainerId());
            this.putSessionInfo(req, this.sessionId);
            NodeConnection.tryPutEmptyOptionalRequest(req);
            this.executeStatement(Statement.ABORT_TRANSACTION, req, resp, StatementFamily.POST);
            succeeded = true;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.setTransactionStarted(false);
                Object var7_8 = null;
                this.closeSubResources(!succeeded, true);
            }
            catch (Throwable throwable2) {
                Object var7_9 = null;
                this.closeSubResources(!succeeded, true);
                throw throwable2;
            }
            throw throwable;
        }
        try {
            this.setTransactionStarted(false);
            Object var7_6 = null;
            this.closeSubResources(!succeeded, true);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.closeSubResources(!succeeded, true);
            throw throwable;
        }
    }

    @Override
    public void setAutoCommit(boolean enabled) throws GSException {
        this.checkOpened();
        if (this.autoCommit && !enabled) {
            this.autoCommit = false;
            this.setTransactionStarted(false);
        } else if (!this.autoCommit && enabled) {
            this.commit();
            this.autoCommit = true;
        }
    }

    @Override
    public R get(K key) throws GSException {
        return this.get(key, false);
    }

    @Override
    public R get(K key, boolean forUpdate) throws GSException {
        StatementFamily family = this.prepareSession(forUpdate ? StatementFamily.LOCK : StatementFamily.QUERY);
        this.clearBlob(false);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, forUpdate);
        this.mapper.encodeKey(req, key, SubnetContainer.getRowMappingMode());
        this.executeStatement(Statement.GET_ROW, req, resp, family);
        if (!resp.getBoolean()) {
            return null;
        }
        boolean rowIdIncluded = !this.mapper.isForTimeSeries();
        RowMapper.Cursor cursor = this.mapper.createCursor(resp, SubnetContainer.getRowMappingMode(), 1, rowIdIncluded, this);
        return this.rowType.cast(this.mapper.decode(cursor));
    }

    @Override
    public boolean put(R value) throws GSException {
        return this.put(null, value);
    }

    @Override
    public boolean put(K key, R value) throws GSException {
        StatementFamily family = this.prepareSession(StatementFamily.UPDATE);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, null);
        this.mapper.encode(req, SubnetContainer.getRowMappingMode(), key, value);
        this.executeStatement(Statement.PUT_ROW, req, resp, family);
        boolean found = resp.getBoolean();
        this.clearBlob(false);
        return found;
    }

    @Override
    public boolean put(Collection<R> rowCollection) throws GSException {
        try {
            if (rowCollection.isEmpty()) {
                return false;
            }
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(rowCollection, "rowCollection", e);
        }
        StatementFamily family = this.prepareSession(StatementFamily.UPDATE);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, null);
        int rowCount = rowCollection.size();
        req.putLong(rowCount);
        RowMapper.Cursor cursor = this.mapper.createCursor(req, SubnetContainer.getRowMappingMode(), rowCount, false, this);
        for (R row : rowCollection) {
            this.mapper.encode(cursor, null, row);
        }
        this.executeMultiStepStatement(Statement.PUT_MULTIPLE_ROWS, req, resp, family, rowCount);
        this.clearBlob(false);
        return resp.getBoolean();
    }

    @Override
    public SubnetQuery<R> query(String tql) throws GSException {
        return this.query(tql, this.rowType);
    }

    @Override
    public <S> SubnetQuery<S> query(final String tql, Class<S> rowType) throws GSException {
        this.checkOpened();
        RowMapper resultMapper = this.mapper.applyResultType(rowType);
        return new SubnetQuery<S>(this, rowType, resultMapper, new QueryFormatter(Statement.QUERY_TQL){

            public void format(BasicBuffer inBuf) {
                try {
                    inBuf.putString(tql);
                }
                catch (NullPointerException e) {
                    throw GSErrorCode.checkNullParameter(tql, "tql", e);
                }
            }

            public String getQueryString() {
                return tql;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSubResources(boolean silent, boolean transactionalOnly) throws GSException {
        GridStoreChannel.Context context = this.context;
        synchronized (context) {
            HashSet targetClasses = new HashSet();
            for (Class<?> targetClass : this.context.getReferenceTargetClasses()) {
                if (!ContainerSubResource.class.isAssignableFrom(targetClass) || transactionalOnly && !TransactionalResource.class.isAssignableFrom(targetClass)) continue;
                targetClasses.add(targetClass);
            }
            this.channel.closeAllRemoteResources(this.context, targetClasses, this.partitionId, this.containerId, silent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <S> SubnetRowSet<S> queryAndFetch(Class<S> resultType, RowMapper resultMapper, QueryFormatter formatter, SubnetQuery.QueryParameters parameters, boolean forUpdate) throws GSException {
        Object targetConnection;
        boolean neverCreate = false;
        StatementFamily family = this.prepareQuerySession(parameters, forUpdate, false);
        this.clearBlob(false);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, forUpdate, this.context.bindQueryOptions(parameters));
        SubnetQuery.QueryParameters.get(parameters).putFixed(req);
        formatter.format(req);
        GridStoreChannel.Context context = this.context;
        synchronized (context) {
            if (this.contextMonitor != null) {
                this.contextMonitor.setQuery(formatter.getQueryString());
            }
            try {
                this.executeStatement(formatter.getStatement(), req, resp, family);
                Object var13_11 = null;
                if (this.contextMonitor != null) {
                    this.contextMonitor.setQuery(null);
                }
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                if (this.contextMonitor != null) {
                    this.contextMonitor.setQuery(null);
                }
                throw throwable;
            }
            targetConnection = this.channel.getLastConnection(this.context);
        }
        return this.acceptQueryResponse(resultType, resultMapper, formatter, parameters, forUpdate, resp, targetConnection, true);
    }

    void makeQueryRequest(QueryFormatter formatter, SubnetQuery.QueryParameters parameters, boolean forUpdate, BasicBuffer req, boolean noUUID) throws GSException {
        boolean neverCreate = true;
        StatementFamily family = this.prepareQuerySession(parameters, forUpdate, true);
        TransactionInfoType type = noUUID ? TransactionInfoType.NO_UUID : null;
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, type, forUpdate, parameters);
        SubnetQuery.QueryParameters.get(parameters).putFixed(req);
        formatter.format(req);
    }

    <S> SubnetRowSet<S> acceptQueryResponse(Class<S> resultType, RowMapper resultMapper, QueryFormatter formatter, SubnetQuery.QueryParameters parameters, boolean forUpdate, BasicBuffer resp, Object targetConnection, boolean bufSwapAllowed) throws GSException {
        boolean rowIdIncluded;
        RowMapper.MappingMode mode;
        Class<?> mapperRowType;
        int resultLimit = resp.base().limit();
        HashMap<Integer, byte[]> extResultMap = null;
        PartialFetchStatus fetchStatus = null;
        PartialExecutionStatus executionStatus = null;
        if (SubnetGridStore.isQueryOptionsExtensible()) {
            QueryResultType rowSetType = null;
            QueryResultType partialType = null;
            int rowSetPos = -1;
            int rowSetLimit = -1;
            int count = BasicBuffer.BufferUtils.getNonNegativeInt(resp.base());
            for (int i = 0; i < count; ++i) {
                QueryResultType lastType;
                int rawType = resp.base().get() & 0xFF;
                int size = resp.base().getInt();
                if (rawType >= QUERY_RESULT_TYPES.length) {
                    SubnetQuery.QueryParameters.get(parameters).checkResultType(rawType);
                    if (extResultMap == null) {
                        extResultMap = new HashMap<Integer, byte[]>();
                    }
                    byte[] value = new byte[BasicBuffer.BufferUtils.checkSize(resp.base(), size)];
                    resp.base().get(value);
                    extResultMap.put(rawType, value);
                    continue;
                }
                int orgLimit = BasicBuffer.BufferUtils.limitForward(resp.base(), size);
                QueryResultType type = QUERY_RESULT_TYPES[rawType];
                if (type == QueryResultType.PARTIAL_FETCH_STATE || type == QueryResultType.PARTIAL_EXECUTION_STATE) {
                    lastType = partialType;
                    partialType = type;
                    if (type == QueryResultType.PARTIAL_FETCH_STATE) {
                        fetchStatus = new PartialFetchStatus(resp);
                    } else {
                        executionStatus = new PartialExecutionStatus(resp);
                    }
                } else {
                    lastType = rowSetType;
                    rowSetType = type;
                    rowSetPos = resp.base().position();
                    rowSetLimit = resp.base().limit();
                }
                if (lastType != null) {
                    throw new GSException(145031, "Protocol error by query result type confliction (lastType=" + (Object)((Object)lastType) + ", type=" + (Object)((Object)type) + ")");
                }
                BasicBuffer.BufferUtils.skipToLimit(resp.base(), orgLimit);
            }
            if (rowSetType == null) {
                if (SubnetQuery.QueryParameters.get((SubnetQuery.QueryParameters)parameters).containerLostAcceptable) {
                    return null;
                }
                throw new GSException(145031, "Protocol error by no query result type");
            }
            resp.base().position(rowSetPos);
            resp.base().limit(rowSetLimit);
            mapperRowType = this.getResultMapperRowType(rowSetType);
            mode = SubnetContainer.getResultRowMappingMode(rowSetType);
            rowIdIncluded = this.isResultRowIdIncluded(rowSetType);
        } else if (SubnetContainer.isAnyQueryResultTypeEnabled(NodeConnection.getProtocolVersion()) || formatter.getStatement() == Statement.QUERY_TQL || !bufSwapAllowed) {
            QueryResultType type = resp.getByteEnum(QueryResultType.class);
            mapperRowType = this.getResultMapperRowType(type);
            mode = SubnetContainer.getResultRowMappingMode(type);
            rowIdIncluded = this.isResultRowIdIncluded(type);
            if (type == QueryResultType.PARTIAL_FETCH_STATE) {
                fetchStatus = new PartialFetchStatus(resp);
            }
        } else {
            mode = SubnetContainer.getRowMappingMode();
            rowIdIncluded = !this.mapper.isForTimeSeries();
            mapperRowType = this.mapper.getRowType();
        }
        if (resultType != null && resultType != mapperRowType) {
            throw new GSException(145002, "Inconsistent result type (requiredType=" + resultType + ", actualType=" + mapperRowType + ")");
        }
        if (resultMapper == null) {
            resultMapper = this.mapper.applyResultType(mapperRowType);
        } else if (resultMapper.getRowType() != mapperRowType) {
            throw new GSException(145002, "Inconsistent result type (requiredType=" + resultMapper.getRowType() + ", actualType=" + mapperRowType + ")");
        }
        if (SubnetQuery.QueryParameters.isForUpdate(parameters, forUpdate)) {
            this.setTransactionStarted(true);
        }
        SubnetQuery.QueryParameters rowSetParameters = SubnetQuery.QueryParameters.inherit(parameters, forUpdate, this.isAutoCommit() ? 0L : this.transactionId, executionStatus);
        int rowCount = this.getResultRowSetCount(resp);
        BasicBuffer resultBuffer = this.getResultBuffer(resp, resultLimit, bufSwapAllowed);
        RowMapper.Cursor cursor = resultMapper.createCursor(resultBuffer, mode, rowCount, rowIdIncluded, this);
        return new SubnetRowSet<S>(this, resultType, resultMapper, cursor, extResultMap, formatter, rowSetParameters, fetchStatus, targetConnection);
    }

    private StatementFamily prepareQuerySession(SubnetQuery.QueryParameters parameters, boolean forUpdate, boolean neverCreate) throws GSException {
        StatementFamily baseFamily;
        boolean forUpdateActual = SubnetQuery.QueryParameters.isForUpdate(parameters, forUpdate);
        Long initialTransactionId = SubnetQuery.QueryParameters.findInitialTransactionId(parameters);
        if (initialTransactionId != null) {
            this.checkTransactionPreserved(forUpdateActual, initialTransactionId, true);
        }
        if (forUpdateActual) {
            if (SubnetQuery.QueryParameters.get(parameters).isPartialExecutionConfigured()) {
                throw new GSException(145003, "Partial execution not supported for update or on manual commit (forUpdate=" + SubnetQuery.QueryParameters.isForUpdate(parameters, forUpdate) + ", autoCommit=" + this.isAutoCommit() + ")");
            }
            if (neverCreate && (!this.sessionPrepared || this.sessionId == 0L)) {
                throw new Error("Internal error by invalid session status");
            }
            baseFamily = StatementFamily.LOCK;
        } else {
            baseFamily = StatementFamily.QUERY;
        }
        return this.prepareSession(baseFamily);
    }

    private Class<?> getResultMapperRowType(QueryResultType type) {
        switch (type) {
            case AGGREGATION: {
                return AggregationResult.class;
            }
            case QUERY_ANALYSIS: {
                return QueryAnalysisEntry.class;
            }
        }
        return this.mapper.getRowType();
    }

    private static RowMapper.MappingMode getResultRowMappingMode(QueryResultType type) {
        if (type == QueryResultType.AGGREGATION) {
            return RowMapper.MappingMode.AGGREGATED;
        }
        return SubnetContainer.getRowMappingMode();
    }

    private boolean isResultRowIdIncluded(QueryResultType type) {
        if (this.mapper.isForTimeSeries()) {
            return false;
        }
        switch (type) {
            case AGGREGATION: 
            case QUERY_ANALYSIS: {
                return false;
            }
        }
        return true;
    }

    private BasicBuffer getResultBuffer(BasicBuffer resp, int orgLimit, boolean bufSwapAllowed) {
        BasicBuffer resultBuffer;
        int resultDataSize = resp.base().remaining();
        if (!bufSwapAllowed || resultDataSize < GridStoreChannel.INITIAL_BUFFER_SIZE) {
            resultBuffer = new BasicBuffer(resultDataSize);
            resultBuffer.base().put(resp.base());
            resultBuffer.base().flip();
            resp.base().limit(orgLimit);
        } else {
            resultBuffer = resp;
            this.context.replaceResponseBuffer(this.channel.createResponseBuffer());
        }
        return resultBuffer;
    }

    private int getResultRowSetCount(BasicBuffer resp) throws GSException {
        long longRowCount = resp.base().getLong();
        if (longRowCount < 0L || longRowCount > Integer.MAX_VALUE) {
            throw new GSConnectionException(145031, "Protocol error by result row count out of range");
        }
        return (int)longRowCount;
    }

    public static boolean isAnyQueryResultTypeEnabled(int protocolVersion) {
        return protocolVersion >= 2 && (GridStoreChannel.v1ProtocolCompatible == null || GridStoreChannel.v1ProtocolCompatible == false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeRowSet(GridStoreChannel channel, GridStoreChannel.Context context, int partitionId, long containerId, PartialFetchStatus fetchStatus, Object targetConnection) throws GSException {
        GridStoreChannel.Context context2 = context;
        synchronized (context2) {
            BasicBuffer req = context.getSynchronizedRequestBuffer();
            BasicBuffer resp = context.getSynchronizedResponseBuffer();
            channel.setupRequestBuffer(req);
            req.putLong(containerId);
            NodeConnection.tryPutEmptyOptionalRequest(req);
            req.putLong(fetchStatus.rowSetId);
            if (!SubnetContainer.isRowSetIdHintDisabled()) {
                req.putLong(fetchStatus.rowSetIdHint);
            }
            channel.checkActiveConnection(context, partitionId, targetConnection);
            channel.executeStatement(context, Statement.CLOSE_ROW_SET.generalize(), partitionId, 0L, req, resp, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowMapper.Cursor fetchRowSet(long remainingCount, PartialFetchStatus fetchStatus, SubnetQuery.QueryParameters parameters, Object[] targetConnection, RowMapper resultMapper) throws GSException {
        boolean neverCreate = true;
        StatementFamily family = this.prepareQuerySession(parameters, false, true);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        if (SubnetGridStore.isQueryOptionsExtensible()) {
            boolean forUpdate = SubnetQuery.QueryParameters.isForUpdate(parameters, false);
            this.putTransactionInfo(req, family, null, forUpdate, parameters);
        } else {
            req.putInt(this.getSchemaVersionId());
            this.tryPutOptionalRequest(req, false, true, false, null);
        }
        req.putLong(fetchStatus.rowSetId);
        if (!SubnetContainer.isRowSetIdHintDisabled()) {
            req.putLong(fetchStatus.rowSetIdHint);
        }
        req.putLong(fetchStatus.totalRowCount - remainingCount);
        req.putLong(SubnetQuery.QueryParameters.get((SubnetQuery.QueryParameters)parameters).fetchSize);
        GridStoreChannel.Context forUpdate = this.context;
        synchronized (forUpdate) {
            this.channel.checkActiveConnection(this.context, this.partitionId, targetConnection[0]);
            try {
                this.executeStatement(Statement.FETCH_ROW_SET, req, resp, null);
            }
            catch (GSRecoverableException e) {
                targetConnection[0] = null;
                throw e;
            }
            catch (GSStatementException e) {
                if (e.getErrorCode() == 60132) {
                    targetConnection[0] = null;
                    throw GSErrorCode.newGSRecoverableException(145043, "Row set temporarily lost by connection problem (reason=" + e.getMessage() + ")", e);
                }
                throw e;
            }
        }
        boolean resultClosed = resp.getBoolean();
        if (resultClosed) {
            targetConnection[0] = null;
        }
        long varDataBaseOffset = resp.base().getLong();
        int resultRowCount = this.getResultRowSetCount(resp);
        long newRemainingCount = remainingCount - (long)resultRowCount;
        if (newRemainingCount < 0L || resultClosed && newRemainingCount > 0L && !SubnetContainer.isPartialRowSetLostAcceptable() || !resultClosed && newRemainingCount == 0L) {
            throw new GSConnectionException(145031, "Protocol error by unexpected result (resultClosed=" + resultClosed + ", resultRowCount=" + resultRowCount + ", remainingCount=" + remainingCount + ")");
        }
        BasicBuffer resultBuffer = this.getResultBuffer(resp, resp.base().limit(), true);
        boolean rowIdIncluded = !this.mapper.isForTimeSeries();
        RowMapper.Cursor cursor = resultMapper.createCursor(resultBuffer, SubnetContainer.getRowMappingMode(), resultRowCount, rowIdIncluded, this);
        cursor.setVarDataBaseOffset(varDataBaseOffset);
        return cursor;
    }

    @Override
    public boolean remove(K key) throws GSException {
        StatementFamily family = this.prepareSession(StatementFamily.UPDATE);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, null);
        this.mapper.encodeKey(req, key, SubnetContainer.getRowMappingMode());
        this.executeStatement(Statement.DELETE_ROW, req, resp, family);
        boolean found = resp.getBoolean();
        this.clearBlob(false);
        return found;
    }

    void remove(RowMapper resolvedMapper, long transactionId, boolean updatable, long rowId, Object key) throws GSException {
        this.checkTransactionPreserved(true, transactionId, updatable);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        StatementFamily family = StatementFamily.UPDATE;
        if (this.mapper.isForTimeSeries()) {
            this.putTransactionInfo(req, family, null, null);
            resolvedMapper.encodeKey(req, key, SubnetContainer.getRowMappingMode());
            this.executeStatement(Statement.DELETE_ROW, req, resp, family);
        } else {
            this.putTransactionInfo(req, family, TransactionInfoType.SKIP_COMMIT_MODE, null);
            req.putLong(rowId);
            this.executeStatement(Statement.DELETE_ROW_BY_ID, req, resp, family);
        }
    }

    void update(RowMapper resolvedMapper, long transactionId, boolean updatable, long rowId, Object key, Object newRowObj) throws GSException {
        Statement statement;
        if (this.mapper.isForTimeSeries() && !timeSeriesUpdateEnabled) {
            throw new GSException(145003, "TimeSeries row can not be updated");
        }
        this.checkTransactionPreserved(true, transactionId, updatable);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        StatementFamily family = StatementFamily.UPDATE;
        if (this.mapper.isForTimeSeries()) {
            this.putTransactionInfo(req, family, null, null);
            statement = Statement.PUT_ROW;
        } else {
            this.putTransactionInfo(req, family, TransactionInfoType.SKIP_COMMIT_MODE, null);
            req.putLong(rowId);
            statement = Statement.UPDATE_ROW_BY_ID;
        }
        resolvedMapper.encode(req, SubnetContainer.getRowMappingMode(), key, newRowObj);
        this.executeStatement(statement, req, resp, family);
    }

    @Override
    public void removeRowById(long transactionId, long baseId) throws GSException {
        long rowId = this.resolveRowIdForUpdate(baseId);
        Object key = this.resolveRowKeyForUpdate(baseId);
        this.remove(this.mapper, transactionId, true, rowId, key);
    }

    @Override
    public void updateRowById(long transactionId, long baseId, R rowObj) throws GSException {
        long rowId = this.resolveRowIdForUpdate(baseId);
        Object key = this.resolveRowKeyForUpdate(baseId);
        this.update(this.mapper, transactionId, true, rowId, key, rowObj);
    }

    private void checkTransactionPreserved(boolean forUpdate, long transactionId, boolean updatable) throws GSException {
        if (forUpdate && (transactionId == 0L || !updatable)) {
            throw new GSException(145039, "Update option must be turned on");
        }
        if (transactionId == 0L) {
            if (!this.autoCommit) {
                throw new GSException(145035, "Illegal operation for partial row set by auto commit query because of currently manual commit mode");
            }
        } else if (transactionId != this.transactionId || !this.transactionStarted || this.autoCommit) {
            throw new GSException(145036, "Transaction expired");
        }
    }

    private long resolveRowIdForUpdate(long baseId) {
        if (this.mapper.isForTimeSeries()) {
            return 0L;
        }
        return baseId;
    }

    private Object resolveRowKeyForUpdate(long baseId) {
        if (this.mapper.isForTimeSeries()) {
            return new Date(baseId);
        }
        return null;
    }

    @Override
    public Blob createBlob() throws GSException {
        this.checkOpened();
        return new BlobImpl(null);
    }

    @Override
    public Blob createBlob(byte[] data) throws GSException {
        BlobImpl blob = new BlobImpl(null);
        blob.setDataDirect(data);
        return blob;
    }

    @Override
    public void createIndex(String columnName) throws GSException {
        this.createIndex(columnName, IndexType.DEFAULT);
    }

    @Override
    public void createIndex(String columnName, IndexType type) throws GSException {
        GSErrorCode.checkNullParameter(columnName, "columnName", null);
        GSErrorCode.checkNullParameter((Object)type, "type", null);
        this.createIndex(IndexInfo.createByColumn(columnName, type));
    }

    @Override
    public void createIndex(IndexInfo info) throws GSException {
        this.createIndex(info, null);
    }

    @Override
    public void createIndex(IndexInfo info, NodeConnection.OptionalRequestSource source) throws GSException {
        Statement statement;
        GSErrorCode.checkNullParameter(info, "info", null);
        IndexInfo filteredInfo = this.filterIndexInfo(info, true);
        this.commitForDDL();
        StatementFamily family = SubnetContainer.isDDLSessionEnabled() ? this.prepareSession(StatementFamily.POST) : null;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        if (family != null) {
            this.putSessionInfo(req, this.sessionId);
        }
        req.putInt(this.getSchemaVersionId());
        this.tryPutOptionalRequest(req, false, true, true, source);
        if (SubnetGridStore.isIndexDetailEnabled()) {
            statement = Statement.CREATE_INDEX_DETAIL;
            SubnetGridStore.exportIndexInfo(req, filteredInfo, false);
        } else {
            statement = Statement.CREATE_INDEX;
            req.putInt(filteredInfo.getColumn());
            req.putByteEnum(filteredInfo.getType());
        }
        this.executeStatement(statement, req, resp, family);
    }

    @Override
    public void dropIndex(String columnName) throws GSException {
        this.dropIndex(columnName, IndexType.DEFAULT);
    }

    @Override
    public void dropIndex(String columnName, IndexType type) throws GSException {
        GSErrorCode.checkNullParameter(columnName, "columnName", null);
        GSErrorCode.checkNullParameter((Object)type, "type", null);
        this.dropIndex(IndexInfo.createByColumn(columnName, type), null);
    }

    @Override
    public void dropIndex(IndexInfo info) throws GSException {
        this.dropIndex(info, null);
    }

    @Override
    public void dropIndex(IndexInfo info, NodeConnection.OptionalRequestSource source) throws GSException {
        Statement statement;
        GSErrorCode.checkNullParameter(info, "info", null);
        IndexInfo filteredInfo = this.filterIndexInfo(info, false);
        if (filteredInfo == null) {
            return;
        }
        this.commitForDDL();
        StatementFamily family = SubnetContainer.isDDLSessionEnabled() ? this.prepareSession(StatementFamily.POST) : null;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        if (family != null) {
            this.putSessionInfo(req, this.sessionId);
        }
        req.putInt(this.getSchemaVersionId());
        this.tryPutOptionalRequest(req, false, true, false, source);
        if (SubnetGridStore.isIndexDetailEnabled()) {
            statement = Statement.DROP_INDEX_DETAIL;
            SubnetGridStore.exportIndexInfo(req, filteredInfo, true);
        } else {
            statement = Statement.DROP_INDEX;
            if (filteredInfo.getColumn() == null) {
                throw new GSException(145001, "Column must be specified");
            }
            req.putInt(filteredInfo.getColumn());
            if (filteredInfo.getType() == null) {
                throw new GSException(145001, "Index type must be specified");
            }
            req.putByteEnum(filteredInfo.getType());
        }
        this.executeStatement(statement, req, resp, family);
    }

    private IndexInfo filterIndexInfo(IndexInfo info, boolean forCreation) throws GSException {
        String columnName;
        IndexInfo filteredInfo = info;
        if (filteredInfo.getName() != null) {
            RowMapper.checkSymbol(filteredInfo.getName(), "index name");
        }
        Integer column = filteredInfo.getColumn();
        String columnNameById = null;
        if (column != null) {
            ColumnInfo columnInfo;
            ContainerInfo containerInfo = this.mapper.getContainerInfo();
            try {
                columnInfo = containerInfo.getColumnInfo(column);
            }
            catch (IllegalArgumentException e) {
                throw new GSException(145002, (Throwable)e);
            }
            columnNameById = columnInfo.getName();
        }
        if ((columnName = filteredInfo.getColumnName()) == null) {
            columnName = columnNameById;
        } else {
            int columnByName = this.mapper.resolveColumnId(columnName);
            if (column == null) {
                filteredInfo = new IndexInfo(filteredInfo);
                filteredInfo.setColumn(columnByName);
            } else if (column != columnByName) {
                throw new GSException(145002, "Inconsistent column specified (specifiedNumber=" + column + " (actualName=" + columnNameById + "), specifiedName=" + columnName + " (actualNumber=" + columnByName + "))");
            }
        }
        if (forCreation && filteredInfo.getColumn() == null) {
            throw new GSException(145001, "Column must be specified");
        }
        IndexType type = filteredInfo.getType();
        if (!SubnetGridStore.isIndexDetailEnabled() && (forCreation && type == null || type == IndexType.DEFAULT)) {
            Integer filteredColumn;
            IndexType defaultType;
            if (filteredInfo == info) {
                filteredInfo = new IndexInfo(filteredInfo);
            }
            IndexType indexType = defaultType = (filteredColumn = filteredInfo.getColumn()) == null ? null : this.getDefaultIndexType(filteredColumn);
            if (defaultType == null) {
                if (!forCreation) {
                    return null;
                }
                throw new GSException(145019, "Default index can not be assigned (columnName=" + columnName + ")");
            }
            filteredInfo.setType(defaultType);
        }
        return filteredInfo;
    }

    private IndexType getDefaultIndexType(int columnId) throws GSException {
        if (this.mapper.isArray(columnId)) {
            return null;
        }
        switch (this.mapper.getFieldElementType(columnId)) {
            case TIMESTAMP: {
                if (columnId == 0 && this.mapper.isForTimeSeries()) {
                    return null;
                }
                return IndexType.TREE;
            }
            case GEOMETRY: {
                if (this.mapper.isForTimeSeries()) {
                    return null;
                }
                return IndexType.SPATIAL;
            }
            case BLOB: {
                return null;
            }
        }
        return IndexType.TREE;
    }

    @Override
    @Deprecated
    public void createEventNotification(URL url) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        NodeConnection.tryPutEmptyOptionalRequest(req);
        try {
            req.putString(url.toString());
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(url, "url", e);
            throw e;
        }
        this.executeStatement(Statement.CREATE_EVENT_NOTIFICATION, req, resp, null);
    }

    @Override
    @Deprecated
    public void dropEventNotification(URL url) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        NodeConnection.tryPutEmptyOptionalRequest(req);
        try {
            req.putString(url.toString());
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(url, "url", e);
            throw e;
        }
        this.executeStatement(Statement.DROP_EVENT_NOTIFICATION, req, resp, null);
    }

    @Override
    public void flush() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        NodeConnection.tryPutEmptyOptionalRequest(req);
        this.executeStatement(Statement.FLUSH_LOG, req, resp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws GSException {
        GridStoreChannel.Context context = this.context;
        synchronized (context) {
            Object v1;
            if (this.isClosed()) {
                return;
            }
            try {
                this.closeSubResources(false, false);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var3_3 = null;
                try {
                    this.closeSession(false);
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var5_7 = v0;
                SubnetGridStore store = this.store;
                if (store != null) {
                    this.store = null;
                    store.removeReference(this);
                }
                throw throwable;
            }
            try {
                this.closeSession(false);
                v1 = null;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            Object var5_6 = v1;
            SubnetGridStore store = this.store;
            if (store != null) {
                this.store = null;
                store.removeReference(this);
            }
        }
    }

    public boolean isClosed() {
        return this.store == null || this.context.isClosedAsync();
    }

    protected void checkOpened() throws GSException {
        if (this.isClosed()) {
            throw new GSException(145040, "Already closed");
        }
    }

    @Override
    public ContainerType getType() throws GSException {
        this.checkOpened();
        return this.mapper.getContainerType();
    }

    @Override
    public R createRow() throws GSException {
        this.checkOpened();
        return this.rowType.cast(this.mapper.createRow(false));
    }

    @Override
    public RowSet<Row> getRowSet(Object[] position, long fetchLimit) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        StatementFamily family = null;
        this.putTransactionInfo(req, family, TransactionInfoType.SKIP_COMMIT_MODE, null);
        req.putLong(fetchLimit);
        req.putLong((Long)position[0]);
        this.executeStatement(Statement.GET_MULTIPLE_ROWS, req, resp, family);
        position[0] = resp.base().getLong();
        long rowCount = resp.base().getLong();
        BasicBuffer resultData = resp;
        this.context.replaceResponseBuffer(this.channel.createResponseBuffer());
        if (this.mapper.getRowType() != Row.class) {
            throw new GSException(145003, "Not supported for this row type (class=" + this.mapper.getRowType() + ")");
        }
        RowMapper.Cursor cursor = this.mapper.createCursor(resultData, SubnetContainer.getRowMappingMode(), (int)rowCount, false, this);
        return new SubnetRowSet<Row>(this, Row.class, this.mapper, cursor, null, null, null, null, null);
    }

    public boolean putRowSet(SubnetRowSet<?> rowSet) throws GSException {
        int rowCount = rowSet.size();
        if (rowCount == 0) {
            return false;
        }
        StatementFamily family = this.prepareSession(StatementFamily.UPDATE);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, null);
        req.putLong(rowCount);
        RowMapper.Cursor cursor = this.mapper.createCursor(req, SubnetContainer.getRowMappingMode(), rowCount, false, this);
        for (int i = 0; i < rowCount; ++i) {
            this.mapper.encode(cursor, null, (Object)rowSet.nextGeneralRow(), true);
        }
        this.executeMultiStepStatement(Statement.PUT_MULTIPLE_ROWS, req, resp, family, rowCount);
        this.clearBlob(false);
        return resp.getBoolean();
    }

    @Override
    public void createTrigger(TriggerInfo info) throws GSException {
        StatementFamily family = SubnetContainer.isDDLSessionEnabled() ? this.prepareSession(StatementFamily.POST) : null;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        if (family != null) {
            this.putSessionInfo(req, this.sessionId);
        }
        req.putInt(this.getSchemaVersionId());
        this.tryPutOptionalRequest(req, false, true, true, null);
        if (info.getName() == null) {
            throw new GSException(145001, "Trigger name not assigned");
        }
        req.putString(info.getName());
        if (info.getType() == null) {
            throw new GSException(145001, "Trigger type not assigned");
        }
        req.putByteEnum(info.getType());
        if (info.getURI() == null) {
            throw new GSException(145001, "Trigger URI not assigned");
        }
        req.putString(info.getURI().toString());
        int eventType = 0;
        for (TriggerInfo.EventType eventType2 : info.getTargetEvents()) {
            eventType |= 1 << eventType2.ordinal();
        }
        req.putInt(eventType);
        int columnCount = info.getTargetColumns().size();
        req.putInt(columnCount);
        for (String columnName : info.getTargetColumns()) {
            req.putInt(this.mapper.resolveColumnId(columnName));
        }
        String string = "";
        switch (info.getType()) {
            case REST: {
                req.putString("");
                req.putString("");
                req.putString("");
                req.putString("");
                req.putString("");
                break;
            }
            case JMS: {
                req.putString("activemq");
                if (info.getJMSDestinationType() == null) {
                    throw new GSException(145001, "Destination type not assigned");
                }
                req.putString(info.getJMSDestinationType());
                if (info.getJMSDestinationName() == null) {
                    throw new GSException(145001, "Destination name not assigned");
                }
                req.putString(info.getJMSDestinationName());
                if (info.getUser() == null) {
                    req.putString("");
                } else {
                    req.putString(info.getUser());
                }
                if (info.getPassword() == null) {
                    req.putString("");
                    break;
                }
                req.putString(info.getPassword());
                break;
            }
            default: {
                throw new Error("Internal error by unknown trigger type");
            }
        }
        this.executeStatement(Statement.CREATE_TRIGGER, req, resp, family);
    }

    @Override
    public void dropTrigger(String name) throws GSException {
        StatementFamily family = SubnetContainer.isDDLSessionEnabled() ? this.prepareSession(StatementFamily.POST) : null;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        if (family != null) {
            this.putSessionInfo(req, this.sessionId);
        }
        req.putInt(this.getSchemaVersionId());
        this.tryPutOptionalRequest(req, false, true, false, null);
        req.putString(name);
        this.executeStatement(Statement.DROP_TRIGGER, req, resp, family);
    }

    @Override
    public Object getRowValue(Object rowObj, int column) throws GSException {
        return this.mapper.resolveField(rowObj, column);
    }

    static {
        Map<Statement, Statement> map = TIME_SERIES_STATEMENT_MAP = new EnumMap<Statement, Statement>(Statement.class);
        map.put(Statement.GET_ROW, Statement.GET_TIME_SERIES_ROW);
        map.put(Statement.QUERY_TQL, Statement.QUERY_TIME_SERIES_TQL);
        map.put(Statement.PUT_ROW, Statement.PUT_TIME_SERIES_ROW);
        map.put(Statement.PUT_MULTIPLE_ROWS, Statement.PUT_TIME_SERIES_MULTIPLE_ROWS);
        map.put(Statement.DELETE_ROW, Statement.DELETE_TIME_SERIES_ROW);
        map.put(Statement.GET_MULTIPLE_ROWS, Statement.GET_TIME_SERIES_MULTIPLE_ROWS);
        Set<Statement> set = FIXED_SESSION_MODE_STATEMENTS = EnumSet.noneOf(Statement.class);
        set.add(Statement.CREATE_SESSION);
        set.add(Statement.CLOSE_SESSION);
        set.add(Statement.COMMIT_TRANSACTION);
        set.add(Statement.ABORT_TRANSACTION);
        QUERY_RESULT_TYPES = QueryResultType.values();
        LOGGER = LoggingUtils.getLogger("Transaction");
    }

    static abstract class QueryFormatter {
        private final Statement statement;

        QueryFormatter(Statement statement) {
            this.statement = statement;
        }

        public Statement getStatement() {
            return this.statement;
        }

        abstract void format(BasicBuffer var1) throws GSException;

        abstract String getQueryString();
    }

    static class PartialExecutionStatus {
        static final PartialExecutionStatus DISABLED = new PartialExecutionStatus(false);
        static final PartialExecutionStatus ENABLED_INITIAL = new PartialExecutionStatus(true);
        private final boolean enabled;
        private final SortedMap<Integer, byte[]> entryMap;

        PartialExecutionStatus(boolean enabled) {
            this.enabled = enabled;
            this.entryMap = null;
        }

        PartialExecutionStatus(BasicBuffer in) throws GSException {
            this.enabled = in.getBoolean();
            int count = BasicBuffer.BufferUtils.getNonNegativeInt(in.base());
            if (count > 0) {
                this.entryMap = new TreeMap<Integer, byte[]>();
                for (int i = 0; i < count; ++i) {
                    byte type = in.base().get();
                    int size = BasicBuffer.BufferUtils.getIntSize(in.base());
                    byte[] bytes = new byte[size];
                    in.base().get(bytes);
                    this.entryMap.put(Integer.valueOf(type), bytes);
                }
            } else {
                this.entryMap = null;
            }
        }

        void put(BasicBuffer out) {
            out.putBoolean(this.enabled);
            int count = this.entryMap == null ? 0 : this.entryMap.size();
            out.putInt(count);
            if (count == 0) {
                return;
            }
            for (Map.Entry<Integer, byte[]> entry : this.entryMap.entrySet()) {
                out.put((byte)entry.getKey().intValue());
                byte[] bytes = entry.getValue();
                out.putInt(bytes.length);
                out.prepare(bytes.length);
                out.base().put(bytes);
            }
        }

        boolean isEnabled() {
            return this.enabled;
        }

        static boolean isEnabled(PartialExecutionStatus status) {
            return status != null && status.isEnabled();
        }

        static PartialExecutionStatus inherit(PartialExecutionStatus prev, PartialExecutionStatus next) throws GSException {
            if (!PartialExecutionStatus.isEnabled(next)) {
                return DISABLED;
            }
            if (!PartialExecutionStatus.isEnabled(prev) || next.entryMap.isEmpty()) {
                throw new GSException(145031, "Protocol error by unexpected partial execution");
            }
            if (prev.entryMap != null && prev.entryMap.size() == next.entryMap.size()) {
                boolean progressed = false;
                for (Map.Entry<Integer, byte[]> entry : prev.entryMap.entrySet()) {
                    byte[] nextBytes;
                    byte[] prevBytes = entry.getValue();
                    if (Arrays.equals(prevBytes, nextBytes = (byte[])next.entryMap.get(entry.getKey()))) continue;
                    progressed = true;
                    break;
                }
                if (!progressed) {
                    throw new GSException(145031, "Protocol error by no progress on partial execution");
                }
            }
            return next;
        }
    }

    static final class PartialFetchStatus {
        final long totalRowCount;
        final long rowSetId;
        final long rowSetIdHint;

        PartialFetchStatus(BasicBuffer in) {
            this.totalRowCount = in.base().getLong();
            this.rowSetId = in.base().getLong();
            this.rowSetIdHint = SubnetContainer.isRowSetIdHintDisabled() ? 0L : in.base().getLong();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryResultType {
        ROW_SET,
        AGGREGATION,
        QUERY_ANALYSIS,
        PARTIAL_FETCH_STATE,
        PARTIAL_EXECUTION_STATE;

    }

    static interface TransactionalResource
    extends ContainerSubResource {
    }

    static interface ContainerSubResource {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TransactionInfoType {
        NO_UUID,
        SKIP_COMMIT_MODE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SessionMode {
        AUTO,
        CREATE,
        GET;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TransactionMode {
        AUTO,
        BEGIN,
        CONTINUE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SessionReference
    extends GridStoreChannel.RemoteReference<SubnetContainer<?, ?>> {
        private final long sessionId;
        private long lastStatementId;

        public SessionReference(SubnetContainer<?, ?> target, long sessionId) {
            super(target, SubnetContainer.class, target.context, ((SubnetContainer)target).partitionId, ((SubnetContainer)target).containerId);
            this.sessionId = sessionId;
        }

        @Override
        public void close(GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
            GridStoreChannel.SessionInfo sessionInfo = new GridStoreChannel.SessionInfo(this.partitionId, this.containerId, this.sessionId, this.lastStatementId);
            SubnetContainer.closeSession(channel, context, context.getSynchronizedRequestBuffer(), context.getSynchronizedResponseBuffer(), sessionInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum StatementFamily {
        QUERY,
        LOCK,
        UPDATE,
        POST;

    }
}

