/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.common.InternPool;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import com.toshiba.mwcloud.gs.common.ServiceAddressResolver;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.NodeConnectionPool;
import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeResolver
implements Closeable {
    private static boolean ipv6EnabledDefault = false;
    public static final int NOTIFICATION_RECEIVE_TIMEOUT = 10000;
    private static final int DEFAULT_NOTIFICATION_STATEMENT_TYPE = 5000;
    private static final int DEFAULT_NOTIFICATION_PORT = 31999;
    private static final String DEFAULT_NOTIFICATION_ADDRESS = "239.0.0.1";
    private static final String DEFAULT_NOTIFICATION_ADDRESS_V6 = "ff12::1";
    private static final String DEFAULT_SERVICE_TYPE = "transaction";
    private static final AddressConfig DEFAULT_ADDRESS_CONFIG = new AddressConfig();
    public static final ProtocolConfig DEFAULT_PROTOCOL_CONFIG = new DefaultProtocolConfig();
    private static final LoggingUtils.BaseGridStoreLogger LOGGER = LoggingUtils.getLogger("Discovery");
    private final NodeConnectionPool pool;
    private final boolean ipv6Enabled;
    private final InetSocketAddress notificationAddress;
    private InetSocketAddress masterAddress;
    private final NodeConnection.Config connectionConfig = new NodeConnection.Config();
    private NodeConnection masterConnection;
    private final BasicBuffer req = new BasicBuffer(64);
    private final BasicBuffer resp = new BasicBuffer(64);
    private long notificationReceiveTimeoutMillis = 10000L;
    private volatile long connectionTrialCounter;
    private boolean connectionFailedPreviously;
    private final InternPool<InetSocketAddress> addressCache = new InternPool();
    private final Map<Integer, InetSocketAddress[]> nodeAddressMap = new HashMap<Integer, InetSocketAddress[]>();
    private int preferableConnectionPoolSize;
    private final ServiceAddressResolver serviceAddressResolver;
    private final Random random = new Random();
    private int lastSelectedMember = -1;
    private boolean alwaysMaster = false;
    private ProtocolConfig protocolConfig;

    public NodeResolver(NodeConnectionPool pool, boolean passive, InetSocketAddress address, NodeConnection.Config connectionConfig, ServiceAddressResolver.Config sarConfig, List<InetSocketAddress> memberList, AddressConfig addressConfig) throws GSException {
        this.pool = pool;
        this.ipv6Enabled = sarConfig == null ? address.getAddress() instanceof Inet6Address : sarConfig.isIPv6Expected();
        this.notificationAddress = passive ? address : null;
        this.masterAddress = passive ? null : address;
        this.connectionConfig.set(connectionConfig);
        this.preferableConnectionPoolSize = pool.getMaxSize();
        this.serviceAddressResolver = NodeResolver.makeServiceAddressResolver(sarConfig, memberList, addressConfig);
        this.protocolConfig = DEFAULT_PROTOCOL_CONFIG;
        if (addressConfig != null) {
            this.alwaysMaster = addressConfig.alwaysMaster;
        }
        NodeConnection.fillRequestHead(this.ipv6Enabled, this.req);
    }

    private static ServiceAddressResolver makeServiceAddressResolver(ServiceAddressResolver.Config sarConfig, List<InetSocketAddress> memberList, AddressConfig addressConfig) throws GSException {
        if (sarConfig == null) {
            return null;
        }
        if (addressConfig == null) {
            return NodeResolver.makeServiceAddressResolver(sarConfig, memberList, DEFAULT_ADDRESS_CONFIG);
        }
        ServiceAddressResolver resolver = new ServiceAddressResolver(sarConfig);
        resolver.initializeType(0, addressConfig.serviceType);
        if (sarConfig.getProviderURL() == null && memberList.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (sarConfig.getProviderURL() == null) {
            for (int i = 0; i < memberList.size(); ++i) {
                resolver.setAddress(i, 0, memberList.get(i));
            }
            resolver.validate();
        }
        return resolver;
    }

    public synchronized void setConnectionConfig(NodeConnection.Config connectionConfig) {
        this.connectionConfig.set(connectionConfig);
    }

    public synchronized void setNotificationReceiveTimeoutMillis(long timeout) {
        this.notificationReceiveTimeoutMillis = timeout;
    }

    public synchronized void setPreferableConnectionPoolSize(int size) {
        if (size >= 0 && this.preferableConnectionPoolSize != size) {
            this.preferableConnectionPoolSize = size;
            this.updateConnectionPoolSize();
        }
    }

    public synchronized void setProtocolConfig(ProtocolConfig protocolConfig) {
        this.protocolConfig = protocolConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPartitionCount(ClusterInfo clusterInfo) throws GSException {
        if (clusterInfo.getPartitionCount() == null) {
            long startTrialCount = this.connectionTrialCounter;
            NodeResolver nodeResolver = this;
            synchronized (nodeResolver) {
                this.prepareConnectionAndClusterInfo(clusterInfo, startTrialCount);
            }
        }
        return clusterInfo.getPartitionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerHashMode getContainerHashMode(ClusterInfo clusterInfo) throws GSException {
        if (clusterInfo.getHashMode() == null) {
            long startTrialCount = this.connectionTrialCounter;
            NodeResolver nodeResolver = this;
            synchronized (nodeResolver) {
                this.prepareConnectionAndClusterInfo(clusterInfo, startTrialCount);
            }
        }
        return clusterInfo.getHashMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDatabaseId(ClusterInfo clusterInfo) throws GSException {
        if (clusterInfo.getDatabaseId() == null) {
            long startTrialCount = this.connectionTrialCounter;
            NodeResolver nodeResolver = this;
            synchronized (nodeResolver) {
                this.prepareConnectionAndClusterInfo(clusterInfo, startTrialCount);
            }
        }
        return clusterInfo.getDatabaseId();
    }

    public void acceptDatabaseId(ClusterInfo clusterInfo, long databaseId, InetSocketAddress address) throws GSException {
        boolean byConnection = true;
        this.acceptClusterInfo(clusterInfo, null, null, databaseId, address, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getMasterAddress(ClusterInfo clusterInfo) throws GSException {
        long startTrialCount = this.connectionTrialCounter;
        NodeResolver nodeResolver = this;
        synchronized (nodeResolver) {
            if (this.masterAddress == null) {
                this.prepareConnectionAndClusterInfo(clusterInfo, startTrialCount);
            }
            return this.masterAddress;
        }
    }

    public InetSocketAddress getNodeAddress(ClusterInfo clusterInfo, int partitionId, boolean backupPreferred) throws GSException {
        return this.getNodeAddress(clusterInfo, partitionId, backupPreferred, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getNodeAddress(ClusterInfo clusterInfo, int partitionId, boolean backupPreferred, InetAddress preferableHost) throws GSException {
        InetSocketAddress[] addressList;
        long startTrialCount = this.connectionTrialCounter;
        NodeResolver nodeResolver = this;
        synchronized (nodeResolver) {
            addressList = this.getNodeAddressList(clusterInfo, partitionId, backupPreferred, startTrialCount, false);
        }
        int backupCount = addressList.length - 1;
        if (backupPreferred && backupCount > 0) {
            boolean ownerCount = true;
            InetSocketAddress address = addressList[1 + this.random.nextInt(backupCount)];
            if (preferableHost != null && !address.getAddress().equals(preferableHost)) {
                for (int i = 1; i < addressList.length; ++i) {
                    if (!addressList[i].getAddress().equals(preferableHost)) continue;
                    return addressList[i];
                }
            }
            return address;
        }
        return addressList[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress[] getNodeAddressList(ClusterInfo clusterInfo, int partitionId) throws GSException {
        InetSocketAddress[] addressList;
        long startTrialCount = this.connectionTrialCounter;
        NodeResolver nodeResolver = this;
        synchronized (nodeResolver) {
            addressList = this.getNodeAddressList(clusterInfo, partitionId, true, startTrialCount, false);
        }
        return Arrays.copyOf(addressList, addressList.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress[] getNodeAddressList(ClusterInfo clusterInfo, int partitionId, boolean backupPreferred, long startTrialCount, boolean allowEmpty) throws GSException {
        Integer partitionIdKey = partitionId;
        InetSocketAddress[] addressList = this.nodeAddressMap.get(partitionId);
        if (addressList != null) {
            return addressList;
        }
        if (this.masterConnection == null || clusterInfo.partitionCount.get() == null) {
            this.prepareConnectionAndClusterInfo(clusterInfo, startTrialCount);
        }
        NodeConnection.fillRequestHead(this.ipv6Enabled, this.req);
        boolean succeeded = false;
        try {
            NodeConnection.tryPutEmptyOptionalRequest(this.req);
            this.masterConnection.executeStatementDirect(this.protocolConfig.getNormalStatementType(Statement.GET_PARTITION_ADDRESS), partitionId, 0L, this.req, this.resp, null);
            int partitionCount = this.resp.base().getInt();
            this.acceptClusterInfo(clusterInfo, partitionCount, null, null, this.masterAddress, true);
            byte[] addressBuffer = new byte[this.getInetAddressSize()];
            int sockAddrSize = addressBuffer.length + 4;
            byte ownerCount = this.resp.base().get();
            int ownerPosition = this.resp.base().position();
            this.resp.base().position(ownerPosition + sockAddrSize * ownerCount);
            byte backupCount = this.resp.base().get();
            int backupPosition = this.resp.base().position();
            this.resp.base().position(backupPosition + sockAddrSize * backupCount);
            if (ownerCount < 0 || backupCount < 0) {
                throw new GSConnectionException(145031, "Protocol error by negative address count (, masterAddress=" + this.masterAddress + ", partitionId=" + partitionId + ", ownerCount=" + ownerCount + ", backupCount=" + backupCount + ")");
            }
            if (!(ownerCount != 0 || backupCount != 0 && backupPreferred)) {
                if (allowEmpty) {
                    InetSocketAddress[] inetSocketAddressArray = new InetSocketAddress[]{};
                    return inetSocketAddressArray;
                }
                throw new GSConnectionException(145032, "Specified partition is currently not available (masterAddress=" + this.masterAddress + ", partitionId=" + partitionId + ", ownerCount=" + ownerCount + ", backupCount=" + backupCount + ", backupPreferred=" + backupPreferred + ")");
            }
            addressList = new InetSocketAddress[1 + backupCount];
            this.resp.base().position(ownerPosition);
            if (ownerCount > 0) {
                addressList[0] = this.decodeSocketAddress(this.resp, addressBuffer);
            }
            this.resp.base().position(backupPosition);
            for (int i = 1; i < addressList.length; ++i) {
                addressList[i] = this.decodeSocketAddress(this.resp, addressBuffer);
            }
            if (ownerCount > 0) {
                this.nodeAddressMap.put(partitionIdKey, addressList);
            }
            this.updateConnectionPoolSize();
            succeeded = true;
            this.connectionFailedPreviously = false;
            InetSocketAddress[] inetSocketAddressArray = addressList;
            return inetSocketAddressArray;
        }
        finally {
            if (!succeeded) {
                this.connectionFailedPreviously = true;
                try {
                    this.masterConnection.close();
                }
                catch (GSException gSException) {
                }
                finally {
                    this.masterConnection = null;
                    this.nodeAddressMap.remove(partitionIdKey);
                }
            }
        }
    }

    private int getInetAddressSize() {
        return this.ipv6Enabled ? 16 : 4;
    }

    private InetSocketAddress decodeSocketAddress(BasicBuffer in, byte[] addressBuffer) throws GSConnectionException {
        InetSocketAddress address;
        in.base().get(addressBuffer);
        try {
            address = new InetSocketAddress(InetAddress.getByAddress(addressBuffer), in.base().getInt());
        }
        catch (UnknownHostException e) {
            throw new GSConnectionException(145031, "Protocol error by invalid address (reason=" + e.getMessage() + ")", e);
        }
        catch (IllegalArgumentException e) {
            throw new GSConnectionException(145031, "Protocol error by invalid address (reason=" + e.getMessage() + ")", e);
        }
        return this.addressCache.intern(address);
    }

    private void prepareConnectionAndClusterInfo(ClusterInfo clusterInfo, long startTrialCount) throws GSException {
        boolean succeeded = false;
        boolean statementError = false;
        try {
            if (this.connectionFailedPreviously && startTrialCount != this.connectionTrialCounter) {
                throw new GSConnectionException(145029, "Previously failed in the other thread");
            }
            if (this.masterAddress == null) {
                ++this.connectionTrialCounter;
                if (this.serviceAddressResolver == null) {
                    this.updateMasterInfo(clusterInfo);
                } else {
                    this.updateNotificationMember();
                }
            }
            while (!this.updateConnectionAndClusterInfo(clusterInfo)) {
                ++this.connectionTrialCounter;
            }
            succeeded = true;
            this.connectionFailedPreviously = false;
        }
        catch (GSStatementException e) {
            statementError = true;
            throw e;
        }
        finally {
            boolean invalidated;
            if (!(succeeded || !(invalidated = clusterInfo.invalidate()) && statementError)) {
                this.connectionFailedPreviously = true;
                this.invalidateMaster(clusterInfo);
            }
        }
    }

    private void updateNotificationMember() throws GSException {
        URL url = this.serviceAddressResolver.getConfig().getProviderURL();
        if (url == null) {
            return;
        }
        LOGGER.debug("discovery.updatingMember", url, this.serviceAddressResolver.isAvailable());
        try {
            this.serviceAddressResolver.update();
            this.serviceAddressResolver.validate();
        }
        catch (GSException e) {
            if (this.serviceAddressResolver.isAvailable()) {
                LOGGER.info("discovery.previousMember", url, e);
                return;
            }
            throw new GSConnectionException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.serviceAddressResolver.getEntryCount(); ++i) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                InetSocketAddress address = this.serviceAddressResolver.getAddress(i, 0);
                builder.append(address.getAddress().getHostAddress());
                builder.append(":");
                builder.append(address.getPort());
            }
            builder.append("]");
            LOGGER.debug("discovery.memberUpdated", url, this.serviceAddressResolver.isChanged(), builder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateConnectionAndClusterInfo(ClusterInfo clusterInfo) throws GSException {
        NodeConnection pendingConnection = null;
        try {
            ContainerHashMode hashMode;
            boolean masterMatched;
            NodeConnection connection;
            InetSocketAddress address;
            if (this.masterAddress == null) {
                int count = this.serviceAddressResolver.getEntryCount();
                if (count == 0) {
                    ServiceAddressResolver.Config config = this.serviceAddressResolver.getConfig();
                    throw new GSConnectionException(123504, "No address found in provider (url=" + config.getProviderURL() + ")");
                }
                int index = this.lastSelectedMember;
                if (index < 0) {
                    index = this.random.nextInt(count);
                } else if (++index >= count) {
                    index = 0;
                }
                this.lastSelectedMember = index;
                address = this.serviceAddressResolver.getAddress(index, 0);
                if (this.alwaysMaster) {
                    this.masterAddress = address;
                }
            } else {
                address = this.masterAddress;
            }
            boolean masterUnresolved = this.masterAddress == null;
            boolean masterResolvable = GridStoreChannel.isMasterResolvableByConnection();
            if (masterUnresolved && !masterResolvable) {
                throw new GSException(145000, "");
            }
            LOGGER.debug("discovery.checkingMaster", this.masterAddress, address);
            NodeConnection.LoginInfo loginInfo = clusterInfo.loginInfo;
            long[] databaseIdRef = new long[1];
            if (this.masterConnection == null) {
                pendingConnection = connection = this.pool.resolve(address, this.req, this.resp, this.connectionConfig, loginInfo, databaseIdRef, !this.connectionFailedPreviously);
            } else {
                connection = this.masterConnection;
                connection.login(this.req, this.resp, loginInfo, databaseIdRef);
            }
            NodeConnection.fillRequestHead(this.ipv6Enabled, this.req);
            NodeConnection.tryPutEmptyOptionalRequest(this.req);
            if (masterResolvable) {
                this.req.putBoolean(true);
            }
            boolean partitionId = false;
            connection.executeStatementDirect(this.protocolConfig.getNormalStatementType(Statement.GET_PARTITION_ADDRESS), 0, 0L, this.req, this.resp, null);
            int partitionCount = this.resp.base().getInt();
            if (masterResolvable) {
                byte ownerCount = this.resp.base().get();
                byte backupCount = this.resp.base().get();
                if (ownerCount != 0 || backupCount != 0 || this.resp.base().remaining() == 0) {
                    throw new GSConnectionException(145031, "Protocol error by invalid master location");
                }
                masterMatched = this.resp.getBoolean();
                hashMode = NodeResolver.decodeContainerHashMode(this.resp);
                this.masterAddress = this.decodeSocketAddress(this.resp, new byte[this.getInetAddressSize()]);
                if (masterUnresolved) {
                    LOGGER.debug("discovery.masterFound", new Object[]{this.masterAddress, connection.getRemoteSocketAddress(), hashMode, partitionCount});
                }
            } else {
                masterMatched = true;
                hashMode = GridStoreChannel.getDefaultContainerHashMode();
            }
            if (masterMatched && pendingConnection != null) {
                this.masterConnection = pendingConnection;
                pendingConnection = null;
            }
            long databaseId = databaseIdRef[0];
            if (this.masterConnection != null) {
                this.acceptClusterInfo(clusterInfo, partitionCount, hashMode, databaseId, this.masterAddress, true);
                LOGGER.debug("discovery.masterUpdated", new Object[]{this.notificationAddress, this.masterAddress, hashMode, partitionCount});
            }
            if (pendingConnection != null) {
                this.pool.add(pendingConnection);
            }
        }
        catch (Throwable throwable) {
            if (pendingConnection != null) {
                this.pool.add(pendingConnection);
            }
            throw throwable;
        }
        return this.masterConnection != null;
    }

    private void updateMasterInfo(ClusterInfo clusterInfo) throws GSException {
        DatagramSocket socket = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("discovery.updatingMaster", this.notificationAddress, this.notificationReceiveTimeoutMillis);
            }
            socket = new MulticastSocket(this.notificationAddress.getPort());
            socket.setSoTimeout(PropertyUtils.timeoutPropertyToIntMillis(this.notificationReceiveTimeoutMillis));
            socket.setReuseAddress(true);
            ((MulticastSocket)socket).joinGroup(this.notificationAddress.getAddress());
            int length = 28 + this.getInetAddressSize() * 2 + 1;
            DatagramPacket packet = new DatagramPacket(new byte[length], length);
            socket.receive(packet);
            if (packet.getLength() != length) {
                throw new GSConnectionException(145031, "Protocol error by invalid packet length (expected=" + length + ", actual=" + packet.getLength() + ")");
            }
            this.resp.clear();
            this.resp.prepare(length);
            this.resp.base().put(packet.getData());
            this.resp.base().flip();
            this.resp.base().position(16 + this.getInetAddressSize());
            int statementType = this.resp.base().getInt();
            if (statementType != this.protocolConfig.getNotificationStatementType()) {
                throw new GSConnectionException(145031, "Protocol error by illegal statement type (type=" + statementType + ")");
            }
            byte[] addressData = new byte[this.getInetAddressSize()];
            this.resp.base().get(addressData);
            InetSocketAddress masterAddress = new InetSocketAddress(InetAddress.getByAddress(addressData), this.resp.base().getInt());
            int partitionCount = this.resp.base().getInt();
            if (partitionCount <= 0) {
                throw new GSConnectionException(145031, "Protocol error by negative partition count");
            }
            ContainerHashMode hashMode = NodeResolver.decodeContainerHashMode(this.resp);
            this.acceptClusterInfo(clusterInfo, partitionCount, hashMode, null, this.notificationAddress, false);
            this.masterAddress = masterAddress;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("discovery.masterUpdated", new Object[]{this.notificationAddress, masterAddress, hashMode, partitionCount});
            }
        }
        catch (IOException e) {
            throw new GSConnectionException(145028, "Failed to update by notification (address=" + this.notificationAddress + ", reason=" + e.getMessage() + ")", e);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    private static ContainerHashMode decodeContainerHashMode(BasicBuffer in) throws GSException {
        try {
            return in.getByteEnum(ContainerHashMode.class);
        }
        catch (IllegalStateException e) {
            throw new GSConnectionException(145031, "Protocol error by illegal hash mode (reason=" + e + ")", e);
        }
    }

    public synchronized void invalidateMaster(ClusterInfo clusterInfo) {
        clusterInfo.invalidate();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("discovery.invalidatingMaster", new Object[]{this.notificationAddress, this.masterAddress, clusterInfo.hashMode.get(), clusterInfo.partitionCount.get(), this.masterConnection != null});
        }
        if (this.notificationAddress != null || this.serviceAddressResolver != null) {
            this.masterAddress = null;
        }
        try {
            this.releaseMasterCache(true);
        }
        catch (GSException gSException) {
            // empty catch block
        }
        this.updateConnectionPoolSize();
    }

    public synchronized void releaseMasterCache(boolean forceClose) throws GSException {
        this.nodeAddressMap.clear();
        this.addressCache.clear();
        if (this.masterConnection != null) {
            NodeConnection connection = this.masterConnection;
            this.masterConnection = null;
            if (forceClose) {
                connection.close();
            } else {
                this.pool.add(connection);
            }
        }
    }

    private void acceptClusterInfo(ClusterInfo clusterInfo, Integer partitionCount, ContainerHashMode hashMode, Long databaseId, InetSocketAddress address, boolean byConnection) throws GSException {
        if (partitionCount != null && partitionCount <= 0) {
            throw new GSConnectionException(145031, "Protocol error by non positive partition count (value=" + partitionCount + ")");
        }
        if (databaseId != null && databaseId < 0L) {
            throw new GSConnectionException(145031, "Protocol error by negative database ID (value=" + databaseId + ")");
        }
        boolean checkOnly = true;
        while (true) {
            this.acceptClusterInfoEntry(clusterInfo, clusterInfo.partitionCount, "partition count", partitionCount, address, byConnection, checkOnly);
            this.acceptClusterInfoEntry(clusterInfo, clusterInfo.hashMode, "container hash mode", hashMode, address, byConnection, checkOnly);
            this.acceptClusterInfoEntry(clusterInfo, clusterInfo.databaseId, "database ID", databaseId, address, byConnection, checkOnly);
            if (!checkOnly) break;
            checkOnly = false;
        }
    }

    private <T> void acceptClusterInfoEntry(ClusterInfo clusterInfo, ClusterInfoEntry<T> entry, String name, T value, InetSocketAddress address, boolean byConnection, boolean checkOnly) throws GSException {
        int errorCode;
        if (entry.tryAccept(value, address, byConnection, checkOnly)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        NodeConnection.LoginInfo loginInfo = clusterInfo.loginInfo;
        if (entry == clusterInfo.databaseId) {
            builder.append("Database may be dropped and created again with same database name ");
        } else {
            builder.append("Multiple cluster may have been existent with same network configuration ");
        }
        builder.append("or fundamental cluster configuration may have been changed ");
        builder.append("detected by receiving different ");
        builder.append(name);
        builder.append(". ");
        builder.append("Please check previous operations or cluster configuration (");
        builder.append("receivedValue=");
        builder.append(value);
        builder.append(", previousValue=");
        builder.append(entry.get());
        builder.append(", ");
        NodeResolver.formatAddressParameter(builder, "receivedAddress", address);
        builder.append(", ");
        NodeResolver.formatAddressParameter(builder, "previousAddress", entry.acceptedAddress);
        builder.append(", ");
        NodeResolver.formatStringParameter(builder, "clusterName", loginInfo.getClusterName());
        if (entry == clusterInfo.databaseId) {
            builder.append(", ");
            NodeResolver.formatStringParameter(builder, "database", loginInfo.getDatabase());
        }
        builder.append(")");
        int n = errorCode = entry == clusterInfo.partitionCount ? 145033 : 145044;
        if (byConnection) {
            throw new GSException(errorCode, builder.toString());
        }
        throw new GSConnectionException(errorCode, builder.toString());
    }

    private static void formatAddressParameter(StringBuilder builder, String name, InetSocketAddress value) {
        builder.append(name);
        builder.append("=");
        if (value == null) {
            builder.append("(manually specified)");
        } else {
            builder.append(value);
        }
    }

    private static void formatStringParameter(StringBuilder builder, String name, String value) {
        builder.append(name);
        builder.append("=");
        if (value == null) {
            builder.append("(not specified)");
        } else {
            builder.append("\"");
            builder.append(value);
            builder.append("\"");
        }
    }

    private void updateConnectionPoolSize() {
        this.pool.setMaxSize(Math.max(this.preferableConnectionPoolSize, this.addressCache.size()));
    }

    @Override
    public synchronized void close() throws GSException {
        this.releaseMasterCache(false);
    }

    public static InetSocketAddress getAddressProperties(PropertyUtils.WrappedProperties props, boolean[] passive, ServiceAddressResolver.Config sarConfig, List<InetSocketAddress> memberList, AddressConfig addressConfig) throws GSException {
        if (addressConfig == null) {
            return NodeResolver.getAddressProperties(props, passive, sarConfig, memberList, DEFAULT_ADDRESS_CONFIG);
        }
        String host = props.getProperty("host", false);
        passive[0] = host == null;
        String ipProtocol = props.getProperty("ipProtocol", true);
        boolean ipv6Enabled = ipv6EnabledDefault;
        if (ipProtocol != null) {
            if (ipProtocol.equals("IPV6")) {
                ipv6Enabled = true;
            }
            if (ipProtocol.equals("IPV4")) {
                ipv6Enabled = false;
            } else {
                throw new GSException(145002, "Illegal IP type (type=" + ipProtocol + ")");
            }
        }
        InetAddress address = NodeResolver.getNotificationProperties(props, host, ipv6Enabled, sarConfig, memberList, addressConfig);
        String portKey = passive[0] ? "notificationPort" : "port";
        Integer port = props.getIntProperty(portKey, false);
        if (port == null) {
            if (passive[0]) {
                port = addressConfig.notificationPort;
            } else if (address != null) {
                throw new GSException(145002, "Port must be specified");
            }
        }
        if (port != null && (port < 0 || port >= 65536)) {
            throw new GSException(145002, "Port out of range (port=" + port + ", propertyName=" + portKey + ")");
        }
        if (address == null) {
            return null;
        }
        return new InetSocketAddress(address, (int)port);
    }

    public static InetAddress getNotificationProperties(PropertyUtils.WrappedProperties props, String host, Boolean ipv6Expected, ServiceAddressResolver.Config sarConfig, List<InetSocketAddress> memberList, AddressConfig addressConfig) throws GSException {
        PropertyUtils.checkExclusiveProperties(props.getBase(), "notificationProvider", "notificationMember", "notificationAddress");
        PropertyUtils.checkExclusiveProperties(props.getBase(), "notificationProvider", "host");
        PropertyUtils.checkExclusiveProperties(props.getBase(), "notificationMember", "host");
        String notificationProvider = props.getProperty("notificationProvider", false);
        String notificationMember = props.getProperty("notificationMember", false);
        String notificationAddress = props.getProperty("notificationAddress", false);
        if (notificationProvider != null) {
            sarConfig.setProviderURL(notificationProvider);
        }
        sarConfig.setIPv6Expected(ipv6Expected != null && ipv6Expected != false);
        sarConfig.setTimeoutMillis((int)Math.min(props.getTimeoutProperty("notificationProviderTimeout", -1L, false), Integer.MAX_VALUE));
        memberList.addAll(NodeResolver.parseNotificationMember(notificationMember, ipv6Expected));
        if (notificationProvider != null || notificationMember != null) {
            return null;
        }
        if (host == null) {
            return NodeResolver.getNotificationAddress(notificationAddress, ipv6Expected, addressConfig, "notificationAddress");
        }
        return NodeResolver.getNotificationAddress(host, ipv6Expected, addressConfig, "host");
    }

    private static InetAddress getNotificationAddress(String host, Boolean ipv6Expected, AddressConfig config, String key) throws GSException {
        if (host == null) {
            String alternative = ipv6Expected != null && ipv6Expected != false ? config.notificationAddressV6 : config.notificationAddress;
            return ServiceAddressResolver.resolveAddress(alternative, ipv6Expected, key);
        }
        return ServiceAddressResolver.resolveAddress(host, ipv6Expected, key);
    }

    public static List<InetSocketAddress> parseNotificationMember(String value, Boolean ipv6Expected) throws GSException {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.isEmpty()) {
            throw new GSException(145001, "Notification member is empty");
        }
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        for (String addrStr : value.split(",", -1)) {
            InetAddress inetAddr;
            int port;
            if (addrStr.isEmpty()) {
                throw new GSException(145002, "One or more element in notifications member are empty (element=" + addrStr + ", list=" + value + ")");
            }
            int portPos = addrStr.lastIndexOf(":");
            int v6AddrEnd = addrStr.lastIndexOf("]");
            if (portPos < 0 || portPos < v6AddrEnd) {
                throw new GSException(145002, "Port not found in notification member (element=" + addrStr + ", list=" + value + ")");
            }
            try {
                port = Integer.parseInt(addrStr.substring(portPos + 1));
            }
            catch (NumberFormatException e) {
                throw new GSException(145002, "Failed to parse port in notification member (element=" + addrStr + ", list=" + value + ", reason=" + e.getMessage() + ")", e);
            }
            try {
                inetAddr = ServiceAddressResolver.resolveAddress(addrStr.substring(0, portPos), ipv6Expected, null);
            }
            catch (GSException e) {
                throw new GSException(145002, "Failed to resolve host in notification member (element=" + addrStr + ", list=" + value + ", reason=" + e.getMessage() + ")", e);
            }
            try {
                list.add(new InetSocketAddress(inetAddr, port));
            }
            catch (IllegalArgumentException e) {
                throw new GSException(145002, "Illegal port in notification member (element=" + addrStr + ", list=" + value + ", reason=" + e.getMessage() + ")", e);
            }
        }
        return list;
    }

    public static class AddressConfig {
        public int notificationPort = 31999;
        public String notificationAddress = "239.0.0.1";
        public String notificationAddressV6 = "ff12::1";
        public String serviceType = "transaction";
        public boolean alwaysMaster = false;
    }

    private static class DefaultProtocolConfig
    extends ProtocolConfig {
        private DefaultProtocolConfig() {
        }

        public int getNotificationStatementType() {
            return 5000;
        }

        public int getNormalStatementType(Statement statement) {
            if (statement == Statement.GET_PARTITION_ADDRESS) {
                return NodeConnection.statementToNumber(statement.generalize());
            }
            throw new Error();
        }
    }

    public static abstract class ProtocolConfig {
        public abstract int getNotificationStatementType();

        public abstract int getNormalStatementType(Statement var1);
    }

    public static class ClusterInfo {
        final NodeConnection.LoginInfo loginInfo;
        final ClusterInfoEntry<Integer> partitionCount = new ClusterInfoEntry();
        final ClusterInfoEntry<ContainerHashMode> hashMode = new ClusterInfoEntry();
        final ClusterInfoEntry<Long> databaseId = new ClusterInfoEntry();

        public ClusterInfo(NodeConnection.LoginInfo loginInfo) {
            this.loginInfo = new NodeConnection.LoginInfo(loginInfo);
            this.loginInfo.setOwnerMode(false);
        }

        boolean invalidate() {
            boolean invalidated = false;
            invalidated |= this.partitionCount.invalidate();
            invalidated |= this.hashMode.invalidate();
            return invalidated |= this.databaseId.invalidate();
        }

        public Integer getPartitionCount() {
            return this.partitionCount.get();
        }

        public ContainerHashMode getHashMode() {
            return this.hashMode.get();
        }

        public Long getDatabaseId() {
            return this.databaseId.get();
        }

        public void setPartitionCount(Integer partitionCount) {
            if (partitionCount != null && partitionCount <= 0) {
                return;
            }
            this.partitionCount.tryAccept(partitionCount, null, true, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClusterInfoEntry<T> {
        T value;
        boolean acceptedByConnection;
        InetSocketAddress acceptedAddress;

        private ClusterInfoEntry() {
        }

        T get() {
            return this.value;
        }

        boolean tryAccept(T value, InetSocketAddress address, boolean byConnection, boolean checkOnly) {
            if (value == null) {
                return true;
            }
            if (this.value == null) {
                if (!checkOnly) {
                    this.value = value;
                }
            } else if (!this.value.equals(value)) {
                return false;
            }
            if (!checkOnly) {
                this.acceptedByConnection |= byConnection;
                this.acceptedAddress = address;
            }
            return true;
        }

        boolean invalidate() {
            if (!this.acceptedByConnection && this.value != null) {
                this.value = null;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContainerHashMode {
        COMPATIBLE1,
        MD5;

    }
}

