/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeConnectionPool
implements Closeable {
    private static final int DEFAULT_MAX_SIZE = 16;
    private Map<SocketAddress, List<NodeConnection>> connectionMap = new HashMap<SocketAddress, List<NodeConnection>>();
    private Set<NodeConnection> connectionSet = new LinkedHashSet<NodeConnection>();
    private List<NodeConnection> exceededConnectionList = Collections.synchronizedList(new ArrayList());
    private int maxSize = 16;

    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxSize) {
        try {
            NodeConnectionPool nodeConnectionPool = this;
            synchronized (nodeConnectionPool) {
                if (this.connectionMap != null) {
                    this.adjustSize(maxSize);
                }
                this.maxSize = maxSize;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.closeExceededConnections();
            }
            catch (GSException gSException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.closeExceededConnections();
        }
        catch (GSException gSException) {}
    }

    private void adjustSize(int maxSize) {
        while (this.connectionSet.size() > Math.max(maxSize, 0)) {
            NodeConnection oldest = this.connectionSet.iterator().next();
            if (oldest == null) continue;
            SocketAddress oldestKey = NodeConnectionPool.getKey(oldest);
            List<NodeConnection> oldestList = this.connectionMap.get(oldestKey);
            if (oldestList != null) {
                oldestList.remove(oldest);
            }
            if (oldestList.isEmpty()) {
                this.connectionMap.remove(oldestKey);
            }
            this.connectionSet.remove(oldest);
            this.exceededConnectionList.add(oldest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(NodeConnection connection) {
        try {
            NodeConnectionPool nodeConnectionPool = this;
            synchronized (nodeConnectionPool) {
                if (this.connectionMap == null) {
                    this.exceededConnectionList.add(connection);
                    connection = null;
                } else if (this.connectionSet.add(connection)) {
                    SocketAddress key = NodeConnectionPool.getKey(connection);
                    List<NodeConnection> list = this.connectionMap.get(key);
                    if (list == null) {
                        list = new LinkedList<NodeConnection>();
                        this.connectionMap.put(key, list);
                    }
                    list.add(connection);
                    connection = null;
                    this.adjustSize(this.maxSize);
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                try {
                    this.closeExceededConnections();
                    Object var9_10 = null;
                    if (connection == null) throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    if (connection == null) throw throwable2;
                    connection.close();
                    this.connectionSet.remove(connection);
                    throw throwable2;
                }
                connection.close();
                this.connectionSet.remove(connection);
                {
                    throw throwable;
                }
            }
            catch (GSException gSException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            try {
                this.closeExceededConnections();
                Object var9_8 = null;
                if (connection == null) return;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (connection == null) throw throwable;
                connection.close();
                this.connectionSet.remove(connection);
                throw throwable;
            }
            connection.close();
            this.connectionSet.remove(connection);
            return;
        }
        catch (GSException gSException) {}
    }

    public synchronized NodeConnection pull(SocketAddress address) {
        if (this.connectionMap == null) {
            return null;
        }
        List<NodeConnection> list = this.connectionMap.get(address);
        if (list == null || list.isEmpty()) {
            return null;
        }
        NodeConnection connection = list.remove(0);
        if (list.isEmpty()) {
            this.connectionMap.remove(address);
        }
        this.connectionSet.remove(connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeConnection resolve(InetSocketAddress address, BasicBuffer req, BasicBuffer resp, NodeConnection.Config config, NodeConnection.LoginInfo loginInfo, long[] databaseId, boolean preferCache) throws GSException {
        NodeConnection connection;
        block9: {
            NodeConnection nodeConnection = connection = preferCache ? this.pull(address) : null;
            if (connection == null) {
                NodeConnection newConnection = new NodeConnection(address, config);
                try {
                    newConnection.connect(req, resp);
                    connection = newConnection;
                    Object var11_11 = null;
                    if (connection != null) break block9;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (connection == null) {
                        newConnection.close();
                    }
                    throw throwable;
                }
                newConnection.close();
            }
        }
        boolean released = false;
        try {
            try {
                connection.login(req, resp, loginInfo, databaseId);
                return connection;
            }
            catch (GSStatementException e) {
                released = true;
                this.add(connection);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (!released) {
                connection.close();
            }
            throw throwable;
        }
    }

    private static SocketAddress getKey(NodeConnection connection) {
        return connection.getRemoteSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws GSException {
        block9: {
            block8: {
                try {
                    NodeConnectionPool nodeConnectionPool = this;
                    synchronized (nodeConnectionPool) {
                        if (this.connectionSet == null) {
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                            Object var6_2 = null;
                            break block8;
                        }
                        try {
                            this.exceededConnectionList.addAll(this.connectionSet);
                            Object var3_5 = null;
                            this.connectionMap = null;
                            this.connectionSet = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_6 = null;
                            this.connectionMap = null;
                            this.connectionSet = null;
                            throw throwable;
                        }
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var6_4 = null;
                    this.closeExceededConnections();
                    throw throwable;
                }
            }
            this.closeExceededConnections();
            return;
        }
        Object var6_3 = null;
        this.closeExceededConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeExceededConnections() throws GSException {
        ArrayList<NodeConnection> connectionList;
        List<NodeConnection> list = this.exceededConnectionList;
        synchronized (list) {
            if (this.exceededConnectionList.isEmpty()) {
                return;
            }
            connectionList = new ArrayList<NodeConnection>();
            connectionList.addAll(this.exceededConnectionList);
            this.exceededConnectionList.clear();
        }
        NodeConnectionPool.closeConnections(connectionList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void closeConnections(List<NodeConnection> connectionList, boolean silent) throws GSException {
        if (connectionList == null || connectionList.isEmpty()) {
            return;
        }
        try {
            Iterator<NodeConnection> it = connectionList.iterator();
            while (it.hasNext()) {
                if (silent) {
                    try {
                        it.next().close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    it.next().close();
                }
                it.remove();
            }
            Object var5_4 = null;
            if (connectionList.isEmpty()) return;
            if (silent) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (connectionList.isEmpty() || silent) throw throwable;
            NodeConnectionPool.closeConnections(connectionList, true);
            throw throwable;
        }
        NodeConnectionPool.closeConnections(connectionList, true);
    }
}

