/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.common.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAddressResolver {
    private final Config config;
    private List<String> typeList = new ArrayList<String>();
    private Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private Set<InetSocketAddress> addressSet = new HashSet<InetSocketAddress>();
    private List<Entry> entryList = new ArrayList<Entry>();
    private boolean initialized;
    private boolean firstUpdated;
    private boolean changed;
    private boolean normalized;

    public ServiceAddressResolver(Config config) {
        this.config = new Config(config);
    }

    public Config getConfig() {
        return new Config(this.config);
    }

    public void initializeType(ServiceAddressResolver resolver) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        ArrayList<String> typeList = new ArrayList<String>(resolver.typeList);
        HashMap<String, Integer> typeMap = new HashMap<String, Integer>(resolver.typeMap);
        this.typeList = typeList;
        this.typeMap = typeMap;
    }

    public void initializeType(int type, String name) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (name.isEmpty() || this.typeMap.containsKey(name)) {
            throw new IllegalArgumentException();
        }
        if (type < this.typeList.size() && this.typeList.get(type) != null) {
            throw new IllegalArgumentException();
        }
        while (type >= this.typeList.size()) {
            this.typeList.add(null);
        }
        this.typeMap.put(name, type);
        this.typeList.set(type, name);
    }

    public int getTypeCount() {
        return this.typeMap.size();
    }

    public int getType(String name) {
        Integer type = this.typeMap.get(name);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return type;
    }

    public void update() throws GSException {
        this.completeInit();
        if (this.config.providerURL == null) {
            return;
        }
        HttpURLConnection connection = null;
        try {
            int result;
            URLConnection urlConnection = this.config.providerURL.openConnection();
            if (!(urlConnection instanceof HttpURLConnection)) {
                throw new GSException(145005, "Provider URL is only supported for HTTP (protocol=" + this.config.providerURL.getProtocol() + ")");
            }
            connection = (HttpURLConnection)urlConnection;
            connection.setConnectTimeout(this.config.timeoutMillis);
            connection.setReadTimeout(this.config.timeoutMillis);
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.connect();
            int code = connection.getResponseCode();
            if (code != 200) {
                throw new GSException(122503, "Unexpected response status code (code=" + code + ")");
            }
            String expectedType = "application/json";
            String type = connection.getContentType();
            if (type == null) {
                throw new GSException(122503, "Content type is not specified (expected=application/json)");
            }
            if (!type.toLowerCase(Locale.US).equals("application/json")) {
                throw new GSException(122503, "Content type does not match (expected=application/json, actual=" + type + ")");
            }
            int length = connection.getContentLength();
            InputStream in = connection.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
            byte[] buf = new byte[8192];
            int rest = length;
            while (rest != 0 && (result = in.read(buf, 0, rest < 0 ? buf.length : Math.min(rest, buf.length))) >= 0) {
                out.write(buf, 0, result);
                if (rest <= 0) continue;
                rest -= result;
            }
            this.assign(JsonUtils.parse(new String(out.toByteArray(), Charset.forName("UTF-8"))));
            this.firstUpdated = true;
        }
        catch (GSException e) {
            throw new GSException("Failed to access the address provider (url=" + this.config.providerURL + ", reason=" + e.getMessage() + ")", (Throwable)e);
        }
        catch (IOException e) {
            throw new GSException(145028, "Network problem occurred while accessing the address provider (url=" + this.config.providerURL + ", reason=" + e.getMessage() + ")", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isAvailable() {
        if (this.config.providerURL == null) {
            return true;
        }
        return this.firstUpdated;
    }

    public boolean isSameEntries(ServiceAddressResolver another) {
        return ServiceAddressResolver.isSameEntries(this.entryList, this.normalized, another.entryList, another.normalized);
    }

    public int getEntryCount() {
        return this.entryList.size();
    }

    public InetSocketAddress getAddress(int index, int type) {
        this.checkType(type);
        this.checkEntry(index);
        InetSocketAddress address = (InetSocketAddress)this.entryList.get(index).list.get(type);
        if (address == null) {
            throw new IllegalStateException();
        }
        return address;
    }

    public void setAddress(int index, int type, InetSocketAddress addr) throws GSException {
        this.completeInit();
        this.checkType(type);
        InetSocketAddress storedAddr = null;
        if (index < this.entryList.size()) {
            storedAddr = (InetSocketAddress)this.entryList.get(index).list.get(type);
        }
        if (addr != null) {
            if (this.addressSet.contains(addr)) {
                if (addr.equals(storedAddr)) {
                    return;
                }
                throw new GSException(123503, "Address conflicted (index=" + index + ", type=" + this.getTypeName(type) + ", address=" + addr + ")");
            }
            boolean ipv6 = addr.getAddress() instanceof Inet6Address;
            if (ipv6 ^ this.config.ipv6Expected) {
                throw new GSException(123505, "Address family unmatched (index=" + index + ", type=" + this.getTypeName(type) + ", address=" + addr + ", expectedFamily=" + (this.config.ipv6Expected ? "IPv6" : "IPv4") + ")");
            }
        }
        int typeCount = this.getTypeCount();
        while (index >= this.entryList.size()) {
            this.entryList.add(new Entry(typeCount));
        }
        if (addr != null) {
            this.addressSet.add(addr);
        }
        this.addressSet.remove(storedAddr);
        this.entryList.get(index).list.set(type, addr);
        this.normalized = false;
    }

    public void validate() throws GSException {
        if (!this.isAvailable() || this.entryList.isEmpty()) {
            throw new GSException(123504, "No available address found");
        }
        if (this.typeList.size() * this.entryList.size() != this.addressSet.size()) {
            throw new GSException(123504, "One or more addresses are not assigned");
        }
    }

    public void normalize() {
        this.completeInit();
        if (!this.normalized) {
            ServiceAddressResolver.normalizeEntries(this.entryList);
            this.normalized = true;
        }
    }

    private InetSocketAddress makeSocketAddress(String host, long port) throws GSException {
        InetAddress selectedAddr = null;
        try {
            Object[] candidates;
            for (InetAddress inetAddress : candidates = InetAddress.getAllByName(host)) {
                if (!this.config.ipv6Expected && inetAddress instanceof Inet4Address) {
                    selectedAddr = inetAddress;
                    continue;
                }
                if (!this.config.ipv6Expected || !(inetAddress instanceof Inet6Address)) continue;
                selectedAddr = inetAddress;
            }
            if (selectedAddr == null) {
                throw new GSException(123505, "Non suitable address can not be resolved (host=" + host + ", ipv6Expected=" + this.config.ipv6Expected + ", candidates=" + Arrays.toString(candidates) + ")");
            }
        }
        catch (UnknownHostException e) {
            throw new GSException(123505, (Throwable)e);
        }
        if (port < 0L || port >= 65536L) {
            throw new GSException(123505, "Port out of range (host=" + host + ", port=" + port + ")");
        }
        return new InetSocketAddress(selectedAddr, (int)port);
    }

    private void completeInit() {
        if (this.initialized) {
            return;
        }
        if (this.typeList.isEmpty() || this.typeList.size() != this.typeMap.size()) {
            throw new IllegalStateException();
        }
        this.initialized = true;
    }

    private void checkEntry(int index) {
        if (index >= this.entryList.size()) {
            throw new IllegalArgumentException();
        }
    }

    private void checkType(int type) {
        if (type >= this.typeList.size() || this.typeList.get(type).isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    private String getTypeName(int type) throws GSException {
        this.checkType(type);
        return this.typeList.get(type);
    }

    private void assign(Object value) throws GSException {
        Config config = new Config(this.config);
        config.providerURL = null;
        ServiceAddressResolver another = new ServiceAddressResolver(config);
        another.initializeType(this);
        List<Object> list = JsonUtils.asArray(value);
        for (int index = 0; index < list.size(); ++index) {
            for (int type = 0; type < this.typeList.size(); ++type) {
                String typeName = this.typeList.get(type);
                Map<String, Object> addrObj = JsonUtils.asObject(list.get(index), typeName);
                String host = JsonUtils.as(String.class, addrObj, "address");
                long port = JsonUtils.asLong(addrObj, "port");
                InetSocketAddress addr = this.makeSocketAddress(host, port);
                another.setAddress(index, type, addr);
            }
        }
        another.normalize();
        another.validate();
        this.changed = !this.isSameEntries(another);
        this.addressSet = another.addressSet;
        this.entryList = another.entryList;
        this.normalized = another.normalized;
    }

    private static boolean isSameEntries(List<Entry> list1, boolean normalized1, List<Entry> list2, boolean normalized2) {
        int size = list1.size();
        if (size != list2.size()) {
            return false;
        }
        if (!normalized1) {
            ArrayList<Entry> normalizedList = new ArrayList<Entry>(list1);
            ServiceAddressResolver.normalizeEntries(normalizedList);
            return ServiceAddressResolver.isSameEntries(normalizedList, true, list2, normalized2);
        }
        if (!normalized2) {
            ArrayList<Entry> normalizedList = new ArrayList<Entry>(list2);
            ServiceAddressResolver.normalizeEntries(normalizedList);
            return ServiceAddressResolver.isSameEntries(list1, normalized1, normalizedList, true);
        }
        for (int i = 0; i < size; ++i) {
            if (list1.get(i).compareTo(list2.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    private static void normalizeEntries(List<Entry> list) {
        Collections.sort(list);
    }

    public static InetAddress resolveAddress(String host, Boolean ipv6Expected, String key) throws GSException {
        if (host.isEmpty()) {
            throw new GSException(145001, "Empty host name or address specified" + (key == null ? "" : " (propertyName=" + key + ")"));
        }
        try {
            boolean found = false;
            for (InetAddress address : InetAddress.getAllByName(host)) {
                if (ipv6Expected == null || !(address instanceof Inet6Address ^ ipv6Expected)) {
                    return address;
                }
                found = true;
            }
            if (found) {
                throw new GSException(145002, "Address family unmatched (value=" + host + ", expectedFamily=" + (ipv6Expected != false ? "IPv6" : "IPv4") + (key == null ? "" : ", propertyName=" + key) + ")");
            }
        }
        catch (UnknownHostException e) {
            throw ServiceAddressResolver.errorOnUnknownHost(e, host, key);
        }
        throw ServiceAddressResolver.errorOnUnknownHost(null, host, key);
    }

    private static GSException errorOnUnknownHost(UnknownHostException e, String host, String key) {
        return new GSException(145002, "Address not resolved (value=" + host + (key == null ? "" : ", propertyName=" + key) + ")", e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SocketAddressComparator
    implements Comparator<InetSocketAddress> {
        @Override
        public int compare(InetSocketAddress o1, InetSocketAddress o2) {
            int comp = Integer.valueOf(SocketAddressComparator.getFamily(o1.getAddress())).compareTo(SocketAddressComparator.getFamily(o2.getAddress()));
            if (comp != 0) {
                return comp;
            }
            comp = SocketAddressComparator.compareBytes(o1.getAddress().getAddress(), o2.getAddress().getAddress());
            if (comp != 0) {
                return comp;
            }
            comp = o1.getPort() - o2.getPort();
            if (comp != 0) {
                return comp;
            }
            return 0;
        }

        private static int getFamily(InetAddress addr) {
            if (addr instanceof Inet4Address) {
                return 1;
            }
            if (addr instanceof Inet6Address) {
                return 2;
            }
            return 3;
        }

        private static int compareBytes(byte[] b1, byte[] b2) {
            int i = 0;
            while (i < b1.length && i < b2.length) {
                int comp = (b1[i] & 0xFF) - (b2[i] & 0xFF);
                if (comp != 0) {
                    return comp;
                }
                ++i;
            }
            return b1.length - b2.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry
    implements Comparable<Entry> {
        private final List<InetSocketAddress> list;
        private static final Comparator<InetSocketAddress> COMPARATOR = new SocketAddressComparator();

        public Entry(int typeCount) {
            this.list = new ArrayList<InetSocketAddress>(typeCount);
            for (int i = 0; i < typeCount; ++i) {
                this.list.add(null);
            }
        }

        @Override
        public int compareTo(Entry o) {
            int size = this.list.size();
            int comp = size - o.list.size();
            if (comp != 0) {
                return comp;
            }
            for (int i = 0; i < size; ++i) {
                int comp2 = COMPARATOR.compare(this.list.get(i), o.list.get(i));
                if (comp2 == 0) continue;
                return comp2;
            }
            return 0;
        }
    }

    public static class Config {
        private static final int DEFAULT_TIMEOUT_MILLIS = 60000;
        private URL providerURL;
        private boolean ipv6Expected;
        private int timeoutMillis = 60000;

        public Config() {
        }

        public Config(Config config) {
            this.providerURL = config.providerURL;
            this.ipv6Expected = config.ipv6Expected;
            this.timeoutMillis = config.timeoutMillis;
        }

        public URL getProviderURL() {
            return this.providerURL;
        }

        public void setProviderURL(String providerURL) throws GSException {
            if (providerURL == null) {
                this.providerURL = null;
                return;
            }
            try {
                this.providerURL = new URL(providerURL);
            }
            catch (MalformedURLException e) {
                if (providerURL.isEmpty()) {
                    throw new GSException(145001, "Empty provider URL");
                }
                throw new GSException(145002, "Failed to parse provider URL (url=" + providerURL + ", reason=" + e.getMessage() + ")", e);
            }
            String protocol = this.providerURL.getProtocol();
            if (!protocol.toLowerCase(Locale.US).equals("http")) {
                throw new GSException(123502, "Only HTTP is supported for provider URL (url=" + providerURL + ")");
            }
            if (this.providerURL.getHost().isEmpty()) {
                throw new GSException(123502, "No host specified in provider URL (url=" + providerURL + ")");
            }
        }

        public boolean isIPv6Expected() {
            return this.ipv6Expected;
        }

        public void setIPv6Expected(boolean ipv6Expected) {
            this.ipv6Expected = ipv6Expected;
        }

        public int getTimeoutMillis() {
            return this.timeoutMillis;
        }

        public void setTimeoutMillis(int timeoutMillis) {
            if (timeoutMillis <= 0) {
                this.timeoutMillis = 60000;
                return;
            }
            this.timeoutMillis = timeoutMillis;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ipv6Expected ? 1231 : 1237);
            result = 31 * result + (this.providerURL == null ? 0 : this.providerURL.hashCode());
            result = 31 * result + this.timeoutMillis;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Config other = (Config)obj;
            if (this.ipv6Expected != other.ipv6Expected) {
                return false;
            }
            if (this.providerURL == null ? other.providerURL != null : !this.providerURL.equals(other.providerURL)) {
                return false;
            }
            return this.timeoutMillis == other.timeoutMillis;
        }
    }
}

