/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.AggregationResult;
import com.toshiba.mwcloud.gs.ColumnInfo;
import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSType;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.NotNull;
import com.toshiba.mwcloud.gs.Nullable;
import com.toshiba.mwcloud.gs.QueryAnalysisEntry;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowField;
import com.toshiba.mwcloud.gs.RowKey;
import com.toshiba.mwcloud.gs.TimestampUtils;
import com.toshiba.mwcloud.gs.TransientRowField;
import com.toshiba.mwcloud.gs.common.AggregationResultImpl;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.BlobImpl;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GeometryUtils;
import com.toshiba.mwcloud.gs.common.InternPool;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowMapper {
    protected static boolean acceptAggregationResultColumnId = false;
    protected static boolean restrictKeyOrderFirst = true;
    private static final RowMapper AGGREGATION_RESULT_MAPPER;
    private static final byte[] EMPTY_LONG_BYTES;
    private static final int MAX_VAR_SIZE_LENGTH = 8;
    private static final GSType[] TYPE_CONSTANTS;
    private static final BlobFactory DIRECT_BLOB_FACTORY;
    private static final Pattern METHOD_PATTERN;
    private static final Cache CACHE;
    private static final byte ANY_NULL_TYPE = -1;
    private static final Map<Class<?>, GSType> ELEMENT_TYPE_MAP;
    private static final Map<GSType, Object> EMPTY_ELEMENT_VALUES;
    private static final Map<GSType, Object> EMPTY_ARRAY_VALUES;
    private static final Config BASIC_CONFIG;
    private static final Config GENERAL_CONFIG;
    private static final List<Integer> EMPTY_KEY_LIST;
    private static final List<Integer> SINGLE_FIRST_KEY_LIST;
    private final Class<?> rowType;
    private final transient Constructor<?> rowConstructor;
    private final transient Map<String, Entry> entryMap;
    private final List<Entry> entryList;
    private transient Entry keyEntry;
    private final boolean forTimeSeries;
    private final boolean nullableAllowed;
    private final transient int variableEntryCount;
    private transient Object[] emptyFieldArray;
    static final long VAR_SIZE_1BYTE_THRESHOLD = 128L;
    static final long VAR_SIZE_4BYTE_THRESHOLD = 0x40000000L;
    static final long VAR_SIZE_8BYTE_THRESHOLD = 0x4000000000000000L;

    private RowMapper(Class<?> rowType, Constructor<?> rowConstructor, Map<String, Entry> entryMap, List<Entry> entryList, Entry keyEntry, ContainerType containerType, boolean nullableAllowed) {
        this.rowType = rowType;
        this.rowConstructor = rowConstructor;
        this.entryMap = entryMap;
        this.entryList = entryList;
        this.keyEntry = keyEntry;
        this.forTimeSeries = containerType == ContainerType.TIME_SERIES;
        this.nullableAllowed = nullableAllowed;
        this.variableEntryCount = RowMapper.calculateVariableEntryCount(entryList);
    }

    private RowMapper(Class<?> rowType, ContainerType containerType, boolean nullableAllowed) throws GSException {
        this.rowType = rowType;
        this.entryMap = new HashMap<String, Entry>();
        this.entryList = new ArrayList<Entry>();
        this.forTimeSeries = containerType == ContainerType.TIME_SERIES;
        this.nullableAllowed = nullableAllowed;
        this.rowConstructor = RowMapper.getRowConstructor(rowType);
        HashSet<String> transientRowFields = new HashSet<String>();
        for (Field field : rowType.getDeclaredFields()) {
            this.accept(transientRowFields, field);
        }
        for (AccessibleObject accessibleObject : rowType.getDeclaredMethods()) {
            this.accept(transientRowFields, (Method)accessibleObject);
        }
        this.applyOrder(transientRowFields, restrictKeyOrderFirst);
        this.applyNullable(nullableAllowed);
        this.checkKeyType(this.forTimeSeries);
        this.variableEntryCount = RowMapper.calculateVariableEntryCount(this.entryList);
    }

    private RowMapper(ContainerType containerType, ContainerInfo containerInfo, boolean anyTypeAllowed, boolean nullableAllowed) throws GSException {
        ContainerType anotherContainerType = containerInfo.getType();
        if (anotherContainerType != null && anotherContainerType != containerType) {
            throw new GSException(145000, "Inconsistent container type");
        }
        this.rowType = Row.class;
        this.entryMap = new HashMap<String, Entry>();
        this.entryList = new ArrayList<Entry>();
        this.forTimeSeries = containerType == ContainerType.TIME_SERIES;
        this.nullableAllowed = nullableAllowed;
        this.rowConstructor = null;
        int columnCount = containerInfo.getColumnCount();
        if (columnCount <= 0 && !anyTypeAllowed) {
            throw new GSException(145023, "Empty schema");
        }
        boolean rowKeyAssigned = containerInfo.isRowKeyAssigned();
        for (int i = 0; i < columnCount; ++i) {
            this.accept(containerInfo.getColumnInfo(i), i == 0 && rowKeyAssigned, anyTypeAllowed, nullableAllowed);
        }
        this.checkKeyType(this.forTimeSeries);
        this.variableEntryCount = RowMapper.calculateVariableEntryCount(this.entryList);
    }

    private static int calculateVariableEntryCount(List<Entry> entryList) {
        int count = 0;
        for (Entry entry : entryList) {
            if (!RowMapper.hasVarDataPart(entry.elementType, entry.arrayUsed)) continue;
            ++count;
        }
        return count;
    }

    public static RowMapper getInstance(Class<?> rowType, ContainerType containerType, Config config) throws GSException {
        if (rowType == AggregationResult.class) {
            throw new GSException(145002, "Illegal row type");
        }
        return CACHE.getInstance(rowType, containerType, config);
    }

    public static RowMapper getInstance(ContainerType containerType, ContainerInfo containerInfo, Config config) throws GSException {
        return CACHE.intern(new RowMapper(containerType, containerInfo, config.anyTypeAllowed, config.nullableAllowed));
    }

    public static RowMapper getInstance(Row row, Config config) throws GSException {
        if (row instanceof ArrayRow) {
            return ((ArrayRow)row).mapper;
        }
        return RowMapper.getInstance(null, row.getSchema(), config);
    }

    public static RowMapper getAggregationResultMapper() {
        return AGGREGATION_RESULT_MAPPER;
    }

    public static RowMapper getInstance(BasicBuffer in, ContainerType containerType, Config config) throws GSException {
        int columnCount = RowMapper.importColumnCount(in);
        List<Integer> keyList = RowMapper.importKeyListBegin(in, config, columnCount);
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
        for (int i = 0; i < columnCount; ++i) {
            columnInfoList.add(RowMapper.importColumnSchema(in, config));
        }
        return RowMapper.getInstance(containerType, new ContainerInfo(null, containerType, columnInfoList, !(keyList = RowMapper.importKeyListEnd(in, config, columnCount, keyList)).isEmpty()), config);
    }

    public void checkSchemaMatched(RowMapper mapper) throws GSException {
        if (this == mapper) {
            return;
        }
        if (this.rowType == AggregationResult.class || mapper.rowType == AggregationResult.class) {
            throw new IllegalArgumentException();
        }
        if (this.entryList.size() != mapper.entryList.size()) {
            throw new GSException(145023, "");
        }
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry thisEntry = this.entryList.get(i);
            Entry entry = mapper.entryList.get(i);
            if (thisEntry.keyType ^ entry.keyType) {
                throw new GSException(145023, "");
            }
            if (thisEntry.elementType != entry.elementType) {
                throw new GSException(145023, "");
            }
            if (thisEntry.arrayUsed ^ entry.arrayUsed) {
                throw new GSException(145023, "");
            }
            if (thisEntry.columnName.equals(entry.columnName) || RowMapper.normalizeSymbolUnchecked(thisEntry.columnName).equals(RowMapper.normalizeSymbolUnchecked(entry.columnName))) continue;
            throw new GSException(145023, "");
        }
    }

    public RowMapper reorderBySchema(BasicBuffer in, Config config, boolean columnOrderIgnorable) throws GSException {
        Entry newKeyEntry;
        int i;
        int size = RowMapper.importColumnCount(in);
        if (size != this.entryList.size()) {
            throw new GSException(145023, "Inconsistent remote schema (column count)");
        }
        List<Integer> keyList = RowMapper.importKeyListBegin(in, config, size);
        HashMap<String, Entry> newEntryMap = new HashMap<String, Entry>();
        ArrayList<Entry> newEntryList = new ArrayList<Entry>(size);
        for (i = 0; i < size; ++i) {
            newEntryList.add(null);
        }
        for (i = 0; i < size; ++i) {
            Entry newEntry = new Entry(null);
            newEntry.importColumnSchema(in, i, this.nullableAllowed);
            String normalizedName = RowMapper.normalizeSymbolUnchecked(newEntry.columnName);
            Entry orgEntry = this.entryMap.get(normalizedName);
            if (orgEntry == null) {
                throw new GSException(145023, "Inconsistent remote schema (column not found)");
            }
            newEntry.importObjectMapping(orgEntry, columnOrderIgnorable);
            if (newEntryList.get(i) != null) {
                throw new GSException(145023, "Inconsistent remote schema (duplicate column)");
            }
            newEntryList.set(i, newEntry);
            newEntryMap.put(normalizedName, newEntry);
        }
        keyList = RowMapper.importKeyListEnd(in, config, size, keyList);
        if (this.keyEntry == null) {
            if (!keyList.isEmpty()) {
                throw new GSException(145023, "Remote schema must not have a key");
            }
            newKeyEntry = null;
        } else {
            if (keyList.isEmpty()) {
                throw new GSException(145023, "Remote schema must have a key");
            }
            newKeyEntry = (Entry)newEntryList.get(keyList.get(0));
            String normalizedName = RowMapper.normalizeSymbolUnchecked(this.keyEntry.columnName);
            if (!normalizedName.equals(RowMapper.normalizeSymbolUnchecked(newKeyEntry.columnName))) {
                throw new GSException(145023, "Inconsistent remote schema (column name)");
            }
            newKeyEntry.keyType = true;
        }
        return CACHE.intern(new RowMapper(this.rowType, this.rowConstructor, newEntryMap, newEntryList, newKeyEntry, this.getContainerType(), this.nullableAllowed));
    }

    public static int importColumnCount(BasicBuffer in) throws GSException {
        return BasicBuffer.BufferUtils.getNonNegativeInt(in.base());
    }

    public static void exportColumnCount(BasicBuffer out, int columnCount) throws GSException {
        out.putInt(columnCount);
    }

    public static List<Integer> importKeyListBegin(BasicBuffer in, Config config, int columnCount) throws GSException {
        if (!config.keyExtensible) {
            int columnId = in.base().getInt();
            if (columnId != 0 && columnId != -1 || columnId >= columnCount) {
                throw new GSConnectionException(145031, "Protocol error by illegal index of row key column (keyColumn=" + columnId + ")");
            }
            return RowMapper.toKeyList(columnId >= 0);
        }
        return null;
    }

    public static List<Integer> importKeyListEnd(BasicBuffer in, Config config, int columnCount, List<Integer> lastKeyList) throws GSException {
        if (config.keyExtensible) {
            int count = in.base().getShort();
            if (count != 0 && count != 1) {
                throw new GSConnectionException(145031, "Protocol error by illegal row key count (count=" + count + ")");
            }
            for (int i = 0; i < count; ++i) {
                short columnId = in.base().getShort();
                if (columnId == 0 && columnId < columnCount) continue;
                throw new GSConnectionException(145031, "Protocol error by illegal index of row key column (keyColumn=" + columnId + ")");
            }
            return RowMapper.toKeyList(count > 0);
        }
        return lastKeyList;
    }

    public static void exportKeyListBegin(BasicBuffer out, Config config, List<Integer> keyList) throws GSException {
        if (!config.keyExtensible) {
            out.putInt(keyList.isEmpty() ? -1 : 0);
        }
    }

    public static void exportKeyListEnd(BasicBuffer out, Config config, List<Integer> keyList) throws GSException {
        if (config.keyExtensible) {
            int count = keyList.size();
            if (count > 1) {
                throw new GSException(145000, "");
            }
            out.putShort((short)count);
            for (int keyIndex : keyList) {
                if (keyIndex != 0) {
                    throw new GSException(145000, "");
                }
                out.putShort((short)keyIndex);
            }
        }
    }

    public static ColumnInfo importColumnSchema(BasicBuffer in, Config config) throws GSException {
        Entry entry = new Entry(null);
        entry.importColumnSchema(in, -1, config.nullableAllowed);
        entry.filterNullable(entry.columnNullable, null, config.nullableAllowed);
        if (config.anyTypeAllowed && entry.columnName.isEmpty()) {
            entry.columnName = null;
        }
        return entry.getColumnInfo();
    }

    public static List<Integer> toKeyList(boolean rowKeyAssigned) {
        return rowKeyAssigned ? SINGLE_FIRST_KEY_LIST : EMPTY_KEY_LIST;
    }

    public RowMapper applyResultType(Class<?> rowType) throws GSException {
        if (this.getRowType() == rowType) {
            return this;
        }
        if (rowType == AggregationResult.class) {
            return AGGREGATION_RESULT_MAPPER;
        }
        if (rowType == QueryAnalysisEntry.class) {
            return RowMapper.getInstance(QueryAnalysisEntry.class, null, BASIC_CONFIG);
        }
        if (rowType == null) {
            return null;
        }
        throw new GSException(145002, "Unsupported result type");
    }

    public boolean hasKey() {
        return this.keyEntry != null;
    }

    public Class<?> getRowType() {
        return this.rowType;
    }

    public boolean isForTimeSeries() {
        return this.forTimeSeries;
    }

    public GSType getFieldElementType(int columnId) {
        return this.entryList.get((int)columnId).elementType;
    }

    public boolean isArray(int columnId) {
        return this.entryList.get((int)columnId).arrayUsed;
    }

    public boolean hasAnyTypeColumn() {
        for (Entry entry : this.entryList) {
            if (entry.elementType != null) continue;
            return true;
        }
        return false;
    }

    private int getVariableEntryCount() {
        return this.variableEntryCount;
    }

    public ContainerType getContainerType() {
        if (this.rowType == AggregationResult.class) {
            return null;
        }
        if (this.forTimeSeries) {
            return ContainerType.TIME_SERIES;
        }
        return ContainerType.COLLECTION;
    }

    public ContainerInfo getContainerInfo() {
        if (this.rowType == AggregationResult.class) {
            return null;
        }
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>(this.entryList.size());
        for (Entry entry : this.entryList) {
            columnInfoList.add(entry.getColumnInfo());
        }
        return new ContainerInfo(null, null, columnInfoList, this.hasKey());
    }

    public void exportSchema(BasicBuffer out, Config config) throws GSException {
        if (this.rowType == AggregationResult.class) {
            throw new GSException(145000, "Unexpected row type: AggregationResult");
        }
        List<Integer> keyList = RowMapper.toKeyList(this.keyEntry != null);
        RowMapper.exportColumnCount(out, this.entryList.size());
        RowMapper.exportKeyListBegin(out, config, keyList);
        for (Entry entry : this.entryList) {
            entry.exportColumnSchema(out);
        }
        RowMapper.exportKeyListEnd(out, config, keyList);
    }

    public int resolveColumnId(String name) throws GSException {
        Entry entry = this.entryMap.get(RowMapper.normalizeSymbol(name, "column name"));
        if (entry == null) {
            throw new GSException(145008, "Unknown column: \"" + name + "\"");
        }
        return entry.order;
    }

    public Object resolveField(Object rowObj, int column) throws GSException {
        return this.entryList.get(column).getFieldObj(rowObj, this.isGeneral());
    }

    public Object resolveKey(Object keyObj, Object rowObj) throws GSException {
        return this.resolveKey(keyObj, rowObj, this.isGeneral());
    }

    public Object resolveKey(Object keyObj, Object rowObj, boolean general) throws GSException {
        if (keyObj != null) {
            return keyObj;
        }
        if (this.keyEntry == null) {
            throw new GSException(145024, "Row key does not exist");
        }
        return this.keyEntry.getFieldObj(rowObj, general);
    }

    public Object resolveKey(String keyString) throws GSException {
        if (this.keyEntry == null) {
            throw new GSException(145024, "Row key does not exist");
        }
        if (this.keyEntry.arrayUsed) {
            throw new GSException(145009, "Unsupported key type");
        }
        try {
            switch (this.keyEntry.elementType) {
                case STRING: {
                    return keyString;
                }
                case INTEGER: {
                    return Integer.parseInt(keyString);
                }
                case LONG: {
                    return Long.parseLong(keyString);
                }
                case TIMESTAMP: {
                    return TimestampUtils.getFormat().parse(keyString);
                }
            }
            throw new GSException(145009, "Unsupported key type");
        }
        catch (NumberFormatException e) {
            throw new GSException(145006, (Throwable)e);
        }
        catch (ParseException e) {
            throw new GSException(145006, (Throwable)e);
        }
    }

    public Row createGeneralRow() throws GSException {
        return ArrayRow.create(this, false);
    }

    public Object createRow(boolean general) throws GSException {
        if (general || this.isGeneral()) {
            return this.createGeneralRow();
        }
        try {
            return this.rowConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new GSException(145000, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new GSException(145000, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new GSException(e);
        }
    }

    public void encodeKey(BasicBuffer buffer, Object keyObj, MappingMode mode) throws GSException {
        if (this.keyEntry == null) {
            throw new GSException(145024, "Row key does not exist");
        }
        if (this.keyEntry.arrayUsed) {
            throw new GSException(145009, "Unsupported key type");
        }
        RowMapper.encodeKey(buffer, keyObj, this.keyEntry.elementType, mode);
    }

    public static void encodeKey(BasicBuffer buffer, Object keyObj, GSType type, MappingMode mode) throws GSException {
        switch (type) {
            case STRING: {
                RowMapper.putString(buffer, (String)keyObj, mode == MappingMode.ROWWISE_SEPARATED_V2);
                break;
            }
            case INTEGER: {
                buffer.putInt((Integer)keyObj);
                break;
            }
            case LONG: {
                buffer.putLong((Long)keyObj);
                break;
            }
            case TIMESTAMP: {
                buffer.putDate((Date)keyObj);
                break;
            }
            default: {
                throw new GSException(145009, "Unsupported key type");
            }
        }
    }

    public Cursor createCursor(BasicBuffer buffer, MappingMode mode, int rowCount, boolean rowIdIncluded, BlobFactory blobFactory) {
        return new Cursor(buffer, mode, rowCount, rowIdIncluded, blobFactory);
    }

    public void encode(BasicBuffer buffer, MappingMode mode, Object keyObj, Object rowObj) throws GSException {
        Cursor cursor = new Cursor(buffer, mode, 1, false, null);
        this.encode(cursor, keyObj, rowObj, this.isGeneral());
    }

    public Object decode(BasicBuffer buffer, MappingMode mode, BlobFactory blobFactory) throws GSException {
        Cursor cursor = new Cursor(buffer, mode, 1, false, blobFactory);
        return this.decode(cursor, this.isGeneral());
    }

    public void encode(Cursor cursor, Object keyObj, Object rowObj) throws GSException {
        this.encode(cursor, keyObj, rowObj, this.isGeneral());
    }

    public Object decode(Cursor cursor) throws GSException {
        return this.decode(cursor, this.isGeneral());
    }

    public void encode(Cursor cursor, Object keyObj, Object rowObj, boolean general) throws GSException {
        if (this.rowType == AggregationResult.class) {
            throw new GSException(145000, "Unexpected row type: AggregationResult");
        }
        if (!this.rowType.isInstance(rowObj)) {
            if (rowObj == null) {
                throw new NullPointerException("The row object is null");
            }
            if (!general) {
                throw new ClassCastException("Inconsistent row type");
            }
        }
        if (keyObj != null && this.keyEntry == null) {
            throw new GSException(145025, "Key must not be specified");
        }
        if (this.rowType == Row.class || general) {
            RowMapper.getInstance((Row)rowObj, GENERAL_CONFIG).checkSchemaMatched(this);
        }
        cursor.beginRowOutput();
        if (cursor.getMode() == MappingMode.AGGREGATED) {
            throw new IllegalArgumentException();
        }
        for (Entry entry : this.entryList) {
            entry.encode(cursor, keyObj, rowObj, general);
        }
        cursor.endRowOutput();
    }

    public Object decode(Cursor cursor, boolean general) throws GSException {
        Object rowObj = general ? ArrayRow.createUninitialized(this) : this.createRow(false);
        cursor.decode(general, rowObj);
        return rowObj;
    }

    public void extractSubRowSetAndCount(Cursor cursor, int rowOffset, int rowLimit, BasicBuffer out, boolean includeVarDataOffset) throws GSException {
        if (cursor.getMode() != MappingMode.ROWWISE_SEPARATED && cursor.getMode() != MappingMode.ROWWISE_SEPARATED_V2) {
            throw new IllegalArgumentException();
        }
        if (rowOffset < 0 || rowLimit <= 0 || rowOffset >= cursor.rowCount) {
            return;
        }
        int extractingCount = Math.min(cursor.rowCount - rowOffset, rowLimit);
        BasicBuffer in = cursor.buffer;
        cursor.skipRowInput(rowOffset);
        int fixedOffset = in.base().position();
        int fixedLength = this.getFixedRowPartSize(cursor.rowIdIncluded, cursor.mode) * extractingCount;
        int varOffset = this.scanVarDataStartOffset(cursor);
        cursor.skipRowInput(extractingCount - 2);
        int varLength = this.scanVarDataEndOffset(cursor) - varOffset;
        cursor.skipRowInput(-(cursor.rowIndex + 1));
        if (includeVarDataOffset) {
            out.putLong(varOffset);
        }
        out.putLong(extractingCount);
        in.base().limit(fixedOffset + fixedLength);
        in.base().position(fixedOffset);
        out.prepare(fixedLength);
        out.base().put(in.base());
        in.base().limit(cursor.varDataTop + varOffset + varLength);
        in.base().position(cursor.varDataTop + varOffset);
        out.prepare(varLength);
        out.base().put(in.base());
        in.base().position(cursor.topPos);
    }

    private int scanVarDataStartOffset(Cursor cursor) throws GSException {
        BasicBuffer in = cursor.buffer;
        if (cursor.mode == MappingMode.ROWWISE_SEPARATED_V2) {
            int orgPos = in.base().position();
            if (cursor.isRowIdIncluded()) {
                in.base().getLong();
            }
            int startOffset = this.getVariableEntryCount() > 0 ? (int)in.base().getLong() : 0;
            in.base().position(orgPos);
            cursor.beginRowInput();
            for (int i = 0; i < this.entryList.size(); ++i) {
                in.base().position(in.base().position() + this.getFixedFieldPartSize(i, cursor.mode));
            }
            cursor.endRowInput();
            return startOffset;
        }
        int startOffset = Integer.MAX_VALUE;
        cursor.beginRowInput();
        for (Entry entry : this.entryList) {
            cursor.beginField();
            if (RowMapper.hasVarDataPart(entry.elementType, entry.arrayUsed)) {
                startOffset = Math.min(startOffset, (int)in.base().getLong());
                continue;
            }
            in.base().position(in.base().position() + this.getFixedFieldPartSize(entry.order, cursor.getMode()));
        }
        cursor.endRowInput();
        if (startOffset == Integer.MAX_VALUE) {
            startOffset = 0;
        }
        return startOffset;
    }

    private int scanVarDataEndOffset(Cursor cursor) throws GSException {
        BasicBuffer in = cursor.buffer;
        if (cursor.mode == MappingMode.ROWWISE_SEPARATED_V2) {
            int endOffset;
            cursor.beginRowInput();
            for (int i = 0; i < this.entryList.size(); ++i) {
                in.base().position(in.base().position() + this.getFixedFieldPartSize(i, cursor.mode));
            }
            cursor.endRowInput();
            if (cursor.hasNext()) {
                int orgPos = in.base().position();
                if (cursor.isRowIdIncluded()) {
                    in.base().getLong();
                }
                endOffset = this.getVariableEntryCount() > 0 ? (int)in.base().getLong() : 0;
                in.base().position(orgPos);
            } else {
                endOffset = in.base().limit() - cursor.varDataTop;
            }
            return endOffset;
        }
        int endOffset = 0;
        cursor.beginRowInput();
        for (Entry entry : this.entryList) {
            cursor.beginField();
            if (RowMapper.hasVarDataPart(entry.elementType, entry.arrayUsed)) {
                int offset = (int)(in.base().getLong() - cursor.varDataBaseOffset);
                int orgPos = in.base().position();
                in.base().position(cursor.varDataTop + offset);
                int size = in.base().getInt() + 4;
                endOffset = Math.max(endOffset, offset + size);
                in.base().position(orgPos);
                continue;
            }
            in.base().position(in.base().position() + this.getFixedFieldPartSize(entry.order, cursor.getMode()));
        }
        cursor.endRowInput();
        return endOffset;
    }

    private boolean isGeneral() {
        return this.rowType == Row.class;
    }

    private static Constructor<?> getRowConstructor(Class<?> rowType) throws GSException {
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : rowType.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null) {
            throw new GSException(145002, "Default constructor not found or specified class is non-static");
        }
        defaultConstructor.setAccessible(true);
        return defaultConstructor;
    }

    private void accept(Set<String> transientRowFields, Field field) throws GSException {
        int modifier = field.getModifiers();
        if (Modifier.isFinal(modifier) || Modifier.isPrivate(modifier) || Modifier.isStatic(modifier) || Modifier.isTransient(modifier)) {
            return;
        }
        RowField rowField = field.getAnnotation(RowField.class);
        String orgName = rowField == null || rowField.name().isEmpty() ? field.getName() : rowField.name();
        String name = RowMapper.normalizeSymbol(orgName, "field name of row class");
        if (field.getAnnotation(TransientRowField.class) != null) {
            transientRowFields.add(name);
            return;
        }
        if (RowMapper.resolveElementType(field.getType(), false, false) == null) {
            return;
        }
        Entry entry = this.putEntry(orgName, rowField);
        if (entry.rowTypeField != null) {
            throw new GSException("Duplicate field name (" + name + ")");
        }
        entry.rowTypeField = field;
        entry.nameByField = orgName;
        entry.applyAccessibleObject(field);
        entry.setObjectType(field.getType());
        this.acceptKeyEntry(entry);
    }

    private void accept(Set<String> transientRowFields, Method method) throws GSException {
        boolean forGetter;
        Class<Object> objectType;
        int modifier = method.getModifiers();
        if (Modifier.isPrivate(modifier) || Modifier.isStatic(modifier)) {
            return;
        }
        RowField rowField = method.getAnnotation(RowField.class);
        Matcher matcher = METHOD_PATTERN.matcher(method.getName());
        if (!matcher.find()) {
            return;
        }
        String orgName = rowField == null || rowField.name().isEmpty() ? matcher.group(5) : rowField.name();
        String name = RowMapper.normalizeSymbol(orgName, "method name of row class");
        if (method.getAnnotation(TransientRowField.class) != null) {
            transientRowFields.add(name);
            return;
        }
        if (matcher.group(2) != null) {
            if (method.getParameterTypes().length != 0) {
                return;
            }
            objectType = method.getReturnType();
            forGetter = true;
        } else if (matcher.group(3) != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                return;
            }
            objectType = parameterTypes[0];
            forGetter = false;
        } else {
            if (method.getParameterTypes().length != 0 || method.getReturnType() != Boolean.TYPE) {
                return;
            }
            objectType = Boolean.TYPE;
            forGetter = true;
        }
        if (RowMapper.resolveElementType(objectType, false, false) == null) {
            return;
        }
        Entry entry = this.putEntry(orgName, rowField);
        if (forGetter) {
            if (entry.getterMethod != null) {
                throw new GSException("Duplicate getter name (" + name + ")");
            }
            entry.getterMethod = method;
            entry.nameByGetter = orgName;
        } else {
            if (entry.setterMethod != null) {
                throw new GSException("Duplicate setter name (" + name + ")");
            }
            entry.setterMethod = method;
        }
        entry.applyAccessibleObject(method);
        entry.setObjectType(objectType);
        this.acceptKeyEntry(entry);
    }

    private void accept(ColumnInfo columnInfo, boolean keyType, boolean anyTypeAllowed, boolean nullableAllowed) throws GSException {
        String normalizedName;
        String orgName = columnInfo.getName();
        String string = normalizedName = orgName == null ? null : RowMapper.normalizeSymbolUnchecked(orgName);
        if (!anyTypeAllowed || orgName != null) {
            RowMapper.checkSymbol(orgName, "column name");
        }
        if (this.entryMap.containsKey(normalizedName)) {
            throw new GSException("Duplicate column name (" + orgName + ")");
        }
        Entry entry = new Entry(orgName);
        GSType type = columnInfo.getType();
        if (!anyTypeAllowed || type != null) {
            entry.elementType = RowMapper.toArrayElementType(type);
            if (entry.elementType == null) {
                entry.elementType = columnInfo.getType();
            } else {
                entry.arrayUsed = true;
            }
        }
        entry.order = this.entryList.size();
        entry.keyType = keyType;
        entry.setNullableGeneral(columnInfo.getNullable(), nullableAllowed);
        if (normalizedName != null) {
            this.entryMap.put(normalizedName, entry);
        }
        this.entryList.add(entry);
        if (keyType) {
            this.keyEntry = entry;
        }
    }

    private Entry putEntry(String name, RowField rowField) throws GSException {
        int order;
        Entry entry = this.entryMap.get(RowMapper.normalizeSymbolUnchecked(name));
        if (entry == null) {
            entry = new Entry(name);
            this.entryMap.put(RowMapper.normalizeSymbolUnchecked(name), entry);
            this.entryList.add(entry);
        }
        if (rowField != null && (order = rowField.columnNumber()) >= 0) {
            if (entry.order >= 0) {
                if (entry.order != order) {
                    throw new GSException("Illegal column number");
                }
            } else {
                entry.order = order;
                entry.orderSpecified = true;
            }
        }
        return entry;
    }

    private void acceptKeyEntry(Entry entry) throws GSException {
        if (entry.keyType) {
            if (this.keyEntry != null && this.keyEntry != entry) {
                throw new GSException(145021, "Multiple keys found");
            }
            this.keyEntry = entry;
        }
    }

    private void applyOrder(Set<String> transientRowFields, boolean keyFirst) throws GSException {
        boolean specified = false;
        Iterator<Entry> i = this.entryList.iterator();
        while (i.hasNext()) {
            Entry entry = i.next();
            String string = RowMapper.normalizeSymbolUnchecked(entry.columnName);
            if (!entry.reduceByAccessors() || transientRowFields.contains(string)) {
                this.entryMap.remove(string);
                i.remove();
            }
            specified |= entry.orderSpecified;
        }
        if (this.entryList.isEmpty()) {
            throw new GSException(145023, "Empty schema");
        }
        if (!(specified || keyFirst && !this.entryList.get((int)0).keyType)) {
            int order = 0;
            for (Entry entry : this.entryList) {
                entry.order = order++;
            }
            return;
        }
        ArrayList<Entry> orgList = new ArrayList<Entry>(this.entryList);
        Collections.fill(this.entryList, null);
        int rest = orgList.size();
        for (Entry entry : orgList) {
            int order = entry.order;
            if (order < 0) continue;
            if (order >= orgList.size() || this.entryList.get(order) != null) {
                throw new GSException("Illegal order");
            }
            this.entryList.set(order, entry);
            --rest;
        }
        if (rest > 0) {
            ListIterator<Entry> listIterator = this.entryList.listIterator();
            boolean keyConsumed = false;
            if (keyFirst && this.keyEntry != null) {
                if (this.keyEntry.order > 0) {
                    throw new GSException("Key must be first column");
                }
                while (listIterator.next() != null) {
                }
                this.keyEntry.order = listIterator.previousIndex();
                listIterator.set(this.keyEntry);
                --rest;
                keyConsumed = true;
            }
            for (Entry entry : orgList) {
                if (entry == this.keyEntry && keyConsumed || entry.order >= 0) continue;
                while (listIterator.next() != null) {
                }
                entry.order = listIterator.previousIndex();
                listIterator.set(entry);
                if (--rest != 0) continue;
                break;
            }
        }
        if (rest != 0) {
            throw new Error();
        }
        if (this.keyEntry != null && keyFirst && !this.entryList.get((int)0).keyType) {
            throw new GSException("Key must be first column");
        }
    }

    private void applyNullable(boolean nullableAllowed) throws GSException {
        Package target;
        Boolean nullableDefault = null;
        for (Class<?> type = this.rowType; type != null && (nullableDefault = Entry.findNullableFromAccessor(type, null, null, null)) == null; type = type.getEnclosingClass()) {
        }
        if (nullableDefault == null && (target = this.rowType.getPackage()) != null) {
            nullableDefault = Entry.findNullableFromAccessor(target, null, null, null);
        }
        for (Entry entry : this.entryList) {
            entry.setNullableByAccessors(nullableDefault, nullableAllowed);
        }
    }

    private void checkKeyType(boolean forTimeSeries) throws GSException {
        if (this.keyEntry == null) {
            if (forTimeSeries) {
                throw new GSException("Key must be required for time series");
            }
            return;
        }
        if (this.keyEntry.arrayUsed) {
            throw new GSException(145009, "Key type must not be array");
        }
        if (forTimeSeries) {
            if (this.keyEntry.elementType != GSType.TIMESTAMP) {
                throw new GSException(145009, "Illegal key type for time series: " + (Object)((Object)this.keyEntry.elementType));
            }
        } else {
            if (this.keyEntry.elementType == null) {
                throw new GSException(145009, "Key must not be any type");
            }
            switch (this.keyEntry.elementType) {
                case STRING: 
                case INTEGER: 
                case LONG: 
                case TIMESTAMP: {
                    break;
                }
                default: {
                    throw new GSException(145009, "Illegal key type for collection: " + (Object)((Object)this.keyEntry.elementType));
                }
            }
        }
    }

    private void decodeAggregation(Cursor cursor, boolean general, Object rowObj) throws GSException {
        if (this.rowType == AggregationResult.class) {
            Object value;
            if (cursor.isRowIdIncluded()) {
                throw new GSException(145011, "Illegal result type");
            }
            cursor.beginRowInput();
            BasicBuffer in = cursor.getBuffer();
            if (acceptAggregationResultColumnId) {
                in.base().getInt();
            }
            GSType type = (GSType)in.getByteEnum(TYPE_CONSTANTS);
            Object orgValue = RowMapper.getField(cursor, type, false);
            switch (type) {
                case BYTE: {
                    value = (long)((Byte)orgValue).byteValue();
                    break;
                }
                case SHORT: {
                    value = (long)((Short)orgValue).shortValue();
                    break;
                }
                case INTEGER: {
                    value = (long)((Integer)orgValue).intValue();
                    break;
                }
                case LONG: {
                    value = orgValue;
                    break;
                }
                case FLOAT: {
                    value = (double)((Float)orgValue).floatValue();
                    break;
                }
                case DOUBLE: {
                    value = orgValue;
                    break;
                }
                case TIMESTAMP: {
                    value = orgValue;
                    break;
                }
                default: {
                    throw new GSException(145010, "Unsupported aggregation result type");
                }
            }
            try {
                ((AggregationResultImpl)rowObj).setValue(value);
            }
            catch (ClassCastException e) {
                throw new GSException(145000, "Internal error by inconsistent aggregation result type", e);
            }
            return;
        }
        if (!acceptAggregationResultColumnId) {
            throw new GSException(145011, "");
        }
        cursor.beginRowInput();
        BasicBuffer in = cursor.getBuffer();
        int column = in.base().getInt();
        GSType type = (GSType)in.getByteEnum(TYPE_CONSTANTS);
        if (column < 0 || column >= this.entryList.size()) {
            if (column == -1) {
                throw new GSException(145011, "Unable to map non columnwise aggregation (ex. COUNT())");
            }
            throw new GSException(145011, "Illegal column ID");
        }
        Entry entry = this.entryList.get(column);
        if (type == entry.elementType) {
            entry.decode(cursor, rowObj, general);
        } else {
            Number fieldObj;
            Object orgValue = RowMapper.getField(cursor, type, false);
            if (!(orgValue instanceof Long) && !(orgValue instanceof Double)) {
                throw new GSException(145011, "Unacceptable result type");
            }
            switch (entry.elementType) {
                case BYTE: {
                    fieldObj = (byte)(orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue);
                    break;
                }
                case SHORT: {
                    fieldObj = (short)(orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue);
                    break;
                }
                case INTEGER: {
                    fieldObj = (int)(orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue);
                    break;
                }
                case LONG: {
                    fieldObj = (long)(orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue);
                    break;
                }
                case FLOAT: {
                    fieldObj = Float.valueOf((float)(orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue));
                    break;
                }
                case DOUBLE: {
                    fieldObj = orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue;
                    break;
                }
                default: {
                    throw new GSException(145010, "Unacceptable result type");
                }
            }
            entry.setFieldObj(rowObj, fieldObj, general);
        }
        cursor.endRowInput();
    }

    private int getNullsByteSize(int fieldNum) {
        return (fieldNum + 7) / 8;
    }

    private int getFixedRowPartSize(boolean rowIdIncluded, MappingMode mode) {
        int size;
        int n = size = rowIdIncluded ? 8 : 0;
        if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
            size += this.getNullsByteSize(this.entryList.size());
        }
        boolean hasVarDataPart = false;
        for (Entry entry : this.entryList) {
            size += RowMapper.getFixedEncodedSize(entry.elementType, entry.arrayUsed, mode);
            if (hasVarDataPart || !RowMapper.hasVarDataPart(entry.elementType, entry.arrayUsed)) continue;
            hasVarDataPart = true;
        }
        if (mode == MappingMode.ROWWISE_SEPARATED_V2 && hasVarDataPart) {
            size += 8;
        }
        return size;
    }

    private int getFixedFieldPartSize(int columnId, MappingMode mode) {
        Entry entry = this.entryList.get(columnId);
        return RowMapper.getFixedEncodedSize(entry.elementType, entry.arrayUsed, mode);
    }

    private int getColumnCount() {
        return this.entryList.size();
    }

    private Entry getEntry(int index) {
        return this.entryList.get(index);
    }

    private void getAllInitialValue(boolean nullable, Object[] dest) {
        Object[] target = this.emptyFieldArray;
        if (target == null || nullable) {
            int count = this.getColumnCount();
            target = nullable ? dest : new Object[count];
            for (int i = 0; i < count; ++i) {
                target[i] = this.getEntry(i).getInitialObj(nullable, true);
            }
            if (nullable) {
                return;
            }
            this.emptyFieldArray = target;
        }
        System.arraycopy(target, 0, dest, 0, target.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entryList == null ? 0 : this.entryList.hashCode());
        result = 31 * result + (this.forTimeSeries ? 1231 : 1237);
        result = 31 * result + (this.nullableAllowed ? 1231 : 1237);
        result = 31 * result + (this.rowType == null ? 0 : this.rowType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RowMapper other = (RowMapper)obj;
        if (this.entryList == null ? other.entryList != null : !this.entryList.equals(other.entryList)) {
            return false;
        }
        if (this.forTimeSeries != other.forTimeSeries) {
            return false;
        }
        if (this.nullableAllowed != other.nullableAllowed) {
            return false;
        }
        return !(this.rowType == null ? other.rowType != null : !this.rowType.equals(other.rowType));
    }

    private static GSType resolveElementType(Class<?> objectType, boolean subClassAllowed, boolean validating) throws GSException {
        Class<?> objectElementType;
        block11: {
            GSType elementType;
            block12: {
                block10: {
                    objectElementType = objectType.isArray() ? objectType.getComponentType() : objectType;
                    elementType = ELEMENT_TYPE_MAP.get(objectElementType);
                    if (elementType != null) break block10;
                    if (Date.class.isAssignableFrom(objectElementType)) {
                        return GSType.TIMESTAMP;
                    }
                    if (Geometry.class.isAssignableFrom(objectElementType)) {
                        return GSType.GEOMETRY;
                    }
                    if (Blob.class.isAssignableFrom(objectElementType)) {
                        return GSType.BLOB;
                    }
                    break block11;
                }
                if (!objectType.isArray()) break block12;
                if (objectElementType.isPrimitive()) {
                    return elementType;
                }
                switch (elementType) {
                    case STRING: 
                    case TIMESTAMP: {
                        return elementType;
                    }
                    case GEOMETRY: 
                    case BLOB: {
                        if (!validating) {
                            return elementType;
                        } else {
                            break;
                        }
                    }
                }
                break block11;
            }
            return elementType;
        }
        if (validating) {
            throw new GSException(145010, "Unsupported field type (className=" + objectType.getName() + ", elementClassName=" + objectElementType.getName() + ", arrayType=" + objectType.isArray() + ")");
        }
        return null;
    }

    private static Map<Class<?>, GSType> createElementTypeMap() {
        HashMap map = new HashMap();
        map.put(String.class, GSType.STRING);
        map.put(Boolean.TYPE, GSType.BOOL);
        map.put(Byte.TYPE, GSType.BYTE);
        map.put(Short.TYPE, GSType.SHORT);
        map.put(Integer.TYPE, GSType.INTEGER);
        map.put(Long.TYPE, GSType.LONG);
        map.put(Float.TYPE, GSType.FLOAT);
        map.put(Double.TYPE, GSType.DOUBLE);
        map.put(Date.class, GSType.TIMESTAMP);
        map.put(Geometry.class, GSType.GEOMETRY);
        map.put(Blob.class, GSType.BLOB);
        map.put(Boolean.class, GSType.BOOL);
        map.put(Byte.class, GSType.BYTE);
        map.put(Short.class, GSType.SHORT);
        map.put(Integer.class, GSType.INTEGER);
        map.put(Long.class, GSType.LONG);
        map.put(Float.class, GSType.FLOAT);
        map.put(Double.class, GSType.DOUBLE);
        return map;
    }

    private static void putArraySizeInfo(Cursor cursor, int elementSize, int elementCount) throws GSException {
        BasicBuffer out = cursor.buffer;
        if (cursor.getMode() == MappingMode.ROWWISE_SEPARATED_V2) {
            RowMapper.putVarSize(out, elementSize * elementCount / 8 + RowMapper.getEncodedLength(elementCount));
            RowMapper.putVarSize(out, elementCount);
        } else {
            out.putInt((32 + elementSize * elementCount) / 8);
            out.putInt(elementCount);
        }
    }

    private static void putField(Cursor cursor, Object fieldObj, GSType type, boolean arrayUsed) throws GSException {
        block49: {
            BasicBuffer out;
            block50: {
                block48: {
                    cursor.beginField();
                    out = cursor.buffer;
                    if (!arrayUsed) break block48;
                    cursor.beginVarDataOutput();
                    switch (type) {
                        case STRING: {
                            String[] rawArray = (String[])fieldObj;
                            int orgPos = out.base().position();
                            if (cursor.isVarSizeMode()) {
                                int estimatedTotalSize = rawArray.length * 32;
                                int estimatedHeadSize = RowMapper.getEncodedLength(estimatedTotalSize);
                                out.prepare(16);
                                RowMapper.putVarSizePrepared(out, estimatedTotalSize);
                                RowMapper.putVarSizePrepared(out, rawArray.length);
                                for (String element : rawArray) {
                                    RowMapper.putString(out, element, true);
                                }
                                int endPos = out.base().position();
                                int totalSize = endPos - (orgPos + estimatedHeadSize);
                                int actualHeadSize = RowMapper.getEncodedLength(totalSize);
                                if (estimatedHeadSize != actualHeadSize) {
                                    out.prepare(actualHeadSize - estimatedHeadSize);
                                    byte[] rawBuf = out.base().array();
                                    System.arraycopy(rawBuf, orgPos + estimatedHeadSize, rawBuf, orgPos + actualHeadSize, totalSize);
                                    endPos = orgPos + (actualHeadSize + totalSize);
                                }
                                out.base().position(orgPos);
                                RowMapper.putVarSizePrepared(out, totalSize);
                                out.base().position(endPos);
                                break;
                            }
                            out.putInt(0);
                            out.putInt(rawArray.length);
                            for (int i = 0; i < rawArray.length; ++i) {
                                out.putString(rawArray[i]);
                            }
                            int endPos = out.base().position();
                            out.base().position(orgPos);
                            out.putInt(endPos - (orgPos + 4));
                            out.base().position(endPos);
                            break;
                        }
                        case BOOL: {
                            boolean[] rawArray = (boolean[])fieldObj;
                            RowMapper.putArraySizeInfo(cursor, 8, rawArray.length);
                            for (int i = 0; i < rawArray.length; ++i) {
                                out.putBoolean(rawArray[i]);
                            }
                            break;
                        }
                        case BYTE: {
                            byte[] rawArray = (byte[])fieldObj;
                            RowMapper.putArraySizeInfo(cursor, 8, rawArray.length);
                            out.prepare(rawArray.length);
                            out.base().put(rawArray);
                            break;
                        }
                        case SHORT: {
                            short[] rawArray = (short[])fieldObj;
                            RowMapper.putArraySizeInfo(cursor, 16, rawArray.length);
                            for (int i = 0; i < rawArray.length; ++i) {
                                out.putShort(rawArray[i]);
                            }
                            break;
                        }
                        case INTEGER: {
                            int[] rawArray = (int[])fieldObj;
                            RowMapper.putArraySizeInfo(cursor, 32, rawArray.length);
                            for (int i = 0; i < rawArray.length; ++i) {
                                out.putInt(rawArray[i]);
                            }
                            break;
                        }
                        case LONG: {
                            long[] rawArray = (long[])fieldObj;
                            RowMapper.putArraySizeInfo(cursor, 64, rawArray.length);
                            for (int i = 0; i < rawArray.length; ++i) {
                                out.putLong(rawArray[i]);
                            }
                            break;
                        }
                        case FLOAT: {
                            float[] rawArray = (float[])fieldObj;
                            RowMapper.putArraySizeInfo(cursor, 32, rawArray.length);
                            for (int i = 0; i < rawArray.length; ++i) {
                                out.putFloat(rawArray[i]);
                            }
                            break;
                        }
                        case DOUBLE: {
                            double[] rawArray = (double[])fieldObj;
                            RowMapper.putArraySizeInfo(cursor, 64, rawArray.length);
                            for (int i = 0; i < rawArray.length; ++i) {
                                out.putDouble(rawArray[i]);
                            }
                            break;
                        }
                        case TIMESTAMP: {
                            Date[] rawArray = (Date[])fieldObj;
                            RowMapper.putArraySizeInfo(cursor, 64, rawArray.length);
                            for (int i = 0; i < rawArray.length; ++i) {
                                out.putDate(rawArray[i]);
                            }
                            break;
                        }
                        case GEOMETRY: {
                            throw new GSException(145010, "Illegal array type");
                        }
                        case BLOB: {
                            throw new GSException(145010, "Illegal array type");
                        }
                        default: {
                            throw new Error();
                        }
                    }
                    cursor.endVarData();
                    break block49;
                }
                if (type == null) break block50;
                switch (type) {
                    case STRING: {
                        cursor.beginVarDataOutput();
                        RowMapper.putString(out, (String)fieldObj, cursor.isVarSizeMode());
                        cursor.endVarData();
                        break block49;
                    }
                    case BOOL: {
                        out.putBooleanPrepared((Boolean)fieldObj);
                        break block49;
                    }
                    case BYTE: {
                        out.base().put((Byte)fieldObj);
                        break block49;
                    }
                    case SHORT: {
                        out.base().putShort((Short)fieldObj);
                        break block49;
                    }
                    case INTEGER: {
                        out.base().putInt((Integer)fieldObj);
                        break block49;
                    }
                    case LONG: {
                        out.base().putLong((Long)fieldObj);
                        break block49;
                    }
                    case FLOAT: {
                        out.base().putFloat(((Float)fieldObj).floatValue());
                        break block49;
                    }
                    case DOUBLE: {
                        out.base().putDouble((Double)fieldObj);
                        break block49;
                    }
                    case TIMESTAMP: {
                        out.putDatePrepared((Date)fieldObj);
                        break block49;
                    }
                    case GEOMETRY: {
                        cursor.beginVarDataOutput();
                        int dataSize = GeometryUtils.getBytesLength((Geometry)fieldObj);
                        if (cursor.isVarSizeMode()) {
                            RowMapper.putVarSize(out, dataSize);
                        } else {
                            out.putInt(dataSize);
                        }
                        GeometryUtils.putGeometry(out, (Geometry)fieldObj);
                        cursor.endVarData();
                        break block49;
                    }
                    case BLOB: {
                        byte[] rawArray;
                        cursor.beginVarDataOutput();
                        try {
                            if (fieldObj instanceof BlobImpl) {
                                rawArray = ((BlobImpl)fieldObj).getDataDirect();
                            } else {
                                Blob blob = (Blob)fieldObj;
                                long length = blob.length();
                                if (length > Integer.MAX_VALUE) {
                                    throw new GSException("Blob size limit exceeded");
                                }
                                rawArray = length > 0L ? blob.getBytes(1L, (int)length) : new byte[]{};
                            }
                        }
                        catch (SQLException e) {
                            throw new GSException(e);
                        }
                        if (cursor.isVarSizeMode()) {
                            RowMapper.putVarSize(out, rawArray.length);
                        } else {
                            out.putInt(rawArray.length);
                        }
                        out.prepare(rawArray.length);
                        out.base().put(rawArray);
                        cursor.endVarData();
                        break block49;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (fieldObj == null) {
                RowMapper.putTypePrepared(out, null);
                out.base().putLong(0L);
            } else {
                Class<?> fieldClass = fieldObj.getClass();
                GSType actualElementType = RowMapper.resolveElementType(fieldClass, true, true);
                boolean actualArrayUsed = fieldClass.isArray();
                RowMapper.putTypePrepared(out, RowMapper.toFullType(actualElementType, actualArrayUsed));
                int lastPos = out.base().position();
                RowMapper.putField(cursor, fieldObj, actualElementType, actualArrayUsed);
                int fixedGap = lastPos + 8 - out.base().position();
                out.base().put(EMPTY_LONG_BYTES, 0, fixedGap);
            }
        }
    }

    private static Object getField(Cursor cursor, GSType type, boolean arrayUsed) throws GSException {
        cursor.beginField();
        BasicBuffer in = cursor.buffer;
        if (arrayUsed) {
            Object[] result;
            int length;
            cursor.beginVarDataInput();
            if (cursor.isVarSizeMode()) {
                RowMapper.getVarSize(in);
                length = RowMapper.getVarSize(in);
            } else {
                in.base().getInt();
                length = in.base().getInt();
            }
            switch (type) {
                case STRING: {
                    String[] rawArray = new String[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = RowMapper.getString(in, cursor.isVarSizeMode());
                    }
                    result = rawArray;
                    break;
                }
                case BOOL: {
                    boolean[] rawArray = new boolean[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.getBoolean();
                    }
                    result = rawArray;
                    break;
                }
                case BYTE: {
                    byte[] rawArray = new byte[length];
                    in.base().get(rawArray);
                    result = rawArray;
                    break;
                }
                case SHORT: {
                    short[] rawArray = new short[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.base().getShort();
                    }
                    result = rawArray;
                    break;
                }
                case INTEGER: {
                    int[] rawArray = new int[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.base().getInt();
                    }
                    result = rawArray;
                    break;
                }
                case LONG: {
                    long[] rawArray = new long[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.base().getLong();
                    }
                    result = rawArray;
                    break;
                }
                case FLOAT: {
                    float[] rawArray = new float[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.base().getFloat();
                    }
                    result = rawArray;
                    break;
                }
                case DOUBLE: {
                    double[] rawArray = new double[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.base().getDouble();
                    }
                    result = rawArray;
                    break;
                }
                case TIMESTAMP: {
                    Date[] rawArray = new Date[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.getDate();
                    }
                    result = rawArray;
                    break;
                }
                case GEOMETRY: {
                    throw new GSException(145010, "Illegal array type");
                }
                case BLOB: {
                    throw new GSException(145010, "Illegal array type");
                }
                default: {
                    throw new Error();
                }
            }
            cursor.endVarData();
            return result;
        }
        if (type != null) {
            switch (type) {
                case STRING: {
                    cursor.beginVarDataInput();
                    String result = RowMapper.getString(in, cursor.isVarSizeMode());
                    cursor.endVarData();
                    return result;
                }
                case BOOL: {
                    return in.getBoolean();
                }
                case BYTE: {
                    return in.base().get();
                }
                case SHORT: {
                    return in.base().getShort();
                }
                case INTEGER: {
                    return in.base().getInt();
                }
                case LONG: {
                    return in.base().getLong();
                }
                case FLOAT: {
                    return Float.valueOf(in.base().getFloat());
                }
                case DOUBLE: {
                    return in.base().getDouble();
                }
                case TIMESTAMP: {
                    return in.getDate();
                }
                case GEOMETRY: {
                    cursor.beginVarDataInput();
                    int length = cursor.isVarSizeMode() ? RowMapper.getVarSize(in) : in.base().getInt();
                    Geometry result = GeometryUtils.getGeometry(in, length);
                    cursor.endVarData();
                    return result;
                }
                case BLOB: {
                    cursor.beginVarDataInput();
                    int length = cursor.isVarSizeMode() ? RowMapper.getVarSize(in) : in.base().getInt();
                    byte[] rawArray = new byte[length];
                    in.base().get(rawArray);
                    Blob blob = cursor.blobFactory == null ? DIRECT_BLOB_FACTORY.createBlob(rawArray) : cursor.blobFactory.createBlob(rawArray);
                    cursor.endVarData();
                    return blob;
                }
            }
            throw new Error();
        }
        GSType actualType = RowMapper.getType(in);
        if (actualType == null) {
            in.base().getLong();
            return null;
        }
        GSType actualElementType = RowMapper.toArrayElementType(actualType);
        boolean actualArrayUsed = actualElementType != null;
        int lastPos = in.base().position();
        Object value = RowMapper.getField(cursor, actualArrayUsed ? actualElementType : actualType, actualArrayUsed);
        int fixedGap = lastPos + 8 - in.base().position();
        if (fixedGap < 0 || fixedGap > 8) {
            throw new Error();
        }
        for (int r = fixedGap; r > 0; --r) {
            in.base().get();
        }
        return value;
    }

    private static int getFixedEncodedSize(GSType type, boolean arrayUsed, MappingMode mode) {
        if (arrayUsed) {
            if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
                return 0;
            }
            return 8;
        }
        if (type != null) {
            switch (type) {
                case STRING: {
                    if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
                        return 0;
                    }
                    return 8;
                }
                case BOOL: {
                    return 1;
                }
                case BYTE: {
                    return 1;
                }
                case SHORT: {
                    return 2;
                }
                case INTEGER: {
                    return 4;
                }
                case LONG: {
                    return 8;
                }
                case FLOAT: {
                    return 4;
                }
                case DOUBLE: {
                    return 8;
                }
                case TIMESTAMP: {
                    return 8;
                }
                case GEOMETRY: {
                    if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
                        return 0;
                    }
                    return 8;
                }
                case BLOB: {
                    if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
                        return 0;
                    }
                    return 8;
                }
            }
            throw new Error();
        }
        return 9;
    }

    private static void putTypePrepared(BasicBuffer out, GSType type) {
        if (type == null) {
            out.base().put((byte)-1);
        } else {
            out.putByteEnumPrepared(type);
        }
    }

    private static GSType getType(BasicBuffer in) {
        byte rawType = in.base().get();
        if (rawType == -1) {
            return null;
        }
        try {
            return TYPE_CONSTANTS[rawType & 0xFF];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean hasVarDataPart(GSType type, boolean arrayUsed) {
        if (arrayUsed) {
            return true;
        }
        if (type != null) {
            switch (type) {
                case STRING: {
                    return true;
                }
                case GEOMETRY: {
                    return true;
                }
                case BLOB: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static Map<GSType, Object> createEmptyValueMap(boolean arrayUsed) {
        EnumMap<GSType, Object> map = new EnumMap<GSType, Object>(GSType.class);
        if (arrayUsed) {
            map.put(GSType.STRING, new String[0]);
            map.put(GSType.BOOL, new boolean[0]);
            map.put(GSType.BYTE, new byte[0]);
            map.put(GSType.SHORT, new short[0]);
            map.put(GSType.INTEGER, new int[0]);
            map.put(GSType.LONG, new long[0]);
            map.put(GSType.FLOAT, new float[0]);
            map.put(GSType.DOUBLE, new double[0]);
            map.put(GSType.TIMESTAMP, new Date[0]);
        } else {
            map.put(GSType.STRING, "");
            map.put(GSType.BOOL, Boolean.valueOf(false));
            map.put(GSType.BYTE, Byte.valueOf((byte)0));
            map.put(GSType.SHORT, Short.valueOf((short)0));
            map.put(GSType.INTEGER, Integer.valueOf(0));
            map.put(GSType.LONG, Long.valueOf(0L));
            map.put(GSType.FLOAT, Float.valueOf(0.0f));
            map.put(GSType.DOUBLE, Double.valueOf(0.0));
            map.put(GSType.TIMESTAMP, new Date(0L));
            map.put(GSType.GEOMETRY, (Object)Geometry.valueOf("POINT(EMPTY)"));
            map.put(GSType.BLOB, (Object)new BlobImpl());
        }
        return map;
    }

    public static GSType toFullType(GSType elementType, boolean arrayUsed) {
        if (arrayUsed) {
            switch (elementType) {
                case STRING: {
                    return GSType.STRING_ARRAY;
                }
                case BOOL: {
                    return GSType.BOOL_ARRAY;
                }
                case BYTE: {
                    return GSType.BYTE_ARRAY;
                }
                case SHORT: {
                    return GSType.SHORT_ARRAY;
                }
                case INTEGER: {
                    return GSType.INTEGER_ARRAY;
                }
                case LONG: {
                    return GSType.LONG_ARRAY;
                }
                case FLOAT: {
                    return GSType.FLOAT_ARRAY;
                }
                case DOUBLE: {
                    return GSType.DOUBLE_ARRAY;
                }
                case TIMESTAMP: {
                    return GSType.TIMESTAMP_ARRAY;
                }
            }
            throw new Error();
        }
        return elementType;
    }

    public static GSType toArrayElementType(GSType type) {
        switch (type) {
            case STRING_ARRAY: {
                return GSType.STRING;
            }
            case BOOL_ARRAY: {
                return GSType.BOOL;
            }
            case BYTE_ARRAY: {
                return GSType.BYTE;
            }
            case SHORT_ARRAY: {
                return GSType.SHORT;
            }
            case INTEGER_ARRAY: {
                return GSType.INTEGER;
            }
            case LONG_ARRAY: {
                return GSType.LONG;
            }
            case FLOAT_ARRAY: {
                return GSType.FLOAT;
            }
            case DOUBLE_ARRAY: {
                return GSType.DOUBLE;
            }
            case TIMESTAMP_ARRAY: {
                return GSType.TIMESTAMP;
            }
        }
        return null;
    }

    public static String normalizeSymbol(String symbol, String typeName) throws GSException {
        RowMapper.checkSymbol(symbol, typeName);
        return RowMapper.normalizeSymbolUnchecked(symbol);
    }

    public static String normalizeSymbolUnchecked(String symbol) {
        return symbol.toLowerCase(Locale.ROOT);
    }

    public static void checkSymbol(String symbol, String typeName) throws GSException {
        if (symbol == null || symbol.isEmpty()) {
            throw new GSException(145001, "Empty " + typeName);
        }
        RowMapper.checkString(symbol, typeName);
    }

    public static void checkString(String value, String typeName) throws GSException {
        boolean highSurrogateLast = false;
        boolean surrogateIllegal = false;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            if (ch == '\u0000') {
                throw new GSException(145007, "Illegal '\\0' character found in " + typeName);
            }
            if (highSurrogateLast) {
                if (!Character.isLowSurrogate(ch)) {
                    surrogateIllegal = true;
                    break;
                }
                highSurrogateLast = false;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                if (highSurrogateLast) {
                    surrogateIllegal = true;
                    break;
                }
                highSurrogateLast = true;
                continue;
            }
            if (!Character.isLowSurrogate(ch)) continue;
            surrogateIllegal = true;
            break;
        }
        if (highSurrogateLast || surrogateIllegal) {
            throw new GSException(145007, "Illegal surrogate character found in " + typeName);
        }
    }

    public static BlobFactory getDirectBlobFactory() {
        return DIRECT_BLOB_FACTORY;
    }

    static final boolean varSizeIs1Byte(byte val) {
        return (val & 1) == 1;
    }

    static final boolean varSizeIs4Byte(byte val) {
        return (val & 3) == 0;
    }

    static final boolean varSizeIs8Byte(byte val) {
        return (val & 3) == 2;
    }

    static final int decode1ByteVarSize(byte byteVal) {
        byte val = byteVal;
        return (val & 0xFF) >>> 1;
    }

    static final int decode4ByteVarSize(int val) {
        return val >>> 2;
    }

    static final long decode8ByteVarSize(long val) {
        return val >>> 2;
    }

    static final byte encode1ByteVarSize(byte val) {
        return (byte)(val << 1 | 1);
    }

    static final int encode4ByteVarSize(int val) {
        return val << 2;
    }

    static final long encode8ByteVarSize(long val) {
        return val << 2 | 2L;
    }

    static final int getEncodedLength(int val) {
        if ((long)val < 128L) {
            return 1;
        }
        if ((long)val < 0x40000000L) {
            return 4;
        }
        return 8;
    }

    public static void putSize(BasicBuffer out, int value, MappingMode mode) {
        if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
            RowMapper.putVarSize(out, value);
        } else {
            out.putInt(value);
        }
    }

    static final void putVarSize(BasicBuffer out, int value) {
        if ((long)value < 128L) {
            out.put(RowMapper.encode1ByteVarSize((byte)value));
        } else if ((long)value < 0x40000000L) {
            out.putInt(RowMapper.encode4ByteVarSize(value));
        } else {
            out.putLong(RowMapper.encode8ByteVarSize(value));
        }
    }

    static void putVarSizePrepared(BasicBuffer out, int value) {
        if ((long)value < 128L) {
            out.base().put(RowMapper.encode1ByteVarSize((byte)value));
        } else if ((long)value < 0x40000000L) {
            out.base().putInt(RowMapper.encode4ByteVarSize(value));
        } else {
            out.base().putLong(RowMapper.encode8ByteVarSize(value));
        }
    }

    static final int getVarSize(BasicBuffer in) throws GSException {
        byte first = in.base().get();
        if (RowMapper.varSizeIs1Byte(first)) {
            return RowMapper.decode1ByteVarSize(first);
        }
        if (RowMapper.varSizeIs4Byte(first)) {
            in.base().position(in.base().position() - 1);
            int rawSize = in.base().getInt();
            return RowMapper.decode4ByteVarSize(rawSize);
        }
        in.base().position(in.base().position() - 1);
        long rawSize = in.base().getLong();
        long decodedSize = RowMapper.decode8ByteVarSize(rawSize);
        if (decodedSize > Integer.MAX_VALUE) {
            throw new GSException(145031, "Decoded size = " + decodedSize);
        }
        return (int)decodedSize;
    }

    static void putString(BasicBuffer out, String value, boolean varSizeMode) {
        if (varSizeMode) {
            byte[] buf = value.getBytes(BasicBuffer.DEFAULT_CHARSET);
            out.prepare(8 + buf.length);
            RowMapper.putVarSizePrepared(out, buf.length);
            out.base().put(buf);
        } else {
            out.putString(value);
        }
    }

    static String getString(BasicBuffer in, boolean varSizeMode) throws GSException {
        int bytesLength = varSizeMode ? RowMapper.getVarSize(in) : in.base().getInt();
        byte[] buf = new byte[bytesLength];
        in.base().get(buf);
        return new String(buf, 0, buf.length, BasicBuffer.DEFAULT_CHARSET);
    }

    static {
        try {
            AGGREGATION_RESULT_MAPPER = new RowMapper(AggregationResult.class, AggregationResultImpl.class.getDeclaredConstructor(new Class[0]), Collections.<String, Entry>emptyMap(), Collections.<Entry>emptyList(), null, null, false);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        EMPTY_LONG_BYTES = new byte[8];
        TYPE_CONSTANTS = GSType.values();
        DIRECT_BLOB_FACTORY = new BlobFactory(){

            public Blob createBlob(byte[] data) throws GSException {
                BlobImpl blob = new BlobImpl(null);
                blob.setDataDirect(data);
                return blob;
            }
        };
        METHOD_PATTERN = Pattern.compile("^((get)|(set)|(is))(.+)$");
        CACHE = new Cache();
        ELEMENT_TYPE_MAP = RowMapper.createElementTypeMap();
        EMPTY_ELEMENT_VALUES = RowMapper.createEmptyValueMap(false);
        EMPTY_ARRAY_VALUES = RowMapper.createEmptyValueMap(true);
        BASIC_CONFIG = new Config(false, false, true);
        GENERAL_CONFIG = new Config(true, true, true);
        EMPTY_KEY_LIST = Collections.emptyList();
        SINGLE_FIRST_KEY_LIST = Collections.singletonList(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tool {
        private Tool() {
        }

        public static Class<?> getRowType(RowMapper mapper) {
            return mapper.getRowType();
        }

        public static ContainerInfo getContainerSchema(RowMapper mapper) {
            return mapper.getContainerInfo();
        }

        public static RowMapper resolveMapper(ContainerInfo containerSchema) throws GSException {
            return RowMapper.getInstance(containerSchema.getType(), containerSchema, GENERAL_CONFIG);
        }

        public static int getColumnCount(RowMapper mapper) {
            return mapper.getColumnCount();
        }

        public static String getColumnName(RowMapper mapper, int index) {
            return ((RowMapper)mapper).getEntry((int)index).columnName;
        }

        public static GSType getElementType(RowMapper mapper, int index) {
            return ((RowMapper)mapper).getEntry((int)index).elementType;
        }

        public static boolean isArrayColumn(RowMapper mapper, int index) {
            return ((RowMapper)mapper).getEntry((int)index).arrayUsed;
        }

        public static boolean isColumnNullable(RowMapper mapper, int index) {
            return ((RowMapper)mapper).getEntry((int)index).columnNullable;
        }

        public static int getKeyColumnId(RowMapper mapper) {
            for (int i = 0; i < mapper.getColumnCount(); ++i) {
                if (!((RowMapper)mapper).getEntry((int)i).keyType) continue;
                return i;
            }
            return -1;
        }

        public static Object createRowObject(RowMapper mapper) throws GSException {
            return mapper.createRow(mapper.isGeneral());
        }

        public static Object getFieldObj(RowMapper mapper, int index, Object rowObj) throws GSException {
            return mapper.getEntry(index).getFieldObj(rowObj, mapper.isGeneral());
        }

        public static void setFieldObj(RowMapper mapper, int index, Object rowObj, Object fieldObj) throws GSException {
            mapper.getEntry(index).setFieldObj(rowObj, fieldObj, mapper.isGeneral());
        }

        public static Blob createBlob(byte[] bytes) throws GSException {
            return DIRECT_BLOB_FACTORY.createBlob(bytes);
        }

        public static GSType getAnyValueType(Row generatedRow, int column) throws GSException {
            Object value = !(generatedRow instanceof ArrayRow) ? generatedRow.getValue(column) : ((ArrayRow)generatedRow).getAnyValue(column);
            if (value == null) {
                return null;
            }
            return RowMapper.resolveElementType(value.getClass(), true, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache {
        private final Map<Class<?>, RowMapper> timeSeriesMap = new WeakHashMap();
        private final Map<Class<?>, RowMapper> collectionMap = new WeakHashMap();
        private final InternPool<RowMapper> internPool = new InternPool();

        private Cache() {
        }

        synchronized RowMapper getInstance(Class<?> rowType, ContainerType containerType, Config config) throws GSException {
            Map<Class<?>, RowMapper> map = containerType == ContainerType.TIME_SERIES ? this.timeSeriesMap : this.collectionMap;
            RowMapper mapper = map.get(rowType);
            if (mapper == null || mapper.nullableAllowed != config.nullableAllowed) {
                mapper = new RowMapper(rowType, containerType, config.nullableAllowed);
                map.put(rowType, mapper);
                this.internPool.intern(mapper);
            }
            return mapper;
        }

        synchronized RowMapper intern(RowMapper mapper) {
            return this.internPool.intern(mapper);
        }
    }

    private static class ArrayRow
    implements Row {
        private final RowMapper mapper;
        private final Object[] fieldArray;

        private ArrayRow(RowMapper mapper, Object[] fieldArray) throws GSException {
            if (mapper.getContainerType() == null) {
                throw new GSException(145003, "");
            }
            this.mapper = mapper;
            this.fieldArray = fieldArray;
        }

        static ArrayRow create(RowMapper mapper, boolean nullable) throws GSException {
            Object[] fieldArray = new Object[mapper.getColumnCount()];
            mapper.getAllInitialValue(nullable, fieldArray);
            return new ArrayRow(mapper, fieldArray);
        }

        static ArrayRow createUninitialized(RowMapper mapper) throws GSException {
            Object[] fieldArray = new Object[mapper.getColumnCount()];
            return new ArrayRow(mapper, fieldArray);
        }

        private void setAnyValueDirect(int column, Object fieldValue) {
            this.fieldArray[column] = fieldValue;
        }

        private Object getAnyValue(int column) throws GSException {
            try {
                return this.fieldArray[column];
            }
            catch (IndexOutOfBoundsException e) {
                throw this.errorColumnNumber(column, e);
            }
        }

        private void setPrimitiveNull(int column, GSType elementType) throws GSException {
            Entry entry = this.getEntry(column);
            this.checkNullable(entry);
            this.checkType(entry, elementType, false);
            this.setAnyValueDirect(column, null);
        }

        private void setArrayNull(int column, GSType elementType) throws GSException {
            Entry entry = this.getEntry(column);
            this.checkNullable(entry);
            this.checkType(entry, elementType, true);
            this.setAnyValueDirect(column, null);
        }

        private void checkPrimitiveType(int column, GSType elementType) throws GSException {
            Entry entry = this.getEntry(column);
            this.checkType(entry, elementType, false);
        }

        private void checkArrayType(int column, GSType elementType) throws GSException {
            Entry entry = this.getEntry(column);
            this.checkType(entry, elementType, true);
        }

        private void checkNullable(Entry entry) throws GSException {
            if (!entry.columnNullable && entry.elementType != null) {
                throw this.errorNull(entry.order, null);
            }
        }

        private void checkType(Entry entry, GSType elementType, boolean arrayUsed) throws GSException {
            if (entry.arrayUsed != arrayUsed || elementType != entry.elementType) {
                GSType expectedType = RowMapper.toFullType(elementType, arrayUsed);
                throw this.errorTypeUnmatch(entry.order, expectedType, null);
            }
        }

        private void checkObjectArrayElements(int column, Object[] arrayElements) throws GSException {
            for (int i = 0; i < arrayElements.length; ++i) {
                if (arrayElements[i] != null) continue;
                throw this.errorNull(column, i);
            }
        }

        private Entry getEntry(int column) throws GSException {
            try {
                return this.mapper.getEntry(column);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.errorColumnNumber(column, e);
            }
        }

        private GSException errorNull(int column, Integer arrayIndex) {
            Entry entry = column < this.mapper.getColumnCount() ? this.mapper.getEntry(column) : null;
            return new GSException(145001, "Null is not allowed" + (arrayIndex == null ? "" : " for array element") + " (" + (arrayIndex == null ? "" : "arrayIndex=" + arrayIndex + ", ") + (entry == null ? "" : "column=" + entry.columnName + ", ") + "columnNumber=" + column + ")");
        }

        private GSException errorColumnNumber(int column, IndexOutOfBoundsException cause) {
            return new GSException(145002, "Column number out of bounds (columnNumber=" + column + ", columnCount=" + this.mapper.getColumnCount() + ")", cause);
        }

        private GSException errorTypeUnmatch(int column, GSType specifiedType, ClassCastException cause) {
            return this.errorTypeUnmatch(column, specifiedType, null, cause);
        }

        private GSException errorTypeUnmatch(int column, GSType specifiedType, Object specifiedValue, ClassCastException cause) {
            String specifiedTypeName = specifiedType == null ? (specifiedValue == null ? "null" : specifiedValue.getClass().getName()) : specifiedType.name();
            Entry entry = column < this.mapper.getColumnCount() ? this.mapper.getEntry(column) : null;
            return new GSException(145002, "Column type unmatched (" + (specifiedTypeName == null ? "" : "specifiedType=" + specifiedTypeName + ", ") + (entry == null ? "" : "actualType=" + (Object)((Object)entry.getFullType()) + ", ") + (entry == null ? "" : "column=" + entry.columnName + ", ") + "columnNumber=" + column + ")", cause);
        }

        private static Blob shareBlob(Blob src) throws GSException {
            try {
                return BlobImpl.share(src);
            }
            catch (SQLException e) {
                throw new GSException(e);
            }
        }

        public ContainerInfo getSchema() throws GSException {
            return this.mapper.getContainerInfo();
        }

        public void setValue(int column, Object fieldValue) throws GSException {
            block29: {
                if (fieldValue == null) {
                    this.setNull(column);
                    return;
                }
                Entry entry = this.getEntry(column);
                try {
                    if (entry.arrayUsed) {
                        switch (entry.elementType) {
                            case STRING: {
                                this.setStringArray(column, (String[])fieldValue);
                                break block29;
                            }
                            case BOOL: {
                                this.setBoolArray(column, (boolean[])fieldValue);
                                break block29;
                            }
                            case BYTE: {
                                this.setByteArray(column, (byte[])fieldValue);
                                break block29;
                            }
                            case SHORT: {
                                this.setShortArray(column, (short[])fieldValue);
                                break block29;
                            }
                            case INTEGER: {
                                this.setIntegerArray(column, (int[])fieldValue);
                                break block29;
                            }
                            case LONG: {
                                this.setLongArray(column, (long[])fieldValue);
                                break block29;
                            }
                            case FLOAT: {
                                this.setFloatArray(column, (float[])fieldValue);
                                break block29;
                            }
                            case DOUBLE: {
                                this.setDoubleArray(column, (double[])fieldValue);
                                break block29;
                            }
                            case TIMESTAMP: {
                                this.setTimestampArray(column, (Date[])fieldValue);
                                break block29;
                            }
                            default: {
                                throw new Error();
                            }
                        }
                    }
                    if (entry.elementType != null) {
                        switch (entry.elementType) {
                            case STRING: {
                                this.setAnyValueDirect(column, (String)fieldValue);
                                break block29;
                            }
                            case BOOL: {
                                this.setAnyValueDirect(column, (Boolean)fieldValue);
                                break block29;
                            }
                            case BYTE: {
                                this.setAnyValueDirect(column, (Byte)fieldValue);
                                break block29;
                            }
                            case SHORT: {
                                this.setAnyValueDirect(column, (Short)fieldValue);
                                break block29;
                            }
                            case INTEGER: {
                                this.setAnyValueDirect(column, (Integer)fieldValue);
                                break block29;
                            }
                            case LONG: {
                                this.setAnyValueDirect(column, (Long)fieldValue);
                                break block29;
                            }
                            case FLOAT: {
                                this.setAnyValueDirect(column, (Float)fieldValue);
                                break block29;
                            }
                            case DOUBLE: {
                                this.setAnyValueDirect(column, (Double)fieldValue);
                                break block29;
                            }
                            case TIMESTAMP: {
                                this.setAnyValueDirect(column, (Date)fieldValue);
                                break block29;
                            }
                            case GEOMETRY: {
                                this.setAnyValueDirect(column, (Geometry)fieldValue);
                                break block29;
                            }
                            case BLOB: {
                                this.setAnyValueDirect(column, ArrayRow.shareBlob((Blob)fieldValue));
                                break block29;
                            }
                            default: {
                                throw new Error();
                            }
                        }
                    }
                    RowMapper.resolveElementType(fieldValue.getClass(), true, true);
                    this.setAnyValueDirect(column, fieldValue);
                }
                catch (ClassCastException e) {
                    throw this.errorTypeUnmatch(column, null, fieldValue, e);
                }
            }
        }

        public Object getValue(int column) throws GSException {
            Entry entry = this.getEntry(column);
            if (entry.arrayUsed) {
                switch (entry.elementType) {
                    case STRING: {
                        return this.getStringArray(column);
                    }
                    case BOOL: {
                        return this.getBoolArray(column);
                    }
                    case BYTE: {
                        return this.getByteArray(column);
                    }
                    case SHORT: {
                        return this.getShortArray(column);
                    }
                    case INTEGER: {
                        return this.getIntegerArray(column);
                    }
                    case LONG: {
                        return this.getLongArray(column);
                    }
                    case FLOAT: {
                        return this.getFloatArray(column);
                    }
                    case DOUBLE: {
                        return this.getDoubleArray(column);
                    }
                    case TIMESTAMP: {
                        return this.getTimestampArray(column);
                    }
                }
                throw new Error();
            }
            if (entry.elementType != null) {
                switch (entry.elementType) {
                    case TIMESTAMP: {
                        return this.getTimestamp(column);
                    }
                    case BLOB: {
                        return this.getBlob(column);
                    }
                }
            }
            return this.getAnyValue(column);
        }

        public void setString(int column, String fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setPrimitiveNull(column, GSType.STRING);
                return;
            }
            this.checkPrimitiveType(column, GSType.STRING);
            this.setAnyValueDirect(column, fieldValue);
        }

        public String getString(int column) throws GSException {
            String src;
            try {
                src = (String)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.STRING, e);
            }
            return src == null ? null : src;
        }

        public void setBool(int column, boolean fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.BOOL);
            this.setAnyValueDirect(column, fieldValue);
        }

        public boolean getBool(int column) throws GSException {
            Boolean src;
            try {
                src = (Boolean)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.BOOL, e);
            }
            return src == null ? false : src;
        }

        public void setByte(int column, byte fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.BYTE);
            this.setAnyValueDirect(column, fieldValue);
        }

        public byte getByte(int column) throws GSException {
            Byte src;
            try {
                src = (Byte)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.BYTE, e);
            }
            return src == null ? (byte)0 : src;
        }

        public void setShort(int column, short fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.SHORT);
            this.setAnyValueDirect(column, fieldValue);
        }

        public short getShort(int column) throws GSException {
            Short src;
            try {
                src = (Short)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.SHORT, e);
            }
            return src == null ? (short)0 : src;
        }

        public void setInteger(int column, int fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.INTEGER);
            this.setAnyValueDirect(column, fieldValue);
        }

        public int getInteger(int column) throws GSException {
            Integer src;
            try {
                src = (Integer)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.INTEGER, e);
            }
            return src == null ? 0 : src;
        }

        public void setLong(int column, long fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.LONG);
            this.setAnyValueDirect(column, fieldValue);
        }

        public long getLong(int column) throws GSException {
            Long src;
            try {
                src = (Long)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.LONG, e);
            }
            return src == null ? 0L : src;
        }

        public void setFloat(int column, float fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.FLOAT);
            this.setAnyValueDirect(column, Float.valueOf(fieldValue));
        }

        public float getFloat(int column) throws GSException {
            Float src;
            try {
                src = (Float)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.FLOAT, e);
            }
            return src == null ? 0.0f : src.floatValue();
        }

        public void setDouble(int column, double fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.DOUBLE);
            this.setAnyValueDirect(column, fieldValue);
        }

        public double getDouble(int column) throws GSException {
            Double src;
            try {
                src = (Double)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.DOUBLE, e);
            }
            return src == null ? 0.0 : src;
        }

        public void setTimestamp(int column, Date fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setPrimitiveNull(column, GSType.TIMESTAMP);
                return;
            }
            this.checkPrimitiveType(column, GSType.TIMESTAMP);
            this.setAnyValueDirect(column, fieldValue);
        }

        public Date getTimestamp(int column) throws GSException {
            Date src;
            try {
                src = (Date)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.TIMESTAMP, e);
            }
            return src == null ? null : new Date(src.getTime());
        }

        public void setGeometry(int column, Geometry fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setPrimitiveNull(column, GSType.GEOMETRY);
                return;
            }
            this.checkPrimitiveType(column, GSType.GEOMETRY);
            this.setAnyValueDirect(column, fieldValue);
        }

        public Geometry getGeometry(int column) throws GSException {
            Geometry src;
            try {
                src = (Geometry)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.GEOMETRY, e);
            }
            return src == null ? null : src;
        }

        public void setBlob(int column, Blob fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setPrimitiveNull(column, GSType.BLOB);
                return;
            }
            this.checkPrimitiveType(column, GSType.BLOB);
            this.setAnyValueDirect(column, ArrayRow.shareBlob(fieldValue));
        }

        public Blob getBlob(int column) throws GSException {
            BlobImpl src;
            try {
                src = (BlobImpl)this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.BLOB, e);
            }
            if (src == null) {
                return null;
            }
            return BlobImpl.shareDirect(src);
        }

        public void setStringArray(int column, String[] fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setArrayNull(column, GSType.STRING);
                return;
            }
            this.checkArrayType(column, GSType.STRING);
            Object[] dest = new String[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.checkObjectArrayElements(column, dest);
            this.setAnyValueDirect(column, dest);
        }

        public String[] getStringArray(int column) throws GSException {
            String[] src;
            try {
                src = (String[])this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.STRING_ARRAY, e);
            }
            if (src == null) {
                return null;
            }
            String[] dest = new String[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        public void setBoolArray(int column, boolean[] fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setArrayNull(column, GSType.BOOL);
                return;
            }
            this.checkArrayType(column, GSType.BOOL);
            boolean[] dest = new boolean[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setAnyValueDirect(column, dest);
        }

        public boolean[] getBoolArray(int column) throws GSException {
            boolean[] src;
            try {
                src = (boolean[])this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.BOOL_ARRAY, e);
            }
            if (src == null) {
                return null;
            }
            boolean[] dest = new boolean[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        public void setByteArray(int column, byte[] fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setArrayNull(column, GSType.BYTE);
                return;
            }
            this.checkArrayType(column, GSType.BYTE);
            byte[] dest = new byte[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setAnyValueDirect(column, dest);
        }

        public byte[] getByteArray(int column) throws GSException {
            byte[] src;
            try {
                src = (byte[])this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.BYTE_ARRAY, e);
            }
            if (src == null) {
                return null;
            }
            byte[] dest = new byte[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        public void setShortArray(int column, short[] fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setArrayNull(column, GSType.SHORT);
                return;
            }
            this.checkArrayType(column, GSType.SHORT);
            short[] dest = new short[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setAnyValueDirect(column, dest);
        }

        public short[] getShortArray(int column) throws GSException {
            short[] src;
            try {
                src = (short[])this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.SHORT_ARRAY, e);
            }
            if (src == null) {
                return null;
            }
            short[] dest = new short[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        public void setIntegerArray(int column, int[] fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setArrayNull(column, GSType.INTEGER);
                return;
            }
            this.checkArrayType(column, GSType.INTEGER);
            int[] dest = new int[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setAnyValueDirect(column, dest);
        }

        public int[] getIntegerArray(int column) throws GSException {
            int[] src;
            try {
                src = (int[])this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.INTEGER_ARRAY, e);
            }
            if (src == null) {
                return null;
            }
            int[] dest = new int[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        public void setLongArray(int column, long[] fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setArrayNull(column, GSType.LONG);
                return;
            }
            this.checkArrayType(column, GSType.LONG);
            long[] dest = new long[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setAnyValueDirect(column, dest);
        }

        public long[] getLongArray(int column) throws GSException {
            long[] src;
            try {
                src = (long[])this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.LONG_ARRAY, e);
            }
            if (src == null) {
                return null;
            }
            long[] dest = new long[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        public void setFloatArray(int column, float[] fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setArrayNull(column, GSType.FLOAT);
                return;
            }
            this.checkArrayType(column, GSType.FLOAT);
            float[] dest = new float[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setAnyValueDirect(column, dest);
        }

        public float[] getFloatArray(int column) throws GSException {
            float[] src;
            try {
                src = (float[])this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.FLOAT_ARRAY, e);
            }
            if (src == null) {
                return null;
            }
            float[] dest = new float[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        public void setDoubleArray(int column, double[] fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setArrayNull(column, GSType.DOUBLE);
                return;
            }
            this.checkArrayType(column, GSType.DOUBLE);
            double[] dest = new double[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setAnyValueDirect(column, dest);
        }

        public double[] getDoubleArray(int column) throws GSException {
            double[] src;
            try {
                src = (double[])this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.DOUBLE_ARRAY, e);
            }
            if (src == null) {
                return null;
            }
            double[] dest = new double[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        public void setTimestampArray(int column, Date[] fieldValue) throws GSException {
            if (fieldValue == null) {
                this.setArrayNull(column, GSType.TIMESTAMP);
                return;
            }
            this.checkArrayType(column, GSType.TIMESTAMP);
            Object[] dest = new Date[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.checkObjectArrayElements(column, dest);
            this.setAnyValueDirect(column, dest);
        }

        public Date[] getTimestampArray(int column) throws GSException {
            Date[] src;
            try {
                src = (Date[])this.getAnyValue(column);
            }
            catch (ClassCastException e) {
                throw this.errorTypeUnmatch(column, GSType.TIMESTAMP_ARRAY, e);
            }
            if (src == null) {
                return null;
            }
            Date[] dest = new Date[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        public void setNull(int column) throws GSException {
            this.checkNullable(this.getEntry(column));
            this.setAnyValueDirect(column, null);
        }

        public boolean isNull(int column) throws GSException {
            return this.getAnyValue(column) == null;
        }
    }

    public class Cursor {
        private BasicBuffer buffer;
        private final int rowCount;
        private final MappingMode mode;
        private final boolean rowIdIncluded;
        private final BlobFactory blobFactory;
        private int rowIndex = -1;
        private int fieldIndex = -1;
        private final int fixedRowPartSize;
        private final int topPos;
        private final int varDataTop;
        private int partialVarDataOffset;
        private int varDataLast;
        private int pendingPos = -1;
        private long lastRowId = -1L;
        private long varDataBaseOffset;
        private byte[] nullsBytes;
        private boolean nullFound;

        private Cursor(BasicBuffer buffer, MappingMode mode, int rowCount, boolean rowIdIncluded, BlobFactory blobFactory) {
            this.buffer = buffer;
            this.mode = mode;
            this.rowCount = rowCount;
            this.rowIdIncluded = rowIdIncluded;
            this.blobFactory = blobFactory;
            this.fixedRowPartSize = RowMapper.this.getFixedRowPartSize(rowIdIncluded, mode);
            this.topPos = buffer.base().position();
            switch (mode) {
                case ROWWISE_SEPARATED: {
                    this.varDataTop = this.topPos + this.fixedRowPartSize * rowCount;
                    break;
                }
                case ROWWISE_SEPARATED_V2: {
                    this.varDataTop = this.topPos + this.fixedRowPartSize * rowCount;
                    this.nullsBytes = new byte[RowMapper.this.getNullsByteSize(RowMapper.this.entryList.size())];
                    break;
                }
                case COLUMNWISE_SEPARATED: {
                    if (rowIdIncluded) {
                        throw new IllegalArgumentException();
                    }
                    this.varDataTop = this.topPos + this.fixedRowPartSize * rowCount;
                    break;
                }
                default: {
                    this.varDataTop = -1;
                }
            }
            this.varDataLast = this.varDataTop;
            this.partialVarDataOffset = 0;
        }

        public void setVarDataBaseOffset(long varDataBaseOffset) {
            this.varDataBaseOffset = varDataBaseOffset;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public long getLastRowId() {
            return this.lastRowId;
        }

        public void setRowId(long rowId) {
            this.lastRowId = rowId;
        }

        public boolean isRowIdIncluded() {
            return this.rowIdIncluded;
        }

        public boolean hasNext() {
            return this.rowIndex + 1 < this.rowCount;
        }

        public boolean isInRange() {
            return 0 <= this.rowIndex && this.rowIndex < this.rowCount;
        }

        public void reset() {
            this.rowIndex = -1;
            this.fieldIndex = -1;
            this.buffer.base().position(this.topPos);
            if (this.varDataLast >= 0) {
                this.buffer.base().limit(this.varDataLast);
            }
            this.varDataLast = this.varDataTop;
            this.partialVarDataOffset = 0;
            this.pendingPos = -1;
            this.lastRowId = -1L;
            if (this.nullsBytes != null) {
                Arrays.fill(this.nullsBytes, (byte)0);
            }
            this.nullFound = false;
        }

        public void resetBuffer() {
            this.buffer = null;
        }

        public void decode(boolean general, Object rowObj) throws GSException {
            if (this.mode == MappingMode.AGGREGATED) {
                RowMapper.this.decodeAggregation(this, general, rowObj);
            } else {
                if (RowMapper.this.rowType == AggregationResult.class) {
                    throw new GSException(145000, "Unexpected row type: AggregationResult");
                }
                this.beginRowInput();
                if (this.nullFound) {
                    for (Entry entry : RowMapper.this.entryList) {
                        entry.decode(this, rowObj, general);
                    }
                } else {
                    for (Entry entry : RowMapper.this.entryList) {
                        entry.decodeNoNull(this, rowObj, general);
                    }
                }
                this.endRowInput();
            }
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        private BasicBuffer getBuffer() {
            return this.buffer;
        }

        private MappingMode getMode() {
            return this.mode;
        }

        private boolean isVarSizeMode() {
            return this.mode == MappingMode.ROWWISE_SEPARATED_V2;
        }

        private void prepareOutput() {
            int limit = this.buffer.base().limit();
            if (limit < this.varDataTop) {
                this.buffer.prepare(this.varDataTop - this.buffer.base().position());
            }
        }

        private void skipRowInput(int skipCount) {
            if (this.rowIndex + skipCount < -1) {
                throw new IllegalStateException();
            }
            if (this.mode == MappingMode.COLUMNWISE_SEPARATED && this.rowIdIncluded) {
                throw new IllegalStateException();
            }
            this.rowIndex += skipCount;
            this.buffer.base().position(this.topPos + this.fixedRowPartSize * (this.rowIndex + 1));
        }

        private void beginRowInput() throws GSException {
            ++this.rowIndex;
            this.fieldIndex = -1;
            if (this.rowIdIncluded) {
                this.lastRowId = this.buffer.base().getLong();
            }
            if (this.mode == MappingMode.ROWWISE_SEPARATED_V2) {
                if (RowMapper.this.getVariableEntryCount() > 0) {
                    long varDataOffset = this.buffer.base().getLong();
                    if (this.rowIndex == 0) {
                        this.partialVarDataOffset = (int)varDataOffset;
                    }
                    this.varDataLast = this.varDataTop + (int)varDataOffset - this.partialVarDataOffset;
                    int savePos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataLast);
                    RowMapper.getVarSize(this.buffer);
                    this.varDataLast = this.buffer.base().position();
                    this.buffer.base().position(savePos);
                }
                this.buffer.base().get(this.nullsBytes);
                this.nullFound = false;
                for (int i = 0; i < this.nullsBytes.length; ++i) {
                    if (this.nullsBytes[i] == 0) continue;
                    this.nullFound = true;
                    break;
                }
            }
        }

        private void beginRowOutput() {
            if (this.rowIndex < 0) {
                this.prepareOutput();
            }
            if (this.rowIdIncluded) {
                if (this.lastRowId <= 0L) {
                    throw new IllegalStateException();
                }
                this.buffer.putLong(this.lastRowId);
                this.lastRowId = -1L;
            }
            if (this.mode == MappingMode.ROWWISE_SEPARATED_V2) {
                if (RowMapper.this.getVariableEntryCount() > 0) {
                    long varOffset = this.varDataLast - this.varDataTop;
                    this.buffer.putLong(varOffset);
                    int savePos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataLast);
                    RowMapper.putVarSize(this.buffer, RowMapper.this.getVariableEntryCount());
                    this.varDataLast = this.buffer.base().position();
                    this.buffer.base().position(savePos);
                }
                this.buffer.prepare(this.nullsBytes.length);
                this.buffer.base().put(this.nullsBytes);
            }
            ++this.rowIndex;
            this.fieldIndex = -1;
        }

        private void endRowInput() {
            if (this.varDataLast >= 0 && this.rowIndex + 1 >= this.rowCount) {
                this.buffer.base().position(this.varDataLast);
            }
        }

        private void endRowOutput() {
            if (this.nullFound) {
                int lastPos = this.buffer.base().position();
                int nullsOffset = 8 * ((this.rowIdIncluded ? 1 : 0) + (RowMapper.this.getVariableEntryCount() > 0 ? 1 : 0));
                this.buffer.base().position(lastPos - this.fixedRowPartSize + nullsOffset);
                this.buffer.base().put(this.nullsBytes);
                this.buffer.base().position(lastPos);
                Arrays.fill(this.nullsBytes, (byte)0);
                this.nullFound = false;
            }
            this.endRowInput();
        }

        private void beginField() {
            if (this.mode == MappingMode.COLUMNWISE_SEPARATED) {
                ++this.fieldIndex;
                int pos = this.fieldIndex == 0 ? this.topPos + RowMapper.this.getFixedFieldPartSize(0, this.mode) * this.rowIndex : this.buffer.base().position() + RowMapper.this.getFixedFieldPartSize(this.fieldIndex - 1, this.mode) * (this.rowCount - this.rowIndex - 1) + RowMapper.this.getFixedFieldPartSize(this.fieldIndex, this.mode) * this.rowIndex;
                this.buffer.base().position(pos);
            }
        }

        private void beginVarDataInput() {
            if (this.varDataTop >= 0) {
                if (this.pendingPos >= 0) {
                    throw new IllegalStateException();
                }
                if (this.mode == MappingMode.ROWWISE_SEPARATED_V2) {
                    this.pendingPos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataLast);
                } else {
                    int offset = (int)(this.buffer.base().getLong() - this.varDataBaseOffset);
                    this.pendingPos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataTop + offset);
                }
            }
        }

        private void beginVarDataOutput() {
            if (this.varDataTop >= 0) {
                if (this.pendingPos >= 0) {
                    throw new IllegalStateException();
                }
                if (this.mode == MappingMode.ROWWISE_SEPARATED_V2) {
                    this.pendingPos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataLast);
                } else {
                    int offset = this.varDataLast - this.varDataTop;
                    this.buffer.base().putLong(offset);
                    this.pendingPos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataLast);
                }
            }
        }

        private void endVarData() {
            if (this.varDataTop >= 0) {
                if (this.pendingPos < 0) {
                    throw new IllegalStateException();
                }
                this.varDataLast = this.buffer.base().position();
                this.buffer.base().position(this.pendingPos);
                this.pendingPos = -1;
            }
        }

        private boolean isNull(int ordinal) {
            return (this.nullsBytes[ordinal / 8] & 1 << ordinal % 8) != 0;
        }

        private void setNull(int ordinal) {
            int n = ordinal / 8;
            this.nullsBytes[n] = (byte)(this.nullsBytes[n] | 1 << ordinal % 8);
            this.nullFound = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        private static final int COLUMN_FLAG_ARRAY = 1;
        private static final int COLUMN_FLAG_NOT_NULL = 4;
        String columnName;
        transient String nameByField;
        transient String nameByGetter;
        transient Field rowTypeField;
        transient Method getterMethod;
        transient Method setterMethod;
        GSType elementType;
        boolean arrayUsed;
        boolean keyType;
        transient int order = -1;
        transient boolean orderSpecified;
        boolean columnNullable;
        boolean objectNullable;

        Entry(String columnName) {
            this.columnName = columnName;
        }

        void applyAccessibleObject(AccessibleObject ao) {
            this.keyType |= ao.getAnnotation(RowKey.class) != null;
            ao.setAccessible(true);
        }

        boolean reduceByAccessors() throws GSException {
            if (this.getterMethod != null || this.setterMethod != null) {
                if (this.getterMethod != null && this.setterMethod != null) {
                    this.rowTypeField = null;
                    if (this.nameByGetter == null) {
                        throw new Error();
                    }
                    this.columnName = this.nameByGetter;
                    return true;
                }
                if (this.getterMethod == null && Entry.findMappingAnnotations(this.setterMethod) || this.setterMethod == null && Entry.findMappingAnnotations(this.getterMethod)) {
                    throw new GSException("Inconsistent annotation");
                }
                this.getterMethod = null;
                this.setterMethod = null;
            }
            if (this.rowTypeField != null) {
                if (this.nameByField == null) {
                    throw new Error();
                }
                this.columnName = this.nameByField;
                return true;
            }
            return false;
        }

        static boolean findMappingAnnotations(AccessibleObject ao) {
            return ao.getAnnotation(RowField.class) != null || ao.getAnnotation(Nullable.class) != null || ao.getAnnotation(NotNull.class) != null;
        }

        void setNullableByAccessors(Boolean nullableDefault, boolean nullableAllowed) throws GSException {
            Boolean nullable = null;
            Field lastFoundTarget = null;
            for (int i = 0; i < 3; ++i) {
                Field target;
                AccessibleObject accessibleObject = i == 0 ? this.rowTypeField : (target = i == 1 ? this.getterMethod : this.setterMethod);
                if (target == null) continue;
                Boolean nextNullable = Entry.findNullableFromAccessor(target, lastFoundTarget, nullable, this);
                if (nullable != null || nextNullable == null) continue;
                lastFoundTarget = target;
                nullable = nextNullable;
            }
            this.columnNullable = this.filterNullable(nullable, nullableDefault, nullableAllowed);
        }

        static Boolean findNullableFromAccessor(AnnotatedElement target, AnnotatedElement lastFoundTarget, Boolean lastNullable, Entry entry) throws GSException {
            boolean curAccepted;
            block3: {
                Boolean nullable;
                block4: {
                    block2: {
                        nullable = lastNullable;
                        curAccepted = false;
                        if (target.getAnnotation(NotNull.class) == null) break block2;
                        if (nullable != null && nullable.booleanValue()) break block3;
                        nullable = false;
                        curAccepted = true;
                    }
                    if (target.getAnnotation(Nullable.class) == null) break block4;
                    if (nullable != null && !nullable.booleanValue()) break block3;
                    nullable = true;
                }
                return nullable;
            }
            throw new GSException(145023, "Inconsistent nullability annotations specified (" + (entry == null ? "" : "column=" + entry.columnName + ", ") + "target=" + target + (!curAccepted && lastFoundTarget != null ? ", conflictingTarget=" + lastFoundTarget : "") + ")");
        }

        void setNullableGeneral(Boolean nullable, boolean nullableAllowed) throws GSException {
            this.columnNullable = this.filterNullable(nullable, null, nullableAllowed);
            this.objectNullable = true;
        }

        boolean filterNullable(Boolean nullable, Boolean nullableDefault, boolean nullableAllowed) throws GSException {
            if (nullable != null && nullable.booleanValue()) {
                if (!nullableAllowed) {
                    throw new GSException(145023, "Nullable column is not currently available (column=" + this.columnName + ")");
                }
                if (this.keyType) {
                    throw new GSException(145023, "Row key cannot be null (column=" + this.columnName + ")");
                }
            }
            if (nullable == null) {
                if (this.keyType) {
                    return false;
                }
                if (nullableDefault != null) {
                    return nullableDefault;
                }
                return nullableAllowed;
            }
            return nullable;
        }

        void setObjectType(Class<?> objectType) throws GSException {
            this.elementType = RowMapper.resolveElementType(objectType, false, false);
            if (objectType.isArray()) {
                switch (this.elementType) {
                    case GEOMETRY: 
                    case BLOB: {
                        throw new GSException(145010, "BLOB or GEOMETRY must not be an element of array");
                    }
                }
                this.arrayUsed = true;
            } else {
                this.arrayUsed = false;
            }
            this.objectNullable = !objectType.isPrimitive();
        }

        GSType getFullType() {
            return RowMapper.toFullType(this.elementType, this.arrayUsed);
        }

        ColumnInfo getColumnInfo() {
            return new ColumnInfo(this.columnName, this.getFullType(), this.columnNullable, null);
        }

        void exportColumnSchema(BasicBuffer out) {
            out.putString(this.columnName == null ? "" : this.columnName);
            out.prepare(1);
            RowMapper.putTypePrepared(out, this.elementType);
            byte flags = 0;
            flags = (byte)(flags | (this.arrayUsed ? 1 : 0));
            flags = (byte)(flags | (this.columnNullable ? 0 : 4));
            out.put(flags);
        }

        void importColumnSchema(BasicBuffer in, int order, boolean nullableAllowed) throws GSException {
            this.columnName = in.getString();
            this.elementType = RowMapper.getType(in);
            byte flags = in.base().get();
            this.arrayUsed = (flags & 1) != 0;
            this.columnNullable = nullableAllowed && (flags & 4) == 0;
            this.order = order;
        }

        void importObjectMapping(Entry orgEntry, boolean orderIgnorable) throws GSException {
            if (this.order != orgEntry.order && (orgEntry.orderSpecified || !orderIgnorable)) {
                throw new GSException(145023, "Inconsistent column order (name=" + this.columnName + ", localOrder=" + orgEntry.order + ", remoteOrder=" + this.order + ")");
            }
            this.order = orgEntry.order;
            if (!RowMapper.normalizeSymbolUnchecked(this.columnName).equals(RowMapper.normalizeSymbolUnchecked(orgEntry.columnName)) || this.elementType != orgEntry.elementType || this.arrayUsed != orgEntry.arrayUsed || this.columnNullable != orgEntry.columnNullable) {
                throw new GSException(145023, "Inconsistent remote column");
            }
            this.rowTypeField = orgEntry.rowTypeField;
            this.getterMethod = orgEntry.getterMethod;
            this.setterMethod = orgEntry.setterMethod;
            this.objectNullable = orgEntry.objectNullable;
        }

        void encode(Cursor cursor, Object keyObj, Object rowObj, boolean general) throws GSException {
            Object fieldObj;
            Object object = fieldObj = !this.keyType || keyObj == null ? this.getFieldObj(rowObj, general) : keyObj;
            if (fieldObj == null && this.elementType != null) {
                if (!this.columnNullable) {
                    throw new NullPointerException("Null field (columnName=" + this.columnName + ", type=" + (Object)((Object)this.getFullType()) + ")");
                }
                cursor.setNull(this.order);
                fieldObj = this.getInitialObj(false, general);
            }
            RowMapper.putField(cursor, fieldObj, this.elementType, this.arrayUsed);
        }

        void decode(Cursor cursor, Object rowObj, boolean general) throws GSException {
            Object fieldObj = RowMapper.getField(cursor, this.elementType, this.arrayUsed);
            if (cursor.isNull(this.order)) {
                fieldObj = this.objectNullable && this.columnNullable ? null : this.getInitialObj(false, general);
            }
            this.setFieldObj(rowObj, fieldObj, general);
        }

        void decodeNoNull(Cursor cursor, Object rowObj, boolean general) throws GSException {
            Object fieldObj = RowMapper.getField(cursor, this.elementType, this.arrayUsed);
            this.setFieldObj(rowObj, fieldObj, general);
        }

        Object getFieldObj(Object rowObj, boolean general) throws GSException {
            if (general) {
                return ((Row)rowObj).getValue(this.order);
            }
            try {
                if (this.rowTypeField != null) {
                    return this.rowTypeField.get(rowObj);
                }
                return this.getterMethod.invoke(rowObj, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new GSException(145000, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new GSException(e);
            }
        }

        void setFieldObj(Object rowObj, Object fieldObj, boolean general) throws GSException {
            if (general) {
                if (rowObj.getClass() == ArrayRow.class) {
                    ((ArrayRow)rowObj).setAnyValueDirect(this.order, fieldObj);
                } else {
                    ((Row)rowObj).setValue(this.order, fieldObj);
                }
                return;
            }
            try {
                if (this.rowTypeField != null) {
                    this.rowTypeField.set(rowObj, fieldObj);
                } else {
                    this.setterMethod.invoke(rowObj, fieldObj);
                }
            }
            catch (IllegalAccessException e) {
                throw new GSException(145000, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new GSException(e);
            }
        }

        Object getInitialObj(boolean nullable, boolean general) {
            if (nullable && (general || this.objectNullable) && this.columnNullable) {
                return null;
            }
            if (this.elementType == null) {
                return null;
            }
            Object emptyObj = this.arrayUsed ? EMPTY_ARRAY_VALUES.get((Object)this.elementType) : EMPTY_ELEMENT_VALUES.get((Object)this.elementType);
            if (emptyObj == null) {
                throw new Error();
            }
            return emptyObj;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.arrayUsed ? 1231 : 1237);
            result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
            result = 31 * result + (this.columnNullable ? 1231 : 1237);
            result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
            result = 31 * result + (this.keyType ? 1231 : 1237);
            result = 31 * result + (this.objectNullable ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.arrayUsed != other.arrayUsed) {
                return false;
            }
            if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
                return false;
            }
            if (this.columnNullable != other.columnNullable) {
                return false;
            }
            if (this.elementType != other.elementType) {
                return false;
            }
            if (this.keyType != other.keyType) {
                return false;
            }
            return this.objectNullable == other.objectNullable;
        }
    }

    public static class Config {
        public boolean anyTypeAllowed;
        public boolean nullableAllowed;
        public boolean keyExtensible;

        public Config(boolean anyTypeAllowed, boolean nullableAllowed, boolean keyExtensible) {
            this.anyTypeAllowed = anyTypeAllowed;
            this.nullableAllowed = nullableAllowed;
            this.keyExtensible = keyExtensible;
        }
    }

    public static interface BlobFactory {
        public Blob createBlob(byte[] var1) throws GSException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MappingMode {
        NORMAL,
        ROWWISE_SEPARATED,
        ROWWISE_SEPARATED_V2,
        COLUMNWISE_SEPARATED,
        AGGREGATED;

    }
}

