/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.GSException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static int timeoutPropertyToIntSeconds(long value) {
        if (value < 0L) {
            return -1;
        }
        if (value >= 2147483647000L) {
            return Integer.MAX_VALUE;
        }
        return (int)(value / 1000L);
    }

    public static int timeoutPropertyToIntMillis(long value) {
        if (value < 0L) {
            return -1;
        }
        if (value >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)value;
    }

    public static void checkExclusiveProperties(Properties props, String ... nameList) throws GSException {
        int count = 0;
        for (String name : nameList) {
            if (!props.containsKey(name)) continue;
            ++count;
        }
        if (count > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("Either one of following properties ");
            builder.append("can be specified (");
            boolean found = false;
            for (String name : nameList) {
                if (!props.containsKey(name)) continue;
                if (!found) {
                    builder.append(", ");
                    found = true;
                }
                builder.append(name);
                builder.append("=");
                builder.append(props.getProperty(name));
            }
            builder.append(")");
            throw new GSException(145005, builder.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappedProperties {
        private final Properties base;
        private final Map<String, Boolean> visited = new HashMap<String, Boolean>();

        public WrappedProperties(Properties base) {
            this.base = base;
        }

        public Properties getBase() {
            return this.base;
        }

        public Long getTimeoutProperty(String name, Long defaultValue, boolean deprecated) throws GSException {
            String millisecName = name + "Millis";
            Integer secValue = this.getIntProperty(name, deprecated);
            Integer millisecValue = this.getIntProperty(millisecName, true);
            if (secValue != null && millisecValue != null) {
                throw new GSException(145005, "Property name conflicted: \"" + name + "\", \"" + millisecName + "\"");
            }
            Long value = secValue != null ? (secValue == Integer.MAX_VALUE ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf((long)secValue.intValue() * 1000L)) : (millisecValue != null ? Long.valueOf(millisecValue.intValue()) : defaultValue);
            if (value != null && value < 0L) {
                return -1L;
            }
            return value;
        }

        public Integer getIntProperty(String name, boolean deprecated) throws GSException {
            String strValue = this.getProperty(name, deprecated);
            if (strValue == null) {
                return null;
            }
            try {
                return Integer.valueOf(strValue);
            }
            catch (NumberFormatException e) {
                throw new GSException(145006, "Failed to parse as integer (value=" + strValue + ", propertyName=" + name + ", reason=" + e.getMessage() + ")", e);
            }
        }

        public Boolean getBooleanProperty(String name, Boolean defaultValue, boolean deprecated) throws GSException {
            String strValue = this.getProperty(name, deprecated);
            if (strValue == null) {
                return defaultValue;
            }
            return Boolean.valueOf(strValue);
        }

        public String getProperty(String name, boolean deprecated) {
            return this.getProperty(name, null, deprecated);
        }

        public String getProperty(String name, String defaultValue, boolean deprecated) {
            String value = this.base.getProperty(name, defaultValue);
            this.visited.put(name, value == null ? false : deprecated);
            return value == null ? defaultValue : value;
        }

        public Set<String> getUnknownNames() {
            HashSet<String> names = new HashSet<String>(this.base.stringPropertyNames());
            names.removeAll(this.visited.keySet());
            return names;
        }

        public Set<String> getDeprecatedNames() {
            Set<String> names = Collections.emptySet();
            for (Map.Entry<String, Boolean> entry : this.visited.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                if (names.isEmpty()) {
                    names = new HashSet<String>();
                }
                names.add(entry.getKey());
            }
            return names;
        }
    }
}

