/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.GridStoreFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class LoggingUtils {
    public static final String DEFAULT_LOGGER_NAME = "com.toshiba.mwcloud.gs.GridStoreLogger";
    public static final String[] SUB_LOGGER_NAMES = new String[]{"Config", "Heartbeat", "Discovery", "Connection", "Transaction", "StatementIO", "StatementExec"};
    private static final Map<String, BaseGridStoreLogger> SUB_LOGGERS = Collections.synchronizedMap(new HashMap());
    private static final BaseGridStoreLogger EMPTY_LOGGER = new BaseGridStoreLogger(){

        public void debug(String format, Object ... arguments) {
        }

        public void info(String format, Object ... arguments) {
        }

        public void warn(String format, Object ... arguments) {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return false;
        }
    };
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(LoggingUtils.class.getName());

    public static void registerLogger(String subName, BaseGridStoreLogger logger) {
        if (SUB_LOGGERS.containsKey(subName)) {
            throw new Error();
        }
        SUB_LOGGERS.put(subName, logger == null ? EMPTY_LOGGER : logger);
    }

    public static BaseGridStoreLogger getLogger(String subName) {
        BaseGridStoreLogger logger = SUB_LOGGERS.get(subName);
        if (logger == null) {
            throw new Error();
        }
        return logger;
    }

    public static String getFormatString(String key) {
        return BUNDLE.getString(key);
    }

    static {
        GridStoreFactory.getInstance();
    }

    public static abstract class BaseGridStoreLogger {
        public abstract void debug(String var1, Object ... var2);

        public abstract void info(String var1, Object ... var2);

        public abstract void warn(String var1, Object ... var2);

        public abstract boolean isDebugEnabled();

        public abstract boolean isInfoEnabled();

        public abstract boolean isWarnEnabled();
    }
}

