/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.contrib.org.json.simple.JSONValue;
import com.toshiba.mwcloud.gs.contrib.org.json.simple.parser.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtils {
    public static Object parse(String value) throws GSException {
        try {
            return JSONValue.parseWithException(value);
        }
        catch (ParseException e) {
            throw JsonUtils.fromParseException(e);
        }
    }

    public static Object parse(Reader reader) throws GSException {
        try {
            return JSONValue.parseWithException(reader);
        }
        catch (ParseException e) {
            throw JsonUtils.fromParseException(e);
        }
        catch (IOException e) {
            throw new GSException(e);
        }
    }

    private static GSException fromParseException(ParseException e) {
        String description = e.getMessage();
        return new GSException(121500, "Failed to parse JSON (reason=" + description + ")", e);
    }

    public static <T> T as(Class<T> type, Object value) throws GSException {
        if (!type.isInstance(value)) {
            throw new GSException(121503, "Json type unmatched (expected=" + type.getName() + ", actual=" + (value == null ? "null" : value.getClass().getName()) + ")");
        }
        return type.cast(value);
    }

    public static Map<String, Object> asObject(Object value) throws GSException {
        return JsonUtils.as(Map.class, value);
    }

    public static List<Object> asArray(Object value) throws GSException {
        return JsonUtils.as(List.class, value);
    }

    public static long asLong(Object value) throws GSException {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        double base = JsonUtils.as(Double.class, value);
        long min = Long.MIN_VALUE;
        long max = Long.MAX_VALUE;
        long result = (long)base;
        if (!(-9.223372036854776E18 <= base) || !(base <= 9.223372036854776E18) || Long.MIN_VALUE > result || result > Long.MAX_VALUE) {
            throw new GSException(121502, "Json value out of range (value=" + value + ", min=" + Long.MIN_VALUE + ", max=" + Long.MAX_VALUE + ")");
        }
        return result;
    }

    public static <T> T as(Class<T> type, Object value, String key) throws GSException {
        Map<String, Object> object = JsonUtils.asObject(value);
        Object found = object.get(key);
        if (found == null) {
            throw new GSException(121501, "Json object does not contain the specified key (key=" + key + ")");
        }
        return JsonUtils.as(type, found);
    }

    public static Map<String, Object> asObject(Object value, String key) throws GSException {
        return JsonUtils.asObject(JsonUtils.as(Object.class, value, key));
    }

    public static List<Object> asArray(Object value, String key) throws GSException {
        return JsonUtils.asArray(JsonUtils.as(Object.class, value, key));
    }

    public static long asLong(Object value, String key) throws GSException {
        return JsonUtils.asLong(JsonUtils.as(Object.class, value, key));
    }
}

