/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerProperties {
    private static final Key[] BUILTIN_KEYS = Key.values();
    private ContainerInfo info;
    private ContainerIdInfo idInfo;
    private Integer attribute;
    private Map<Integer, byte[]> rawEntries;

    public ContainerInfo getInfo() {
        return this.info;
    }

    public void setInfo(ContainerInfo info) {
        this.info = info;
    }

    public ContainerIdInfo getIdInfo() {
        return this.idInfo;
    }

    public void setIdInfo(ContainerIdInfo idInfo) {
        this.idInfo = idInfo;
    }

    public Integer getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Integer attribute) {
        this.attribute = attribute;
    }

    public Map<Integer, byte[]> getRawEntries() {
        return this.rawEntries;
    }

    public void setRawEntries(Map<Integer, byte[]> rawEntries) {
        this.rawEntries = rawEntries;
    }

    public static Key tryResolveKey(int rawkey) {
        if (rawkey < BUILTIN_KEYS.length) {
            return BUILTIN_KEYS[rawkey];
        }
        return null;
    }

    public static ContainerInfo findInfo(ContainerProperties props) {
        if (props == null) {
            return null;
        }
        return props.getInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeySet {
        private final Integer[] rawKeys;

        public KeySet(Set<Key> keys, Integer ... rawKeys) {
            TreeSet<Integer> allKeys = new TreeSet<Integer>();
            for (Key key : keys) {
                allKeys.add(key.ordinal());
            }
            if (rawKeys != null) {
                List<Integer> rawKeyList = Arrays.asList(rawKeys);
                allKeys.removeAll(rawKeyList);
                allKeys.addAll(rawKeyList);
            }
            this.rawKeys = allKeys.toArray(new Integer[allKeys.size()]);
        }

        public Integer[] getRawKeys() {
            return this.rawKeys;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Key {
        ID,
        SCHEMA,
        INDEX,
        EVENT_NOTIFICATION,
        TRIGGER,
        ATTRIBUTE,
        INDEX_DETAIL;

    }

    public static class ContainerIdInfo {
        public final int versionId;
        public final long containerId;
        public final ContainerKeyConverter.ContainerKey remoteKey;

        public ContainerIdInfo(int versionId, long containerId, ContainerKeyConverter.ContainerKey remoteKey) {
            this.versionId = versionId;
            this.containerId = containerId;
            this.remoteKey = remoteKey;
        }
    }
}

