/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimestampUtils {
    private static final boolean TRIM_MILLISECONDS = false;

    @Deprecated
    public TimestampUtils() {
    }

    public static Date current() {
        return TimestampUtils.currentCalendar().getTime();
    }

    public static Calendar currentCalendar() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return calendar;
    }

    public static Date add(Date timestamp, int amount, TimeUnit timeUnit) {
        Calendar calendar = TimestampUtils.currentCalendar();
        try {
            calendar.setTime(timestamp);
            calendar.add(TimestampUtils.toCalendarField(timeUnit), amount);
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(timestamp, "timestamp", e);
            GSErrorCode.checkNullParameter((Object)timeUnit, "timeUnit", e);
            throw e;
        }
        return calendar.getTime();
    }

    private static int toCalendarField(TimeUnit timeUnit) {
        switch (timeUnit) {
            case YEAR: {
                return 1;
            }
            case MONTH: {
                return 2;
            }
            case DAY: {
                return 5;
            }
            case HOUR: {
                return 10;
            }
            case MINUTE: {
                return 12;
            }
            case SECOND: {
                return 13;
            }
            case MILLISECOND: {
                return 14;
            }
        }
        throw new Error("Internal error by unknown time unit (timeUnit=" + (Object)((Object)timeUnit) + ")");
    }

    public static String format(Date timestamp) {
        try {
            return TimestampUtils.getFormat().format(timestamp);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(timestamp, "timestamp", e);
        }
    }

    public static Date parse(String source) throws ParseException {
        try {
            return TimestampUtils.getFormat().parse(source);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(source, "source", e);
        }
    }

    public static DateFormat getFormat() {
        return new CustomDateFormat();
    }

    private static class CustomDateFormat
    extends DateFormat {
        private static final long serialVersionUID = -5296445605735800942L;
        private static final int SECONDS_FORMAT_LENGTH = 20;
        private static final int MILLIS_FORMAT_LENGTH = 24;
        private static final int MILLIS_DOT_POSITION = 19;
        private DateFormat secondsFormat;
        private DateFormat millisFormat;

        private CustomDateFormat() {
        }

        private DateFormat getSecondsFormat() {
            if (this.secondsFormat == null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
                format.setLenient(false);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                this.secondsFormat = format;
            }
            return this.secondsFormat;
        }

        private DateFormat getMillisFormat() {
            if (this.millisFormat == null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
                format.setLenient(false);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                this.millisFormat = format;
            }
            return this.millisFormat;
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return this.getMillisFormat().format(date, toAppendTo, fieldPosition);
        }

        public Date parse(String source, ParsePosition pos) {
            if (source.length() > 19 && source.charAt(19) == '.') {
                if (source.length() != 24) {
                    return null;
                }
                return this.getMillisFormat().parse(source, pos);
            }
            if (source.length() != 20) {
                return null;
            }
            return this.getSecondsFormat().parse(source, pos);
        }

        public void setCalendar(Calendar newCalendar) {
            throw new UnsupportedOperationException("Modification is currently not supported");
        }

        public void setNumberFormat(NumberFormat newNumberFormat) {
            throw new UnsupportedOperationException("Modification is currently not supported");
        }

        public void setTimeZone(TimeZone zone) {
            throw new UnsupportedOperationException("Modification is currently not supported");
        }

        public void setLenient(boolean lenient) {
            throw new UnsupportedOperationException("Modification is currently not supported");
        }

        public int hashCode() {
            return CustomDateFormat.class.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }
    }
}

