/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.common.GSErrorCode;

public class IndexInfo {
    private IndexType type;
    private String name;
    private Integer column;
    private String columnName;

    public IndexInfo() {
    }

    public IndexInfo(IndexInfo info) {
        try {
            this.type = info.type;
            this.name = info.name;
            this.column = info.column;
            this.columnName = info.columnName;
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(info, "info", e);
        }
    }

    public static IndexInfo createByColumn(String columnName, IndexType type) {
        IndexInfo info = new IndexInfo();
        info.setColumnName(columnName);
        info.setType(type);
        return info;
    }

    public static IndexInfo createByName(String name, IndexType type) {
        IndexInfo info = new IndexInfo();
        info.setName(name);
        info.setType(type);
        return info;
    }

    public IndexType getType() {
        return this.type;
    }

    public void setType(IndexType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getColumn() {
        return this.column;
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    IndexInfo toUnmodifiable() {
        return new Unmodifiable(this);
    }

    private static class Unmodifiable
    extends IndexInfo {
        Unmodifiable(IndexInfo info) {
            super.setType(info.getType());
            super.setName(info.getName());
            super.setColumn(info.getColumn());
            super.setColumnName(info.getColumnName());
        }

        public void setType(IndexType type) {
            throw new UnsupportedOperationException();
        }

        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        public void setColumn(Integer column) {
            throw new UnsupportedOperationException();
        }

        public void setColumnName(String columnName) {
            throw new UnsupportedOperationException();
        }

        IndexInfo toUnmodifiable() {
            return this;
        }
    }
}

