/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.common.LoggingUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class GridStoreLogger
extends LoggingUtils.BaseGridStoreLogger {
    private static int SUITABLE_LOGGER_MAJOR = 1;
    private static int SUITABLE_LOGGER_MINOR = 6;
    final Logger base;

    GridStoreLogger() {
        LoggerFactory.getLogger(GridStoreLogger.class);
        this.base = LoggerFactory.getLogger((String)this.getClass().getName().replace('$', '.'));
    }

    public boolean isDebugEnabled() {
        return this.base.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.base.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.base.isWarnEnabled();
    }

    private static String fmt(String key) {
        return LoggingUtils.getFormatString(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkVersion(LoggingUtils.BaseGridStoreLogger logger) {
        BufferedReader reader = null;
        Pattern versionPattern = Pattern.compile("^Bundle-Version: (([0-9]+)\\.([0-9]+)\\.[0-9]+)");
        for (URL url : Collections.list(LoggerFactory.class.getClassLoader().getResources("META-INF/MANIFEST.MF"))) {
            String line;
            reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            boolean libraryFound = false;
            String version = null;
            boolean versionSuitable = false;
            while ((line = reader.readLine()) != null) {
                if (line.equals("Bundle-SymbolicName: slf4j.api")) {
                    libraryFound = true;
                } else {
                    Matcher matcher = versionPattern.matcher(line);
                    if (matcher.find()) {
                        version = matcher.group(1);
                        int major = Integer.parseInt(matcher.group(2));
                        int minor = Integer.parseInt(matcher.group(3));
                        if (major > SUITABLE_LOGGER_MAJOR || major == SUITABLE_LOGGER_MAJOR && minor >= SUITABLE_LOGGER_MINOR) {
                            versionSuitable = true;
                        }
                    }
                }
                if (!libraryFound || version == null) continue;
            }
            if (libraryFound && version != null && !versionSuitable) {
                logger.warn("config.slf4jVersionNotSuitable", SUITABLE_LOGGER_MAJOR + "." + SUITABLE_LOGGER_MINOR + ".0", version);
            }
            reader.close();
            reader = null;
        }
        Object var13_13 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException e) {
                logger.warn("config.slf4jVersionCheckFailed", e);
                Object var13_14 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static class StatementExec
    extends GridStoreLogger {
        StatementExec() {
        }

        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class StatementIO
    extends GridStoreLogger {
        StatementIO() {
        }

        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class Transaction
    extends GridStoreLogger {
        Transaction() {
        }

        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class Connection
    extends GridStoreLogger {
        Connection() {
        }

        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class Discovery
    extends GridStoreLogger {
        Discovery() {
        }

        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class Heartbeat
    extends GridStoreLogger {
        Heartbeat() {
        }

        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class Config
    extends GridStoreLogger {
        Config() {
            GridStoreLogger.checkVersion(this);
        }

        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }
}

