/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.common.GridStoreFactoryProvider;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import java.io.Closeable;
import java.util.Collections;
import java.util.Properties;

public abstract class GridStoreFactory
implements Closeable {
    private static final GridStoreFactory INSTANCE;

    protected GridStoreFactory() {
    }

    private static GridStoreFactory newInstance() {
        return GridStoreFactoryProvider.getProvider(GridStoreFactoryProvider.class, GridStoreFactory.class, Collections.<Class<?>>emptySet()).getFactory();
    }

    public static GridStoreFactory getInstance() {
        return INSTANCE;
    }

    public abstract GridStore getGridStore(Properties var1) throws GSException;

    public abstract void setProperties(Properties var1) throws GSException;

    public abstract void close() throws GSException;

    private static void registerLoggers() {
        boolean loggerAvailable = false;
        try {
            Class.forName("org.slf4j.Logger");
            Class.forName("org.slf4j.LoggerFactory");
            loggerAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (String subName : LoggingUtils.SUB_LOGGER_NAMES) {
            LoggingUtils.BaseGridStoreLogger logger;
            if (loggerAvailable) {
                try {
                    logger = (LoggingUtils.BaseGridStoreLogger)Class.forName("com.toshiba.mwcloud.gs.GridStoreLogger$" + subName).newInstance();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            } else {
                logger = null;
            }
            LoggingUtils.registerLogger(subName, logger);
        }
    }

    static {
        GridStoreFactory.registerLoggers();
        INSTANCE = GridStoreFactory.newInstance();
    }
}

