/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.common.GSErrorCode;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSException
extends IOException {
    private static final long serialVersionUID = -7261622831192521426L;
    private static final Map<String, String> EMPTY_PARAMETERS = Collections.emptyMap();
    private final int errorCode;
    private final String errorName;
    private final String description;
    private final Map<String, String> parameters;

    public GSException() {
        this.errorCode = 0;
        this.errorName = null;
        this.description = null;
        this.parameters = EMPTY_PARAMETERS;
    }

    public GSException(String message, Throwable cause) {
        super(cause);
        this.errorCode = GSException.resolveErrorCode(0, cause);
        this.errorName = GSException.resolveErrorName(0, null, cause);
        this.description = GSException.resolveDescription(message, cause);
        this.parameters = EMPTY_PARAMETERS;
    }

    public GSException(String message) {
        this.errorCode = 0;
        this.errorName = null;
        this.description = message;
        this.parameters = EMPTY_PARAMETERS;
    }

    public GSException(Throwable cause) {
        super(cause);
        this.errorCode = GSException.resolveErrorCode(0, cause);
        this.errorName = GSException.resolveErrorName(0, null, cause);
        this.description = GSException.resolveDescription(null, cause);
        this.parameters = GSException.resolveParameters(null, cause);
    }

    public GSException(int errorCode, String description, Throwable cause) {
        super(cause);
        this.errorCode = GSException.resolveErrorCode(errorCode, cause);
        this.errorName = GSException.resolveErrorName(errorCode, null, cause);
        this.description = GSException.resolveDescription(description, cause);
        this.parameters = EMPTY_PARAMETERS;
    }

    public GSException(int errorCode, String description) {
        this.errorCode = GSException.resolveErrorCode(errorCode, null);
        this.errorName = GSException.resolveErrorName(errorCode, null, null);
        this.description = GSException.resolveDescription(description, null);
        this.parameters = EMPTY_PARAMETERS;
    }

    public GSException(int errorCode, Throwable cause) {
        super(cause);
        this.errorCode = GSException.resolveErrorCode(errorCode, cause);
        this.errorName = GSException.resolveErrorName(errorCode, null, null);
        this.description = GSException.resolveDescription(null, cause);
        this.parameters = EMPTY_PARAMETERS;
    }

    public GSException(int errorCode, String errorName, String description, Throwable cause) {
        super(cause);
        this.errorCode = GSException.resolveErrorCode(errorCode, cause);
        this.errorName = GSException.resolveErrorName(errorCode, errorName, cause);
        this.description = GSException.resolveDescription(description, cause);
        this.parameters = EMPTY_PARAMETERS;
    }

    public GSException(int errorCode, String errorName, String description, Map<String, String> parameters, Throwable cause) {
        super(cause);
        this.errorCode = GSException.resolveErrorCode(errorCode, cause);
        this.errorName = GSException.resolveErrorName(errorCode, errorName, cause);
        this.description = GSException.resolveDescription(description, cause);
        this.parameters = GSException.resolveParameters(parameters, null);
    }

    private static int resolveErrorCode(int errorCode, Throwable cause) {
        if (errorCode != 0) {
            return errorCode;
        }
        if (cause instanceof GSException) {
            return ((GSException)cause).getErrorCode();
        }
        return 0;
    }

    private static String resolveErrorName(int errorCode, String errorName, Throwable cause) {
        if (errorCode != 0 && errorName != null) {
            return errorName;
        }
        if (cause instanceof GSException) {
            GSException gsCause = (GSException)cause;
            if (errorCode == 0 || errorCode == gsCause.getErrorCode()) {
                return gsCause.errorName;
            }
        }
        return null;
    }

    private static String resolveDescription(String description, Throwable cause) {
        if (description != null) {
            return description;
        }
        if (cause instanceof GSException) {
            return ((GSException)cause).description;
        }
        if (cause != null) {
            return cause.getMessage();
        }
        return null;
    }

    private static Map<String, String> resolveParameters(Map<String, String> parameters, Throwable cause) {
        if (parameters != null) {
            if (!parameters.isEmpty()) {
                return Collections.unmodifiableMap(GSErrorCode.newParameters(parameters));
            }
        } else if (cause instanceof GSException) {
            return ((GSException)cause).parameters;
        }
        return EMPTY_PARAMETERS;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getMessage() {
        if (this.errorCode == 0 && this.description == null) {
            return super.getMessage();
        }
        if (this.errorCode == 0) {
            return this.description;
        }
        String resolvedErrorName = this.errorName == null ? GSErrorCode.getName(this.errorCode) : this.errorName;
        StringBuilder builder = new StringBuilder();
        if (resolvedErrorName == null) {
            builder.append("[Code:").append(this.errorCode).append("]");
        } else {
            builder.append("[").append(this.errorCode).append(":");
            builder.append(resolvedErrorName).append("]");
        }
        if (this.description != null) {
            builder.append(" ").append(this.description);
        }
        return builder.toString();
    }

    static {
        GSErrorCode.setExceptionAccessor(new GSErrorCode.ExceptionAccessor(){

            public String getDescription(GSException e) {
                return e.description;
            }
        });
    }
}

