/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.ColumnInfo;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.IndexInfo;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.TimeSeriesProperties;
import com.toshiba.mwcloud.gs.TriggerInfo;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.RowMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerInfo {
    private String name;
    private ContainerType type;
    private List<ColumnInfo> columnInfoList;
    private List<IndexInfo> indexInfoList;
    private boolean rowKeyAssigned;
    private TimeSeriesProperties timeSeriesProperties;
    private boolean columnOrderIgnorable;
    private List<TriggerInfo> triggerInfoList;
    private String dataAffinity;

    public ContainerInfo(String name, ContainerType type, List<ColumnInfo> columnInfoList, boolean rowKeyAssigned) {
        try {
            this.name = name;
            this.type = type;
            this.columnInfoList = new ArrayList<ColumnInfo>(columnInfoList);
            this.indexInfoList = Collections.emptyList();
            this.rowKeyAssigned = rowKeyAssigned;
            this.triggerInfoList = Collections.emptyList();
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(columnInfoList, "columnInfoList", e);
        }
    }

    public ContainerInfo() {
        this.columnInfoList = Collections.emptyList();
        this.indexInfoList = Collections.emptyList();
        this.triggerInfoList = Collections.emptyList();
    }

    public ContainerInfo(ContainerInfo containerInfo) {
        this();
        this.setName(containerInfo.getName());
        this.setType(containerInfo.getType());
        int columnCount = containerInfo.getColumnCount();
        if (columnCount > 0) {
            ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
            for (int i = 0; i < columnCount; ++i) {
                columnInfoList.add(containerInfo.getColumnInfo(i));
            }
            this.setColumnInfoList(columnInfoList);
        }
        this.setRowKeyAssigned(containerInfo.isRowKeyAssigned());
        this.setIndexInfoList(containerInfo.getIndexInfoList());
        this.setTimeSeriesProperties(containerInfo.getTimeSeriesProperties());
        this.setTriggerInfoList(containerInfo.getTriggerInfoList());
        this.setDataAffinity(containerInfo.getDataAffinity());
    }

    public String getName() {
        return this.name;
    }

    public ContainerType getType() {
        return this.type;
    }

    public int getColumnCount() {
        return this.columnInfoList.size();
    }

    public ColumnInfo getColumnInfo(int column) {
        try {
            return this.columnInfoList.get(column);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Column number out of range (column=" + column + ", reason=" + e.getMessage() + ")", e);
        }
    }

    public boolean isRowKeyAssigned() {
        return this.rowKeyAssigned;
    }

    public boolean isColumnOrderIgnorable() {
        return this.columnOrderIgnorable;
    }

    public void setColumnOrderIgnorable(boolean ignorable) {
        this.columnOrderIgnorable = ignorable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(ContainerType type) {
        this.type = type;
    }

    public void setColumnInfoList(List<ColumnInfo> columnInfoList) {
        if (columnInfoList == null) {
            this.columnInfoList = Collections.emptyList();
            return;
        }
        this.columnInfoList = new ArrayList<ColumnInfo>(columnInfoList);
    }

    public void setRowKeyAssigned(boolean assigned) {
        this.rowKeyAssigned = assigned;
    }

    public List<IndexInfo> getIndexInfoList() {
        return this.indexInfoList;
    }

    public void setIndexInfoList(List<IndexInfo> indexInfoList) {
        if (indexInfoList == null || indexInfoList.isEmpty()) {
            this.indexInfoList = Collections.emptyList();
            return;
        }
        ArrayList<IndexInfo> dest = new ArrayList<IndexInfo>(indexInfoList.size());
        for (IndexInfo info : indexInfoList) {
            dest.add(info.toUnmodifiable());
        }
        this.indexInfoList = Collections.unmodifiableList(dest);
    }

    public TimeSeriesProperties getTimeSeriesProperties() {
        return this.timeSeriesProperties;
    }

    public void setTimeSeriesProperties(TimeSeriesProperties props) {
        if (props == null) {
            this.timeSeriesProperties = null;
            return;
        }
        this.timeSeriesProperties = props.clone();
    }

    @Deprecated
    public Set<IndexType> getIndexTypes(int column) {
        throw new Error("Not supported on any version except for V1.5 beta");
    }

    @Deprecated
    public void setIndexTypes(int column, Set<IndexType> indexTypes) {
        throw new Error("Not supported on any version except for V1.5 beta");
    }

    public List<TriggerInfo> getTriggerInfoList() {
        return this.triggerInfoList;
    }

    public void setTriggerInfoList(List<TriggerInfo> triggerInfoList) {
        if (triggerInfoList == null) {
            this.triggerInfoList = Collections.emptyList();
            return;
        }
        this.triggerInfoList = Collections.unmodifiableList(new ArrayList<TriggerInfo>(triggerInfoList));
    }

    public String getDataAffinity() {
        return this.dataAffinity;
    }

    public void setDataAffinity(String dataAffinity) {
        if (dataAffinity != null) {
            try {
                RowMapper.checkSymbol(dataAffinity, "data affinity");
            }
            catch (GSException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.dataAffinity = dataAffinity;
    }
}

