/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.NoArgsFactory;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import com.github.f4b6a3.uuid.factory.function.ClockSeqFunction;
import com.github.f4b6a3.uuid.factory.function.NodeIdFunction;
import com.github.f4b6a3.uuid.factory.function.TimeFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultClockSeqFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultNodeIdFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultTimeFunction;
import com.github.f4b6a3.uuid.factory.function.impl.HashNodeIdFunction;
import com.github.f4b6a3.uuid.factory.function.impl.MacNodeIdFunction;
import com.github.f4b6a3.uuid.factory.function.impl.RandomNodeIdFunction;
import com.github.f4b6a3.uuid.factory.function.impl.WindowsTimeFunction;
import com.github.f4b6a3.uuid.util.UuidTime;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import com.github.f4b6a3.uuid.util.internal.SettingsUtil;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstTimeBasedFactory
extends UuidFactory
implements NoArgsFactory {
    protected TimeFunction timeFunction;
    protected NodeIdFunction nodeidFunction;
    protected ClockSeqFunction clockseqFunction;
    private static final String NODE_MAC = "mac";
    private static final String NODE_HASH = "hash";
    private static final String NODE_RANDOM = "random";
    protected final ReentrantLock lock = new ReentrantLock();
    private static final long EPOCH_TIMESTAMP = TimeFunction.toUnixTimestamp(UuidTime.EPOCH_GREG);

    protected AbstTimeBasedFactory(UuidVersion version, Builder<?, ?> builder) {
        super(version);
        this.timeFunction = builder.getTimeFunction();
        this.nodeidFunction = builder.getNodeIdFunction();
        this.clockseqFunction = builder.getClockSeqFunction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID create() {
        this.lock.lock();
        try {
            long timestamp = TimeFunction.toExpectedRange(this.timeFunction.getAsLong() - EPOCH_TIMESTAMP);
            long nodeIdentifier = NodeIdFunction.toExpectedRange(this.nodeidFunction.getAsLong());
            long clockSequence = ClockSeqFunction.toExpectedRange(this.clockseqFunction.applyAsLong(timestamp));
            long msb = this.formatMostSignificantBits(timestamp);
            long lsb = this.formatLeastSignificantBits(nodeIdentifier, clockSequence);
            UUID uUID = new UUID(msb, lsb);
            return uUID;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected long formatMostSignificantBits(long timestamp) {
        return (timestamp & 0xFFF000000000000L) >>> 48 | (timestamp & 0xFFFF00000000L) >>> 16 | (timestamp & 0xFFFFFFFFL) << 32 | 0x1000L;
    }

    protected long formatLeastSignificantBits(long nodeIdentifier, long clockSequence) {
        return (clockSequence << 48 | nodeIdentifier & 0xFFFFFFFFFFFFL) & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
    }

    protected static NodeIdFunction selectNodeIdFunction() {
        String string = SettingsUtil.getProperty("node");
        if (NODE_MAC.equalsIgnoreCase(string)) {
            return new MacNodeIdFunction();
        }
        if (NODE_HASH.equalsIgnoreCase(string)) {
            return new HashNodeIdFunction();
        }
        if (NODE_RANDOM.equalsIgnoreCase(string)) {
            return new RandomNodeIdFunction();
        }
        Long number = SettingsUtil.getNodeIdentifier();
        if (number != null) {
            long nodeid = NodeIdFunction.toExpectedRange(number);
            return () -> nodeid;
        }
        return new DefaultNodeIdFunction();
    }

    protected static TimeFunction selectTimeFunction() {
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase().startsWith("win")) {
            return new WindowsTimeFunction();
        }
        return new DefaultTimeFunction();
    }

    public static abstract class Builder<T, B extends Builder<T, B>> {
        protected TimeFunction timeFunction;
        protected NodeIdFunction nodeidFunction;
        protected ClockSeqFunction clockseqFunction;

        protected TimeFunction getTimeFunction() {
            if (this.timeFunction == null) {
                this.timeFunction = AbstTimeBasedFactory.selectTimeFunction();
            }
            return this.timeFunction;
        }

        protected NodeIdFunction getNodeIdFunction() {
            if (this.nodeidFunction == null) {
                this.nodeidFunction = AbstTimeBasedFactory.selectNodeIdFunction();
            }
            return this.nodeidFunction;
        }

        protected ClockSeqFunction getClockSeqFunction() {
            if (this.clockseqFunction == null) {
                this.clockseqFunction = new DefaultClockSeqFunction();
            }
            return this.clockseqFunction;
        }

        public B withTimeFunction(TimeFunction timeFunction) {
            this.timeFunction = timeFunction;
            return (B)this;
        }

        public B withNodeIdFunction(NodeIdFunction nodeidFunction) {
            this.nodeidFunction = nodeidFunction;
            return (B)this;
        }

        public B withClockSeqFunction(ClockSeqFunction clockseqFunction) {
            this.clockseqFunction = clockseqFunction;
            return (B)this;
        }

        public B withInstant(Instant instant) {
            long timestamp = TimeFunction.toUnixTimestamp(instant);
            this.timeFunction = () -> timestamp;
            return (B)this;
        }

        public B withClockSeq(long clockseq) {
            long clockSequence = ClockSeqFunction.toExpectedRange(clockseq);
            this.clockseqFunction = x -> clockSequence;
            return (B)this;
        }

        public B withClockSeq(byte[] clockseq) {
            long clockSequence = ClockSeqFunction.toExpectedRange(ByteUtil.toNumber(clockseq));
            this.clockseqFunction = x -> clockSequence;
            return (B)this;
        }

        public B withNodeId(long nodeid) {
            long nodeIdentifier = NodeIdFunction.toExpectedRange(nodeid);
            this.nodeidFunction = () -> nodeIdentifier;
            return (B)this;
        }

        public B withNodeId(byte[] nodeid) {
            long nodeIdentifier = NodeIdFunction.toExpectedRange(ByteUtil.toNumber(nodeid));
            this.nodeidFunction = () -> nodeIdentifier;
            return (B)this;
        }

        public B withMacNodeId() {
            this.nodeidFunction = new MacNodeIdFunction();
            return (B)this;
        }

        public B withHashNodeId() {
            this.nodeidFunction = new HashNodeIdFunction();
            return (B)this;
        }

        public B withRandomNodeId() {
            this.nodeidFunction = new RandomNodeIdFunction();
            return (B)this;
        }

        public abstract T build();
    }
}

