/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.utils;

import com.github.drinkjava2.jdialects.ColumnDef;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.annotation.GenerationType;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.SequenceGen;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jdialects.springsrc.utils.ReflectionUtils;
import com.github.drinkjava2.jdialects.utils.StrUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ConvertUtils {
    private static boolean matchNameCheck(String annotationName, String cName) {
        if (("javax.persistence." + annotationName).equals(cName)) {
            return true;
        }
        if (("com.github.drinkjava2.jdialects.annotation." + annotationName).equals(cName)) {
            return true;
        }
        for (int i = 1; i <= 3; ++i) {
            if (!("com.github.drinkjava2.jdialects.annotation." + annotationName + i).equals(cName)) continue;
            return true;
        }
        return false;
    }

    private static List<Map<String, Object>> getPojoAnnotations(Object targetClass, String annotationName) {
        Annotation[] anno = null;
        anno = targetClass instanceof Field ? ((Field)targetClass).getAnnotations() : ((Class)targetClass).getAnnotations();
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        for (Annotation annotation : anno) {
            Class<? extends Annotation> type = annotation.annotationType();
            String cName = type.getName();
            if (!ConvertUtils.matchNameCheck(annotationName, cName)) continue;
            l.add(ConvertUtils.changeAnnotationValuesToMap(annotation, type));
        }
        return l;
    }

    private static Map<String, Object> getFirstPojoAnnotation(Object targetClass, String annotationName) {
        Annotation[] anno = null;
        anno = targetClass instanceof Field ? ((Field)targetClass).getAnnotations() : ((Class)targetClass).getAnnotations();
        for (Annotation annotation : anno) {
            Class<? extends Annotation> type = annotation.annotationType();
            String cName = type.getName();
            if (!ConvertUtils.matchNameCheck(annotationName, cName)) continue;
            return ConvertUtils.changeAnnotationValuesToMap(annotation, type);
        }
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> changeAnnotationValuesToMap(Annotation annotation, Class<? extends Annotation> type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("AnnotationExist", true);
        for (Method method : type.getDeclaredMethods()) {
            try {
                result.put(method.getName(), method.invoke((Object)annotation, (Object[])null));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static TableModel[] pojo2Model(Class<?> ... pojoClasses) {
        ArrayList<TableModel> l = new ArrayList<TableModel>();
        for (Class<?> clazz : pojoClasses) {
            l.add(ConvertUtils.onePojo2Model(clazz));
        }
        return l.toArray(new TableModel[l.size()]);
    }

    private static TableModel onePojo2Model(Class<?> pojoClass) {
        DialectException.assureNotNull(pojoClass, "pojo2Model method does not accept a null class");
        String tableName = null;
        Map<String, Object> entityMap = ConvertUtils.getFirstPojoAnnotation(pojoClass, "Entity");
        tableName = (String)entityMap.get("name");
        Map<String, Object> tableMap = ConvertUtils.getFirstPojoAnnotation(pojoClass, "Table");
        if (!StrUtils.isEmpty(tableMap.get("name"))) {
            tableName = (String)tableMap.get("name");
        }
        if (StrUtils.isEmpty(tableName)) {
            tableName = pojoClass.getSimpleName();
        }
        TableModel model = new TableModel(tableName);
        if (!tableMap.isEmpty()) {
            Annotation[] uniques;
            Annotation[] indexes = (Annotation[])tableMap.get("indexes");
            if (indexes != null && indexes.length > 0) {
                for (Annotation anno : indexes) {
                    Map<String, Object> mp = ConvertUtils.changeAnnotationValuesToMap(anno, anno.annotationType());
                    String columnListString = (String)mp.get("columnList");
                    String[] columns = columnListString.indexOf(44) >= 0 ? columnListString.split(",") : new String[]{columnListString};
                    if (columns.length <= 0) continue;
                    model.index((String)mp.get("name")).columns(columns).setUnique((Boolean)mp.get("unique"));
                }
            }
            if ((uniques = (Annotation[])tableMap.get("uniqueConstraints")) != null && uniques.length > 0) {
                for (Annotation anno : uniques) {
                    Map<String, Object> mp = ConvertUtils.changeAnnotationValuesToMap(anno, anno.annotationType());
                    String[] columnNames = (String[])mp.get("columnNames");
                    if (columnNames == null || columnNames.length <= 0) continue;
                    model.unique((String)mp.get("name")).columns(columnNames);
                }
            }
        }
        List<Map<String, Object>> sequences = ConvertUtils.getPojoAnnotations(pojoClass, "SequenceGenerator");
        for (Map<String, Object> map : sequences) {
            model.sequenceGenerator(new SequenceGen((String)map.get("name"), (String)map.get("sequenceName"), (Integer)map.get("initialValue"), (Integer)map.get("allocationSize")));
        }
        List<Map<String, Object>> tableGens = ConvertUtils.getPojoAnnotations(pojoClass, "TableGenerator");
        for (Map<String, Object> map : tableGens) {
            model.tableGenerator((String)map.get("name"), (String)map.get("table"), (String)map.get("pkColumnName"), (String)map.get("valueColumnName"), (String)map.get("pkColumnValue"), (Integer)map.get("initialValue"), (Integer)map.get("allocationSize"));
        }
        List<Map<String, Object>> fkeys = ConvertUtils.getPojoAnnotations(pojoClass, "FKey");
        for (Map<String, Object> map : fkeys) {
            model.fkey((String)map.get("name")).columns((String[])map.get("columns")).refs((String[])map.get("refs"));
        }
        BeanInfo beanInfo = null;
        PropertyDescriptor[] pds = null;
        try {
            beanInfo = Introspector.getBeanInfo(pojoClass);
            pds = beanInfo.getPropertyDescriptors();
        }
        catch (Exception e) {
            DialectException.throwEX(e, "pojo2Model can not get bean info");
        }
        for (PropertyDescriptor pd : pds) {
            Map<String, Object> uniMap;
            Map<String, Object> idxMap;
            Map<String, Object> refMap;
            Field field;
            String entityField = pd.getName();
            Class<?> propertyClass = pd.getPropertyType();
            if (!ColumnDef.canMapToSqlType(propertyClass) || !ConvertUtils.getFirstPojoAnnotation(field = ReflectionUtils.findField(pojoClass, entityField), "Transient").isEmpty()) continue;
            ColumnModel vcolumn = new ColumnModel(entityField);
            vcolumn.pojoField(entityField);
            Map<String, Object> colMap = ConvertUtils.getFirstPojoAnnotation(field, "Column");
            if (!colMap.isEmpty()) {
                if (!((Boolean)colMap.get("nullable")).booleanValue()) {
                    vcolumn.setNullable(false);
                }
                if (!StrUtils.isEmpty(colMap.get("name"))) {
                    vcolumn.setColumnName((String)colMap.get("name"));
                }
                vcolumn.setLength((Integer)colMap.get("length"));
                vcolumn.setPrecision((Integer)colMap.get("precision"));
                vcolumn.setScale((Integer)colMap.get("scale"));
                vcolumn.setLengths(new Integer[]{vcolumn.getLength(), vcolumn.getPrecision(), vcolumn.getScale()});
                vcolumn.setColumnType(ColumnDef.toType((String)colMap.get("columnDefinition")));
                vcolumn.setInsertable((Boolean)colMap.get("insertable"));
                vcolumn.setUpdatable((Boolean)colMap.get("updatable"));
            } else {
                vcolumn.setColumnType(ColumnDef.toType(propertyClass));
                vcolumn.setLengths(new Integer[]{255, 0, 0});
            }
            Map<String, Object> seqMap = ConvertUtils.getFirstPojoAnnotation(field, "SequenceGenerator");
            if (!seqMap.isEmpty()) {
                model.sequenceGenerator(new SequenceGen((String)seqMap.get("name"), (String)seqMap.get("sequenceName"), (Integer)seqMap.get("initialValue"), (Integer)seqMap.get("allocationSize")));
            }
            if (!ConvertUtils.getFirstPojoAnnotation(field, "Id").isEmpty()) {
                vcolumn.pkey();
            }
            model.addColumn(vcolumn);
            Map<String, Object> gvMap = ConvertUtils.getFirstPojoAnnotation(field, "GeneratedValue");
            if (!gvMap.isEmpty()) {
                GenerationType typ = (GenerationType)((Object)gvMap.get("annotationType"));
                if (GenerationType.AUTO.equals((Object)typ)) {
                    vcolumn.autoID();
                } else if (GenerationType.SEQUENCE.equals((Object)typ)) {
                    vcolumn.sequence((String)gvMap.get("generator"));
                } else if (GenerationType.IDENTITY.equals((Object)typ)) {
                    vcolumn.identity();
                } else if (GenerationType.TABLE.equals((Object)typ)) {
                    vcolumn.tableGenerator((String)gvMap.get("generator"));
                }
            }
            if (!(refMap = ConvertUtils.getFirstPojoAnnotation(field, "SingleFKey")).isEmpty()) {
                model.fkey((String)refMap.get("name")).columns(vcolumn.getColumnName()).refs((String[])refMap.get("refs"));
            }
            if (!(idxMap = ConvertUtils.getFirstPojoAnnotation(field, "SingleIndex")).isEmpty()) {
                model.index((String)idxMap.get("name")).columns(vcolumn.getColumnName());
            }
            if ((uniMap = ConvertUtils.getFirstPojoAnnotation(field, "SingleUnique")).isEmpty()) continue;
            model.unique((String)uniMap.get("name")).columns(vcolumn.getColumnName());
        }
        return model;
    }
}

