/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.model;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyConst;
import com.github.drinkjava2.jdialects.model.IndexConst;
import com.github.drinkjava2.jdialects.model.SequenceGen;
import com.github.drinkjava2.jdialects.model.TableGen;
import com.github.drinkjava2.jdialects.model.UniqueConst;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableModel {
    private String tableName;
    private String check;
    private String comment;
    private String engineTail;
    private Map<String, ColumnModel> columns = new LinkedHashMap<String, ColumnModel>();
    private Map<String, SequenceGen> sequences = new LinkedHashMap<String, SequenceGen>();
    private Map<String, TableGen> tableGenerators = new LinkedHashMap<String, TableGen>();
    private List<FKeyConst> fkeyConstraints = new ArrayList<FKeyConst>();
    private List<IndexConst> indexConsts = new ArrayList<IndexConst>();
    private List<UniqueConst> uniqueConsts = new ArrayList<UniqueConst>();

    public TableModel() {
    }

    public TableModel(String tableName) {
        this.tableName = tableName;
    }

    public void addTableGenerator(TableGen tableGenerator) {
        DialectException.assureNotNull(tableGenerator, new String[0]);
        DialectException.assureNotEmpty(tableGenerator.getName(), "TableGen name can not be empty");
        if (this.tableGenerators.get(tableGenerator.getName().toLowerCase()) != null) {
            DialectException.throwEX("Dulplicated TableGen name \"" + tableGenerator.getName() + "\" found in table \"" + this.getTableName() + "\"");
        }
        this.tableGenerators.put(tableGenerator.getName().toLowerCase(), tableGenerator);
    }

    public void tableGenerator(String name, String tableName, String pkColumnName, String valueColumnName, String pkColumnValue, Integer initialValue, Integer allocationSize) {
        this.addTableGenerator(new TableGen(name, tableName, pkColumnName, valueColumnName, pkColumnValue, initialValue, allocationSize));
    }

    public void sequenceGenerator(String name, String sequenceName, Integer initialValue, Integer allocationSize) {
        this.sequenceGenerator(new SequenceGen(name, sequenceName, initialValue, allocationSize));
    }

    public void sequenceGenerator(SequenceGen sequence) {
        DialectException.assureNotNull(sequence, new String[0]);
        DialectException.assureNotEmpty(sequence.getSequenceName(), "SequenceGen name can not be empty");
        this.sequences.put(sequence.getSequenceName().toLowerCase(), sequence);
    }

    public TableModel check(String check) {
        this.check = check;
        return this;
    }

    public TableModel comment(String comment) {
        this.comment = comment;
        return this;
    }

    public TableModel addColumn(ColumnModel column) {
        DialectException.assureNotNull(column, new String[0]);
        DialectException.assureNotEmpty(column.getColumnName(), "Column's columnName can not be empty");
        if (this.columns.get(column.getColumnName().toLowerCase()) != null) {
            DialectException.throwEX("Dulplicated column name \"" + column.getColumnName() + "\" found in table \"" + this.getTableName() + "\"");
        }
        column.setTableModel(this);
        this.columns.put(column.getColumnName().toLowerCase(), column);
        return this;
    }

    public ColumnModel column(String columnName) {
        ColumnModel column = new ColumnModel(columnName);
        column.setTableModel(this);
        this.addColumn(column);
        return column;
    }

    public ColumnModel getColumn(String columnName) {
        DialectException.assureNotEmpty(columnName, new String[0]);
        return this.columns.get(columnName.toLowerCase());
    }

    public FKeyConst fkey() {
        FKeyConst fkey = new FKeyConst();
        fkey.setTableName(this.tableName);
        this.fkeyConstraints.add(fkey);
        return fkey;
    }

    public FKeyConst fkey(String fkeyName) {
        FKeyConst fkey = new FKeyConst();
        fkey.setTableName(this.tableName);
        fkey.setFkeyName(fkeyName);
        this.fkeyConstraints.add(fkey);
        return fkey;
    }

    public IndexConst index() {
        IndexConst index = new IndexConst();
        this.indexConsts.add(index);
        return index;
    }

    public IndexConst index(String indexName) {
        IndexConst index = new IndexConst();
        index.setName(indexName);
        this.indexConsts.add(index);
        return index;
    }

    public UniqueConst unique() {
        UniqueConst unique = new UniqueConst();
        this.uniqueConsts.add(unique);
        return unique;
    }

    public UniqueConst unique(String uniqueName) {
        UniqueConst unique = new UniqueConst();
        unique.setName(uniqueName);
        this.uniqueConsts.add(unique);
        return unique;
    }

    public TableModel engineTail(String engineTail) {
        this.engineTail = engineTail;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Map<String, ColumnModel> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<String, ColumnModel> columns) {
        this.columns = columns;
    }

    public Map<String, SequenceGen> getSequences() {
        return this.sequences;
    }

    public void setSequences(Map<String, SequenceGen> sequences) {
        this.sequences = sequences;
    }

    public Map<String, TableGen> getTableGenerators() {
        return this.tableGenerators;
    }

    public void setTableGenerators(Map<String, TableGen> tableGenerators) {
        this.tableGenerators = tableGenerators;
    }

    public List<FKeyConst> getFkeyConstraints() {
        return this.fkeyConstraints;
    }

    public void setFkeyConstraints(List<FKeyConst> fkeyConstraints) {
        this.fkeyConstraints = fkeyConstraints;
    }

    public String getEngineTail() {
        return this.engineTail;
    }

    public void setEngineTail(String engineTail) {
        this.engineTail = engineTail;
    }

    public List<IndexConst> getIndexConsts() {
        return this.indexConsts;
    }

    public void setIndexConsts(List<IndexConst> indexConsts) {
        this.indexConsts = indexConsts;
    }

    public List<UniqueConst> getUniqueConsts() {
        return this.uniqueConsts;
    }

    public void setUniqueConsts(List<UniqueConst> uniqueConsts) {
        this.uniqueConsts = uniqueConsts;
    }
}

