/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.utils.StrUtils;

public class FunctionUtils {
    protected static String render(Dialect d, String functionName, Object ... args) {
        String searchStr;
        char c;
        String template = d.functions.get(functionName);
        DialectException.assureNotEmpty(template, "Dialect \"" + (Object)((Object)d) + "\" does not support \"" + functionName + "\" function, a full list of supported functions of this dialect can see \"DatabaseDialects.xls\"");
        if ("*".equals(template)) {
            template = functionName + "($Params)";
        }
        if ((c = template.charAt(1)) != '=') {
            if (template.indexOf("$Params") >= 0) {
                return StrUtils.replace(template, "$Params", StrUtils.arrayToString(args, ", "));
            }
            if (template.indexOf("$Compact_Params") >= 0) {
                return StrUtils.replace(template, "$Compact_Params", StrUtils.arrayToString(args, ","));
            }
            if (template.indexOf("$Lined_Params") >= 0) {
                return StrUtils.replace(template, "$Lined_Params", StrUtils.arrayToString(args, "||"));
            }
            if (template.indexOf("$Add_Params") >= 0) {
                return StrUtils.replace(template, "$Add_Params", StrUtils.arrayToString(args, "+"));
            }
            if (template.indexOf("$IN_Params") >= 0) {
                return StrUtils.replace(template, "$IN_Params", StrUtils.arrayToString(args, " in "));
            }
            if (template.indexOf("$Pattern_Params") >= 0) {
                return StrUtils.replace(template, "$Pattern_Params", StrUtils.arrayToString(args, "%pattern"));
            }
            if (template.indexOf("$Startswith_Params") >= 0) {
                return StrUtils.replace(template, "$Startswith_Params", StrUtils.arrayToString(args, "%startswith"));
            }
            if (template.indexOf("$NVL_Params") >= 0) {
                if (args == null || args.length < 2) {
                    DialectException.throwEX("Nvl function require at least 2 parameters");
                } else {
                    String s = "nvl(" + args[args.length - 2] + ", " + args[args.length - 1] + ")";
                    for (int i = args.length - 3; i > -1; --i) {
                        s = "nvl(" + args[i] + ", " + s + ")";
                    }
                    return StrUtils.replace(template, "$NVL_Params", s);
                }
            }
            return (String)DialectException.throwEX("jDialect found a template bug error, please submit this bug");
        }
        int argsCount = 0;
        if (args != null) {
            argsCount = args.length;
        }
        if (template.indexOf(searchStr = Integer.toString(argsCount) + "=") < 0) {
            DialectException.throwEX("Dialect " + (Object)((Object)d) + "'s function \"" + functionName + "\" only support " + FunctionUtils.allowedParameterCounts(template) + " parameters");
        }
        String result = StrUtils.substringBetween(template + "|", searchStr, "|");
        for (int i = 0; args != null && i < args.length; ++i) {
            result = StrUtils.replace(result, "$P" + (i + 1), "" + args[i]);
        }
        return result;
    }

    private static String allowedParameterCounts(String template) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            if (template.indexOf(Integer.toString(i) + "=") < 0) continue;
            sb.append(Integer.toString(i)).append(" or ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 4);
        }
        return sb.toString();
    }
}

