/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.transform.flip;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Flip
extends MarvinAbstractImagePlugin {
    private static final String HORIZONTAL = "horizontal";
    private static final String VERTICAL = "vertical";
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;
    private boolean[][] arrMask;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("flip", (Object)HORIZONTAL);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("labelTipo", "Type:");
            this.attributesPanel.addComboBox("combpFlip", "flip", new Object[]{HORIZONTAL, VERTICAL}, this.attributes);
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        String l_operation = (String)this.attributes.get("flip");
        this.arrMask = a_mask.getMask();
        if (l_operation.equals(HORIZONTAL)) {
            this.flipHorizontal(a_imageIn, a_imageOut);
        } else {
            this.flipVertical(a_imageIn, a_imageOut);
        }
    }

    private void flipHorizontal(MarvinImage a_imageIn, MarvinImage a_imageOut) {
        for (int y = 0; y < a_imageIn.getHeight(); ++y) {
            for (int x = 0; x < a_imageIn.getWidth() / 2 + 1; ++x) {
                if (this.arrMask != null && !this.arrMask[x][y]) continue;
                int r = a_imageIn.getIntComponent0(x, y);
                int g = a_imageIn.getIntComponent1(x, y);
                int b = a_imageIn.getIntComponent2(x, y);
                a_imageOut.setIntColor(x, y, a_imageIn.getAlphaComponent(x, y), a_imageIn.getIntComponent0(a_imageIn.getWidth() - 1 - x, y), a_imageIn.getIntComponent1(a_imageIn.getWidth() - 1 - x, y), a_imageIn.getIntComponent2(a_imageIn.getWidth() - 1 - x, y));
                int nx = a_imageIn.getWidth() - 1 - x;
                a_imageOut.setIntColor(nx, y, a_imageIn.getAlphaComponent(nx, y), r, g, b);
            }
        }
    }

    private void flipVertical(MarvinImage a_imageIn, MarvinImage a_imageOut) {
        for (int x = 0; x < a_imageIn.getWidth(); ++x) {
            for (int y = 0; y < a_imageIn.getHeight() / 2 + 1; ++y) {
                if (this.arrMask != null && this.arrMask[x][y]) continue;
                int r = a_imageIn.getIntComponent0(x, y);
                int g = a_imageIn.getIntComponent1(x, y);
                int b = a_imageIn.getIntComponent2(x, y);
                a_imageOut.setIntColor(x, y, a_imageIn.getAlphaComponent(x, y), a_imageIn.getIntComponent0(x, a_imageIn.getHeight() - 1 - y), a_imageIn.getIntComponent1(x, a_imageIn.getHeight() - 1 - y), a_imageIn.getIntComponent2(x, a_imageIn.getHeight() - 1 - y));
                int ny = a_imageIn.getHeight() - 1 - y;
                a_imageOut.setIntColor(x, ny, a_imageIn.getAlphaComponent(x, ny), r, g, b);
            }
        }
    }
}

