/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.test.determineGround;

import java.awt.Color;
import java.awt.Point;
import java.util.LinkedList;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.brightnessAndContrast.BrightnessAndContrast;
import org.marvinproject.image.edge.edgeDetector.EdgeDetector;

public class DetermineGround
extends MarvinAbstractImagePlugin {
    private MarvinImagePlugin l_pluginEdgeDetector;
    private MarvinImagePlugin l_pluginBC;

    public void load() {
        this.l_pluginEdgeDetector = new EdgeDetector();
        this.l_pluginEdgeDetector.load();
        this.l_pluginBC = new BrightnessAndContrast();
        this.l_pluginBC.load();
        this.l_pluginBC.setAttribute("contrast", (Object)255);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        MarvinImage l_originalImage = a_imageIn.clone();
        this.l_pluginEdgeDetector.process(a_imageIn, a_imageOut, a_attributesOut, a_mask, a_previewMode);
        this.l_pluginBC.process(a_imageOut, a_imageOut, a_attributesOut, a_mask, a_previewMode);
        a_imageOut.drawRect(0, 0, a_imageOut.getWidth(), a_imageOut.getHeight(), Color.white);
        MarvinImage.copyColorArray((MarvinImage)a_imageOut, (MarvinImage)a_imageIn);
        this.max(a_imageIn, a_imageOut);
        this.floodFill(a_imageOut, 10, 400, -1, -16711936);
        this.blend(a_imageOut, l_originalImage);
        MarvinImage.copyColorArray((MarvinImage)l_originalImage, (MarvinImage)a_imageOut);
    }

    private void blend(MarvinImage a_imageIn, MarvinImage a_imageOut) {
        for (int l_y = 0; l_y < a_imageIn.getHeight(); ++l_y) {
            for (int l_x = 0; l_x < a_imageIn.getWidth(); ++l_x) {
                if (a_imageIn.getIntColor(l_x, l_y) != -16711936) continue;
                a_imageOut.setIntColor(l_x, l_y, -16711936);
            }
        }
    }

    private void max(MarvinImage a_imageIn, MarvinImage a_imageOut) {
        for (int l_y = 0; l_y < a_imageIn.getHeight(); ++l_y) {
            for (int l_x = 0; l_x < a_imageIn.getWidth(); ++l_x) {
                if (a_imageIn.getIntColor(l_x, l_y) == -1) continue;
                this.paintPixel(a_imageOut, l_x - 1, l_y);
                this.paintPixel(a_imageOut, l_x - 2, l_y);
                this.paintPixel(a_imageOut, l_x - 3, l_y);
                this.paintPixel(a_imageOut, l_x - 4, l_y);
                this.paintPixel(a_imageOut, l_x - 5, l_y);
                this.paintPixel(a_imageOut, l_x + 1, l_y);
                this.paintPixel(a_imageOut, l_x + 2, l_y);
                this.paintPixel(a_imageOut, l_x + 3, l_y);
                this.paintPixel(a_imageOut, l_x + 4, l_y);
                this.paintPixel(a_imageOut, l_x + 5, l_y);
            }
        }
    }

    private void paintPixel(MarvinImage a_image, int a_x, int a_y) {
        if (a_x > 0 && a_x < a_image.getWidth() && a_y > 0 && a_y < a_image.getHeight()) {
            a_image.setIntColor(a_x, a_y, 0, 0, 0);
        }
    }

    private void floodFill(MarvinImage a_image, int a_x, int a_y, int a_regionTargetRGB, int a_regionNewRGB) {
        LinkedList<Point> l_list = new LinkedList<Point>();
        if (a_image.getIntColor(a_x, a_y) != a_regionTargetRGB) {
            return;
        }
        l_list.add(new Point(a_x, a_y));
        while (l_list.size() > 0) {
            Point l_point = (Point)l_list.poll();
            Point l_pointW = new Point(l_point.x, l_point.y);
            Point l_pointE = new Point(l_point.x, l_point.y);
            while (l_pointW.x - 1 > 0 && a_image.getIntColor(l_pointW.x - 1, l_pointW.y) == a_regionTargetRGB) {
                --l_pointW.x;
            }
            while (l_pointE.x + 1 < a_image.getWidth() && a_image.getIntColor(l_pointE.x + 1, l_pointE.y) == a_regionTargetRGB) {
                ++l_pointE.x;
            }
            if (l_pointE.x == l_pointW.x && l_pointE.y == l_pointW.y) continue;
            for (int l_px = l_pointW.x; l_px <= l_pointE.x; ++l_px) {
                a_image.setIntColor(l_px, l_point.y, a_regionNewRGB);
                if (l_point.y - 1 > 0 && a_image.getIntColor(l_px, l_point.y - 1) == a_regionTargetRGB) {
                    l_list.add(new Point(l_px, l_point.y - 1));
                }
                if (l_point.y + 1 >= a_image.getHeight() || a_image.getIntColor(l_px, l_point.y + 1) != a_regionTargetRGB) continue;
                l_list.add(new Point(l_px, l_point.y + 1));
            }
        }
    }

    private void foo(MarvinImage a_image, int a_x, int a_y, int a_regionRGB, int a_regionNewRGB) {
        a_image.setIntColor(a_x, a_y, a_regionNewRGB);
        if (a_x - 1 > 0 && a_image.getIntColor(a_x - 1, a_y) == a_regionRGB) {
            this.foo(a_image, a_x - 1, a_y, a_regionRGB, a_regionNewRGB);
        }
        if (a_x + 1 < a_image.getWidth() && a_image.getIntColor(a_x + 1, a_y) == a_regionRGB) {
            this.foo(a_image, a_x + 1, a_y, a_regionRGB, a_regionNewRGB);
        }
        if (a_y - 1 > 0 && a_image.getIntColor(a_x, a_y - 1) == a_regionRGB) {
            this.foo(a_image, a_x, a_y - 1, a_regionRGB, a_regionNewRGB);
        }
        if (a_y + 1 < a_image.getHeight() && a_image.getIntColor(a_x, a_y + 1) == a_regionRGB) {
            this.foo(a_image, a_x, a_y + 1, a_regionRGB, a_regionNewRGB);
        }
    }
}

