/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.steganography;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import marvin.util.MarvinFileChooser;

public class Steganography
extends MarvinAbstractImagePlugin
implements ActionListener {
    private final int numArgs = 3;
    private final int RED = 0;
    private final int GREEN = 1;
    private final int BLUE = 2;
    private int currentColor = 0;
    private int currentPixel = 0;
    private MarvinAttributes attributes;
    private MarvinAttributesPanel attributesPanel;
    private JButton buttonOK;
    private byte[] put;
    private byte[] get;
    private Type type;
    private long pixels;
    private String ext;
    private int xH;
    private int yH = 0;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("txtLines", (Object)"");
        this.attributes.set("cbSelection", (Object)"Write on Image");
        this.attributes.set("cbType", (Object)"Store a file");
    }

    public Action getAction() {
        String s = this.attributes.get("cbSelection").toString();
        if (s.equals("Write on Image")) {
            return Action.MODE_WRITE;
        }
        return Action.MODE_READ;
    }

    public Type getType() {
        String s = this.attributes.get("cbType").toString();
        if (s.equals("Store a file")) {
            return Type.TYPE_FILE;
        }
        return Type.TYPE_TEXT;
    }

    public void getHEADER(MarvinImage a_image) {
        int cont = 0;
        String binpar = "";
        String pixaux = "";
        this.ext = "";
        this.type = null;
        this.pixels = 0L;
        this.currentColor = 0;
        this.currentPixel = 0;
        while (cont != 3) {
            if ((binpar = binpar + this.readBit(a_image)).length() != 8) continue;
            if (binpar.equals("00101111")) {
                ++cont;
            } else {
                switch (cont) {
                    case 0: {
                        if (binpar.equals("01010100")) {
                            this.type = Type.TYPE_TEXT;
                            break;
                        }
                        this.type = Type.TYPE_FILE;
                        break;
                    }
                    case 1: {
                        this.ext = this.ext + (char)Integer.parseInt(binpar, 2);
                        break;
                    }
                    case 2: {
                        pixaux = pixaux + (char)Integer.parseInt(binpar, 2);
                    }
                }
            }
            binpar = "";
        }
        this.xH = this.currentPixel / a_image.getHeight();
        this.yH = this.currentPixel % a_image.getHeight();
        this.pixels = Long.valueOf(pixaux);
    }

    public String setHEADER(File fileOrigin) {
        String rec = "";
        switch (this.getType()) {
            case TYPE_FILE: {
                rec = rec + "F";
                break;
            }
            case TYPE_TEXT: {
                rec = rec + "T";
            }
        }
        rec = rec + "/";
        rec = rec + fileOrigin.getName().substring(fileOrigin.getName().lastIndexOf(46) + 1);
        rec = rec + "/";
        rec = rec + fileOrigin.length() * 8L;
        rec = rec + "/";
        return rec;
    }

    public String setHEADER(String Message) {
        String rec = "";
        switch (this.getType()) {
            case TYPE_FILE: {
                rec = rec + "F";
                break;
            }
            case TYPE_TEXT: {
                rec = rec + "T";
            }
        }
        rec = rec + "/";
        rec = rec + "txt";
        rec = rec + "/";
        rec = rec + Message.length() * 8;
        rec = rec + "/";
        return rec;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        int l_result = 0;
        String name = "";
        block1 : switch (this.getAction()) {
            case MODE_WRITE: {
                switch (this.getType()) {
                    case TYPE_FILE: {
                        try {
                            JOptionPane.showMessageDialog(null, "Select a file to store on image");
                            JFileChooser jfc = new JFileChooser("./img");
                            jfc.setAcceptAllFileFilterUsed(true);
                            l_result = jfc.showOpenDialog((Component)this.attributesPanel);
                            if (l_result != 1) {
                                name = jfc.getSelectedFile().getCanonicalPath();
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        if (l_result != 1 && name != null && name.length() > 0) {
                            File arq = new File(name);
                            this.PrepareFile(arq);
                            break;
                        }
                        JOptionPane.showMessageDialog(null, "Invalid file name!");
                        return;
                    }
                    case TYPE_TEXT: {
                        this.prepareFile(((JTextArea)this.attributesPanel.getComponent("txtLines").getComponent()).getText());
                    }
                }
                if (!this.storeOnImage(a_imageIn, this.put)) break;
                a_imageIn.update();
                JOptionPane.showMessageDialog(null, "Image modified successfully");
                this.attributesPanel.getParent().setVisible(false);
                break;
            }
            case MODE_READ: {
                if (this.isPng(a_imageIn)) {
                    switch (this.StorageType(a_imageIn)) {
                        case TYPE_TEXT: {
                            JOptionPane.showMessageDialog(null, "Text found!");
                            this.ReadText(a_imageIn);
                            break block1;
                        }
                        case TYPE_FILE: {
                            JOptionPane.showMessageDialog(null, "File found!");
                            this.ReadFile(a_imageIn);
                            break block1;
                        }
                    }
                    JOptionPane.showMessageDialog(null, "This file does not contain any content!");
                    break;
                }
                JOptionPane.showMessageDialog(null, "The image must be in PNG format!");
                return;
            }
        }
    }

    public MarvinAttributesPanel getAttributesPanel() {
        this.attributesPanel = new MarvinAttributesPanel();
        this.attributesPanel.newComponentRow();
        this.attributesPanel.addComboBox("cbSelection", "cbSelection", (Object[])new String[]{"Read from Image", "Write on Image"}, this.attributes);
        this.attributesPanel.newComponentRow();
        this.attributesPanel.addComboBox("cbType", "cbType", (Object[])new String[]{"Store a file", "Store a text"}, this.attributes);
        this.attributesPanel.newComponentRow();
        this.attributesPanel.addLabel("lblTexto", "Type below the text to be stored:");
        this.attributesPanel.newComponentRow();
        this.attributesPanel.addTextArea("txtLines", "txtLines", 6, 40, this.attributes);
        this.attributesPanel.newComponentRow();
        this.buttonOK = new JButton("OK");
        this.buttonOK.addActionListener(this);
        this.attributesPanel.getCurrentPanel().add(this.buttonOK);
        JComboBox cbSel = (JComboBox)this.attributesPanel.getComponent("cbSelection").getComponent();
        cbSel.addActionListener(this);
        JComboBox cbType = (JComboBox)this.attributesPanel.getComponent("cbType").getComponent();
        cbType.setVisible(false);
        return this.attributesPanel;
    }

    public boolean storeOnImage(MarvinImage a_image, byte[] Put) {
        for (int l_pos = 0; l_pos < this.put.length; ++l_pos) {
            for (int l_bit = 0; l_bit < 8; ++l_bit) {
                this.storeBit(a_image, this.put[l_pos], 7 - l_bit);
            }
        }
        return true;
    }

    private Type StorageType(MarvinImage a_image) {
        this.getHEADER(a_image);
        return this.type;
    }

    private void ReadText(MarvinImage a_image) {
        this.get = new byte[(int)(this.pixels / 8L)];
        String msgbin = "";
        String msg = "";
        int cont = 0;
        int i = 0;
        while ((long)i < this.pixels) {
            if ((msgbin = msgbin + this.readBit(a_image)).length() == 8) {
                this.get[cont] = (byte)Integer.parseInt(msgbin, 2);
                msgbin = "";
                ++cont;
            }
            ++i;
        }
        for (i = 0; i < this.get.length; ++i) {
            msg = msg + (char)this.get[i];
        }
        ((JTextArea)this.attributesPanel.getComponent("txtLines").getComponent()).setText(msg);
    }

    private void ReadFile(MarvinImage a_image) {
        this.get = new byte[(int)(this.pixels / 8L)];
        String msgbin = "";
        int cont = 0;
        int i = 0;
        while ((long)i < this.pixels) {
            if ((msgbin = msgbin + this.readBit(a_image)).length() == 8) {
                this.get[cont] = (byte)Integer.parseInt(msgbin, 2);
                msgbin = "";
                ++cont;
            }
            ++i;
        }
        try {
            String name = "";
            JOptionPane.showMessageDialog(null, "Select the file destination.");
            FileNameExtensionFilter[] vExt = new FileNameExtensionFilter[]{new FileNameExtensionFilter("File - *." + this.ext, this.ext)};
            name = MarvinFileChooser.select((Component)this.attributesPanel, (boolean)false, (int)1, (FileNameExtensionFilter[])vExt);
            if (name != null && name.length() > 0) {
                File fileOutput = new File(name);
                FileOutputStream out = new FileOutputStream(fileOutput);
                BufferedOutputStream on = new BufferedOutputStream(out);
                for (int i2 = 0; i2 < this.get.length; ++i2) {
                    on.write(this.get[i2]);
                }
                on.close();
            } else {
                JOptionPane.showMessageDialog(null, "Invalid file name.");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void prepareFile(String Message) {
        int j;
        String header = "";
        int cont = 0;
        header = this.setHEADER(Message);
        this.put = new byte[header.length() + Message.length()];
        for (j = 0; j < header.length(); ++j) {
            this.put[cont] = (byte)header.charAt(j);
            ++cont;
        }
        for (j = 0; j < Message.length(); ++j) {
            this.put[cont] = (byte)Message.charAt(j);
            ++cont;
        }
    }

    private void PrepareFile(File FileName) {
        String header = "";
        int cont = 0;
        try {
            File fileOrigin = FileName;
            FileInputStream i = new FileInputStream(fileOrigin);
            BufferedInputStream in = new BufferedInputStream(i);
            byte[] arq = new byte[(int)fileOrigin.length()];
            in.read(arq);
            header = this.setHEADER(FileName);
            this.put = new byte[header.length() + arq.length];
            for (int j = 0; j < header.length(); ++j) {
                this.put[cont] = (byte)header.charAt(j);
                ++cont;
            }
            for (int r = 0; r < arq.length; ++r) {
                this.put[cont] = arq[r];
                ++cont;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int truncate(int a) {
        if (a < 0) {
            return 0;
        }
        if (a > 255) {
            return 255;
        }
        return a;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.attributesPanel.applyValues();
            this.process(this.getImagePanel().getImage(), null);
        } else {
            JComboBox cbSel = (JComboBox)this.attributesPanel.getComponent("cbSelection").getComponent();
            JComboBox cbType = (JComboBox)this.attributesPanel.getComponent("cbType").getComponent();
            cbType.setVisible(cbSel.getSelectedItem() == "Write on Image");
        }
    }

    private boolean isPng(MarvinImage a_image) {
        String ext = a_image.getFormatName();
        return ext != null && ext.equals("png");
    }

    private int getBit(int dado, int bit) {
        return (dado & 1 << bit) >> bit;
    }

    private void storeBit(MarvinImage image, byte dado, int bit) {
        int currX = this.currentPixel / image.getHeight();
        int currY = this.currentPixel % image.getHeight();
        int vbit = this.getBit(dado, bit);
        int r = image.getIntComponent0(currX, currY);
        int g = image.getIntComponent1(currX, currY);
        int b = image.getIntComponent2(currX, currY);
        switch (this.currentColor) {
            case 0: {
                if (vbit == 0) {
                    if (r % 2 != 0) {
                        r = r + 1 < 255 ? ++r : --r;
                    }
                } else if (r % 2 == 0) {
                    r = r + 1 < 255 ? ++r : --r;
                }
                image.setIntColor(currX, currY, r, g, b);
                ++this.currentColor;
                break;
            }
            case 1: {
                if (vbit == 0) {
                    if (g % 2 != 0) {
                        g = g + 1 < 255 ? ++g : --g;
                    }
                } else if (g % 2 == 0) {
                    g = g + 1 < 255 ? ++g : --g;
                }
                image.setIntColor(currX, currY, r, g, b);
                ++this.currentColor;
                break;
            }
            case 2: {
                if (vbit == 0) {
                    if (b % 2 != 0) {
                        b = b + 1 < 255 ? ++b : --b;
                    }
                } else if (b % 2 == 0) {
                    b = b + 1 < 255 ? ++b : --b;
                }
                image.setIntColor(currX, currY, r, g, b);
                this.currentColor = 0;
                ++this.currentPixel;
            }
        }
    }

    private char readBit(MarvinImage image) {
        int result = 48;
        int currX = this.currentPixel / image.getHeight();
        int currY = this.currentPixel % image.getHeight();
        int r = image.getIntComponent0(currX, currY);
        int g = image.getIntComponent1(currX, currY);
        int b = image.getIntComponent2(currX, currY);
        switch (this.currentColor) {
            case 0: {
                result = r % 2 == 0 ? 48 : 49;
                ++this.currentColor;
                break;
            }
            case 1: {
                result = g % 2 == 0 ? 48 : 49;
                ++this.currentColor;
                break;
            }
            case 2: {
                result = b % 2 == 0 ? 48 : 49;
                this.currentColor = 0;
                ++this.currentPixel;
            }
        }
        return (char)result;
    }

    private static enum Type {
        TYPE_TEXT,
        TYPE_FILE;

    }

    private static enum Action {
        MODE_READ,
        MODE_WRITE;

    }
}

