/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.restoration.noiseReduction;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class NoiseReduction
extends MarvinAbstractImagePlugin {
    MarvinPerformanceMeter performanceMeter;
    double[][] mat1;
    double[][] mat2;
    double[][] mat3;
    double[][] mat4;
    double[][] mata;
    double[][] img_x;
    double[][] img_y;
    double[][] img_xx;
    double[][] img_yy;
    double[][] img_xy;
    double[][] matr;
    double[][] matg;
    double[][] matb;
    double[][] img_org;
    int width;
    int height;

    public void load() {
        this.performanceMeter = new MarvinPerformanceMeter();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        int y;
        int x;
        this.width = a_imageIn.getWidth();
        this.height = a_imageIn.getHeight();
        this.mat1 = new double[this.width][this.height];
        this.mat2 = new double[this.width][this.height];
        this.mat4 = new double[this.width][this.height];
        this.mata = new double[this.width][this.height];
        this.img_x = new double[this.width][this.height];
        this.img_y = new double[this.width][this.height];
        this.img_xx = new double[this.width][this.height];
        this.img_yy = new double[this.width][this.height];
        this.img_xy = new double[this.width][this.height];
        this.matr = new double[this.width][this.height];
        this.matg = new double[this.width][this.height];
        this.matb = new double[this.width][this.height];
        this.performanceMeter.start("RestoreNoise");
        this.performanceMeter.startEvent("RestoreNoise");
        int iter = 20;
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                this.matr[x][y] = a_imageIn.getIntComponent0(x, y);
                this.matg[x][y] = a_imageIn.getIntComponent1(x, y);
                this.matb[x][y] = a_imageIn.getIntComponent2(x, y);
            }
        }
        this.matr = this.denoise(this.matr, iter);
        this.matg = this.denoise(this.matg, iter);
        this.matb = this.denoise(this.matb, iter);
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                a_imageOut.setIntColor(x, y, (int)this.truncate(this.matr[x][y]), (int)this.truncate(this.matg[x][y]), (int)this.truncate(this.matb[x][y]));
            }
            this.performanceMeter.stepsFinished(this.height);
        }
        this.performanceMeter.finishEvent();
        this.performanceMeter.finish();
    }

    public double[][] denoise(double[][] mat, int iter) {
        this.img_org = new double[this.width][this.height];
        double[][] img_res = new double[this.width][this.height];
        boolean val = true;
        double lam = 0.0;
        double dt = 0.4;
        this.img_org = mat;
        for (int it = 0; it < iter; ++it) {
            this.img_x = this.diff_x(mat);
            this.img_y = this.diff_y(mat);
            this.img_xx = this.diff_xx(mat);
            this.img_yy = this.diff_yy(mat);
            this.img_xy = this.diff_xy(mat);
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    double a = this.img_xx[i][j] * ((double)val + Math.pow(this.img_y[i][j], 2.0));
                    double b = 2.0 * this.img_x[i][j] * this.img_y[i][j] * this.img_xy[i][j];
                    double c = this.img_yy[i][j] * ((double)val + Math.pow(this.img_x[i][j], 2.0));
                    double l_currentNum = a - b + c;
                    double l_currentDen = Math.pow((double)val + Math.pow(this.img_x[i][j], 2.0) + Math.pow(this.img_y[i][j], 2.0), 1.5);
                    img_res[i][j] = l_currentNum / l_currentDen + lam * (this.img_org[i][j] - mat[i][j]);
                    mat[i][j] = mat[i][j] + dt * img_res[i][j];
                }
            }
        }
        return mat;
    }

    public double[][] diff_x(double[][] matx) {
        this.mat3 = new double[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                double mat2;
                double mat1;
                if (j == 0) {
                    mat1 = matx[i][j];
                    mat2 = matx[i][j + 1];
                } else if (j == this.height - 1) {
                    mat1 = matx[i][j - 1];
                    mat2 = matx[i][j];
                } else {
                    mat1 = matx[i][j - 1];
                    mat2 = matx[i][j + 1];
                }
                this.mat3[i][j] = (mat2 - mat1) / 2.0;
            }
        }
        return this.mat3;
    }

    public double[][] diff_y(double[][] maty) {
        this.mat3 = new double[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                double mat2;
                double mat1;
                if (i == 0) {
                    mat1 = maty[i][j];
                    mat2 = maty[i + 1][j];
                } else if (i == this.width - 1) {
                    mat1 = maty[i - 1][j];
                    mat2 = maty[i][j];
                } else {
                    mat1 = maty[i - 1][j];
                    mat2 = maty[i + 1][j];
                }
                this.mat3[i][j] = (mat2 - mat1) / 2.0;
            }
        }
        return this.mat3;
    }

    public double[][] diff_xx(double[][] matxx) {
        this.mat3 = new double[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                double mat2;
                double mat1;
                if (j == 0) {
                    mat1 = matxx[i][j];
                    mat2 = matxx[i][j + 1];
                } else if (j == this.height - 1) {
                    mat1 = matxx[i][j - 1];
                    mat2 = matxx[i][j];
                } else {
                    mat1 = matxx[i][j - 1];
                    mat2 = matxx[i][j + 1];
                }
                this.mat3[i][j] = mat1 + mat2 - 2.0 * matxx[i][j];
            }
        }
        return this.mat3;
    }

    public double[][] diff_yy(double[][] matyy) {
        this.mat3 = new double[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                double mat2;
                double mat1;
                if (i == 0) {
                    mat1 = matyy[i][j];
                    mat2 = matyy[i + 1][j];
                } else if (i == this.width - 1) {
                    mat1 = matyy[i - 1][j];
                    mat2 = matyy[i][j];
                } else {
                    mat1 = matyy[i - 1][j];
                    mat2 = matyy[i + 1][j];
                }
                this.mat3[i][j] = mat1 + mat2 - 2.0 * matyy[i][j];
            }
        }
        return this.mat3;
    }

    public double[][] diff_xy(double[][] matxy) {
        int j;
        int i;
        this.mat3 = new double[this.width][this.height];
        for (i = 0; i < this.width - 1; ++i) {
            for (j = 0; j < this.height - 1; ++j) {
                this.mat1[i][j] = matxy[i + 1][j + 1];
                this.mat2[i + 1][j + 1] = matxy[i][j];
                this.mat3[i + 1][j] = matxy[i][j + 1];
                this.mat4[i][j + 1] = matxy[i + 1][j];
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                if (j == this.height - 1 && i < this.width - 1) {
                    this.mat1[i][j] = this.mat1[i][j - 1];
                } else if (i == this.width - 1) {
                    this.mat1[i][j] = this.mat1[i - 1][j];
                }
                if (i == 0 && j > 0) {
                    this.mat2[i][j] = this.mat2[1][j];
                } else if (j == 0) {
                    this.mat2[i][0] = this.mat2[i][1];
                }
                if (i == 0 && j < this.height - 1) {
                    this.mat3[i][j] = this.mat3[1][j];
                } else if (j == this.height - 1) {
                    this.mat3[i][j] = this.mat3[i][j - 1];
                }
                if (j == 0 && i < this.width - 1) {
                    this.mat4[i][j] = this.mat4[i][1];
                    continue;
                }
                if (i != this.width - 1) continue;
                this.mat4[i][j] = this.mat4[i - 1][j];
            }
            this.mat2[0][0] = this.mat2[0][1];
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                double Dp = this.mat1[i][j] + this.mat2[i][j];
                double Dm = this.mat3[i][j] + this.mat4[i][j];
                this.mata[i][j] = (Dp - Dm) / 4.0;
            }
        }
        return this.mata;
    }

    public double truncate(double a) {
        if (a < 0.0) {
            return 0.0;
        }
        if (a > 255.0) {
            return 255.0;
        }
        return a;
    }
}

