/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.render.mandelbrot;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Mandelbrot
extends MarvinAbstractImagePlugin {
    private static final String MODEL_0 = "Model 0";
    private static final String MODEL_1 = "Model 1";
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;
    private int colorModel;
    int width;
    int height;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("zoom", (Object)1.0);
        this.attributes.set("xCenter", (Object)0.0);
        this.attributes.set("yCenter", (Object)0.0);
        this.attributes.set("iterations", (Object)500);
        this.attributes.set("colorModel", (Object)MODEL_0);
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes out2, MarvinImageMask a_mask, boolean previewMode) {
        this.width = imageOut.getWidth();
        this.height = imageOut.getHeight();
        double zoom = (Double)this.attributes.get("zoom");
        double xc = (Double)this.attributes.get("xCenter");
        double yc = (Double)this.attributes.get("yCenter");
        int iterations = (Integer)this.attributes.get("iterations");
        this.colorModel = ((String)this.attributes.get("colorModel")).equals(MODEL_0) ? 0 : 1;
        double factor = 5.0 / zoom;
        boolean[][] mask = a_mask.getMask();
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int iter;
                if (mask != null && !mask[j][i]) continue;
                double x0 = xc - factor / 2.0 + factor * (double)j / (double)this.width;
                double y0 = yc - factor / 2.0 + factor * (double)i / (double)this.height;
                double nx = x0;
                double ny = y0;
                for (iter = 0; Math.sqrt(nx * nx + ny * ny) < 2.0 && iter < iterations; ++iter) {
                    double nx1 = nx * nx - ny * ny;
                    double ny1 = 2.0 * (nx * ny);
                    nx = nx1 + x0;
                    ny = ny1 + y0;
                }
                imageOut.setIntColor(j, this.height - 1 - i, 255, this.getColor(iter, iterations, this.colorModel));
            }
        }
    }

    private int getColor(int iter, int max, int colorModel) {
        if (colorModel == 0) {
            return this.getColor0(iter, max);
        }
        return this.getColor1(iter, max);
    }

    private int getColor1(int iter, int max) {
        double f = 0xFFFFFF / max;
        int i = (int)((double)iter * f);
        int blue = (i & 0xFF0000) >> 16;
        int green = (i & 0xFF00) >> 8;
        int red = i & 0xFF;
        return blue + (green << 8) + (red << 16);
    }

    private int getColor0(int iter, int max) {
        int red = (int)((Math.cos((float)iter / 10.0f) + 1.0) * 127.0);
        int green = (int)((Math.cos((float)iter / 20.0f) + 1.0) * 127.0);
        int blue = (int)((Math.cos((float)iter / 300.0f) + 1.0) * 127.0);
        return blue + (green << 8) + (red << 16);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblXCenter", "X Center:");
            this.attributesPanel.addTextField("txtXCenter", "xCenter", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblYCenter", "Y Center:");
            this.attributesPanel.addTextField("txtYCenter", "yCenter", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblZoom", "Zoom:");
            this.attributesPanel.addTextField("txtZoom", "zoom", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblIterations", "Iterations:");
            this.attributesPanel.addTextField("txtIterations", "iterations", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblColorModel", "Color Model:");
            this.attributesPanel.addComboBox("combColorModel", "colorModel", new Object[]{MODEL_0, MODEL_1}, this.attributes);
        }
        return this.attributesPanel;
    }
}

