/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.render.iteratedFunctionSystem;

import java.util.ArrayList;
import java.util.List;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.render.iteratedFunctionSystem.Rule;

public class IteratedFunctionSystem
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;
    private List<Rule> rules;
    private static final String EXAMPLE_RULES = "0,0,0,0.16,0,0,0.01\n0.85,0.04,-0.04,0.85,0,1.6,0.85\n0.2,-0.26,0.23,0.22,0,1.6,0.07\n-0.15,0.28,0.26,0.24,0,0.44,0.07\n";

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("rules", (Object)EXAMPLE_RULES);
        this.attributes.set("iterations", (Object)1000000);
        this.rules = new ArrayList<Rule>();
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes out2, MarvinImageMask a_mask, boolean previewMode) {
        double factor;
        double deltaY;
        double y;
        double x;
        Rule tempRule;
        this.loadRules();
        int iterations = (Integer)this.attributes.get("iterations");
        double x0 = 0.0;
        double y0 = 0.0;
        double minX = 9.99999999E8;
        double minY = 9.99999999E8;
        double maxX = -9.99999999E8;
        double maxY = -9.9999999E7;
        double[] point = new double[]{x0, y0};
        imageOut.clear(-1);
        for (int i = 0; i < iterations; ++i) {
            tempRule = this.getRule();
            this.applyRule(point, tempRule);
            x = point[0];
            y = point[1];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        int width = imageOut.getWidth();
        int height = imageOut.getHeight();
        double deltaX = Math.abs(maxX - minX);
        if (deltaX > (deltaY = Math.abs(maxY - minY))) {
            factor = (double)width / deltaX;
            if (deltaY * factor > (double)height) {
                factor *= (double)height / (deltaY * factor);
            }
        } else {
            factor = (double)height / deltaY;
            if (deltaX * factor > (double)width) {
                factor *= (double)width / (deltaX * factor);
            }
        }
        int startX = (int)((double)(width / 2) - (minX + deltaX / 2.0) * (factor *= 0.9));
        int startY = (int)((double)height - ((double)(height / 2) - (minY + deltaY / 2.0) * factor));
        point[0] = x0;
        point[1] = y0;
        for (int i = 0; i < iterations; ++i) {
            tempRule = this.getRule();
            this.applyRule(point, tempRule);
            x = (int)(point[0] * factor) + startX;
            y = startY - (int)(point[1] * factor);
            if (!(x >= 0.0) || !(x < (double)width) || !(y >= 0.0) || !(y < (double)height)) continue;
            imageOut.setIntColor((int)x, (int)y, 255, 0);
        }
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblRules", "Rules:");
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addTextArea("txtRules", "rules", 8, 40, this.attributes);
        }
        return this.attributesPanel;
    }

    private void loadRules() {
        String[] r = ((String)this.attributes.get("rules")).split("\n");
        for (int i = 0; i < r.length; ++i) {
            this.addRule(r[i]);
        }
    }

    private void addRule(String rule) {
        String[] attr = (rule = rule.replace(" ", "")).split(",");
        if (attr.length == 7) {
            Rule r = new Rule(Double.parseDouble(attr[0]), Double.parseDouble(attr[1]), Double.parseDouble(attr[2]), Double.parseDouble(attr[3]), Double.parseDouble(attr[4]), Double.parseDouble(attr[5]), Double.parseDouble(attr[6]));
            this.rules.add(r);
        }
    }

    private Rule getRule() {
        int i;
        double random = Math.random();
        double sum = 0.0;
        for (i = 0; i < this.rules.size(); ++i) {
            if (!(random < (sum += this.rules.get((int)i).probability))) continue;
            return this.rules.get(i);
        }
        if (i != 0) {
            return this.rules.get(i - 1);
        }
        return this.rules.get(0);
    }

    private void applyRule(double[] point, Rule rule) {
        double nx = rule.a * point[0] + rule.b * point[1] + rule.e;
        double ny = rule.c * point[0] + rule.d * point[1] + rule.f;
        point[0] = nx;
        point[1] = ny;
    }
}

