/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.quantization.grayScaleQuantization;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.grayScale.GrayScale;

public class GrayScaleQuantization
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    private MarvinImagePlugin gray;

    public void load() {
        this.gray = new GrayScale();
        this.gray.load();
        this.setAttribute("shades", 10);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblShades", "Shades:");
            this.attributesPanel.addTextField("txtShades", "shades", this.getAttributes());
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean preview) {
        int colors = (Integer)this.getAttribute("shades");
        int range = 255 / colors;
        this.gray.process(imageIn.clone(), imageIn);
        for (int y = 0; y < imageIn.getHeight(); ++y) {
            for (int x = 0; x < imageIn.getWidth(); ++x) {
                if (imageIn.getAlphaComponent(x, y) <= 0) continue;
                int c = imageIn.getIntComponent0(x, y);
                int c2 = c / range * range;
                imageOut.setIntColor(x, y, 255, c2, c2, c2);
            }
        }
    }
}

