/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.pattern.findTextRegions;

import java.util.ArrayList;
import java.util.List;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.image.MarvinSegment;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.thresholding.Thresholding;

public class FindTextRegions
extends MarvinAbstractImagePlugin {
    private MarvinImagePlugin threshold;

    public void load() {
        this.setAttribute("maxWhiteSpace", 10);
        this.setAttribute("maxFontLineWidth", 10);
        this.setAttribute("minTextWidth", 30);
        this.setAttribute("grayScaleThreshold", 127);
        this.threshold = new Thresholding();
        this.threshold.load();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean preview) {
        int y;
        imageIn = imageIn.clone();
        int maxWhiteSpace = (Integer)this.getAttribute("maxWhiteSpace");
        int maxFontLineWidth = (Integer)this.getAttribute("maxFontLineWidth");
        int minTextWidth = (Integer)this.getAttribute("minTextWidth");
        int grayScaleThreshold = (Integer)this.getAttribute("grayScaleThreshold");
        this.threshold.setAttribute("threshold", (Object)grayScaleThreshold);
        this.threshold.process(imageIn, imageIn);
        ArrayList segments = new ArrayList(imageIn.getHeight());
        for (int i = 0; i < imageIn.getHeight(); ++i) {
            segments.add(new ArrayList());
        }
        boolean[][] processed = new boolean[imageIn.getWidth()][imageIn.getHeight()];
        int patternStartX = -1;
        int patternLength = 0;
        int whitePixels = 0;
        int blackPixels = 0;
        for (y = 0; y < imageIn.getHeight(); ++y) {
            for (int x = 0; x < imageIn.getWidth(); ++x) {
                if (processed[x][y]) continue;
                int color = imageIn.getIntColor(x, y);
                if (color == -1 && patternStartX != -1) {
                    ++whitePixels;
                    blackPixels = 0;
                }
                if (color == -16777216) {
                    ++blackPixels;
                    if (patternStartX == -1) {
                        patternStartX = x;
                    }
                    whitePixels = 0;
                }
                if (whitePixels > maxWhiteSpace || blackPixels > maxFontLineWidth || x == imageIn.getWidth() - 1) {
                    if (patternLength >= minTextWidth) {
                        List list = (List)segments.get(y);
                        list.add(new Integer[]{patternStartX, y, patternStartX + patternLength, y});
                    }
                    whitePixels = 0;
                    blackPixels = 0;
                    patternLength = 0;
                    patternStartX = -1;
                }
                if (patternStartX != -1) {
                    ++patternLength;
                }
                processed[x][y] = true;
            }
        }
        for (y = 0; y < imageIn.getHeight() - 2; ++y) {
            List listY = (List)segments.get(y);
            for (int w = y + 1; w <= y + 2; ++w) {
                List listW = (List)segments.get(w);
                block5: for (int i = 0; i < listY.size(); ++i) {
                    Integer[] sA = (Integer[])listY.get(i);
                    for (int j = 0; j < listW.size(); ++j) {
                        Integer[] sB = (Integer[])listW.get(j);
                        if (!(sA[0] <= sB[0] && sA[2] >= sB[2] || sA[0] >= sB[0] && sA[0] <= sB[2]) && (sA[2] < sB[0] || sA[2] > sB[2])) continue;
                        sA[0] = Math.min(sA[0], sB[0]);
                        sA[2] = Math.max(sA[2], sB[2]);
                        sA[3] = sB[3];
                        listY.remove(i);
                        --i;
                        listW.remove(j);
                        listW.add(sA);
                        continue block5;
                    }
                }
            }
        }
        ArrayList<MarvinSegment> marvinSegments = new ArrayList<MarvinSegment>();
        for (int y2 = 0; y2 < imageIn.getHeight(); ++y2) {
            List l = (List)segments.get(y2);
            for (Integer[] seg : l) {
                marvinSegments.add(new MarvinSegment(seg[0].intValue(), seg[1].intValue(), seg[2].intValue(), seg[3].intValue()));
            }
        }
        attrOut.set("matches", marvinSegments);
    }
}

