/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.halftone.errorDiffusion;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.grayScale.GrayScale;

public class ErrorDiffusion
extends MarvinAbstractImagePlugin {
    int threshold;
    private MarvinPerformanceMeter performanceMeter;

    public void load() {
        this.performanceMeter = new MarvinPerformanceMeter();
        this.threshold = 128;
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        GrayScale l_filter = new GrayScale();
        l_filter.load();
        l_filter.process(a_imageIn, a_imageOut, a_attributesOut, a_mask, a_previewMode);
        this.performanceMeter.start("Halftone - Error Diffusion");
        this.performanceMeter.enableProgressBar("Halftone - Error Diffusion", a_imageOut.getHeight() * a_imageOut.getWidth());
        this.performanceMeter.startEvent("Error Diffusion");
        boolean[][] l_arrMask = a_mask.getMask();
        for (int y = 0; y < a_imageOut.getHeight(); ++y) {
            for (int x = 0; x < a_imageOut.getWidth(); ++x) {
                double dif;
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                int color = a_imageOut.getIntComponent0(x, y);
                if (color > this.threshold) {
                    a_imageOut.setIntColor(x, y, a_imageIn.getAlphaComponent(x, y), 255, 255, 255);
                    dif = -(255 - color);
                } else {
                    a_imageOut.setIntColor(x, y, a_imageIn.getAlphaComponent(x, y), 0, 0, 0);
                    dif = color;
                }
                if (x + 1 < a_imageOut.getWidth()) {
                    color = a_imageOut.getIntComponent0(x + 1, y);
                    color += (int)(0.4375 * dif);
                    color = this.getValidGray(color);
                    a_imageOut.setIntColor(x + 1, y, a_imageIn.getAlphaComponent(x + 1, y), color, color, color);
                    if (y + 1 < a_imageOut.getHeight()) {
                        color = a_imageOut.getIntComponent0(x + 1, y + 1);
                        color += (int)(0.0625 * dif);
                        color = this.getValidGray(color);
                        a_imageOut.setIntColor(x + 1, y + 1, a_imageIn.getAlphaComponent(x + 1, y + 1), color, color, color);
                    }
                }
                if (y + 1 >= a_imageOut.getHeight()) continue;
                color = a_imageOut.getIntComponent0(x, y + 1);
                color += (int)(0.3125 * dif);
                color = this.getValidGray(color);
                a_imageOut.setIntColor(x, y + 1, a_imageIn.getAlphaComponent(x, y + 1), color, color, color);
                if (x - 1 < 0) continue;
                color = a_imageOut.getIntComponent0(x - 1, y + 1);
                color += (int)(0.1875 * dif);
                color = this.getValidGray(color);
                a_imageOut.setIntColor(x - 1, y + 1, a_imageIn.getAlphaComponent(x - 1, y + 1), color, color, color);
            }
            this.performanceMeter.stepsFinished(a_imageOut.getWidth());
            this.performanceMeter.incProgressBar(a_imageOut.getWidth());
        }
        this.performanceMeter.finishEvent();
        this.performanceMeter.finish();
    }

    private int getValidGray(int a_value) {
        if (a_value < 0) {
            return 0;
        }
        if (a_value > 255) {
            return 255;
        }
        return a_value;
    }
}

