/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.corner.susan;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.grayScale.GrayScale;

public class Susan
extends MarvinAbstractImagePlugin {
    private MarvinImagePlugin gray;

    public void load() {
        this.gray = new GrayScale();
        this.gray.load();
        this.setAttribute("matrixSize", 7);
        this.setAttribute("threshold", 100);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean previewMode) {
        int j;
        int i;
        int threshold = (Integer)this.getAttribute("threshold");
        int matrixSize = (Integer)this.getAttribute("matrixSize");
        MarvinImage tempImage = new MarvinImage(imageIn.getWidth(), imageIn.getHeight());
        this.gray.process(imageIn, tempImage);
        int width = tempImage.getWidth();
        int height = tempImage.getHeight();
        int USAN = 0;
        int[][] usan = new int[width][height];
        int[][] cornernessMapOut = new int[width][height];
        int[][] cornernessMap = new int[width][height];
        boolean[][] circleMask = new boolean[matrixSize][matrixSize];
        USAN = 0;
        for (i = 0; i < matrixSize; ++i) {
            for (j = 0; j < matrixSize; ++j) {
                if (Math.pow(i - matrixSize / 2, 2.0) + Math.pow(j - matrixSize / 2, 2.0) <= Math.pow((double)matrixSize / 2.0, 2.0)) {
                    circleMask[i][j] = true;
                    ++USAN;
                    continue;
                }
                circleMask[i][j] = false;
            }
        }
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                int blockradius = matrixSize / 2;
                if (i - blockradius < 0) {
                    blockradius = i;
                }
                if (j - blockradius < 0) {
                    blockradius = j;
                }
                if (i + blockradius > width - 1) {
                    blockradius = width - 1 - i;
                }
                if (j + blockradius > height - 1) {
                    blockradius = height - 1 - j;
                }
                int nucleusValue = tempImage.getIntComponent0(i, j);
                for (int BRi = i - blockradius; BRi <= i + blockradius; ++BRi) {
                    for (int BRj = j - blockradius; BRj <= j + blockradius; ++BRj) {
                        if (BRi == i && BRj == j || !circleMask[BRi - i + blockradius][BRj - j + blockradius] || Math.abs(tempImage.getIntComponent0(BRi, BRj) - nucleusValue) >= threshold) continue;
                        int[] nArray = usan[i];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        }
        int max = 3 * USAN / 4;
        for (int i2 = 0; i2 < width; ++i2) {
            for (int j2 = 0; j2 < height; ++j2) {
                if (Math.abs(max - usan[i2][j2]) >= 2) continue;
                cornernessMap[i2][j2] = 255 - Math.abs(max - usan[i2][j2]);
            }
        }
        for (int x = 0; x < cornernessMap.length; ++x) {
            for (int y = 0; y < cornernessMap[x].length; ++y) {
                cornernessMapOut[x][y] = this.nonmax(x, y, matrixSize, cornernessMap);
                if (cornernessMapOut[x][y] <= 0) continue;
                cornernessMapOut[x][y] = 1;
            }
        }
        if (attrOut != null) {
            attrOut.set("cornernessMap", (Object)cornernessMapOut);
        }
    }

    private int nonmax(int x, int y, int matrixSize, int[][] matrix) {
        int s = matrixSize / 2;
        if (x - (s + 1) >= 0 && x + (s + 1) < matrix.length && y - (s + 1) >= 0 && y + (s + 1) < matrix[0].length) {
            for (int i = -s; i <= s; ++i) {
                for (int j = -s; j <= s; ++j) {
                    if (i == 0 && j == 0 || matrix[x][y] >= matrix[x + i][y + j]) continue;
                    return 0;
                }
            }
        }
        return matrix[x][y];
    }
}

