/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.convolution;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Convolution
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("matrix", null);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addMatrixPanel("matrixPanel", "matrix", this.attributes, 3, 3);
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        double[][] matrix = (double[][])this.attributes.get("matrix");
        if (matrix != null && matrix.length > 0) {
            for (int y = 0; y < imageIn.getHeight(); ++y) {
                for (int x = 0; x < imageIn.getWidth(); ++x) {
                    if (y >= matrix.length / 2 && y < imageIn.getHeight() - matrix.length / 2 && x >= matrix[0].length / 2 && x < imageIn.getWidth() - matrix[0].length / 2) {
                        this.applyMatrix(x, y, matrix, imageIn, imageOut);
                        continue;
                    }
                    imageOut.setIntColor(x, y, -16777216);
                }
            }
        }
    }

    private void applyMatrix(int x, int y, double[][] matrix, MarvinImage imageIn, MarvinImage imageOut) {
        double resultRed = 0.0;
        double resultGreen = 0.0;
        double resultBlue = 0.0;
        int xC = matrix[0].length / 2;
        int yC = matrix.length / 2;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                if (matrix[i][j] == 0.0) continue;
                int nx = x + (j - xC);
                int ny = y + (i - yC);
                if (nx < 0 || nx >= imageOut.getWidth() || ny < 0 || ny >= imageOut.getHeight()) continue;
                resultRed += matrix[i][j] * (double)imageIn.getIntComponent0(nx, ny);
                resultGreen += matrix[i][j] * (double)imageIn.getIntComponent1(nx, ny);
                resultBlue += matrix[i][j] * (double)imageIn.getIntComponent2(nx, ny);
            }
        }
        resultRed = Math.abs(resultRed);
        resultGreen = Math.abs(resultGreen);
        resultBlue = Math.abs(resultBlue);
        resultRed += (double)imageOut.getIntComponent0(x, y);
        resultGreen += (double)imageOut.getIntComponent1(x, y);
        resultBlue += (double)imageOut.getIntComponent2(x, y);
        resultRed = Math.min(resultRed, 255.0);
        resultGreen = Math.min(resultGreen, 255.0);
        resultBlue = Math.min(resultBlue, 255.0);
        resultRed = Math.max(resultRed, 0.0);
        resultGreen = Math.max(resultGreen, 0.0);
        resultBlue = Math.max(resultBlue, 0.0);
        imageOut.setIntColor(x, y, imageIn.getAlphaComponent(x, y), (int)resultRed, (int)resultGreen, (int)resultBlue);
    }
}

