/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.combine.mergePhotos;

import java.util.List;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.background.determineSceneBackground.DetermineSceneBackground;

public class MergePhotos
extends MarvinAbstractImagePlugin {
    private MarvinImagePlugin background;
    private int threshold;

    public void load() {
        this.background = new DetermineSceneBackground();
        this.background.load();
        this.setAttribute("threshold", 30);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean preview) {
    }

    public void process(List<MarvinImage> images, MarvinImage imageOut) {
        if (!images.isEmpty()) {
            this.threshold = (Integer)this.getAttribute("threshold");
            this.background.setAttribute("threshold", (Object)this.threshold);
            MarvinImage backgroundImage = images.get(0).clone();
            this.background.process(images, backgroundImage);
            this.mergePhotos(images, imageOut, backgroundImage, this.threshold);
        }
    }

    private void mergePhotos(List<MarvinImage> images, MarvinImage imageOut, MarvinImage background, int threshold) {
        for (MarvinImage img : images) {
            this.mergePhotos(img, imageOut, background, threshold);
        }
    }

    private void mergePhotos(MarvinImage imageA, MarvinImage imageB, MarvinImage imageBackground, int threshold) {
        for (int y = 0; y < imageA.getHeight(); ++y) {
            for (int x = 0; x < imageA.getWidth(); ++x) {
                int rA = imageA.getIntComponent0(x, y);
                int gA = imageA.getIntComponent1(x, y);
                int bA = imageA.getIntComponent2(x, y);
                int rB = imageBackground.getIntComponent0(x, y);
                int gB = imageBackground.getIntComponent1(x, y);
                int bB = imageBackground.getIntComponent2(x, y);
                if (Math.abs(rA - rB) <= threshold && Math.abs(gA - gB) <= threshold && Math.abs(bA - bB) <= threshold) continue;
                imageB.setIntColor(x, y, 255, rA, gA, bA);
            }
        }
    }
}

