/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.combine.combineByTransparency;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class CombineByTransparency
extends MarvinAbstractImagePlugin {
    private MarvinAttributes attributes;
    private int xi = 0;
    private int yi = 0;
    private int transparency = 10;
    private MarvinImage combinationImage;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("xi", (Object)this.xi);
        this.attributes.set("yi", (Object)this.yi);
        this.attributes.set("transparency", (Object)this.transparency);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        this.xi = (Integer)this.attributes.get("xi");
        this.yi = (Integer)this.attributes.get("yi");
        this.combinationImage = (MarvinImage)this.attributes.get("combinationImage");
        this.transparency = (Integer)this.attributes.get("transparency");
        double l_factor = (double)(100 - this.transparency) / 100.0;
        int l_widthCI = this.combinationImage.getWidth();
        int l_heightCI = this.combinationImage.getHeight();
        for (int y = 0; y < imageIn.getHeight(); ++y) {
            for (int x = 0; x < imageIn.getWidth(); ++x) {
                int l_xCI = x - this.xi;
                int l_yCI = y - this.yi;
                if (l_xCI >= 0 && l_xCI < l_widthCI && l_yCI >= 0 && l_yCI < l_heightCI) {
                    double l_redA = imageIn.getIntComponent0(x, y);
                    double l_greenA = imageIn.getIntComponent1(x, y);
                    double l_blueA = imageIn.getIntComponent2(x, y);
                    double l_redB = this.combinationImage.getIntComponent0(l_xCI, l_yCI);
                    double l_greenB = this.combinationImage.getIntComponent1(l_xCI, l_yCI);
                    double l_blueB = this.combinationImage.getIntComponent2(l_xCI, l_yCI);
                    imageOut.setIntColor(x, y, (int)(l_redA * (1.0 - l_factor) + l_redB * l_factor), (int)(l_greenA * (1.0 - l_factor) + l_greenB * l_factor), (int)(l_blueA * (1.0 - l_factor) + l_blueB * l_factor));
                    continue;
                }
                imageOut.setIntColor(x, y, imageIn.getIntColor(x, y));
            }
        }
    }
}

