/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.color.thresholding;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.grayScale.GrayScale;

public class Thresholding
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;
    private int threshold;
    private int thresholdRange;
    private int neighborhood;
    private int range;
    private MarvinImagePlugin pluginGray;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("threshold", (Object)125);
        this.attributes.set("thresholdRange", (Object)-1);
        this.attributes.set("neighborhood", (Object)-1);
        this.attributes.set("range", (Object)-1);
        this.pluginGray = new GrayScale();
        this.pluginGray.load();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblThreshold", "Threshold");
            this.attributesPanel.addTextField("txtThreshold", "threshold", this.attributes);
            this.attributesPanel.addLabel("lblNeighborhood", "Neighborhood");
            this.attributesPanel.addTextField("txtNeighborhood", "neighborhood", this.attributes);
            this.attributesPanel.addLabel("lblRange", "Range");
            this.attributesPanel.addTextField("txtRange", "range", this.attributes);
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        this.threshold = (Integer)this.attributes.get("threshold");
        this.thresholdRange = (Integer)this.attributes.get("thresholdRange");
        this.neighborhood = (Integer)this.attributes.get("neighborhood");
        this.range = (Integer)this.attributes.get("range");
        if (this.thresholdRange == -1) {
            this.thresholdRange = 255 - this.threshold;
        }
        this.pluginGray.process(imageIn, imageOut, attributesOut, mask, previewMode);
        boolean[][] bmask = mask.getMask();
        if (this.neighborhood == -1 && this.range == -1) {
            this.hardThreshold(imageIn, imageOut, bmask);
        } else {
            this.contrastThreshold(imageIn, imageOut);
        }
    }

    private void hardThreshold(MarvinImage imageIn, MarvinImage imageOut, boolean[][] mask) {
        for (int y = 0; y < imageIn.getHeight(); ++y) {
            for (int x = 0; x < imageIn.getWidth(); ++x) {
                if (mask != null && !mask[x][y]) continue;
                int gray = imageIn.getIntComponent0(x, y);
                if (gray < this.threshold || gray > this.threshold + this.thresholdRange) {
                    imageOut.setIntColor(x, y, imageIn.getAlphaComponent(x, y), 0, 0, 0);
                    continue;
                }
                imageOut.setIntColor(x, y, imageIn.getAlphaComponent(x, y), 255, 255, 255);
            }
        }
    }

    private void contrastThreshold(MarvinImage imageIn, MarvinImage imageOut) {
        this.range = 1;
        for (int x = 0; x < imageIn.getWidth(); ++x) {
            for (int y = 0; y < imageIn.getHeight(); ++y) {
                if (this.checkNeighbors(x, y, this.neighborhood, this.neighborhood, imageIn)) {
                    imageOut.setIntColor(x, y, 0, 0, 0);
                    continue;
                }
                imageOut.setIntColor(x, y, 255, 255, 255);
            }
        }
    }

    private boolean checkNeighbors(int x, int y, int neighborhoodX, int neighborhoodY, MarvinImage img) {
        int z = 0;
        int color = img.getIntComponent0(x, y);
        for (int i = 0 - neighborhoodX; i <= neighborhoodX; ++i) {
            for (int j = 0 - neighborhoodY; j <= neighborhoodY; ++j) {
                if (i == 0 && j == 0 || color >= this.getSafeColor(x + i, y + j, img) - this.range || this.getSafeColor(x + i, y + j, img) == -1) continue;
                ++z;
            }
        }
        return (double)z > (double)(neighborhoodX * neighborhoodY) * 0.5;
    }

    private int getSafeColor(int x, int y, MarvinImage img) {
        if (x >= 0 && x < img.getWidth() && y >= 0 && y < img.getHeight()) {
            return img.getIntComponent0(x, y);
        }
        return -1;
    }
}

