/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.color.skinColorDetection;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.skinColorDetection.ColorSpaceConverter;

public class SkinColorDetection
extends MarvinAbstractImagePlugin {
    MarvinAttributes attributes;

    public void load() {
        this.attributes = this.getAttributes();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        MarvinImage l_hsvImage = new MarvinImage(imageIn.getWidth(), imageIn.getHeight());
        ColorSpaceConverter l_colorspaceConverter = new ColorSpaceConverter();
        l_colorspaceConverter.process(imageIn, l_hsvImage, attributesOut, mask, false);
        this.findSkinColorPixels(imageIn, l_hsvImage, imageOut);
    }

    private void findSkinColorPixels(MarvinImage imageIn, MarvinImage hsvImage, MarvinImage imageOut) {
        int l_imageHeight = imageIn.getHeight();
        int l_imageWidth = imageIn.getWidth();
        boolean[] l_rules = new boolean[]{false, false, false};
        for (int xx = 0; xx < l_imageWidth; ++xx) {
            for (int yy = 0; yy < l_imageHeight; ++yy) {
                int l_currentHue = hsvImage.getIntComponent0(xx, yy);
                int l_currentSat = hsvImage.getIntComponent1(xx, yy);
                int l_currentVar = hsvImage.getIntComponent2(xx, yy);
                if (l_currentHue > 0 && l_currentHue < 23) {
                    imageOut.setIntColor(xx, yy, imageIn.getIntColor(xx, yy));
                    continue;
                }
                imageOut.setIntColor(xx, yy, 0);
            }
        }
    }

    protected void checkRule2(int currentRed, int currentGreen, int currentBlue, boolean[] a_rules) {
        int l_maxCoords = this.max3nums(currentRed, currentGreen, currentBlue);
        int l_minCoords = this.min3nums(currentRed, currentGreen, currentBlue);
        a_rules[2] = currentRed > 95 && currentGreen > 40 && currentBlue > 20 && l_maxCoords - l_minCoords > 15 && Math.abs(currentRed - currentGreen) > 15 && currentRed > currentGreen && currentRed > currentBlue;
    }

    public int max3nums(int a_red, int a_green, int a_blue) {
        int l_max = 0;
        l_max = a_red > a_green ? a_red : a_green;
        if (l_max < a_blue) {
            l_max = a_blue;
        }
        return l_max;
    }

    public int min3nums(int a_red, int a_green, int a_blue) {
        int l_min = 255;
        l_min = a_red < a_green ? a_red : a_green;
        if (l_min < a_blue) {
            return l_min;
        }
        return a_blue;
    }

    protected void checkRule1(int currentRed, int currentGreen, int currentBlue, boolean[] rules) {
        rules[1] = currentRed > 220 && currentGreen > 210 && currentBlue > 170 && Math.abs(currentRed - currentGreen) <= 15 && currentRed > currentBlue && currentGreen > currentBlue;
    }

    protected void checkRule0(int currentRed, int currentGreen, int currentBlue, boolean[] rules) {
        int[] l_currentSkintone = new int[]{currentRed, currentGreen};
        if (currentRed < 40 || currentGreen < 40) {
            rules[0] = false;
        } else {
            int[] l_VectorSkintoneA = new int[2];
            int[] l_VectorSkintoneB = new int[2];
            l_VectorSkintoneA[0] = 225;
            l_VectorSkintoneA[1] = 165;
            l_VectorSkintoneB[0] = 125;
            l_VectorSkintoneB[1] = 50;
            double l_angleCurrentSkinVectorA = this.calculateVectorAngle(l_VectorSkintoneA, l_currentSkintone);
            double l_angleCurrentSkinVectorB = this.calculateVectorAngle(l_VectorSkintoneB, l_currentSkintone);
            rules[0] = !(l_angleCurrentSkinVectorA < 0.995) || !(l_angleCurrentSkinVectorB < 0.995);
        }
    }

    protected void findMinMax(MarvinImage imageIn, int[] minMax) {
        for (int l_currentX = 0; l_currentX < imageIn.getWidth(); ++l_currentX) {
            for (int l_currentY = 0; l_currentY < imageIn.getHeight(); ++l_currentY) {
                int l_currentRed = imageIn.getIntComponent0(l_currentX, l_currentY);
                int l_currentGreen = imageIn.getIntComponent1(l_currentX, l_currentY);
                int l_currentBlue = imageIn.getIntComponent2(l_currentX, l_currentY);
                if (l_currentRed < minMax[0]) {
                    minMax[0] = l_currentRed;
                }
                if (l_currentRed > minMax[1]) {
                    minMax[1] = l_currentRed;
                }
                if (l_currentGreen < minMax[0]) {
                    minMax[0] = l_currentGreen;
                }
                if (l_currentGreen > minMax[1]) {
                    minMax[1] = l_currentGreen;
                }
                if (l_currentBlue < minMax[0]) {
                    minMax[0] = l_currentBlue;
                }
                if (l_currentBlue <= minMax[1]) continue;
                minMax[1] = l_currentBlue;
            }
        }
    }

    protected double calculateVectorAngle(int[] vector1, int[] vector2) {
        if (vector1.length != vector2.length) {
            return 0.0;
        }
        double l_magVector1 = this.findMagnitude(vector1);
        double l_magVector2 = this.findMagnitude(vector2);
        double l_dotProduct = this.dotProduct(vector1, vector2);
        return l_dotProduct / (l_magVector1 * l_magVector2);
    }

    protected double findMagnitude(int[] vector) {
        if (vector.length != 2) {
            return 0.0;
        }
        return Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1]);
    }

    private double dotProduct(int[] vector1, int[] vector2) {
        if (vector1.length != vector2.length && vector1.length != 2) {
            return 0.0;
        }
        return vector1[0] * vector2[0] + vector1[1] * vector2[1];
    }
}

