/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.color.skinColorDetection;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class ColorSpaceConverter
extends MarvinAbstractImagePlugin {
    MarvinAttributes attributes;

    public void load() {
        this.attributes = this.getAttributes();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        int l_imageWidth = imageIn.getWidth();
        int l_imageHeight = imageIn.getHeight();
        for (int l_currentX = 0; l_currentX < l_imageWidth; ++l_currentX) {
            for (int l_currentY = 0; l_currentY < l_imageHeight; ++l_currentY) {
                double l_red = imageIn.getIntComponent0(l_currentX, l_currentY);
                double l_green = imageIn.getIntComponent1(l_currentX, l_currentY);
                double l_blue = imageIn.getIntComponent2(l_currentX, l_currentY);
                double l_normalisedRed = l_red / 255.0;
                double l_normalisedGreen = l_green / 255.0;
                double l_normalisedBlue = l_blue / 255.0;
                double l_currentMin = this.min3nums(l_normalisedRed, l_normalisedGreen, l_normalisedBlue);
                double l_currentMax = this.max3nums(l_normalisedRed, l_normalisedGreen, l_normalisedBlue);
                double l_hue = 0.0;
                double l_sat = 0.0;
                double l_var = 0.0;
                if (l_currentMin == l_currentMax) {
                    l_hue = 0.0;
                } else if (l_normalisedRed == l_currentMax) {
                    l_hue = (60.0 * ((l_normalisedGreen - l_normalisedBlue) / (l_currentMax - l_currentMin)) + 360.0) % 360.0;
                } else if (l_normalisedGreen == l_currentMax) {
                    l_hue = 60.0 * ((l_normalisedBlue - l_normalisedRed) / (l_currentMax - l_currentMin)) + 120.0;
                } else if (l_normalisedBlue == l_currentMax) {
                    l_hue = 60.0 * ((l_normalisedRed - l_normalisedGreen) / (l_currentMax - l_currentMin)) + 240.0;
                }
                l_sat = l_currentMax == 0.0 ? 0.0 : 1.0 - l_currentMin / l_currentMax;
                l_var = l_currentMax;
                imageOut.setIntColor(l_currentX, l_currentY, (int)(l_hue * 255.0 / 360.0), (int)(l_sat * 255.0), (int)(l_var * 255.0));
            }
        }
    }

    public void process1(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        int l_imageWidth = a_imageIn.getWidth();
        int l_imageHeight = a_imageIn.getHeight();
        for (int l_currentX = 0; l_currentX < l_imageWidth; ++l_currentX) {
            for (int l_currentY = 0; l_currentY < l_imageHeight; ++l_currentY) {
                double l_red = a_imageIn.getIntComponent0(l_currentX, l_currentY);
                double l_green = a_imageIn.getIntComponent1(l_currentX, l_currentY);
                double l_blue = a_imageIn.getIntComponent2(l_currentX, l_currentY);
                double l_varR = l_red / 255.0;
                double l_varG = l_green / 255.0;
                double l_varB = l_blue / 255.0;
                double l_varMin = this.min3nums(l_varR, l_varG, l_varB);
                double l_varMax = this.max3nums(l_varR, l_varG, l_varB);
                double l_delMax = l_varMin - l_varMax;
                double l_var = l_varMax;
                double l_hue = 0.0;
                double l_sat = 0.0;
                if (l_delMax != 0.0) {
                    l_sat = l_delMax / l_varMax;
                    double l_del_R = ((l_varMax - l_varR) / 6.0 + l_delMax / 2.0) / l_delMax;
                    double l_del_G = ((l_varMax - l_varG) / 6.0 + l_delMax / 2.0) / l_delMax;
                    double l_del_B = ((l_varMax - l_varB) / 6.0 + l_delMax / 2.0) / l_delMax;
                    if (l_varR == l_varMax) {
                        l_hue = l_del_B - l_del_G;
                    } else if (l_varG == l_varMax) {
                        l_hue = 0.0 + l_del_R - l_del_B;
                    } else if (l_varB == l_varMax) {
                        l_hue = 0.0 + l_del_G - l_del_R;
                    }
                    if (l_hue < 0.0) {
                        l_hue += 1.0;
                    }
                    if (l_hue > 1.0) {
                        l_hue -= 1.0;
                    }
                }
                System.out.println(l_hue);
                System.out.println((l_hue *= 255.0) + "\n___________");
                a_imageOut.setIntColor(l_currentX, l_currentY, (int)l_hue, (int)l_hue, (int)l_hue);
            }
        }
    }

    public double max3nums(double a_red, double a_green, double a_blue) {
        double l_max = 0.0;
        l_max = a_red > a_green ? a_red : a_green;
        if (l_max < a_blue) {
            l_max = a_blue;
        }
        return l_max;
    }

    public double min3nums(double a_red, double a_green, double a_blue) {
        double l_min = 255.0;
        l_min = a_red < a_green ? a_red : a_green;
        if (l_min < a_blue) {
            return l_min;
        }
        return a_blue;
    }
}

