/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.color.sepia;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Sepia
extends MarvinAbstractImagePlugin
implements ChangeListener,
KeyListener {
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;
    private MarvinPerformanceMeter performanceMeter;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("txtValue", (Object)"20");
        this.attributes.set("intensity", (Object)20);
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        int depth = Integer.parseInt(this.attributes.get("intensity").toString());
        int width = imageIn.getWidth();
        int height = imageIn.getHeight();
        boolean[][] l_arrMask = mask.getMask();
        for (int x = 0; x < imageIn.getWidth(); ++x) {
            for (int y = 0; y < imageIn.getHeight(); ++y) {
                int corfinal;
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                int r = imageIn.getIntComponent0(x, y);
                int g = imageIn.getIntComponent1(x, y);
                int b = imageIn.getIntComponent2(x, y);
                g = b = (corfinal = (r + g + b) / 3);
                r = b;
                r = this.truncate(r + depth * 2);
                g = this.truncate(g + depth);
                imageOut.setIntColor(x, y, imageIn.getAlphaComponent(x, y), r, g, b);
            }
        }
    }

    public int truncate(int a) {
        if (a < 0) {
            return 0;
        }
        if (a > 255) {
            return 255;
        }
        return a;
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblIntensidade", "Intensidade do Filtro");
            this.attributesPanel.addHorizontalSlider("hsIntensidade", "hsIntensidade", 0, 100, 20, this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addTextField("txtValue", "txtValue", this.attributes);
            JTextField txtValue = (JTextField)this.attributesPanel.getComponent("txtValue").getComponent();
            JSlider slider = (JSlider)this.attributesPanel.getComponent("hsIntensidade").getComponent();
            slider.addChangeListener(this);
            txtValue.addKeyListener(this);
        }
        return this.attributesPanel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider barra = (JSlider)e.getSource();
        JTextField lbl = (JTextField)this.attributesPanel.getComponent("txtValue").getComponent();
        lbl.setText("" + barra.getValue());
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        JTextField txtValor = (JTextField)this.attributesPanel.getComponent("txtValue").getComponent();
        JSlider barra = (JSlider)this.attributesPanel.getComponent("hsIntensidade").getComponent();
        try {
            barra.setValue(Integer.parseInt(txtValor.getText().trim()));
        }
        catch (Exception exception) {
            barra.setValue(0);
            txtValor.setText("0");
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

