/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.color.colorChannel;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class ColorChannel
extends MarvinAbstractImagePlugin {
    public void load() {
        this.setAttribute("red", 0);
        this.setAttribute("green", 0);
        this.setAttribute("blue", 0);
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean preview) {
        int vr = (Integer)this.getAttribute("red");
        int vg = (Integer)this.getAttribute("green");
        int vb = (Integer)this.getAttribute("blue");
        double mr = 1.0 + Math.abs((double)vr / 100.0 * 2.5);
        double mg = 1.0 + Math.abs((double)vg / 100.0 * 2.5);
        double mb = 1.0 + Math.abs((double)vb / 100.0 * 2.5);
        mr = vr > 0 ? mr : 1.0 / mr;
        mg = vg > 0 ? mg : 1.0 / mg;
        mb = vb > 0 ? mb : 1.0 / mb;
        for (int y = 0; y < imageIn.getHeight(); ++y) {
            for (int x = 0; x < imageIn.getWidth(); ++x) {
                int red = imageIn.getIntComponent0(x, y);
                int green = imageIn.getIntComponent1(x, y);
                int blue = imageIn.getIntComponent2(x, y);
                red = (int)Math.min((double)red * mr, 255.0);
                green = (int)Math.min((double)green * mg, 255.0);
                blue = (int)Math.min((double)blue * mb, 255.0);
                imageOut.setIntColor(x, y, 255, red, green, blue);
            }
        }
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }
}

