/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.color.blackAndWhite;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.grayScale.GrayScale;

public class BlackAndWhite
extends MarvinAbstractImagePlugin {
    private static final double MAX_RLEVEL = 0.03;
    private MarvinImagePlugin grayScale;

    public void load() {
        this.grayScale = new GrayScale();
        this.grayScale.load();
        this.setAttribute("level", 10);
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean preview) {
        this.grayScale.process(imageIn, imageOut);
        int level = (Integer)this.getAttribute("level");
        double rlevel = (double)level / 100.0 * 0.03;
        for (int y = 0; y < imageOut.getHeight(); ++y) {
            for (int x = 0; x < imageOut.getWidth(); ++x) {
                int gray = imageIn.getIntComponent0(x, y);
                gray = gray <= 127 ? (int)Math.max((double)gray * (1.0 - (double)(127 - gray) * rlevel), 0.0) : (int)Math.min((double)gray * (1.0 + (double)(gray - 127) * rlevel), 255.0);
                imageOut.setIntColor(x, y, gray, gray, gray);
            }
        }
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }
}

