/*
 * Decompiled with CFR 0.152.
 */
package com.dengxq.lnglat2Geo.utils;

import com.dengxq.lnglat2Geo.entity.Azimuth$;
import com.dengxq.lnglat2Geo.entity.Bound;
import com.dengxq.lnglat2Geo.entity.CoordinateSystem$;
import com.dengxq.lnglat2Geo.entity.EnumImplicit$;
import com.dengxq.lnglat2Geo.entity.Location;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellUnion;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2RegionCoverer;
import java.util.ArrayList;
import java.util.List;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

public final class GeoUtils$ {
    public static final GeoUtils$ MODULE$;
    private final double x_PI;
    private final double EE;
    private final double A;
    private final double EQUATOR_C;
    private final double EARTH_RADIUS;
    private final double EARTH_POLAR_RADIUS;
    private final double SQRT2;
    private final double kEarthCircumferenceMeters;

    static {
        new GeoUtils$();
    }

    private double x_PI() {
        return this.x_PI;
    }

    private double EE() {
        return this.EE;
    }

    private double A() {
        return this.A;
    }

    private double EQUATOR_C() {
        return this.EQUATOR_C;
    }

    private double EARTH_RADIUS() {
        return this.EARTH_RADIUS;
    }

    private double EARTH_POLAR_RADIUS() {
        return this.EARTH_POLAR_RADIUS;
    }

    private double SQRT2() {
        return this.SQRT2;
    }

    private double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public double distance(Location locA, Location locB) {
        double lngA = locA.lng();
        double latA = locA.lat();
        double lngB = locB.lng();
        double latB = locB.lat();
        double f = this.rad((latA + latB) / (double)2);
        double g = this.rad((latA - latB) / (double)2);
        double l = this.rad((lngA - lngB) / (double)2);
        if (g == 0.0 && l == 0.0) {
            return 0.0;
        }
        double sg = Math.sin(g);
        double sl = Math.sin(l);
        double sf = Math.sin(f);
        double s = 0.0;
        double c = 0.0;
        double w = 0.0;
        double r = 0.0;
        double d = 0.0;
        double h1 = 0.0;
        double h2 = 0.0;
        double dis = 0.0;
        double a = this.EARTH_RADIUS();
        double fl = 0.0033528131778969143;
        sg *= sg;
        sl *= sl;
        sf *= sf;
        s = sg * (1.0 - sl) + (1.0 - sf) * sl;
        c = (1.0 - sg) * (1.0 - sl) + sf * sl;
        w = Math.atan(Math.sqrt(s / c));
        r = Math.sqrt(s * c) / w;
        d = (double)2 * w * a;
        h1 = ((double)3 * r - 1.0) / (double)2 / c;
        h2 = ((double)3 * r + 1.0) / (double)2 / s;
        dis = d * (1.0 + fl * (h1 * sf * (1.0 - sg) - h2 * (1.0 - sf) * sg));
        return new StringOps(Predef$.MODULE$.augmentString(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)dis)), "%.2f"))).toDouble();
    }

    public Tuple2<Object, Object> gcj02ToWgs84(double lng, double lat) {
        if (this.outOfChina(lng, lat)) {
            return new Tuple2.mcDD.sp(lng, lat);
        }
        double dlat = this.transformLat(lng - 105.0, lat - 35.0);
        double dlng = this.transformLng(lng - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - this.EE() * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (this.A() * (1.0 - this.EE()) / (magic * sqrtmagic) * Math.PI);
        dlng = dlng * 180.0 / (this.A() / sqrtmagic * Math.cos(radlat) * Math.PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new Tuple2.mcDD.sp(lng * (double)2 - mglng, lat * (double)2 - mglat);
    }

    public Tuple2<Object, Object> gcj02ToBD09(double lng, double lat) {
        if (this.outOfChina(lng, lat)) {
            return new Tuple2.mcDD.sp(lng, lat);
        }
        double z = Math.sqrt(lng * lng + lat * lat) + 2.0E-5 * Math.sin(lat * this.x_PI());
        double theta = Math.atan2(lat, lng) + 3.0E-6 * Math.cos(lng * this.x_PI());
        double bd_lng = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new Tuple2.mcDD.sp(bd_lng, bd_lat);
    }

    public Tuple2<Object, Object> bd09ToGCJ02(double lng, double lat) {
        if (this.outOfChina(lng, lat)) {
            return new Tuple2.mcDD.sp(lng, lat);
        }
        double x = lng - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * this.x_PI());
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * this.x_PI());
        double gg_lng = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        return new Tuple2.mcDD.sp(gg_lng, gg_lat);
    }

    public Tuple2<Object, Object> wgs84ToGCj02(double lng, double lat) {
        double mglat = 0.0;
        double mglng = 0.0;
        if (this.outOfChina(lng, lat)) {
            mglat = lat;
            mglng = lng;
        } else {
            double dLat = this.transformLat(lng - 105.0, lat - 35.0);
            double dLon = this.transformLng(lng - 105.0, lat - 35.0);
            double radLat = lat / 180.0 * Math.PI;
            double magic = Math.sin(radLat);
            magic = 1.0 - this.EE() * magic * magic;
            double sqrtMagic = Math.sqrt(magic);
            dLat = dLat * 180.0 / (this.A() * (1.0 - this.EE()) / (magic * sqrtMagic) * Math.PI);
            dLon = dLon * 180.0 / (this.A() / sqrtMagic * Math.cos(radLat) * Math.PI);
            mglat = lat + dLat;
            mglng = lng + dLon;
        }
        return new Tuple2.mcDD.sp(mglng, mglat);
    }

    private double transformLng(double lng, double lat) {
        double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng + 0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lng * Math.PI) + 40.0 * Math.sin(lng / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lng / 12.0 * Math.PI) + 300.0 * Math.sin(lng / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    private double transformLat(double lng, double lat) {
        double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat + 0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lat / 12.0 * Math.PI) + (double)320 * Math.sin(lat * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    public boolean isInChina(double lng, double lat) {
        return !this.outOfChina(lng, lat);
    }

    public boolean outOfChina(double lng, double lat) {
        return lng < 72.004 || lng > 137.8347 || lat < 0.8293 || lat > 55.8271;
    }

    public boolean checkLoc(double lng, double lat) {
        return lng <= (double)180 && lng >= (double)-180 && lat <= (double)90 && lat >= (double)-90;
    }

    public Tuple2<Object, Object> toGCJ02(double lng, double lat, Enumeration.Value coordType) {
        Tuple2.mcDD.sp sp2;
        Enumeration.Value value = coordType;
        Enumeration.Value value2 = CoordinateSystem$.MODULE$.WGS84();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Tuple2<Object, Object> d = this.wgs84ToGCj02(lng, lat);
            sp2 = new Tuple2.mcDD.sp(d._1$mcD$sp(), d._2$mcD$sp());
        } else {
            Enumeration.Value value4 = CoordinateSystem$.MODULE$.BD09();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Tuple2<Object, Object> d = this.bd09ToGCJ02(lng, lat);
                sp2 = new Tuple2.mcDD.sp(d._1$mcD$sp(), d._2$mcD$sp());
            } else {
                sp2 = new Tuple2.mcDD.sp(lng, lat);
            }
        }
        return sp2;
    }

    public Tuple2<Object, Object> toWGS84(double lng, double lat, Enumeration.Value coordType) {
        Tuple2.mcDD.sp sp2;
        Enumeration.Value value = coordType;
        Enumeration.Value value2 = CoordinateSystem$.MODULE$.GCJ02();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Tuple2<Object, Object> d = this.gcj02ToWgs84(lng, lat);
            sp2 = new Tuple2.mcDD.sp(d._1$mcD$sp(), d._2$mcD$sp());
        } else {
            Enumeration.Value value4 = CoordinateSystem$.MODULE$.BD09();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Tuple2<Object, Object> d02 = this.bd09ToGCJ02(lng, lat);
                Tuple2<Object, Object> d = this.gcj02ToWgs84(d02._1$mcD$sp(), d02._2$mcD$sp());
                sp2 = new Tuple2.mcDD.sp(d._1$mcD$sp(), d._2$mcD$sp());
            } else {
                sp2 = new Tuple2.mcDD.sp(lng, lat);
            }
        }
        return sp2;
    }

    public <A> Option<A> nearest(Object source, Location loc, Function1<A, Location> locExpression) {
        Object object;
        if (source == null || Predef$.MODULE$.genericArrayOps(source).isEmpty()) {
            object = None$.MODULE$;
        } else {
            long locId = S2CellId.fromLatLng((S2LatLng)S2LatLng.fromDegrees((double)loc.lat(), (double)loc.lng())).id();
            Tuple2 MARK_ITEM = new Tuple2((Object)BoxesRunTime.boxToLong((long)locId), (Object)None$.MODULE$);
            Tuple2[] sortedLs = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(source).map((Function1)new Serializable(locExpression){
                public static final long serialVersionUID = 0L;
                private final Function1 locExpression$1;

                public final Tuple2<Object, Some<A>> apply(A item) {
                    Location itemLoc = (Location)this.locExpression$1.apply(item);
                    long id = S2CellId.fromLatLng((S2LatLng)S2LatLng.fromDegrees((double)itemLoc.lat(), (double)itemLoc.lng())).id();
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)id), (Object)new Some(item));
                }
                {
                    this.locExpression$1 = locExpression$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).$colon$plus((Object)MARK_ITEM, ClassTag$.MODULE$.apply(Tuple2.class))).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple2<Object, Option<A>> x$1) {
                    return x$1._1$mcJ$sp();
                }
            }, (Ordering)Ordering.Long$.MODULE$);
            int locIndex = Predef$.MODULE$.refArrayOps((Object[])sortedLs).indexOf((Object)MARK_ITEM);
            None$ nearestLeft = locIndex != 0 ? (Option)sortedLs[locIndex - 1]._2() : None$.MODULE$;
            None$ nearestRight = locIndex == sortedLs.length - 1 ? None$.MODULE$ : (Option)sortedLs[locIndex + 1]._2();
            Tuple2[] distanceLs = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])new Option[]{nearestLeft, nearestRight}).flatMap((Function1)new Serializable(loc, locExpression){
                public static final long serialVersionUID = 0L;
                private final Location loc$1;
                private final Function1 locExpression$1;

                public final Iterable<Tuple2<Object, A>> apply(Option<A> x0$1) {
                    Option<A> option;
                    block4: {
                        Iterable iterable;
                        block3: {
                            block2: {
                                option = x0$1;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Object nearest2 = some.x();
                                double d = GeoUtils$.MODULE$.distance((Location)this.locExpression$1.apply(nearest2), this.loc$1);
                                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), nearest2)));
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                        return iterable;
                    }
                    throw new MatchError(option);
                }
                {
                    this.loc$1 = loc$1;
                    this.locExpression$1 = locExpression$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            object = Predef$.MODULE$.refArrayOps((Object[])distanceLs).nonEmpty() ? new Some(((Tuple2)Predef$.MODULE$.refArrayOps((Object[])distanceLs).minBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, A> x$2) {
                    return x$2._1$mcD$sp();
                }
            }, (Ordering)Ordering.Double$.MODULE$))._2()) : None$.MODULE$;
        }
        return object;
    }

    private double kEarthCircumferenceMeters() {
        return this.kEarthCircumferenceMeters;
    }

    private double earthMeters2Radians(double meters) {
        return Math.PI * 2 * (meters / this.kEarthCircumferenceMeters());
    }

    public S2Cap genS2Cap(Location loc, double radius) {
        S2LatLng s2LatLng = S2LatLng.fromDegrees((double)loc.lat(), (double)loc.lng());
        double radiusRadians = this.earthMeters2Radians(radius);
        return S2Cap.fromAxisHeight((S2Point)s2LatLng.normalized().toPoint(), (double)(radiusRadians * radiusRadians / (double)2));
    }

    public <T extends S2Region> S2CellUnion genS2CellUnion(Seq<T> regions, int minLevel, int maxLevel, int maxCells) {
        S2RegionCoverer regionCoverer = new S2RegionCoverer();
        if (maxCells != 0) {
            regionCoverer.setMaxCells(maxCells);
        }
        if (maxLevel != 0) {
            regionCoverer.setMaxLevel(maxLevel);
        }
        if (minLevel != 0) {
            regionCoverer.setMinLevel(minLevel);
        }
        ArrayList s2CellIds = new ArrayList();
        ((IterableLike)regions.flatMap((Function1)new Serializable(regionCoverer){
            public static final long serialVersionUID = 0L;
            private final S2RegionCoverer regionCoverer$1;

            public final Buffer<S2CellId> apply(T x) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.regionCoverer$1.getCovering(x).cellIds()).asScala();
            }
            {
                this.regionCoverer$1 = regionCoverer$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(s2CellIds){
            public static final long serialVersionUID = 0L;
            private final ArrayList s2CellIds$1;

            public final boolean apply(S2CellId x$1) {
                return this.s2CellIds$1.add(x$1);
            }
            {
                this.s2CellIds$1 = s2CellIds$1;
            }
        });
        S2CellUnion cellUnion = new S2CellUnion();
        cellUnion.initFromCellIds(s2CellIds);
        return cellUnion;
    }

    public <T extends S2Region> int genS2CellUnion$default$2() {
        return 0;
    }

    public <T extends S2Region> int genS2CellUnion$default$3() {
        return 0;
    }

    public <T extends S2Region> int genS2CellUnion$default$4() {
        return 0;
    }

    public Location move(Location loc, double distance, Enumeration.Value azimuth) {
        double radLat = this.rad(loc.lat());
        double radLng = this.rad(loc.lng());
        double ec = this.EARTH_POLAR_RADIUS() + (this.EARTH_RADIUS() - this.EARTH_POLAR_RADIUS()) * ((double)90 - loc.lng()) / (double)90;
        double ed = ec * Math.cos(radLat);
        double dx = distance * Math.sin((double)EnumImplicit$.MODULE$.enum2int(azimuth) * Math.PI / (double)180);
        double dy = distance * Math.cos((double)EnumImplicit$.MODULE$.enum2int(azimuth) * Math.PI / (double)180);
        double lng = (dx / ed + radLng) * (double)180 / Math.PI;
        double lat = (dy / ec + radLat) * (double)180 / Math.PI;
        return new Location(lng, lat);
    }

    public Bound genCapBound(Location loc, double radius) {
        double swDistance = this.SQRT2() * radius;
        Location sw = this.move(loc, swDistance, Azimuth$.MODULE$.SouthWest());
        Location ne = this.move(loc, swDistance, Azimuth$.MODULE$.NorthEast());
        return new Bound(sw, ne);
    }

    public Bound genCapInnerBound(Location loc, double radius) {
        Location sw = this.move(loc, radius, Azimuth$.MODULE$.SouthWest());
        Location ne = this.move(loc, radius, Azimuth$.MODULE$.NorthEast());
        return new Bound(sw, ne);
    }

    public Seq<String> genCellBound(Location center, double radius, int level) {
        S2Cap cap = this.genS2Cap(center, radius);
        S2CellUnion cu = this.genS2CellUnion((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new S2Cap[]{cap})), level, level, 5);
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)cu.cellIds()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(S2CellId x$3) {
                return RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(x$3.id()));
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public String toCellBoundId(double lng, double lat, int level) {
        return RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(S2CellId.fromLatLng((S2LatLng)S2LatLng.fromDegrees((double)lat, (double)lng)).parent(9).id()));
    }

    private GeoUtils$() {
        MODULE$ = this;
        this.x_PI = 52.35987755982988;
        this.EE = 0.006693421622965943;
        this.A = 6378245.0;
        this.EQUATOR_C = 2.00375083427892E7;
        this.EARTH_RADIUS = 6378137.0;
        this.EARTH_POLAR_RADIUS = 6356725.0;
        this.SQRT2 = 1.414213562;
        this.kEarthCircumferenceMeters = 4.0075017E7;
    }
}

