/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc.tuple;

import com.github.davidmoten.guavamini.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.davidmoten.rx.jdbc.ResultSetMapper;
import org.davidmoten.rx.jdbc.Util;
import org.davidmoten.rx.jdbc.exceptions.SQLRuntimeException;
import org.davidmoten.rx.jdbc.tuple.Tuple2;
import org.davidmoten.rx.jdbc.tuple.Tuple3;
import org.davidmoten.rx.jdbc.tuple.Tuple4;
import org.davidmoten.rx.jdbc.tuple.Tuple5;
import org.davidmoten.rx.jdbc.tuple.Tuple6;
import org.davidmoten.rx.jdbc.tuple.Tuple7;
import org.davidmoten.rx.jdbc.tuple.TupleN;

public final class Tuples {
    private Tuples() {
    }

    public static <T> ResultSetMapper<T> single(final Class<T> cls) {
        Preconditions.checkNotNull(cls, (String)"cls cannot be null");
        return new ResultSetMapper<T>(){

            @Override
            public T apply(ResultSet rs) {
                return Util.mapObject(rs, cls, 1);
            }
        };
    }

    public static <T1, T2> ResultSetMapper<Tuple2<T1, T2>> tuple(final Class<T1> cls1, final Class<T2> cls2) {
        Preconditions.checkNotNull(cls1, (String)"cls1 cannot be null");
        Preconditions.checkNotNull(cls2, (String)"cls2 cannot be null");
        return new ResultSetMapper<Tuple2<T1, T2>>(){

            @Override
            public Tuple2<T1, T2> apply(ResultSet rs) {
                return new Tuple2(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2));
            }
        };
    }

    public static <T1, T2, T3> ResultSetMapper<Tuple3<T1, T2, T3>> tuple(final Class<T1> cls1, final Class<T2> cls2, final Class<T3> cls3) {
        Preconditions.checkNotNull(cls1, (String)"cls1 cannot be null");
        Preconditions.checkNotNull(cls2, (String)"cls2 cannot be null");
        Preconditions.checkNotNull(cls3, (String)"cls3 cannot be null");
        return new ResultSetMapper<Tuple3<T1, T2, T3>>(){

            @Override
            public Tuple3<T1, T2, T3> apply(ResultSet rs) {
                return new Tuple3(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2), Util.mapObject(rs, cls3, 3));
            }
        };
    }

    public static <T1, T2, T3, T4> ResultSetMapper<Tuple4<T1, T2, T3, T4>> tuple(final Class<T1> cls1, final Class<T2> cls2, final Class<T3> cls3, final Class<T4> cls4) {
        Preconditions.checkNotNull(cls1, (String)"cls1 cannot be null");
        Preconditions.checkNotNull(cls2, (String)"cls2 cannot be null");
        Preconditions.checkNotNull(cls3, (String)"cls3 cannot be null");
        Preconditions.checkNotNull(cls4, (String)"cls4 cannot be null");
        return new ResultSetMapper<Tuple4<T1, T2, T3, T4>>(){

            @Override
            public Tuple4<T1, T2, T3, T4> apply(ResultSet rs) {
                return new Tuple4(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2), Util.mapObject(rs, cls3, 3), Util.mapObject(rs, cls4, 4));
            }
        };
    }

    public static <T1, T2, T3, T4, T5> ResultSetMapper<Tuple5<T1, T2, T3, T4, T5>> tuple(final Class<T1> cls1, final Class<T2> cls2, final Class<T3> cls3, final Class<T4> cls4, final Class<T5> cls5) {
        Preconditions.checkNotNull(cls1, (String)"cls1 cannot be null");
        Preconditions.checkNotNull(cls2, (String)"cls2 cannot be null");
        Preconditions.checkNotNull(cls3, (String)"cls3 cannot be null");
        Preconditions.checkNotNull(cls4, (String)"cls4 cannot be null");
        Preconditions.checkNotNull(cls5, (String)"cls5 cannot be null");
        return new ResultSetMapper<Tuple5<T1, T2, T3, T4, T5>>(){

            @Override
            public Tuple5<T1, T2, T3, T4, T5> apply(ResultSet rs) {
                return new Tuple5(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2), Util.mapObject(rs, cls3, 3), Util.mapObject(rs, cls4, 4), Util.mapObject(rs, cls5, 5));
            }
        };
    }

    public static <T1, T2, T3, T4, T5, T6> ResultSetMapper<Tuple6<T1, T2, T3, T4, T5, T6>> tuple(final Class<T1> cls1, final Class<T2> cls2, final Class<T3> cls3, final Class<T4> cls4, final Class<T5> cls5, final Class<T6> cls6) {
        Preconditions.checkNotNull(cls1, (String)"cls1 cannot be null");
        Preconditions.checkNotNull(cls2, (String)"cls2 cannot be null");
        Preconditions.checkNotNull(cls3, (String)"cls3 cannot be null");
        Preconditions.checkNotNull(cls4, (String)"cls4 cannot be null");
        Preconditions.checkNotNull(cls5, (String)"cls5 cannot be null");
        Preconditions.checkNotNull(cls6, (String)"cls6 cannot be null");
        return new ResultSetMapper<Tuple6<T1, T2, T3, T4, T5, T6>>(){

            @Override
            public Tuple6<T1, T2, T3, T4, T5, T6> apply(ResultSet rs) {
                return new Tuple6(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2), Util.mapObject(rs, cls3, 3), Util.mapObject(rs, cls4, 4), Util.mapObject(rs, cls5, 5), Util.mapObject(rs, cls6, 6));
            }
        };
    }

    public static <T1, T2, T3, T4, T5, T6, T7> ResultSetMapper<Tuple7<T1, T2, T3, T4, T5, T6, T7>> tuple(final Class<T1> cls1, final Class<T2> cls2, final Class<T3> cls3, final Class<T4> cls4, final Class<T5> cls5, final Class<T6> cls6, final Class<T7> cls7) {
        Preconditions.checkNotNull(cls1, (String)"cls1 cannot be null");
        Preconditions.checkNotNull(cls2, (String)"cls2 cannot be null");
        Preconditions.checkNotNull(cls3, (String)"cls3 cannot be null");
        Preconditions.checkNotNull(cls4, (String)"cls4 cannot be null");
        Preconditions.checkNotNull(cls5, (String)"cls5 cannot be null");
        Preconditions.checkNotNull(cls6, (String)"cls6 cannot be null");
        Preconditions.checkNotNull(cls7, (String)"cls7 cannot be null");
        return new ResultSetMapper<Tuple7<T1, T2, T3, T4, T5, T6, T7>>(){

            @Override
            public Tuple7<T1, T2, T3, T4, T5, T6, T7> apply(ResultSet rs) {
                return new Tuple7(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2), Util.mapObject(rs, cls3, 3), Util.mapObject(rs, cls4, 4), Util.mapObject(rs, cls5, 5), Util.mapObject(rs, cls6, 6), Util.mapObject(rs, cls7, 7));
            }
        };
    }

    public static <T> ResultSetMapper<TupleN<T>> tupleN(final Class<T> cls) {
        Preconditions.checkNotNull(cls, (String)"cls cannot be null");
        return new ResultSetMapper<TupleN<T>>(){

            @Override
            public TupleN<T> apply(ResultSet rs) {
                return Tuples.toTupleN(cls, rs);
            }
        };
    }

    private static <T> TupleN<T> toTupleN(Class<T> cls, ResultSet rs) {
        try {
            int n = rs.getMetaData().getColumnCount();
            ArrayList<T> list = new ArrayList<T>();
            for (int i = 1; i <= n; ++i) {
                list.add(Util.mapObject(rs, cls, i));
            }
            return new TupleN(list);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

