/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc.pool.internal;

import io.reactivex.functions.Consumer;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public final class SerializedConnectionListener
extends AtomicInteger
implements Consumer<Optional<Throwable>> {
    private final Consumer<? super Optional<Throwable>> c;
    private final SimplePlainQueue<Optional<Throwable>> queue = new MpscLinkedQueue();

    public SerializedConnectionListener(Consumer<? super Optional<Throwable>> c) {
        this.c = c;
    }

    public void accept(Optional<Throwable> error) throws Exception {
        this.queue.offer(error);
        this.drain();
    }

    private void drain() {
        if (this.getAndIncrement() == 0) {
            int missed = 1;
            while (true) {
                Optional o;
                if ((o = (Optional)this.queue.poll()) != null) {
                    try {
                        this.c.accept((Object)o);
                    }
                    catch (Exception e) {
                        RxJavaPlugins.onError((Throwable)e);
                    }
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
            return;
        }
    }
}

