/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc.pool;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.schedulers.ExecutorScheduler;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.sql.Connection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.sql.DataSource;
import org.davidmoten.rx.jdbc.ConnectionProvider;
import org.davidmoten.rx.jdbc.Util;
import org.davidmoten.rx.jdbc.internal.SingletonConnectionProvider;
import org.davidmoten.rx.jdbc.pool.DatabaseType;
import org.davidmoten.rx.jdbc.pool.internal.HealthCheckPredicate;
import org.davidmoten.rx.jdbc.pool.internal.PooledConnection;
import org.davidmoten.rx.jdbc.pool.internal.SerializedConnectionListener;
import org.davidmoten.rx.pool.Checkin;
import org.davidmoten.rx.pool.Member;
import org.davidmoten.rx.pool.NonBlockingPool;
import org.davidmoten.rx.pool.Pool;

public final class NonBlockingConnectionPool
implements Pool<Connection> {
    private final AtomicReference<NonBlockingPool<Connection>> pool = new AtomicReference();

    NonBlockingConnectionPool(NonBlockingPool.Builder<Connection> builder) {
        this.pool.set((NonBlockingPool<Connection>)builder.build());
    }

    public static Builder<NonBlockingConnectionPool> builder() {
        return new Builder<NonBlockingConnectionPool>(x -> x);
    }

    public Single<Member<Connection>> member() {
        return this.pool.get().member();
    }

    public void close() {
        this.pool.get().close();
    }

    public static final class Builder<T> {
        private ConnectionProvider cp;
        private Predicate<? super Connection> healthCheck = c -> true;
        private int maxPoolSize = 5;
        private long idleTimeBeforeHealthCheckMs = 60000L;
        private long maxIdleTimeMs = 1800000L;
        private long connectionRetryIntervalMs = 30000L;
        private Consumer<? super Connection> disposer = Util::closeSilently;
        private Scheduler scheduler = null;
        private Properties properties = new Properties();
        private final Function<NonBlockingConnectionPool, T> transform;
        private String url;
        private Consumer<? super Optional<Throwable>> c;

        public Builder(Function<NonBlockingConnectionPool, T> transform) {
            this.transform = transform;
        }

        public Builder<T> connectionProvider(ConnectionProvider cp) {
            Preconditions.checkArgument((!(cp instanceof SingletonConnectionProvider) ? 1 : 0) != 0, (String)"connection provider should not return a singleton connection because a pool needs control over the creation and closing of connections. Use ConnectionProvider.from(url,...) instead.");
            this.cp = cp;
            return this;
        }

        public Builder<T> connectionProvider(DataSource ds) {
            return this.connectionProvider(Util.connectionProvider(ds));
        }

        public Builder<T> url(String url) {
            this.url = url;
            return this;
        }

        public Builder<T> user(String user) {
            this.properties.put("user", user);
            return this;
        }

        public Builder<T> password(String password) {
            this.properties.put("password", password);
            return this;
        }

        public Builder<T> properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder<T> property(Object key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder<T> maxIdleTime(long duration, TimeUnit unit) {
            this.maxIdleTimeMs = unit.toMillis(duration);
            return this;
        }

        public Builder<T> idleTimeBeforeHealthCheck(long duration, TimeUnit unit) {
            this.idleTimeBeforeHealthCheckMs = unit.toMillis(duration);
            return this;
        }

        public Builder<T> connectionRetryInterval(long duration, TimeUnit unit) {
            this.connectionRetryIntervalMs = unit.toMillis(duration);
            return this;
        }

        public Builder<T> healthCheck(Predicate<? super Connection> healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder<T> healthCheck(DatabaseType databaseType) {
            return this.healthCheck(databaseType.healthCheck());
        }

        public Builder<T> healthCheck(String sql) {
            return this.healthCheck(new HealthCheckPredicate(sql));
        }

        public Builder<T> connectionListener(Consumer<? super Optional<Throwable>> c) {
            Preconditions.checkArgument((c != null ? 1 : 0) != 0, (String)"listener can only be set once");
            this.c = c;
            return this;
        }

        public Builder<T> maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder<T> scheduler(Scheduler scheduler) {
            Preconditions.checkArgument((scheduler != Schedulers.trampoline() ? 1 : 0) != 0, (String)"do not use trampoline scheduler because of risk of stack overflow");
            this.scheduler = scheduler;
            return this;
        }

        public T build() {
            if (this.scheduler == null) {
                ExecutorService executor = Executors.newFixedThreadPool(this.maxPoolSize);
                this.scheduler = new ExecutorScheduler((Executor)executor, false);
            }
            if (this.url != null) {
                this.cp = Util.connectionProvider(this.url, this.properties);
            }
            SerializedConnectionListener listener = this.c == null ? null : new SerializedConnectionListener(this.c);
            NonBlockingConnectionPool p = new NonBlockingConnectionPool((NonBlockingPool.Builder<Connection>)NonBlockingPool.factory(() -> {
                try {
                    Connection con = this.cp.get();
                    if (listener != null) {
                        try {
                            listener.accept(Optional.empty());
                        }
                        catch (Throwable e) {
                            RxJavaPlugins.onError((Throwable)e);
                        }
                    }
                    return con;
                }
                catch (Throwable e) {
                    if (listener != null) {
                        try {
                            listener.accept(Optional.of(e));
                        }
                        catch (Throwable e2) {
                            RxJavaPlugins.onError((Throwable)e2);
                        }
                    }
                    throw e;
                }
            }).checkinDecorator((con, checkin) -> new PooledConnection((Connection)con, (Checkin)checkin)).idleTimeBeforeHealthCheck(this.idleTimeBeforeHealthCheckMs, TimeUnit.MILLISECONDS).maxIdleTime(this.maxIdleTimeMs, TimeUnit.MILLISECONDS).createRetryInterval(this.connectionRetryIntervalMs, TimeUnit.MILLISECONDS).scheduler(this.scheduler).disposer(this.disposer).healthCheck(this.healthCheck).scheduler(this.scheduler).maxSize(this.maxPoolSize));
            return this.transform.apply(p);
        }
    }
}

