/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.davidmoten.rx.jdbc.NamedPreparedStatement;
import org.davidmoten.rx.jdbc.Parameter;
import org.davidmoten.rx.jdbc.ResultSetAutoClosesStatement;
import org.davidmoten.rx.jdbc.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Select {
    private static final Logger log = LoggerFactory.getLogger(Select.class);

    private Select() {
    }

    static <T> Flowable<T> create(Single<Connection> connections, Flowable<List<Object>> parameterGroups, String sql, int fetchSize, Function<? super ResultSet, ? extends T> mapper, boolean eagerDispose, int queryTimeoutSec) {
        return connections.toFlowable().flatMap(con -> Select.create(con, sql, parameterGroups, fetchSize, mapper, eagerDispose, queryTimeoutSec));
    }

    static <T> Flowable<T> create(Connection con, String sql, Flowable<List<Object>> parameterGroups, int fetchSize, Function<? super ResultSet, T> mapper, boolean eagerDispose, int queryTimeoutSec) {
        log.debug("Select.create called with con={}", (Object)con);
        Callable<NamedPreparedStatement> initialState = () -> Util.prepare(con, fetchSize, sql, queryTimeoutSec);
        Function observableFactory = ps -> parameterGroups.flatMap(parameters -> Select.create(ps.ps, parameters, mapper, ps.names, sql, fetchSize, queryTimeoutSec), true, 1);
        Consumer disposer = Util::closePreparedStatementAndConnection;
        return Flowable.using(initialState, (Function)observableFactory, (Consumer)disposer, (boolean)eagerDispose);
    }

    private static <T> Flowable<? extends T> create(PreparedStatement ps, List<Object> parameters, Function<? super ResultSet, T> mapper, List<String> names, String sql, int fetchSize, int queryTimeoutSec) {
        log.debug("parameters={}", parameters);
        log.debug("names={}", names);
        Callable<ResultSet> initialState = () -> {
            List<Parameter> params = Util.toParameters(parameters);
            boolean hasCollection = params.stream().anyMatch(x -> x.isCollection());
            if (hasCollection) {
                PreparedStatement ps2 = Util.prepare(ps.getConnection(), fetchSize, sql, params, queryTimeoutSec);
                return new ResultSetAutoClosesStatement(Util.setParameters(ps2, params, names).executeQuery(), ps2);
            }
            PreparedStatement ps2 = ps;
            return Util.setParameters(ps2, params, names).executeQuery();
        };
        BiConsumer generator = (rs, emitter) -> {
            log.debug("getting row from ps={}, rs={}", (Object)rs.getStatement(), rs);
            if (rs.next()) {
                Object v = mapper.apply(rs);
                log.debug("emitting {}", v);
                emitter.onNext(v);
            } else {
                log.debug("completed");
                emitter.onComplete();
            }
        };
        Consumer disposeState = Util::closeSilently;
        return Flowable.generate(initialState, (BiConsumer)generator, (Consumer)disposeState);
    }
}

