/*
 * Decompiled with CFR 0.152.
 */
package com.github.czietsman.xxhash;

import com.github.czietsman.xxhash.StreamingXXHash32;
import com.github.czietsman.xxhash.StreamingXXHash32JavaSafe;
import com.github.czietsman.xxhash.StreamingXXHash64;
import com.github.czietsman.xxhash.StreamingXXHash64JavaSafe;
import com.github.czietsman.xxhash.XXHash32;
import com.github.czietsman.xxhash.XXHash32JavaSafe;
import com.github.czietsman.xxhash.XXHash64;
import com.github.czietsman.xxhash.XXHash64JavaSafe;
import java.util.Random;

public final class XXHashFactory {
    public static XXHashFactory INSTANCE = new XXHashFactory();
    private final XXHash32 hash32 = XXHash32JavaSafe.INSTANCE;
    private final XXHash64 hash64;
    private final StreamingXXHash32.Factory streamingHash32Factory = new StreamingXXHash32JavaSafe.Factory();
    private final StreamingXXHash64.Factory streamingHash64Factory;

    private XXHashFactory() {
        this.hash64 = XXHash64JavaSafe.INSTANCE;
        this.streamingHash64Factory = new StreamingXXHash64JavaSafe.Factory();
        byte[] bytes = new byte[100];
        Random random = new Random();
        random.nextBytes(bytes);
        int seed = random.nextInt();
        int h1 = this.hash32.hash(bytes, 0, bytes.length, seed);
        StreamingXXHash32 streamingHash32 = this.newStreamingHash32(seed);
        streamingHash32.update(bytes, 0, bytes.length);
        int h2 = streamingHash32.getValue();
        long h3 = this.hash64.hash(bytes, 0, bytes.length, (long)seed);
        StreamingXXHash64 streamingHash64 = this.newStreamingHash64(seed);
        streamingHash64.update(bytes, 0, bytes.length);
        long h4 = streamingHash64.getValue();
        if (h1 != h2) {
            throw new AssertionError();
        }
        if (h3 != h4) {
            throw new AssertionError();
        }
    }

    public static void main(String[] args) {
        System.out.println("Fastest instance is " + INSTANCE);
    }

    public XXHash32 hash32() {
        return this.hash32;
    }

    public XXHash64 hash64() {
        return this.hash64;
    }

    public StreamingXXHash32 newStreamingHash32(int seed) {
        return this.streamingHash32Factory.newStreamingHash(seed);
    }

    public StreamingXXHash64 newStreamingHash64(long seed) {
        return this.streamingHash64Factory.newStreamingHash(seed);
    }
}

