/*
 * Decompiled with CFR 0.152.
 */
package com.github.czietsman.util;

import java.nio.ByteOrder;

public enum Utils {

    public static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();

    public static void checkRange(byte[] buf, int off) {
        if (off < 0 || off >= buf.length) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
    }

    public static void checkRange(byte[] buf, int off, int len) {
        Utils.checkLength(len);
        if (len > 0) {
            Utils.checkRange(buf, off);
            Utils.checkRange(buf, off + len - 1);
        }
    }

    public static void checkLength(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
    }

    public static byte readByte(byte[] buf, int i) {
        return buf[i];
    }

    public static int readIntBE(byte[] buf, int i) {
        return (buf[i] & 0xFF) << 24 | (buf[i + 1] & 0xFF) << 16 | (buf[i + 2] & 0xFF) << 8 | buf[i + 3] & 0xFF;
    }

    public static int readIntLE(byte[] buf, int i) {
        return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | (buf[i + 3] & 0xFF) << 24;
    }

    public static int readInt(byte[] buf, int i) {
        if (NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            return Utils.readIntBE(buf, i);
        }
        return Utils.readIntLE(buf, i);
    }

    public static long readLongLE(byte[] buf, int i) {
        return (long)buf[i] & 0xFFL | ((long)buf[i + 1] & 0xFFL) << 8 | ((long)buf[i + 2] & 0xFFL) << 16 | ((long)buf[i + 3] & 0xFFL) << 24 | ((long)buf[i + 4] & 0xFFL) << 32 | ((long)buf[i + 5] & 0xFFL) << 40 | ((long)buf[i + 6] & 0xFFL) << 48 | ((long)buf[i + 7] & 0xFFL) << 56;
    }

    public static void writeShortLE(byte[] buf, int off, int v) {
        buf[off++] = (byte)v;
        buf[off++] = (byte)(v >>> 8);
    }

    public static void writeInt(int[] buf, int off, int v) {
        buf[off] = v;
    }

    public static int readInt(int[] buf, int off) {
        return buf[off];
    }

    public static void writeByte(byte[] dest, int off, int i) {
        dest[off] = (byte)i;
    }

    public static void writeShort(short[] buf, int off, int v) {
        buf[off] = (short)v;
    }

    public static int readShortLE(byte[] buf, int i) {
        return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8;
    }

    public static int readShort(short[] buf, int off) {
        return buf[off] & 0xFFFF;
    }
}

